#ifndef __MAIN_H__
#define __MAIN_H__

#include "lcm32f06x.h"
#include "dprintf.h"
#include "kp_utils.h"
#include "serial.h"





#define NMI_Offset                      8
#define HardFault_Offset                12   
#define SVC_Offset                      44
#define PendSV_Offset                   56
#define SysTick_Offset                  60
#define WWDG_Offset                     64             
#define EXTI16_LVD_Offset               68         
#define EXTI17_WT_Offset                72            
#define EFLS_Offset                     76            
#define CHIPCTRL_Offset                 80            
#define EXTI0_1_Offset                  84            
#define EXTI2_3_Offset                  88            
#define EXTI4_15_Offset                 92            
#define ACMP_EXTI18_19_Offset           96            
#define DMAC_CH0_Offset                 100            
#define DMAC_CH1_Offset                 104            
#define SRAM_Offset                     108            
#define ADC_Offset                      112            
#define TIM1_NON_CC_Offset              116            
#define TIM1_CC_Offset                  120            
#define TIM2_Offset                     124            
#define EXTI22_24_LP_USART_Offset       128            
#define DAC0_Offset                     132            
#define ACMP_EXTI20_21_Offset           136            
#define TIM15_Offset                    144            
#define TIM16_Offset                    148            
#define TIM17_Offset                    152            
#define I2C0_Offset                     156            
#define SSP0_Offset                     164            
#define USART0_Offset                   172            
#define USART1_Offset                   176            
#define DIV_CORDIC_Offset               188            




#define ENABL_SPECK64           0

#define APP_CONF_VER            0x0100

#define BL_ARGS                 0x20000000 // first word
#define ONCE_PAGE_SIZE          512
#define APP_CONF_ADDR           0x0800FC00
#define APP_ADDR                0x08001800 // offset: 6KB
#define MCU_UID_ADDR            0x1FFFF7B)
#define APP_LEN_OFFSET          (4 * 10)
#define MCU_FLASH_END           (0x08000000 + 64 * 1024)
#define APP_MAX_LEN             (MCU_FLASH_END - APP_ADDR)





#define TTL_OR_485_RXMODE()   do{GPIOA->BSRR = (GPIO_Pin_8 << 16); /*UART1->CR |= 0x200; GPIOA->AFRL_b.AFR2 = 0x07;*/ }while(0)
#define TTL_OR_485_TXMODE()   do{GPIOA->BSRR = (GPIO_Pin_8); /*UART1->CR &= (~0x200); GPIOA->AFRL_b.AFR2 = 0x01;*/}while(0)

typedef struct
{
    uint16_t        magic_code; // "KP"
    uint16_t        conf_ver;
    uint8_t         conf_from;  // 0: default, 1: all from flash, 2: partly from flash
    uint8_t         do_reboot;
    bool            keep_bl;    // keep_in_bl for bl
    bool            save_conf;

    uint8_t         mac;

    uint8_t         _reserved0[512];

#define _end_save _reserved1
    uint32_t        _reserved1;

} csa_t;

extern csa_t csa;



void load_conf(void);
void save_conf(void);
bool app_valid(void);

uint8_t flash_erase(uint32_t addr, uint32_t len);
uint8_t flash_write(uint32_t addr, uint32_t len, uint8_t *buf);


//static inline void dputc(char c)
//{
//    while (!(USART_STAT(USART1) & USART_STAT_TBE));
//    USART_TDATA(USART1) = c;
//}

#endif
