/**
  ******************************************************************************
  * @file    lcm32f06x_conf.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Library configuration file.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
  
/* Includes ------------------------------------------------------------------*/
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_CONF_H__
#define __LCM32F06X_CONF_H__

#include "lcm32f06x_acmp.h"
#include "lcm32f06x_dac.h"
#include "lcm32f06x_adc.h"

#include "lcm32f06x_flash.h"
#include "lcm32f06x_tim.h"
#include "lcm32f06x_spi.h"
#include "lcm32f06x_wt.h"
#include "lcm32f06x_usart.h"
#include "lcm32f06x_i2c.h"
#include "lcm32f06x_crc.h"

#include "lcm32f06x_div.h"
#include "lcm32f06x_iwdg.h"
#include "lcm32f06x_gpio.h"

#include "lcm32f06x_rcc.h"
#include "lcm32f06x_dma.h"
#include "lcm32f06x_exti.h"
#include "lcm32f06x_pwr.h"
#include "lcm32f06x_dbgmcu.h"
#include "lcm32f06x_eeprom.h"


#if defined (LCM32F067) || defined (LCM32F063)  || defined (LCM32CF6990)
#include "lcm32f06x_opa.h"
#include "lcm32f06x_cordic.h"
#elif defined (LCM32F062)
  /* None OPA */
#endif
/* Exported macro ------------------------------------------------------------*/
#ifdef USE_FULL_ASSERT

//����ʱ���Էſ�����궨�壬��ʱ���ֻ��һ�����Ӵ���˵������У���ǳɹ��ģ�����Ϊʲô��һ������
//ԭ��μ���http://www.openedv.com/forum.php?mod=viewthread&tid=233944&page=1&extra=
//  https://www.cnblogs.com/vivohan/p/8470680.html
#define uint8_t unsigned char
#define uint32_t unsigned int
/**
  * @brief  The assert_param macro is used for function's parameters check.
  * @param  expr: If expr is false, it calls assert_failed function which reports 
  *         the name of the source file and the source line number of the call 
  *         that failed. If expr is true, it returns no value.
  * @retval None
  */
#define assert_param(expr) ((expr) ? ((void)0) : (assert_failed((uint8_t *)__FILE__, __LINE__)))
/* Exported functions ------------------------------------------------------- */
void assert_failed(uint8_t *file, uint32_t line);

#undef uint8_t
#undef uint32_t
#else
#define assert_param(expr) ((void)0)
#endif /* USE_FULL_ASSERT */

// <<< Use Configuration Wizard in Context Menu >>>

// <o>���ܵ�λѡ��
//  <i> ѡ��оƬ���������ܵ�λ��
//  <i>     High energy efficiency�������ܵ�λ����������ǿ�����ĸߣ�FLASH���ڶ̣������¶�150�����ڡ������ڵ��������Ӧ��
//  <i>     low power efficiency���͹��ĵ�λ�����������������ĵͣ�FLASH���ڳ��������¶�125�����ڡ����������߳��Ӧ��
//  <0=> High energy efficiency
//  <1=> low power efficiency
#define GERA_SELECT                       0
#if (GERA_SELECT == 0)
  /* �����ܵ�λ����������ǿ�����ĸߣ�FLASH���ڶ̣������¶�150�����ڡ������ڵ��������Ӧ�� */
  #define HIGH_ENERGY_EFFICIENCY_GEAR     1
#elif (GERA_SELECT == 1)
  /* �͹��ĵ�λ�����������������ĵͣ�FLASH���ڳ��������¶�125�����ڡ����������߳��Ӧ�� */
  #define LOW_POWER_EFFICIENCY_GEAR       1
#endif

// <o> ϵͳʱ��Ƶ��ѡ��
//  <i> ѡ��оƬϵͳʱ��Ƶ�ʣ�
//  <8=> 8MHz
//  <16=> 16MHz
//  <24=> 24MHz
//  <28=> 28MHz
//  <32=> 32MHz
//  <40=> 40MHz
//  <48=> 48MHz
//  <56=> 56MHz
//  <64=> 64MHz
//  <72=> 72MHz
//  <84=> 84MHz
//  <88=> 88MHz
//  <92=> 92MHz
//  <96=> 96MHz
//  <108=> 108MHz
#define HSI_SYSCLK_FREQ_MHz            84

#define SYSTEM_CORE_CLOCK               (HSI_SYSCLK_FREQ_MHz * 1000000)

#if defined(LCM32F062) || defined(LCM32F063)
  #if SYSTEM_CORE_CLOCK > 96000000
    #error "This model does not support this frequency and supports a maximum of 96MHz (check lcm32f06x_conf.h)"
  #endif
#elif defined(LCM32CF6990)
  #if SYSTEM_CORE_CLOCK > 72000000
    #error "This model does not support this frequency and supports a maximum of 72MHz (check lcm32f06x_conf.h)"
  #endif
#endif
// <<< end of configuration section >>>
#endif /* __LCM32F06X_CONF_H__ */
