#include "main.h"


//下面是中断重映射。当APP发生中断时，APP会跳转到下面的中断函数，然后重新定位到正确的中断函数
void NMI_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + NMI_Offset));
    entry();
}


void HardFault_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + HardFault_Offset));
    entry();
}


void SVC_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + SVC_Offset));
    entry();
}


void PendSV_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + PendSV_Offset));
    entry();
}

volatile uint32_t systick;
volatile uint32_t scb_offset = 0;
void SysTick_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + SysTick_Offset));
    entry();
}


void WWDG_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + WWDG_Offset));
    entry();
}


void EXTI16_LVD_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + EXTI16_LVD_Offset));
    entry();
}


void EXTI17_WT_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + EXTI17_WT_Offset));
    entry();
}


void EFLS_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + EFLS_Offset));
    entry();
}


void CHIPCTRL_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + CHIPCTRL_Offset));
    entry();
}


void EXTI0_1_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + EXTI0_1_Offset));
    entry();
}


void EXTI2_3_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + EXTI2_3_Offset));
    entry();
}


void EXTI4_15_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + EXTI4_15_Offset));
    entry();
}


void ACMP_EXTI18_19_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + ACMP_EXTI18_19_Offset));
    entry();
}


void DMAC_CH0_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + DMAC_CH0_Offset));
    entry();
}


void DMAC_CH1_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + DMAC_CH1_Offset));
    entry();
}


void SRAM_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + SRAM_Offset));
    entry();
}


void ADC_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + ADC_Offset));
    entry();
}


void TIM1_NON_CC_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + TIM1_NON_CC_Offset));
    entry();
}


void TIM1_CC_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + TIM1_CC_Offset));
    entry();
}


void TIM2_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + TIM2_Offset));
    entry();
}


void EXTI22_24_LP_USART_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + EXTI22_24_LP_USART_Offset));
    entry();
}


void DAC0_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + DAC0_Offset));
    entry();
}


void ACMP_EXTI20_21_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + ACMP_EXTI20_21_Offset));
    entry();
}




void TIM15_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + TIM15_Offset));
    entry();
}


void TIM16_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + TIM16_Offset));
    entry();
}


void TIM17_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + TIM17_Offset));
    entry();
}


void I2C0_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + I2C0_Offset));
    entry();
}




void SSP0_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + SSP0_Offset));
    entry();
}





void USART0_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + USART0_Offset));
    entry();
}


void USART1_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + USART1_Offset));
    entry();
}




void DIV_CORDIC_Handler(void)
{
    volatile void (*entry)(void);
    entry = (volatile void(*)())(*(uint32_t *)(APP_ADDR + DIV_CORDIC_Offset));
    entry();
}
