/**
  ******************************************************************************
  * @file    lcm32f06x_wt.c 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   This file provides all the wt firmware functions.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x_wt.h"

/* Private define ------------------------------------------------------------*/

/**
  * @name   WT_Init
  * @brief  EN: Initializes the WT peripheral according to the specified 
  *             parameters in the WT_InitStruct.
  *         CN:  WT_InitStruct ָĲʼ WT
  * @param  WTx: 
  *         EN: Specific WT peripherals.
  *         CN: ض WT 衣
  * @param  WT_InitStruct:  
  *         EN: pointer to a WT_InitTypeDef structure that contains the 
  *             configuration information for the specified WT peripheral.
  *         CN: ָ WT_InitTypeDef ṹָ룬ýṹָ WT Ϣ
  * @retval None
  */
void WT_Init(WT_TypeDef *WTx, WT_InitTypeDef *WT_InitStruct)
{

  /* Check the WT parameters */
  assert_param(IS_WT_BZOUT(WT_InitStruct->WT_BZOUT));
  assert_param(IS_WT_WTState(WT_InitStruct->WT_WTState));
  assert_param(IS_WT_Outfrequency(WT_InitStruct->WT_Outfrequency));
  assert_param(IS_WT_T8State(WT_InitStruct->WT_T8State));
  assert_param(IS_WT_T8frequency(WT_InitStruct->WT_T8frequency));
  assert_param(IS_WT_Interrupt(WT_InitStruct->WT_Interrupt));

  WT->WTCON = WT_InitStruct->WT_BZOUT | WT_InitStruct->WT_WTState |
              WT_InitStruct->WT_Outfrequency | WT_InitStruct->WT_T8State |
              WT_InitStruct->WT_T8frequency | WT_InitStruct->WT_Interrupt;
}

/**
  * @name   WT_StructInit
  * @brief  EN: Fills each WT_InitStruct member with its default value.
  *         CN: Ĭֵÿ WT_InitStruct Ա
  * @param  WT_InitStruct: 
  *         EN: pointer to a WT_InitTypeDef structure that contains the 
  *             configuration information for the specified WT peripheral.
  *         CN: ָ WT_InitTypeDef ṹָ룬ýṹָ WT Ϣ
  * @retval None
  */
void WT_StructInit(WT_InitTypeDef *WT_InitStruct)
{
  WT_InitStruct->WT_BZOUT = WT_BZOUT_Hight;

  WT_InitStruct->WT_WTState = WT_WTState_Disable;

  WT_InitStruct->WT_Outfrequency = WT_Outfrequency_1024;

  WT_InitStruct->WT_T8State = WT_T8State_Disable;

  WT_InitStruct->WT_T8frequency = WT_T8frequency_4096;

  WT_InitStruct->WT_Interrupt = WT_Interrupt_2HZ;
}

/**
  * @name   WT_SetCounter
  * @brief  EN: Set the initial value of the timer.
  *         CN: öʱʼֵ
  * @param  WTx: 
  *         EN: Specific WT peripherals.
  *         CN: ض WT 衣
  * @param  Counter:
  *         EN: The specified timer value.
  *         CN: ָĶʱֵ
  * @retval None
  */
void WT_SetCounter(WT_TypeDef *WTx, uint16_t Counter)
{
  WTx->T8 = Counter;
}

/**
  * @name   WT_ClearITPendingBit
  * @brief  EN: Clear WT interrupt.
  *         CN:  WT жϡ
  * @param  WTx: 
  *         EN: Specific WT peripherals.
  *         CN: ض WT 衣
  * @retval None
  */
void WT_ClearITPendingBit(WT_TypeDef *WTx)
{
  WTx->WTCON &= ~WT_WTCON_WTF_Msk;
}
