/**
  ******************************************************************************
  * @file    lcm32f06x_div.c
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   This file provides all the div firmware functions.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x_div.h"

/**
  * @name   Fun_32_DIV_16
  * @brief  EN: 32-bit divided by 16 bits function.
  *         CN: 32λ16λܡ
  * @param  dividend:
  *         EN: The dividend.
  *         CN: 
  * @param  divisor: 
  *         EN: The Divisor.
  *         CN: 
  * @param  result:
  *         EN: result.
  *         CN: 
  * @retval None
  */
int Fun_32_DIV_16(int dividend, int divisor, result_t *result)
{
  __disable_irq();
  DIV0->DIV_CTRL_b.DIV16 = 0; //32λ
  DIV0->DIV_ALO = dividend;
  DIV0->DIV_B = divisor;
  while (DIV0->DIV_CTRL_b.DIV_IN_PROCCEED == RESET)
  {
    __NOP(); __NOP(); __NOP(); __NOP(); __NOP();
  };
  DIV0->DIV_CTRL_b.DIV_IN_PROCCEED = SET; //д10
  result->discuss = DIV0->DIV_QUOT;
  result->remainder = DIV0->DIV_REM;
  __enable_irq();
  return result->discuss;
}

/**
  * @name   Fun_16_DIV_16
  * @brief  EN: 16-bit divided by 16 bits function.
  *         CN: 16λ16λܡ
  * @param  dividend:
  *         EN: The dividend.
  *         CN: 
  * @param  divisor: 
  *         EN: The Divisor.
  *         CN: 
  * @param  result:
  *         EN: result.
  *         CN: 
  * @retval None
  */
int Fun_16_DIV_16(int dividend, int divisor, result_t *result)
{
  __disable_irq();
  DIV0->DIV_CTRL_b.DIV16 = 1; //16λ
  DIV0->DIV_ALO = dividend;
  DIV0->DIV_B = divisor;
  while (DIV0->DIV_CTRL_b.DIV_IN_PROCCEED == RESET)
  {
    __NOP(); __NOP(); __NOP(); __NOP(); __NOP();
  };
  DIV0->DIV_CTRL_b.DIV_IN_PROCCEED = SET; //д10
  result->discuss = DIV0->DIV_QUOT;
  result->remainder = DIV0->DIV_REM;
  __enable_irq();
  return result->discuss;
}
