/**
  ******************************************************************************
  * @file    lcm32f06x_dbgmcu.c
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   This file provides all the dbgmcu firmware functions.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Includes ------------------------------------------------------------------*/
#if 1
#include "lcm32f06x_dbgmcu.h"

#define IDCODE_DEVID_MASK ((uint32_t)0x00000FFF)

uint32_t DBGMCU_GetREVID(void)
{
  return 0;
}

/**
  * @brief  Returns the device identifier.
  * @param  None
  * @retval Device identifier
  */
uint32_t DBGMCU_GetDEVID(void)
{
  return 0;
}

/**
  * @}
  */

/**
  * @brief  Configures low power mode behavior when the MCU is in Debug mode.
  * @param  DBGMCU_Periph: specifies the low power mode.
  *         This parameter can be any combination of the following values:
  *             @arg DBGMCU_STOP: Keep debugger connection during STOP mode
  *             @arg DBGMCU_STANDBY: Keep debugger connection during STANDBY mode
  * @param  NewState: new state of the specified low power mode in Debug mode.
  *         This parameter can be: ENABLE or DISABLE.
  * @retval None
  */
void DBGMCU_Config(uint32_t DBGMCU_Periph, FunctionalState NewState)
{
  /* Check the parameters */
  assert_param(IS_DBGMCU_PERIPH(DBGMCU_Periph));
  assert_param(IS_FUNCTIONAL_STATE(NewState));

  if (NewState != DISABLE)
  {
    //DBGMCU->CR |= DBGMCU_Periph;
  }
  else
  {
    //DBGMCU->CR &= ~DBGMCU_Periph;
  }
}

/**
  * @name   DBGMCU_APB0PeriphConfig
  * @brief  EN: Configures APB0 peripheral behavior when the MCU is in Debug mode.
  *         CN: MCUڵģʽʱAPB0Χ豸Ϊ
  * @param  DBGMCU_Periph: 
  *         EN: specifies the APB0 peripheral.
  *         CN: ָAPB0Χ豸
  *             @arg DBGMCU_TIM1_STOP
  *             @arg DBGMCU_TIM15_STOP
  *             @arg DBGMCU_TIM16_STOP
  *             @arg DBGMCU_TIM17_STOP: 
  *             @arg DBGMCU_WT_STOP
  *             @arg DBGMCU_IWDG_STOP
  *             @arg DBGMCU_TIM2_STOP
  * @param  NewState: 
  *         EN: new state of the specified APB0 peripheral in Debug mode.
  *         CN: ָAPB0Χ豸ڵģʽµ״̬
  * @retval None
  */
void DBGMCU_APB0PeriphConfig(uint32_t DBGMCU_Periph, FunctionalState NewState)
{
  /* Check the parameters */
  assert_param(IS_DBGMCU_APB0PERIPH(DBGMCU_Periph));
  assert_param(IS_FUNCTIONAL_STATE(NewState));

  if (NewState != DISABLE)
  {
    sysctrl_access();
    SYSCTRL->DBG_CFG |= DBGMCU_Periph;
    __dekey();
  }
  else
  {
    sysctrl_access();
    SYSCTRL->DBG_CFG &= ~DBGMCU_Periph;
    __dekey();
  }
}

/************************ (C) COPYRIGHT LCMicroelectronics *****END OF FILE****/

#endif
