/**
  ******************************************************************************
  * @file    lcm32f06x_wt.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for wt.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_WT_H__
#define __LCM32F06X_WT_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

#ifdef __cplusplus
  extern "C" {
#endif

/** 
  * @brief WT Init structure definition
  */

typedef struct
{
  uint16_t WT_BZOUT;        /*!< EN: The buzzer output high and low frequency selection bit.  
                                 CN: ߵƵѡλ 
                                 @Register: WTCON @Bits:[8]BZLS
                                 @default:  WT_BZOUT_Hight                    */

  uint16_t WT_WTState;      /*!< EN: WT enable bit.  
                                 CN: WT ʹλ
                                 @Register: WTCON @Bits:[7]WTEN
                                 @default:  WT_WTState_Disable                */

  uint16_t WT_Outfrequency; /*!< EN: The output frequency of the buzzer selection bit.  
                                 CN: Ƶѡλ
                                 @Register: WTCON @Bits:[5:4]BUZS
                                 @default:  WT_Outfrequency_1024              */

  uint16_t WT_T8State;      /*!< EN: T8 enable bit.  
                                 CN: T8 ʹλ
                                 @Register: WTCON @Bits:[3]TR8
                                 @default:  WT_T8State_Disable                */

  uint16_t WT_T8frequency;  /*!< EN: T8 Select bit of the clock source.  
                                 CN: T8 ʱԴѡλ
                                 @Register: WTCON @Bits:[2:1]T8CKS
                                 @default:  WT_T8frequency_4096               */

  uint16_t WT_Interrupt;    /*!< EN: WT interrupt source selection bit.  
                                 CN: WT жԴѡλ
                                 @Register: WTCON @Bits:[0]WTINTS
                                 @default:  WT_Interrupt_2HZ                  */
} WT_InitTypeDef;

/* @defgroup WT_BZOUT */
#define WT_BZOUT_Hight                   ((uint16_t)0x0000) /*@EN: Output high-frequency @CN: Ƶ */
#define WT_BZOUT_Low                     ((uint16_t)0x0100) /*@EN: Output low-frequency  @CN: Ƶ */
#define IS_WT_BZOUT(MODE)                (((MODE) == WT_BZOUT_Hight) || \
                                          ((MODE) == WT_BZOUT_Low))
/* @end */

/* @defgroup WT_WTState */
#define WT_WTState_Enable                ((uint16_t)0x0080) /*@EN: Enable WT  @CN: ʹ WT */
#define WT_WTState_Disable               ((uint16_t)0x0000) /*@EN: Disable WT @CN: ֹ WT */
#define IS_WT_WTState(STATE)             (((STATE) == WT_WTState_Enable) || \
                                          ((STATE) == WT_WTState_Disable))
/* @end */

/* @defgroup WT_Outfrequency */
#define WT_Outfrequency_1024             ((uint16_t)0x0000) /*@EN: Output frequency 1024 HZ @CN: Ƶ 1024 HZ */
#define WT_Outfrequency_2048             ((uint16_t)0x0010) /*@EN: Output frequency 2048 HZ @CN: Ƶ 2048 HZ */
#define WT_Outfrequency_4096             ((uint16_t)0x0020) /*@EN: Output frequency 4096 HZ @CN: Ƶ 4096 HZ */
#define WT_Outfrequency_8192             ((uint16_t)0x0030) /*@EN: Output frequency 8192 HZ @CN: Ƶ 8192 HZ */
#define WT_Outfrequency_0_25             ((uint16_t)0x0000) /*@EN: Output frequency 1024 HZ @CN: Ƶ 0.25 HZ */
#define WT_Outfrequency_0_5              ((uint16_t)0x0010) /*@EN: Output frequency 2048 HZ @CN: Ƶ 0.5  HZ */
#define WT_Outfrequency_1                ((uint16_t)0x0020) /*@EN: Output frequency 4096 HZ @CN: Ƶ 1    HZ */
#define WT_Outfrequency_2                ((uint16_t)0x0030) /*@EN: Output frequency 8192 HZ @CN: Ƶ 2    HZ */
#define IS_WT_Outfrequency(Outfrequency) (((Outfrequency) == WT_Outfrequency_1024) || \
                                          ((Outfrequency) == WT_Outfrequency_2048) || \
                                          ((Outfrequency) == WT_Outfrequency_4096) || \
                                          ((Outfrequency) == WT_Outfrequency_8192))
/* @end */

/* @defgroup WT_T8State */
#define WT_T8State_Disable               ((uint16_t)0x0000) /*@EN: Enable T8  @CN: ʹ T8 */
#define WT_T8State_Enable                ((uint16_t)0x0008) /*@EN: Disable T8 @CN: ֹ T8 */
#define IS_WT_T8State(STATE)             (((STATE) == WT_T8State_Enable) || \
                                          ((STATE) == WT_T8State_Disable))
/* @end */

/* @defgroup WT_T8frequency */
#define WT_T8frequency_4096              ((uint16_t)0x0000) /*@EN: T8 clock selection 4096 @CN: T8 ʱѡ 4096 */
#define WT_T8frequency_64                ((uint16_t)0x0002) /*@EN: T8 clock selection 64   @CN: T8 ʱѡ 64   */
#define WT_T8frequency_1                 ((uint16_t)0x0004) /*@EN: T8 clock selection 1    @CN: T8 ʱѡ 1    */
#define WT_T8frequency_1_60              ((uint16_t)0x0006) /*@EN: T8 clock selection 1/60 @CN: T8 ʱѡ 1/60 */
#define IS_WT_T8frequency(frequency)     (((frequency) == WT_T8frequency_4096) || \
                                          ((frequency) == WT_T8frequency_64)   || \
                                          ((frequency) == WT_T8frequency_1)    || \
                                          ((frequency) == WT_T8frequency_1_60))
/* @end */

/* @defgroup WT_Interrupt */
#define WT_Interrupt_2HZ                 ((uint16_t)0x0000) /*@EN: WT interrupt source selection 2HZ    @CN: WT жԴѡ 2HZ    */
#define WT_Interrupt_T8DOWN              ((uint16_t)0x0001) /*@EN: WT interrupt source selection T8DOWM @CN: WT жԴѡ T8DOWM */
#define IS_WT_Interrupt(Interrupt)       (((Interrupt) == WT_Interrupt_2HZ) || \
                                          ((Interrupt) == WT_Interrupt_T8DOWN))
/* @end */

/* ========================================================================== */
/* ================              WT  REGISTER BIT               ============= */
/* ========================================================================== */

/* ================================  WTCON  ================================= */
#define WT_WTCON_BZLS_Pos                         (8UL)                        /*!< WTCON (Bit 8)                      */
#define WT_WTCON_BZLS_Msk                         (0x00000100UL)               /*!< WTCON (Bitfield-Mask: 0x01)        */
#define WT_WTCON_WTEN_Pos                         (7UL)                        /*!< WTCON (Bit 7)                      */
#define WT_WTCON_WTEN_Msk                         (0x00000080UL)               /*!< WTCON (Bitfield-Mask: 0x01)        */
#define WT_WTCON_WTF_Pos                          (6UL)                        /*!< WTCON (Bit 6)                      */
#define WT_WTCON_WTF_Msk                          (0x00000040UL)               /*!< WTCON (Bitfield-Mask: 0x01)        */
#define WT_WTCON_BUZS_Pos                         (4UL)                        /*!< WTCON (Bit 4)                      */
#define WT_WTCON_BUZS_Msk                         (0x00000030UL)               /*!< WTCON (Bitfield-Mask: 0x03)        */
#define WT_WTCON_TR8_Pos                          (3UL)                        /*!< WTCON (Bit 3)                      */
#define WT_WTCON_TR8_Msk                          (0x00000008UL)               /*!< WTCON (Bitfield-Mask: 0x01)        */
#define WT_WTCON_T8CKS_Pos                        (1UL)                        /*!< WTCON (Bit 1)                      */
#define WT_WTCON_T8CKS_Msk                        (0x00000006UL)               /*!< WTCON (Bitfield-Mask: 0x03)        */
#define WT_WTCON_WTINTS_Pos                       (0UL)                        /*!< WTCON (Bit 0)                      */
#define WT_WTCON_WTINTS_Msk                       (0x00000001UL)               /*!< WTCON (Bitfield-Mask: 0x01)        */
/* ==================================  T8  ================================== */
#define WT_T8_Pos                                 (0UL)                        /*!< T8 (Bit 0)                         */
#define WT_T8_Msk                                 (0x000000FFUL)               /*!< T8 (Bitfield-Mask: 0xff)           */

/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */
void WT_Init(WT_TypeDef *WTx, WT_InitTypeDef *WT_InitStruct);
void WT_StructInit(WT_InitTypeDef *WT_InitStruct);
void WT_SetCounter(WT_TypeDef *WTx, uint16_t Counter);
void WT_ClearITPendingBit(WT_TypeDef *WTx);
#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_WT_H__

