/**
  ******************************************************************************
  * @file    lcm32f06x_usart.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for usart.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_USART_H__
#define __LCM32F06X_USART_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

#ifdef __cplusplus
  extern "C" {
#endif

/** 
  * @brief LIN Init structure definition
  */
typedef struct
{
  uint32_t LIN_Mode;                  /*!< EN: Configure the working mode of serial port LIN
                                           CN: ô LIN Ĺģʽ
                                           @Register: LINCON1 @Bits:[0]MS 
                                           @default:  LIN_Mode_Master         */

  uint32_t LIN_ResponseLen;           /*!< EN: Configure the response data length for serial port LIN
                                           CN: ô LIN Ӧݳ
                                           @Register: DATCON @Bits:[2:0]DATLEN
                                           @default:  LIN_ResponseLength_1b   */

  uint32_t LIN_ChecksunStore;         /*!< EN: Select checksum store
                                           CN: checksum 洢ѡ
                                           @Register: LINCON1 @Bits:[5]CSI
                                           @default:  LIN_None_Write_RXFIFO   */

  uint32_t LIN_BitErrorCheck;         /*!< EN: Select bit error check
                                           CN: λ
                                           @Register: FRAMECON @Bits:[6]CEN
                                           @default:  LIN_BitErrorCheck_Disable */

  uint32_t LIN_BreakSyncGap;          /*!< EN: The length of the interval between 
                                               the end of a break and the beginning of 
                                               a synchronized byte
                                           CN: break ֽͬڿʼ֮ļ
                                           @Register: FRAMECON @Bits:[5:3]LEAD
                                           @default:  LIN_BreakSyncGap_1b     */

  uint32_t LIN_TransmissionGap;       /*!< EN: The interval length for transmitting
                                               bytes
                                           CN: ֽڵļ
                                           @Register: FRAMECON @Bits:[2:0]IDLE
                                           @default:  LIN_TransmissionGap_0b  */

  uint32_t LIN_ResponseRole;          /*!< EN: Configure Response Usage
                                           CN:  Response ;
                                           @Register: DATCON @Bits:[4]RM
                                           @default:  LIN_Freme_Timeout       */

  uint32_t LIN_ParityType;            /*!< EN: Configure the verification type of 
                                               serial port LIN
                                           CN: ô LIN У
                                           @Register: DATCON @Bits:[5]CMS
                                           @default:  LIN_Classic_Checck      */
} LIN_InitTypeDef;

/* @defgroup LIN_Mode */
#define LIN_Mode_Master                         ((uint32_t)0x00000001) /*@EN: Master mode  @CN: ģʽ */
#define LIN_Mode_Slave                          ((uint32_t)0x00000000) /*@EN: Slave mode @CN: ӻģʽ */
#define IS_LIN_MODE(MODE)                       (((MODE )== LIN_Mode_Master) ||\
                                                 ((MODE) == LIN_Mode_Slave))
/* @end */

/* @defgroup LIN_ChecksunStore */
#define LIN_None_Write_RXFIFO                   ((uint32_t)0x00000000) /*@EN: Do not write RXFIFO  @CN: дRXFIFO */
#define LIN_Write_RXFIFO                        ((uint32_t)0x00000020) /*@EN: Write RXFIFO @CN: дRXFIFO */
#define IS_LIN_CHECKSELECT(CHECK)               (((CHECK )== LIN_None_Write_RXFIFO) ||\
                                                 ((CHECK) == LIN_Write_RXFIFO))
/* @end */

/* @defgroup LIN_BitErrorCheck */
#define LIN_BitErrorCheck_Disable               ((uint32_t)0x00000000) /*@EN: Prohibit bit error checking @CN: ֹλ */
#define LIN_BitErrorCheck_Enable                ((uint32_t)0x00000040) /*@EN: Enable bit error check      @CN: ʹλ */
#define IS_LIN_BITERROR(CHECK)                  (((CHECK )== LIN_BitErrorCheck_Disable) ||\
                                                 ((CHECK) == LIN_BitErrorCheck_Enable))
/* @end */

/* @defgroup LIN_ResponseRole */
#define LIN_Freme_Timeout                       ((uint32_t)0x00000000) /*@EN: Frame timeout  @CN: frame ʱ */
#define LIN_Response_Timeout                    ((uint32_t)0x00000010) /*@EN: Response timeout @CN: response ʱ */
#define IS_LIN_USAGE(USAGE)                      (((USAGE )== LIN_MessageHead_Response) ||\
                                                 ((USAGE) == LIN_Only_MessageHead))
/* @end */

/* @defgroup LIN_BreakSyncGap */
#define LIN_BreakSyncGap_1b                     ((uint32_t)0x00000000) /*@EN: 1 break gap length bits @CN: 1 λ break  */
#define LIN_BreakSyncGap_2b                     ((uint32_t)0x00000008) /*@EN: 2 break gap length bits @CN: 2 λ break  */
#define LIN_BreakSyncGap_3b                     ((uint32_t)0x00000010) /*@EN: 3 break gap length bits @CN: 3 λ break  */
#define LIN_BreakSyncGap_4b                     ((uint32_t)0x00000018) /*@EN: 4 break gap length bits @CN: 4 λ break  */
#define LIN_BreakSyncGap_5b                     ((uint32_t)0x00000020) /*@EN: 5 break gap length bits @CN: 5 λ break  */
#define LIN_BreakSyncGap_6b                     ((uint32_t)0x00000028) /*@EN: 6 break gap length bits @CN: 6 λ break  */
#define LIN_BreakSyncGap_7b                     ((uint32_t)0x00000030) /*@EN: 7 break gap length bits @CN: 7 λ break  */
#define LIN_BreakSyncGap_8b                     ((uint32_t)0x00000038) /*@EN: 8 break gap length bits @CN: 8 λ break  */
#define IS_LIN_BREAK_LENGTH(LENGTH)             (((LENGTH) == LIN_BreakSyncGap_1b) || \
                                                 ((LENGTH) == LIN_BreakSyncGap_2b) || \
                                                 ((LENGTH) == LIN_BreakSyncGap_3b) || \
                                                 ((LENGTH) == LIN_BreakSyncGap_4b) || \
                                                 ((LENGTH) == LIN_BreakSyncGap_5b) || \
                                                 ((LENGTH) == LIN_BreakSyncGap_6b) || \
                                                 ((LENGTH) == LIN_BreakSyncGap_7b) || \
                                                 ((LENGTH) == LIN_BreakSyncGap_8b))
/* @end */

/* @defgroup LIN_TransmissionGap */
#define LIN_TransmissionGap_0b                  ((uint32_t)0x00000000) /*@EN: 0 trans gap length bits @CN: 0 λ  */
#define LIN_TransmissionGap_1b                  ((uint32_t)0x00000001) /*@EN: 1 trans gap length bits @CN: 1 λ  */
#define LIN_TransmissionGap_2b                  ((uint32_t)0x00000002) /*@EN: 2 trans gap length bits @CN: 2 λ  */
#define LIN_TransmissionGap_3b                  ((uint32_t)0x00000003) /*@EN: 3 trans gap length bits @CN: 3 λ  */
#define LIN_TransmissionGap_4b                  ((uint32_t)0x00000004) /*@EN: 4 trans gap length bits @CN: 4 λ  */
#define LIN_TransmissionGap_5b                  ((uint32_t)0x00000005) /*@EN: 5 trans gap length bits @CN: 5 λ  */
#define LIN_TransmissionGap_6b                  ((uint32_t)0x00000006) /*@EN: 6 trans gap length bits @CN: 6 λ  */
#define LIN_TransmissionGap_7b                  ((uint32_t)0x00000007) /*@EN: 7 trans gap length bits @CN: 7 λ  */
#define IS_LIN_TRANS_LENGTH(LENGTH)             (((LENGTH) == LIN_TransmissionGap_0b) || \
                                                 ((LENGTH) == LIN_TransmissionGap_1b) || \
                                                 ((LENGTH) == LIN_TransmissionGap_2b) || \
                                                 ((LENGTH) == LIN_TransmissionGap_3b) || \
                                                 ((LENGTH) == LIN_TransmissionGap_4b) || \
                                                 ((LENGTH) == LIN_TransmissionGap_5b) || \
                                                 ((LENGTH) == LIN_TransmissionGap_6b) || \
                                                 ((LENGTH) == LIN_TransmissionGap_7b))
/* @end */

/* @defgroup LIN_ResponseLen */
#define LIN_ResponseLength_1b                   ((uint32_t)0x00000000) /*@EN: 1 response data length byte @CN: 1 ֽӦݳ */
#define LIN_ResponseLength_2b                   ((uint32_t)0x00000001) /*@EN: 2 response data length byte @CN: 2 ֽӦݳ */
#define LIN_ResponseLength_3b                   ((uint32_t)0x00000002) /*@EN: 3 response data length byte @CN: 3 ֽӦݳ */
#define LIN_ResponseLength_4b                   ((uint32_t)0x00000003) /*@EN: 4 response data length byte @CN: 4 ֽӦݳ */
#define LIN_ResponseLength_5b                   ((uint32_t)0x00000004) /*@EN: 5 response data length byte @CN: 5 ֽӦݳ */
#define LIN_ResponseLength_6b                   ((uint32_t)0x00000005) /*@EN: 6 response data length byte @CN: 6 ֽӦݳ */
#define LIN_ResponseLength_7b                   ((uint32_t)0x00000006) /*@EN: 7 response data length byte @CN: 7 ֽӦݳ */
#define LIN_ResponseLength_8b                   ((uint32_t)0x00000007) /*@EN: 8 response data length byte @CN: 8 ֽӦݳ */
#define IS_LIN_RESPONSE_LENGTH(LENGTH)          (((LENGTH) == USART_WordLength_1b) || \
                                                 ((LENGTH) == USART_WordLength_2b) || \
                                                 ((LENGTH) == USART_WordLength_3b) || \
                                                 ((LENGTH) == USART_WordLength_4b) || \
                                                 ((LENGTH) == USART_WordLength_5b) || \
                                                 ((LENGTH) == USART_WordLength_6b) || \
                                                 ((LENGTH) == USART_WordLength_7b) || \
                                                 ((LENGTH) == USART_WordLength_8b))
/* @end */

/* @defgroup LIN_ParityType */
#define LIN_Classic_Checck                      ((uint32_t)0x00000000) /*@EN: Classic verification  @CN: У */
#define LIN_Enhance_Checck                      ((uint32_t)0x00000020) /*@EN: Enhanced verification @CN: ǿУ */
#define IS_LIN_PARITYTYPE(CHECK)                (((CHECK )== LIN_Classic_Checck) ||\
                                                 ((CHECK) == LIN_Enhance_Checck))
/* @end */

/* @defgroup LIN_CurrentStatus */
#define LIN_CURRENT_Work_ACTIVE                 ((uint32_t)0x00000000) /*@EN: LIN current active state @CN: LIN ǰԾ״̬ */
#define LIN_CURRENT_Work_SLEEP                  ((uint32_t)0x00000100) /*@EN: LIN current sleep state  @CN: LIN ǰ״̬ */
#define IS_USART_LIN_CURRENT_STATUS(Status)     ((Status == LIN_CURRENT_Work_ACTIVE) || \
                                                 (Status == LIN_CURRENT_Work_SLEEP))
/* @end */

/* @defgroup LIN_SCM */
#define LIN_Software                            ((uint32_t)0x00000008) /*@EN: Software implementation of LIN function @CN: ʵLIN */
#define LIN_Hardware                            ((uint32_t)0x00000000) /*@EN: Hardware implementation of LIN function @CN: ӲʵLIN */
#define IS_USART_LIN_FUNCTION_TYPE(TYPE)        ((TYPE == LIN_Software) || \
                                                 (TYPE == LIN_Hardware))
/* @end */

/* @defgroup LIN_ModeStatus */
#define LIN_MODE_IDLE                           ((uint32_t)0x00000000) /*@EN: LIN Idle mode status @CN: LIN Idle ģʽ״̬*/ 
#define LIN_MODE_BREAK                          ((uint32_t)0x00000002) /*@EN: LIN Break mode status @CN: LIN Break ģʽ״̬ */ 
#define LIN_MODE_BREAKDELIMITER                 ((uint32_t)0x00000004) /*@EN: LIN Break Delimiter mode status @CN: LIN Break Delimiter ģʽ״̬ */ 
#define LIN_MODE_SYNCHFIELD                     ((uint32_t)0x00000006) /*@EN: LIN Synch Field mode status @CN: LIN Synch Field ģʽ״̬ */ 
#define LIN_MODE_PARITYFIELD                    ((uint32_t)0x00000008) /*@EN: LIN Parity Identifier Field mode status @CN: LIN Parity Identifier Field ģʽ״̬ */ 
#define LIN_MODE_HEADRECEPTION                  ((uint32_t)0x0000000A) /*@EN: LIN Header completed mode status @CN: LIN Header completed ģʽ״̬ */ 
#define LIN_MODE_DATARECEPTION                  ((uint32_t)0x0000000C) /*@EN: LIN Data Field mode status @CN: Data Field ģʽ״̬ */ 
#define LIN_MODE_CHECKSUM                       ((uint32_t)0x0000000E) /*@EN: LIN Checksum mode status @CN: LIN Checksum ģʽ״̬ */ 
#define LIN_MODE_WAKEUPFIELD                    ((uint32_t)0x0000001E) /*@EN: LIN Wake up transmission field mode status @CN: LIN Wake up transmission field ģʽ״̬*/ 
#define IS_USART_LIN_MODE_STATUS(ModeStatus)    ((ModeStatus == LIN_MODE_IDLE)           || \
                                                 (ModeStatus == LIN_MODE_BREAK)          || \
                                                 (ModeStatus == LIN_MODE_BREAKDELIMITER) || \
                                                 (ModeStatus == LIN_MODE_SYNCHFIELD)     || \
                                                 (ModeStatus == LIN_MODE_PARITYFIELD)    || \
                                                 (ModeStatus == LIN_MODE_HEADRECEPTION)  || \
                                                 (ModeStatus == LIN_MODE_DATARECEPTION)  || \
                                                 (ModeStatus == LIN_MODE_CHECKSUM)       || \
                                                 (ModeStatus == LIN_MODE_WAKEUPFIELD))
/* @end */

/* @defgroup LIN_PinStatus */
#define LIN_PIN_LEVEL_LOW                       ((uint32_t)0x00000000) /*@EN: Receive pin low level @CN: LIN ŵ͵ƽ */
#define LIN_PIN_LEVEL_HIGH                      ((uint32_t)0x00000001) /*@EN: Receive pin high level @CN: LIN Ÿߵƽ */
#define IS_USART_LIN_LEVEL_STATUS(PinStatus)    ((PinStatus == LIN_PIN_LEVEL_LOW) || \
                                                 (PinStatus == LIN_PIN_LEVEL_HIGH))
/* @end */

/* @defgroup LIN_IT */
#define LIN_IT_SFI                                ((uint32_t)0x00001000) /* @EN: LIN synchronization segment error interrupt bit @CN: LIN ͬδжλ */
#define LIN_IT_LZI                                ((uint32_t)0x00000800) /* @EN: LIN Long zero interrupt bit @CN: LIN ж״̬λ */
#define LIN_IT_REDI                               ((uint32_t)0x00000400) /* @EN: LINRX rising edge detection interrupt status bit @CN: LINRX ж״̬λ */
#define LIN_IT_FEDI                               ((uint32_t)0x00000200) /* @EN: LINRX falling edge detection interrupt status bit @CN: LINRX ж״̬λ */
#define LIN_IT_LPI                                ((uint32_t)0x00000100) /* @EN: LIN identifier parity interrupt bit @CN: LIN ʶżУж״̬λ */
#define LIN_IT_LCI                                ((uint32_t)0x00000080) /* @EN: LIN checksum error interrupt bit @CN: LIN Уʹж״̬λ */
#define LIN_IT_LAI                                ((uint32_t)0x00000040) /* @EN: LIN automatic baud rate detection error interrupt bit @CN: LIN Զж״̬λ */
#define LIN_IT_RTI                                ((uint32_t)0x00000020) /* @EN: LIN response timeout interrupt bit @CN: LIN Ӧʱж״̬λ */
#define LIN_IT_HTI                                ((uint32_t)0x00000010) /* @EN: LIN frame header timeout interrupt bit @CN: LIN ֡ͷʱж״̬λ */
#define LIN_IT_TRI                                ((uint32_t)0x00000008) /* @EN: LIN response sending interrupt bit @CN: LIN Ӧж״̬λ */
#define LIN_IT_THI                                ((uint32_t)0x00000004) /* @EN: LIN frame sending interrupt blocking bit @CN: LIN ֡ͷж״̬λ */
#define LIN_IT_RRI                                ((uint32_t)0x00000002) /* @EN: LIN response receive interrupt bit @CN: LIN Ӧж״̬λ */
#define LIN_IT_RHI                                ((uint32_t)0x00000001) /* @EN: LIN frame header receive interrupt bit @CN: LIN ֡ͷж״̬λ */
#define IS_LIN_IT(LIN_IT)                         ((LIN_IT == LIN_IT_SFI)  || \
                                                   (LIN_IT == LIN_IT_LZI)  || \
                                                   (LIN_IT == LIN_IT_REDI) || \
                                                   (LIN_IT == LIN_IT_FEDI) || \
                                                   (LIN_IT == LIN_IT_LPI)  || \
                                                   (LIN_IT == LIN_IT_LCI)  || \
                                                   (LIN_IT == LIN_IT_LAI)  || \
                                                   (LIN_IT == LIN_IT_RTI)  || \
                                                   (LIN_IT == LIN_IT_HTI)  || \
                                                   (LIN_IT == LIN_IT_TRI)  || \
                                                   (LIN_IT == LIN_IT_THI)  || \
                                                   (LIN_IT == LIN_IT_RRI)  || \
                                                   (LIN_IT == LIN_IT_RHI))
/* @end */

/* @defgroup Request */
#define LIN_Master_Only_Header                    ((uint32_t)0x80000001) /*@EN: The host only sends frame headers  @CN: ֻ֡ͷ */
#define LIN_Master_Send_Response                  ((uint32_t)0x00000003) /*@EN: Host sends frame header and response  @CN: ֡ͷͷӦ */
#define LIN_Master_Recv_Response                  ((uint32_t)0x00000001) /*@EN: Host sends frame headers and receives responses  @CN: ֡ͷӦ */
#define LIN_Slave_Recv_Data                       ((uint32_t)0x00000000) /*@EN: Collect data from the machine  @CN: ӻ */
#define LIN_Slave_Send_Data                       ((uint32_t)0x00000002) /*@EN: Send data from the machine  @CN: ӻ */
#define LIN_Slave_None_Response                   ((uint32_t)0x80000000) /*@EN: Slave does not respond  @CN: ӻӦ */
#define LIN_Stop_Response                         ((uint32_t)0x00000004) /*@EN: Response aborted  @CN: Ӧֹ */
#define LIN_Wake_Up                               ((uint32_t)0x00000008) /*@EN: LIN wake-up  @CN: LIN  */
#define IS_LIN_REQUEST(REQUEST)                   ((REQUEST == LIN_Master_Only_Header)   || \
                                                   (REQUEST == LIN_Master_Send_Response) || \
                                                   (REQUEST == LIN_Master_Recv_Response) || \
                                                   (REQUEST == LIN_Slave_Recv_Data)      || \
                                                   (REQUEST == LIN_Slave_Send_Data)      || \
                                                   (REQUEST == LIN_Slave_None_Response)  || \
                                                   (REQUEST == LIN_Stop_Response)        || \
                                                   (REQUEST == LIN_Wake_Up))
/* @end */

/** 
  * @brief USART Init structure definition
  */
typedef struct
{
  uint32_t USART_BaudRate;            /*!< EN: This member configures the USART communication baud rate.
                                           CN: ôڵͨŲ
                                           @Register: USARTIBRD @Bits:[15:0]BAUDDIVINT 
                                                      USARTFBRD @Bits:[5:0]BAUDDIVFRAC
                                           @range 0x00000000 - 0xFFFFFFFF
                                           @default:  115200                  */

  uint32_t USART_WordLength;          /*!< EN: Specifies the number of data bits transmitted or received in a frame.
                                           CN: ָһ֡зͻյλ
                                           @Register: USARTLCR_H @Bits:[6:5]WLEN
                                           @default:  USART_WordLength_5b     */

  uint32_t USART_StopBits;            /*!< EN: Specifies the number of stop bits transmitted.
                                           CN: ָֹͣλ
                                           @Register: USARTLCR_H @Bits:[3]STP2
                                           @default:  USART_StopBits_1        */

  uint32_t USART_Parity;              /*!< EN: Specifies the parity mode.
                                           CN: ָżУģʽ
                                           @Register: USARTLCR_H @Bits:[2:1]EPS PEN
                                           @default:  USART_Parity_No         */
  uint32_t USART_Mode;                /*!< EN: Specifies wether the Receive or Transmit mode is enabled or disabled.
                                           CN: ָûǽýջģʽ
                                           @Register: USARTCR @Bits:[9:8]RXE TXE
                                           @default:  USART_Mode_Rx | USART_Mode_Tx */

  uint32_t USART_HardwareFlowControl; /*!< EN: Specifies wether the hardware flow control mode is enabled or disabled.
                                           CN: ָǷӲģʽ
                                           @Register: USARTCR @Bits:[15:14]CTSEn RTSEn
                                           @default:  USART_HardwareFlowControl_None */
} USART_InitTypeDef;

/* @defgroup USART_WordLength */
#define USART_WordLength_5b                     ((uint32_t)0x00000000) /*@EN: 5 data bits @CN: 5 λλ */
#define USART_WordLength_6b                     ((uint32_t)0x00000020) /*@EN: 6 data bits @CN: 6 λλ */
#define USART_WordLength_7b                     ((uint32_t)0x00000040) /*@EN: 7 data bits @CN: 7 λλ */
#define USART_WordLength_8b                     ((uint32_t)0x00000060) /*@EN: 8 data bits @CN: 8 λλ */
#define IS_USART_WORD_LENGTH(LENGTH)            (((LENGTH) == USART_WordLength_5b) || \
                                                 ((LENGTH) == USART_WordLength_6b) || \
                                                 ((LENGTH) == USART_WordLength_7b) || \
                                                 ((LENGTH) == USART_WordLength_8b))
/* @end */

/* @defgroup USART_StopBits */
#define USART_StopBits_1                        ((uint32_t)0x00000000) /*@EN: 1 stop bits @CN: 1 λֹͣλ */
#define USART_StopBits_2                        ((uint32_t)0x00000008) /*@EN: 2 stop bits @CN: 2 λֹͣλ */
#define IS_USART_STOPBITS(STOPBITS)             (((STOPBITS) == USART_StopBits_1) || \
                                                 ((STOPBITS) == USART_StopBits_2))
/* @end */

/* @defgroup USART_Parity */
#define USART_Parity_No                         ((uint32_t)0x00000000) /*@EN: No Parity  @CN: żУ */
#define USART_Parity_Even                       ((uint32_t)0x00000006) /*@EN: even check @CN: żУ     */
#define USART_Parity_Odd                        ((uint32_t)0x00000002) /*@EN: Odd check  @CN: У     */
#define USART_Parity_One                        ((uint32_t)0x00000082) /*@EN: Parity check bit is 0 @CN: żУλΪ 0 */
#define USART_Parity_Zero                       ((uint32_t)0x00000086) /*@EN: Parity check bit is 1 @CN: żУλΪ 1 */
#define IS_USART_PARITY(PARITY)                 (((PARITY) == USART_Parity_No)   || \
                                                 ((PARITY) == USART_Parity_Even) || \
                                                 ((PARITY) == USART_Parity_Odd)  || \
                                                 ((PARITY) == USART_Parity_One)  || \
                                                 ((PARITY) == USART_Parity_Zero))
/* @end */

/* @defgroup USART_Mode */
#define USART_Mode_Rx                           ((uint32_t)0x00000200) /*@EN: receive mode  @CN: ģʽ */
#define USART_Mode_Tx                           ((uint32_t)0x00000100) /*@EN: transmit mode @CN: ģʽ */
#define IS_USART_MODE(MODE)                     (((MODE )== USART_Mode_Rx) ||\
                                                 ((MODE) == USART_Mode_Tx))
/* @end */

/* @defgroup USART_HardwareFlowControl */
#define USART_HardwareFlowControl_None           ((uint32_t)0x00000000) /*@EN: No hardware flow control @CN: Ӳ   */
#define USART_HardwareFlowControl_RTS            ((uint32_t)0x00004000) /*@EN: RTS flow control         @CN: RTS      */
#define USART_HardwareFlowControl_CTS            ((uint32_t)0x00008000) /*@EN: CTS flow control         @CN: CTS      */
#define USART_HardwareFlowControl_RTS_CTS        ((uint32_t)0x0000C000) /*@EN: RTS_CTS flow control     @CN: RTS_CTS  */
#define IS_USART_HARDWARE_FLOW_CONTROL(CONTROL)  (((CONTROL )== USART_HardwareFlowControl_None) ||\
                                                  ((CONTROL) == USART_HardwareFlowControl_RTS)  ||\
                                                  ((CONTROL) == USART_HardwareFlowControl_CTS)  ||\
                                                  ((CONTROL) == USART_HardwareFlowControl_RTS_CTS))
/* @end */

/* @defgroup USART_DirectionMode */
#define USART_Direction_Tx                       ((uint32_t)0x00000100) /*@EN: transmit direction @CN: ͷ */
#define USART_Direction_Rx                       ((uint32_t)0x00000200) /*@EN: receive direction  @CN: շ */
#define IS_USART_DIRECTION(USART_DirectionMode)  ((USART_DirectionMode == USART_Direction_Tx) || \
                                                  (USART_DirectionMode == USART_Direction_Rx))
/* @end */

/* @defgroup Event */
#define USART_WUS_ADDRSS                         ((uint32_t)0x00000000) /*@EN: Wake up occurs during address matching @CN: ַƥʱ */
#define USART_WUS_START_BIT                      ((uint32_t)0x00000010) /*@EN: Start bit detection wakes up @CN: ʼλⷢ */
#define IS_USART_WUS(WUS)                        ((WUS == USART_WUS_ADDRSS)    || \
                                                  (WUS == USART_WUS_START_BIT))
/* @end */

/* @defgroup RxFIFO */
#define USART_RXIFLSEL_LEAVEL_0_16                ((uint32_t)0x00000000) /*@EN: receive fifo 0/16 @CN:  FIFO 0/16 */
#define USART_RXIFLSEL_LEAVEL_1_16                ((uint32_t)0x00000010) /*@EN: receive fifo 1/16 @CN:  FIFO 1/16 */
#define USART_RXIFLSEL_LEAVEL_2_16                ((uint32_t)0x00000020) /*@EN: receive fifo 2/16 @CN:  FIFO 2/16 */
#define USART_RXIFLSEL_LEAVEL_3_16                ((uint32_t)0x00000030) /*@EN: receive fifo 3/16 @CN:  FIFO 3/16 */
#define USART_RXIFLSEL_LEAVEL_4_16                ((uint32_t)0x00000040) /*@EN: receive fifo 4/16 @CN:  FIFO 4/16 */
#define USART_RXIFLSEL_LEAVEL_5_16                ((uint32_t)0x00000050) /*@EN: receive fifo 5/16 @CN:  FIFO 5/16 */
#define USART_RXIFLSEL_LEAVEL_6_16                ((uint32_t)0x00000060) /*@EN: receive fifo 6/16 @CN:  FIFO 6/16 */
#define USART_RXIFLSEL_LEAVEL_7_16                ((uint32_t)0x00000070) /*@EN: receive fifo 7/16 @CN:  FIFO 7/16 */
#define USART_RXIFLSEL_LEAVEL_8_16                ((uint32_t)0x00000080) /*@EN: receive fifo 8/16 @CN:  FIFO 8/16 */
#define USART_RXIFLSEL_LEAVEL_9_16                ((uint32_t)0x00000090) /*@EN: receive fifo 9/16 @CN:  FIFO 9/16 */
#define USART_RXIFLSEL_LEAVEL_10_16               ((uint32_t)0x000000A0) /*@EN: receive fifo 10/16 @CN:  FIFO 10/16 */
#define USART_RXIFLSEL_LEAVEL_11_16               ((uint32_t)0x000000B0) /*@EN: receive fifo 11/16 @CN:  FIFO 11/16 */
#define USART_RXIFLSEL_LEAVEL_12_16               ((uint32_t)0x000000C0) /*@EN: receive fifo 12/16 @CN:  FIFO 12/16 */
#define USART_RXIFLSEL_LEAVEL_13_16               ((uint32_t)0x000000D0) /*@EN: receive fifo 13/16 @CN:  FIFO 13/16 */
#define USART_RXIFLSEL_LEAVEL_14_16               ((uint32_t)0x000000E0) /*@EN: receive fifo 14/16 @CN:  FIFO 14/16 */
#define USART_RXIFLSEL_LEAVEL_15_16               ((uint32_t)0x000000F0) /*@EN: receive fifo 15/16 @CN:  FIFO 15/16 */
#define IS_USART_RXIFLSEL_LEAVEL(FIFOLEAVEL)     ((FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_0_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_1_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_2_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_3_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_4_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_5_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_6_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_7_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_8_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_9_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_10_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_11_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_12_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_13_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_14_16) || \
                                                  (FIFOLEAVEL == USART_RXIFLSEL_LEAVEL_15_16))
/* @end */

/* @defgroup TxFIFO */
#define USART_TXIFLSEL_LEAVEL_0_16                ((uint32_t)0x00000000) /*@EN: transmit fifo 0/16 @CN:  FIFO 0/16 */
#define USART_TXIFLSEL_LEAVEL_1_16                ((uint32_t)0x00000001) /*@EN: transmit fifo 1/16 @CN:  FIFO 1/16 */
#define USART_TXIFLSEL_LEAVEL_2_16                ((uint32_t)0x00000002) /*@EN: transmit fifo 2/16 @CN:  FIFO 2/16 */
#define USART_TXIFLSEL_LEAVEL_3_16                ((uint32_t)0x00000003) /*@EN: transmit fifo 3/16 @CN:  FIFO 3/16 */
#define USART_TXIFLSEL_LEAVEL_4_16                ((uint32_t)0x00000004) /*@EN: transmit fifo 4/16 @CN:  FIFO 4/16 */
#define USART_TXIFLSEL_LEAVEL_5_16                ((uint32_t)0x00000005) /*@EN: transmit fifo 5/16 @CN:  FIFO 5/16 */
#define USART_TXIFLSEL_LEAVEL_6_16                ((uint32_t)0x00000006) /*@EN: transmit fifo 6/16 @CN:  FIFO 6/16 */
#define USART_TXIFLSEL_LEAVEL_7_16                ((uint32_t)0x00000007) /*@EN: transmit fifo 7/16 @CN:  FIFO 7/16 */
#define USART_TXIFLSEL_LEAVEL_8_16                ((uint32_t)0x00000008) /*@EN: transmit fifo 8/16 @CN:  FIFO 8/16 */
#define USART_TXIFLSEL_LEAVEL_9_16                ((uint32_t)0x00000009) /*@EN: transmit fifo 9/16 @CN:  FIFO 9/16 */
#define USART_TXIFLSEL_LEAVEL_10_16               ((uint32_t)0x0000000A) /*@EN: transmit fifo 10/16 @CN:  FIFO 10/16 */
#define USART_TXIFLSEL_LEAVEL_11_16               ((uint32_t)0x0000000B) /*@EN: transmit fifo 11/16 @CN:  FIFO 11/16 */
#define USART_TXIFLSEL_LEAVEL_12_16               ((uint32_t)0x0000000C) /*@EN: transmit fifo 12/16 @CN:  FIFO 12/16 */
#define USART_TXIFLSEL_LEAVEL_13_16               ((uint32_t)0x0000000D) /*@EN: transmit fifo 13/16 @CN:  FIFO 13/16 */
#define USART_TXIFLSEL_LEAVEL_14_16               ((uint32_t)0x0000000E) /*@EN: transmit fifo 14/16 @CN:  FIFO 14/16 */
#define USART_TXIFLSEL_LEAVEL_15_16               ((uint32_t)0x0000000F) /*@EN: transmit fifo 15/16 @CN:  FIFO 15/16 */
#define IS_USART_TXIFLSEL_LEAVEL(FIFOLEAVEL)     ((FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_0_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_1_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_2_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_3_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_4_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_5_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_6_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_7_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_8_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_9_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_10_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_11_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_12_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_13_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_14_16) || \
                                                  (FIFOLEAVEL == USART_TXIFLSEL_LEAVEL_15_16))
/* @end */

/* @defgroup USART_DMAReq */
#define USART_DMAReq_Rx                           ((uint32_t)0x00000001) /*@EN: receive dma request  @CN:  DMA  */
#define USART_DMAReq_Tx                           ((uint32_t)0x00000002) /*@EN: transmit dma request @CN:  DMA  */
#define IS_USART_DMAREQ(DMAREQ)                  ((DMAREQ == USART_DMAReq_Rx) || \
                                                  (DMAREQ == USART_DMAReq_Tx))
/* @end */

/* @defgroup USART_IT */
#define USART_IT_CERIS                            ((uint32_t)0x00004000) /*@EN: Detect error interrupt bit @CN: жλ */
#define USART_IT_WUFRIS                           ((uint32_t)0x00002000) /*@EN: Wake up event bit in low-power mode @CN: ͹ģʽ»¼λ */
#define USART_IT_LINE                             ((uint32_t)0x00001000) /*@EN: Receive header interrupt bit in LIN mode @CN: LIN ģʽ½ձͷжλ */
#define USART_IT_OE                               ((uint32_t)0x00000400) /*@EN: Overflow error interrupt bit @CN: жλ */
#define USART_IT_BE                               ((uint32_t)0x00000200) /*@EN: Break error interrupt bit @CN: ϴжλ */
#define USART_IT_PE                               ((uint32_t)0x00000100) /*@EN: Parity error interrupt bit @CN: żУжλ */
#define USART_IT_FE                               ((uint32_t)0x00000080) /*@EN: Frame error interrupt bit @CN: ֡жλ */
#define USART_IT_RT                               ((uint32_t)0x00000040) /*@EN: Receive stop interrupt bit @CN: ֹͣжλ */
#define USART_IT_TX                               ((uint32_t)0x00000020) /*@EN: Send interrupt bit @CN: жλ */
#define USART_IT_RX                               ((uint32_t)0x00000010) /*@EN: Receive interrupt bit @CN: жλ */
#define USART_IT_CTS                              ((uint32_t)0x00000002) /*@EN: Hard control flow interrupt shielding bit @CN: Ӳжλ */
#define IS_USART_IT(USART_IT)                     ((USART_IT == USART_IT_LINE)   || \
                                                   (USART_IT == USART_IT_OE)     || \
                                                   (USART_IT == USART_IT_BE)     || \
                                                   (USART_IT == USART_IT_PE)     || \
                                                   (USART_IT == USART_IT_FE)     || \
                                                   (USART_IT == USART_IT_RT)     || \
                                                   (USART_IT == USART_IT_TX)     || \
                                                   (USART_IT == USART_IT_RX)     || \
                                                   (USART_IT == USART_IT_CERIS)  || \
                                                   (USART_IT == USART_IT_WUFRIS) || \
                                                   (USART_IT == USART_IT_CTS))
/* @end */

/* @defgroup USART_Flag */
#define USART_FLAG_RXBUSY                       ((uint32_t)0x00000200) /*@EN: Receive busy       @CN: æ־λ */
#define USART_FLAG_TXFE                         ((uint32_t)0X00000080) /*@EN: Send FIFO empty    @CN:  FIFO ձ־λ */
#define USART_FLAG_RXFF                         ((uint32_t)0x00000040) /*@EN: Receive FIFO full  @CN:  FIFO ־λ */
#define USART_FLAG_TXFF                         ((uint32_t)0X00000020) /*@EN: Send FIFO full     @CN:  FIFO ־λ */
#define USART_FLAG_RXFE                         ((uint32_t)0x00000010) /*@EN: Receive FIFO empty @CN:  FIFO ձ־λ */
#define USART_FLAG_BUSY                         ((uint32_t)0X00000008) /*@EN: Usart busy         @CN: USART æ־λ */
#define USART_FLAG_CTS                          ((uint32_t)0X00000001) /*@EN: nUSARTCTS          @CN: CTS ־λ */
#define IS_USART_STATUSFLAG(FLAG)               ((FLAG == USART_STATUS_RI)   || \
                                                 (FLAG == USART_STATUS_TXFE) || \
                                                 (FLAG == USART_STATUS_RXFF) || \
                                                 (FLAG == USART_STATUS_TXFF) || \
                                                 (FLAG == USART_STATUS_RXFE) || \
                                                 (FLAG == USART_STATUS_BUSY) || \
                                                 (FLAG == USART_STATUS_CTS))
/* @end */

/* @defgroup OutputMode_Sel */
#define USART_HDOD_OD                           ((uint32_t)0x00000000) /*@EN: In half duplex mode, the RXD port is an open drain output(default) @CN:  ˫ģʽRXD˿Ϊ©Ĭϣ*/
#define USART_HDOD_PP                           ((uint32_t)0X00000002) /*@EN: In half duplex mode, the RXD port is a push-pull output @CN: ˫ģʽRXD˿Ϊ */
#define IS_USART_HDOD(HDOD)                     ((HDOD == USART_HDOD_OD) || (HDOD == USART_HDOD_PP))
/* @end */

/* @defgroup CPHA_Mode_Sel */
#define USART_CPHA_1EDGE                        ((uint32_t)0x00000000) /*@EN: The data is valid on the first edge of the synchronous clock pulse (default) @CN: ͬʱһЧ Ĭϣ*/
#define USART_CPHA_2EDGE                        ((uint32_t)0X00000080) /*@EN: The data is valid on the second edge of the synchronous clock pulse @CN: ͬʱڶЧ */
#define IS_USART_CPHA(CPHA)                     ((CPHA == USART_CPHA_1EDGE) || (CPHA == USART_CPHA_2EDGE))
/* @end */

/* @defgroup CPOL_Mode_Sel */
#define USART_CPOL_LOW                          ((uint32_t)0x00000000) /*@EN: CK clock is low when idle (default) @CN: CKʱӿʱΪ͵ƽ Ĭϣ*/
#define USART_CPOL_HIGH                         ((uint32_t)0X00000040) /*@EN: CK clock is High when idle  @CN: CKʱӿʱΪߵƽ */
#define IS_USART_CPOL(CPOL)                     ((CPOL == USART_CPOL_LOW) || (CPOL == USART_CPOL_HIGH))
/* @end */

/* ========================================================================== */
/* ================            USART  REGISTER BIT              ============= */
/* ========================================================================== */

/* =================================  DR  =================================== */
#define USART_DR_OE_Pos                           (11UL)                       /*!< OE (Bit 11)                                           */
#define USART_DR_OE_Msk                           (0x00000800UL)               /*!< OE (Bitfield-Mask: 0x01)                              */
#define USART_DR_BE_Pos                           (10UL)                       /*!< BE (Bit 10)                                           */
#define USART_DR_BE_Msk                           (0x00000400UL)               /*!< BE (Bitfield-Mask: 0x01)                              */
#define USART_DR_PE_Pos                           (9UL)                        /*!< PE (Bit 9)                                            */
#define USART_DR_PE_Msk                           (0x00000200UL)               /*!< PE (Bitfield-Mask: 0x01)                              */
#define USART_DR_FE_Pos                           (8UL)                        /*!< FE (Bit 8)                                            */
#define USART_DR_FE_Msk                           (0x00000100UL)               /*!< FE (Bitfield-Mask: 0x01)                              */
#define USART_DR_DATA_Pos                         (0UL)                        /*!< DATA (Bit 0)                                          */
#define USART_DR_DATA_Msk                         (0x000000FFUL)               /*!< DATA (Bitfield-Mask: 0xff)                            */
/* ================================  RSR  =================================== */
#define USART_RSR_OE_Pos                          (3UL)                        /*!< OE (Bit 3)                                            */
#define USART_RSR_OE_Msk                          (0x00000008UL)               /*!< OE (Bitfield-Mask: 0x01)                              */
#define USART_RSR_BE_Pos                          (2UL)                        /*!< BE (Bit 2)                                            */
#define USART_RSR_BE_Msk                          (0x00000004UL)               /*!< BE (Bitfield-Mask: 0x01)                              */
#define USART_RSR_PE_Pos                          (1UL)                        /*!< PE (Bit 1)                                            */
#define USART_RSR_PE_Msk                          (0x00000002UL)               /*!< PE (Bitfield-Mask: 0x01)                              */
#define USART_RSR_FE_Pos                          (0UL)                        /*!< FE (Bit 0)                                            */
#define USART_RSR_FE_Msk                          (0x00000001UL)               /*!< FE (Bitfield-Mask: 0x01)                              */

/* ================================  CR2  =================================== */
#define USART_CR2_CPHA_Pos                        (7UL)                        /*!< CPHA (Bit 7)                                          */
#define USART_CR2_CPHA_Msk                        (0x00000080UL)               /*!< CPHA (Bitfield-Mask: 0x01)                            */
#define USART_CR2_CPOL_Pos                        (6UL)                        /*!< CPOL (Bit 6)                                          */
#define USART_CR2_CPOL_Msk                        (0x00000040UL)               /*!< CPOL (Bitfield-Mask: 0x01)                            */
#define USART_CR2_CLKEN_Pos                       (5UL)                        /*!< CLKEN (Bit 5)                                         */
#define USART_CR2_CLKEN_Msk                       (0x00000020UL)               /*!< CLKEN (Bitfield-Mask: 0x01)                           */
#define USART_CR2_HDOD_Pos                        (1UL)                        /*!< HDOD (Bit 1)                                          */
#define USART_CR2_HDOD_Msk                        (0x00000002UL)               /*!< HDOD (Bitfield-Mask: 0x01)                            */
#define USART_CR2_HDSEL_Pos                       (0UL)                        /*!< HDSEL (Bit 0)                                         */
#define USART_CR2_HDSEL_Msk                       (0x00000001UL)               /*!< HDSEL (Bitfield-Mask: 0x01)                           */

/* ================================  CR3  =================================== */
#define USART_CR3_ADDR_Pos                        (8UL)                        /*!< ADDR (Bit 8)                                          */
#define USART_CR3_ADDR_Msk                        (0x0000FF00UL)               /*!< ADDR (Bitfield-Mask: 0xFF)                            */
#define USART_CR3_ADDM_Pos                        (7UL)                        /*!< ADDM (Bit 7)                                          */
#define USART_CR3_ADDM_Msk                        (0x00000080UL)               /*!< ADDM (Bitfield-Mask: 0x01)                            */
#define USART_CR3_WUS_Pos                         (3UL)                        /*!< WUS (Bit 3)                                           */
#define USART_CR3_WUS_Msk                         (0x00000018UL)               /*!< WUS (Bitfield-Mask: 0x03)                             */
#define USART_CR3_UELP_Pos                        (0UL)                        /*!< UELP (Bit 0)                                          */
#define USART_CR3_UELP_Msk                        (0x00000001UL)               /*!< UELP (Bitfield-Mask: 0x01)                            */
/* ================================  FR  ==================================== */
#define USARTFR_RXBUSY_Pos                        (9UL)                        /*!< RXBUSY (Bit 9)                                        */
#define USARTFR_RXBUSY_Msk                        (0x00000200UL)               /*!< RXBUSY (Bitfield-Mask: 0x1)                           */
#define USART_FR_RI_Pos                           (8UL)                        /*!< RI (Bit 8)                                            */
#define USART_FR_RI_Msk                           (0x00000100UL)               /*!< RI (Bitfield-Mask: 0x01)                              */
#define USART_FR_TXFE_Pos                         (7UL)                        /*!< TXFE (Bit 7)                                          */
#define USART_FR_TXFE_Msk                         (0x00000080UL)               /*!< TXFE (Bitfield-Mask: 0x01)                            */
#define USART_FR_RXFF_Pos                         (6UL)                        /*!< RXFF (Bit 6)                                          */
#define USART_FR_RXFF_Msk                         (0x00000040UL)               /*!< RXFF (Bitfield-Mask: 0x01)                            */
#define USART_FR_TXFF_Pos                         (5UL)                        /*!< TXFF (Bit 5)                                          */
#define USART_FR_TXFF_Msk                         (0x00000020UL)               /*!< TXFF (Bitfield-Mask: 0x01)                            */
#define USART_FR_RXFE_Pos                         (4UL)                        /*!< RXFE (Bit 4)                                          */
#define USART_FR_RXFE_Msk                         (0x00000010UL)               /*!< RXFE (Bitfield-Mask: 0x01)                            */
#define USART_FR_BUSY_Pos                         (3UL)                        /*!< BUSY (Bit 3)                                          */
#define USART_FR_BUSY_Msk                         (0x00000008UL)               /*!< BUSY (Bitfield-Mask: 0x01)                            */
#define USART_FR_DCD_Pos                          (2UL)                        /*!< DCD (Bit 2)                                           */
#define USART_FR_DCD_Msk                          (0x00000004UL)               /*!< DCD (Bitfield-Mask: 0x01)                             */
#define USART_FR_DSR_Pos                          (1UL)                        /*!< DSR (Bit 1)                                           */
#define USART_FR_DSR_Msk                          (0x00000002UL)               /*!< DSR (Bitfield-Mask: 0x01)                             */
#define USART_FR_CTS_Pos                          (0UL)                        /*!< CTS (Bit 0)                                           */
#define USART_FR_CTS_Msk                          (0x00000001UL)               /*!< CTS (Bitfield-Mask: 0x01)                             */
/* ===============================  IBRD  =================================== */
#define USART_IBRD_BAUD_DIVINT_Pos                (0UL)                        /*!< BAUD_DIVINT (Bit 0)                                   */
#define USART_IBRD_BAUD_DIVINT_Msk                (0x000000FFUL)               /*!< BAUD_DIVINT (Bitfield-Mask: 0xFF)                     */
/* ===============================  FBRD  =================================== */
#define USART_FBRD_BAUD_DIVFRAC_Pos               (0UL)                        /*!< BAUD_DIVFRAC (Bit 0)                                  */
#define USART_FBRD_BAUD_DIVFRAC_Msk               (0x0000003FUL)               /*!< BAUD_DIVFRAC (Bitfield-Mask: 0x3F)                    */
/* ===============================  LCR  ==================================== */
#define USART_LCR_SPS_Pos                         (7UL)                        /*!< SPS (Bit 7)                                           */
#define USART_LCR_SPS_Msk                         (0x00000080UL)               /*!< SPS (Bitfield-Mask: 0x01)                             */
#define USART_LCR_WLEN_Pos                        (5UL)                        /*!< WLEN (Bit 5)                                          */
#define USART_LCR_WLEN_Msk                        (0x00000060UL)               /*!< WLEN (Bitfield-Mask: 0x03)                            */
#define USART_LCR_FEN_Pos                         (4UL)                        /*!< FEN (Bit 4)                                           */
#define USART_LCR_FEN_Msk                         (0x00000010UL)               /*!< FEN (Bitfield-Mask: 0x01)                             */
#define USART_LCR_STP2_Pos                        (3UL)                        /*!< STP2 (Bit 3)                                          */
#define USART_LCR_STP2_Msk                        (0x00000008UL)               /*!< STP2 (Bitfield-Mask: 0x01)                            */
#define USART_LCR_EPS_Pos                         (2UL)                        /*!< EPS (Bit 2)                                           */
#define USART_LCR_EPS_Msk                         (0x00000004UL)               /*!< EPS (Bitfield-Mask: 0x01)                             */
#define USART_LCR_PEN_Pos                         (1UL)                        /*!< PEN (Bit 1)                                           */
#define USART_LCR_PEN_Msk                         (0x00000002UL)               /*!< PEN (Bitfield-Mask: 0x01)                             */
#define USART_LCR_BRK_Pos                         (0UL)                        /*!< BRK (Bit 0)                                           */
#define USART_LCR_BRK_Msk                         (0x00000001UL)               /*!< BRK (Bitfield-Mask: 0x01)                             */
/* ===============================  CR  ===================================== */
#define USART_CR_CTSEn_Pos                        (15UL)                       /*!< CTSEn (Bit 15)                                        */
#define USART_CR_CTSEn_Msk                        (0x00008000UL)               /*!< CTSEn (Bitfield-Mask: 0x01)                           */
#define USART_CR_RTSEn_Pos                        (14UL)                       /*!< RTSEn (Bit 14)                                        */
#define USART_CR_RTSEn_Msk                        (0x00004000UL)               /*!< RTSEn (Bitfield-Mask: 0x01)                           */
#define USART_CR_RTS_Pos                          (11UL)                       /*!< RTS (Bit 11)                                          */
#define USART_CR_RTS_Msk                          (0x00000800UL)               /*!< RTS (Bitfield-Mask: 0x01)                             */
#define USART_CR_DTR_Pos                          (10UL)                       /*!< DTR (Bit 10)                                          */
#define USART_CR_DTR_Msk                          (0x00000400UL)               /*!< DTR (Bitfield-Mask: 0x01)                             */
#define USART_CR_RXE_Pos                          (9UL)                        /*!< RXE (Bit 9)                                           */
#define USART_CR_RXE_Msk                          (0x00000200UL)               /*!< RXE (Bitfield-Mask: 0x01)                             */
#define USART_CR_TXE_Pos                          (8UL)                        /*!< TXE (Bit 8)                                           */
#define USART_CR_TXE_Msk                          (0x00000100UL)               /*!< TXE (Bitfield-Mask: 0x01)                             */
#define USART_CR_LBE_Pos                          (7UL)                        /*!< LBE (Bit 7)                                           */
#define USART_CR_LBE_Msk                          (0x00000080UL)               /*!< LBE (Bitfield-Mask: 0x01)                             */
#define USART_CR_RXTSP_Pos                        (6UL)                        /*!< RXTSP (Bit 6)                                         */
#define USART_CR_RXTSP_MSK                        (0x00000040UL)               /*!< RXTSP (Bitfield-Mask: 0x01)                           */
#define USART_CR_TXTSP_Pos                        (5UL)                        /*!< TXTSP (Bit 5)                                         */
#define USART_CR_TXTSP_MSK                        (0x00000020UL)               /*!< TXTSP (Bitfield-Mask: 0x01)                           */
#define USART_CR_LINEN_Pos                        (4UL)                        /*!< LINEN (Bit 4)                                         */
#define USART_CR_LINEN_MSK                        (0x00000010UL)               /*!< LINEN (Bitfield-Mask: 0x01)                           */
#define USART_CR_SIRLP_Pos                        (2UL)                        /*!< SIRLP (Bit 2)                                         */
#define USART_CR_SIRLP_Msk                        (0x00000004UL)               /*!< SIRLP (Bitfield-Mask: 0x01)                           */
#define USART_CR_SIREN_Pos                        (1UL)                        /*!< SIREN (Bit 1)                                         */
#define USART_CR_SIREN_Msk                        (0x00000002UL)               /*!< SIREN (Bitfield-Mask: 0x01)                           */
#define USART_CR_USARTEN_Pos                      (0UL)                        /*!< USARTEN (Bit 0)                                       */
#define USART_CR_USARTEN_Msk                      (0x00000001UL)               /*!< USARTEN (Bitfield-Mask: 0x01)                         */
/* ===============================  IFLS  =================================== */
#define USART_IFLS_RXIFLSEL_Pos                   (4UL)                        /*!< RXIFLSEL (Bit 4)                                      */
#define USART_IFLS_RXIFLSEL_Msk                   (0x000000F0UL)               /*!< RXIFLSEL (Bitfield-Mask: 0x0F)                        */
#define USART_IFLS_TXIFLSEL_Pos                   (0UL)                        /*!< TXIFLSEL (Bit 0)                                      */
#define USART_IFLS_TXIFLSEL_Msk                   (0x0000000FUL)               /*!< TXIFLSEL (Bitfield-Mask: 0x0F)                        */
/* ===============================  IMSC  =================================== */
#define USART_IMSC_CEIM_Pos                       (14UL)                       /*!< CEIM (Bit 14)                                         */
#define USART_IMSC_CEIM_Msk                       (0x00004000UL)               /*!< CEIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC_WUFIM_Pos                      (13UL)                       /*!< WUFIM (Bit 13)                                        */
#define USART_IMSC_WUFIM_Msk                      (0x00002000UL)               /*!< WUFIM (Bitfield-Mask: 0x01)                           */
#define USART_IMSC_LINIM_Pos                      (12UL)                       /*!< LINIM (Bit 12)                                        */
#define USART_IMSC_LINIM_Msk                      (0x00001000UL)               /*!< LINIM (Bitfield-Mask: 0x01)                           */
#define USART_IMSC_OEIM_Pos                       (10UL)                       /*!< OEIM (Bit 10)                                         */
#define USART_IMSC_OEIM_Msk                       (0x00000400UL)               /*!< OEIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC_BEIM_Pos                       (9UL)                        /*!< BEIM (Bit 9)                                          */
#define USART_IMSC_BEIM_Msk                       (0x00000200UL)               /*!< BEIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC_PEIM_Pos                       (8UL)                        /*!< PEIM (Bit 8)                                          */
#define USART_IMSC_PEIM_Msk                       (0x00000100UL)               /*!< PEIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC_FEIM_Pos                       (7UL)                        /*!< FEIM (Bit 7)                                          */
#define USART_IMSC_FEIM_Msk                       (0x00000080UL)               /*!< FEIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC_RTIM_Pos                       (6UL)                        /*!< RTIM (Bit 6)                                          */
#define USART_IMSC_RTIM_Msk                       (0x00000040UL)               /*!< RTIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC_TXIM_Pos                       (5UL)                        /*!< TXIM (Bit 5)                                          */
#define USART_IMSC_TXIM_Msk                       (0x00000020UL)               /*!< TXIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC_RXIM_Pos                       (4UL)                        /*!< RXIM (Bit 4)                                          */
#define USART_IMSC_RXIM_Msk                       (0x00000010UL)               /*!< RXIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC_CTSIM_Pos                      (1UL)                        /*!< CTSIM (Bit 1)                                         */
#define USART_IMSC_CTSIM_Msk                      (0x00000002UL)               /*!< CTSIM (Bitfield-Mask: 0x01)                           */
/* ===============================  RIS  ==================================== */
#define USART_RIS_CERIS_Pos                       (14UL)                       /*!< CERIS (Bit 14)                                        */
#define USART_RIS_CERIS_Msk                       (0x00004000UL)               /*!< CERIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS_WUFRIS_Pos                      (13UL)                       /*!< WUFRIS (Bit 13)                                       */
#define USART_RIS_WUFRIS_Msk                      (0x00002000UL)               /*!< WUFRIS (Bitfield-Mask: 0x01)                          */
#define USART_RIS_LINRIS_Pos                      (12UL)                       /*!< LINRIS (Bit 12)                                       */
#define USART_RIS_LINRIS_Msk                      (0x00001000UL)               /*!< LINRIS (Bitfield-Mask: 0x01)                          */
#define USART_RIS_OERIS_Pos                       (10UL)                       /*!< OERIS (Bit 10)                                        */
#define USART_RIS_OERIS_Msk                       (0x00000400UL)               /*!< OERIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS_BERIS_Pos                       (9UL)                        /*!< BERIS (Bit 9)                                         */
#define USART_RIS_BERIS_Msk                       (0x00000200UL)               /*!< BERIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS_PERIS_Pos                       (8UL)                        /*!< PERIS (Bit 8)                                         */
#define USART_RIS_PERIS_Msk                       (0x00000100UL)               /*!< PERIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS_FERIS_Pos                       (7UL)                        /*!< FERIS (Bit 7)                                         */
#define USART_RIS_FERIS_Msk                       (0x00000080UL)               /*!< FERIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS_RTRIS_Pos                       (6UL)                        /*!< RTRIS (Bit 6)                                         */
#define USART_RIS_RTRIS_Msk                       (0x00000040UL)               /*!< RTRIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS_TXRIS_Pos                       (5UL)                        /*!< TXRIS (Bit 5)                                         */
#define USART_RIS_TXRIS_Msk                       (0x00000020UL)               /*!< TXRIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS_RXRIS_Pos                       (4UL)                        /*!< RXRIS (Bit 4)                                         */
#define USART_RIS_RXRIS_Msk                       (0x00000010UL)               /*!< RXRIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS_DSRRMIS_Pos                     (3UL)                        /*!< DSRRMIS (Bit 3)                                       */
#define USART_RIS_DSRRMIS_Msk                     (0x00000008UL)               /*!< DSRRMIS (Bitfield-Mask: 0x01)                         */
#define USART_RIS_DCDRMIS_Pos                     (2UL)                        /*!< DCDRMIS (Bit 2)                                       */
#define USART_RIS_DCDRMIS_Msk                     (0x00000004UL)               /*!< DCDRMIS (Bitfield-Mask: 0x01)                         */
#define USART_RIS_CTSRMIS_Pos                     (1UL)                        /*!< CTSRMIS (Bit 1)                                       */
#define USART_RIS_CTSRMIS_Msk                     (0x00000002UL)               /*!< CTSRMIS (Bitfield-Mask: 0x01)                         */
#define USART_RIS_RIRMIS_Pos                      (0UL)                        /*!< RIRMIS (Bit 0)                                        */
#define USART_RIS_RIRMIS_Msk                      (0x00000001UL)               /*!< RIRMIS (Bitfield-Mask: 0x01)                          */
/* ==============================  MIS  ===================================== */
#define USART_MIS_CEMIS_Pos                       (14UL)                       /*!< CEMIS (Bit 14)                                        */
#define USART_MIS_CEMIS_Msk                       (0x00004000UL)               /*!< CEMIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS_WUFMIS_Pos                      (13UL)                       /*!< WUFMIS (Bit 13)                                       */
#define USART_MIS_WUFMIS_Msk                      (0x00002000UL)               /*!< WUFMIS (Bitfield-Mask: 0x01)                          */
#define USART_MIS_LINMIS_Pos                      (12UL)                       /*!< LINMIS (Bit 12)                                       */
#define USART_MIS_LINMIS_Msk                      (0x00001000UL)               /*!< LINMIS (Bitfield-Mask: 0x01)                          */
#define USART_MIS_OEMIS_Pos                       (10UL)                       /*!< OEMIS (Bit 10)                                        */
#define USART_MIS_OEMIS_Msk                       (0x00000400UL)               /*!< OEMIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS_BEMIS_Pos                       (9UL)                        /*!< BEMIS (Bit 9)                                         */
#define USART_MIS_BEMIS_Msk                       (0x00000200UL)               /*!< BEMIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS_PEMIS_Pos                       (8UL)                        /*!< PEMIS (Bit 8)                                         */
#define USART_MIS_PEMIS_Msk                       (0x00000100UL)               /*!< PEMIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS_FEMIS_Pos                       (7UL)                        /*!< FEMIS (Bit 7)                                         */
#define USART_MIS_FEMIS_Msk                       (0x00000080UL)               /*!< FEMIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS_RTMIS_Pos                       (6UL)                        /*!< RTMIS (Bit 6)                                         */
#define USART_MIS_RTMIS_Msk                       (0x00000040UL)               /*!< RTMIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS_TXMIS_Pos                       (5UL)                        /*!< TXMIS (Bit 5)                                         */
#define USART_MIS_TXMIS_Msk                       (0x00000020UL)               /*!< TXMIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS_RXMIS_Pos                       (4UL)                        /*!< RXMIS (Bit 4)                                         */
#define USART_MIS_RXMIS_Msk                       (0x00000010UL)               /*!< RXMIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS_DSRMMIS_Pos                     (3UL)                        /*!< DSRMMIS (Bit 3)                                       */
#define USART_MIS_DSRMMIS_Msk                     (0x00000008UL)               /*!< DSRMMIS (Bitfield-Mask: 0x01)                         */
#define USART_MIS_DCDMMIS_Pos                     (2UL)                        /*!< DCDMMIS (Bit 2)                                       */
#define USART_MIS_DCDMMIS_Msk                     (0x00000004UL)               /*!< DCDMMIS (Bitfield-Mask: 0x01)                         */
#define USART_MIS_CTSMMIS_Pos                     (1UL)                        /*!< CTSMMIS (Bit 1)                                       */
#define USART_MIS_CTSMMIS_Msk                     (0x00000002UL)               /*!< CTSMMIS (Bitfield-Mask: 0x01)                         */
#define USART_MIS_RIMMIS_Pos                      (0UL)                        /*!< RIMMIS (Bit 0)                                        */
#define USART_MIS_RIMMIS_Msk                      (0x00000001UL)               /*!< RIMMIS (Bitfield-Mask: 0x01)                          */
/* =============================  ICR  ====================================== */
#define USART_ICR_CEIC_Pos                        (14UL)                       /*!< CEIC (Bit 14)                                         */
#define USART_ICR_CEIC_Msk                        (0x00004000UL)               /*!< CEIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR_WUFIC_Pos                       (13UL)                       /*!< WUFIC (Bit 13)                                        */
#define USART_ICR_WUFIC_Msk                       (0x00002000UL)               /*!< WUFIC (Bitfield-Mask: 0x01)                           */
#define USART_ICR_LINIC_Pos                       (12UL)                       /*!< LINIC (Bit 12)                                        */
#define USART_ICR_LINIC_Msk                       (0x00001000UL)               /*!< LINIC (Bitfield-Mask: 0x01)                           */
#define USART_ICR_OEIC_Pos                        (10UL)                       /*!< OEIC (Bit 10)                                         */
#define USART_ICR_OEIC_Msk                        (0x00000400UL)               /*!< OEIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR_BEIC_Pos                        (9UL)                        /*!< BEIC (Bit 9)                                          */
#define USART_ICR_BEIC_Msk                        (0x00000200UL)               /*!< BEIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR_PEMIS_Pos                       (8UL)                        /*!< PEMIS (Bit 8)                                         */
#define USART_ICR_PEMIS_Msk                       (0x00000100UL)               /*!< PEMIS (Bitfield-Mask: 0x01)                           */
#define USART_ICR_FEIC_Pos                        (7UL)                        /*!< FEIC (Bit 7)                                          */
#define USART_ICR_FEIC_Msk                        (0x00000080UL)               /*!< FEIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR_RTIC_Pos                        (6UL)                        /*!< RTIC (Bit 6)                                          */
#define USART_ICR_RTIC_Msk                        (0x00000040UL)               /*!< RTIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR_TXIC_Pos                        (5UL)                        /*!< TXIC (Bit 5)                                          */
#define USART_ICR_TXIC_Msk                        (0x00000020UL)               /*!< TXIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR_RXIC_Pos                        (4UL)                        /*!< RXIC (Bit 4)                                          */
#define USART_ICR_RXIC_Msk                        (0x00000010UL)               /*!< RXIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR_DSRMIC_Pos                      (3UL)                        /*!< DSRMIC (Bit 3)                                        */
#define USART_ICR_DSRMIC_Msk                      (0x00000008UL)               /*!< DSRMIC (Bitfield-Mask: 0x01)                          */
#define USART_ICR_DCDMIC_Pos                      (2UL)                        /*!< DCDMIC (Bit 2)                                        */
#define USART_ICR_DCDMIC_Msk                      (0x00000004UL)               /*!< DCDMIC (Bitfield-Mask: 0x01)                          */
#define USART_ICR_CTSMIC_Pos                      (1UL)                        /*!< CTSMIC (Bit 1)                                        */
#define USART_ICR_CTSMIC_Msk                      (0x00000002UL)               /*!< CTSMIC (Bitfield-Mask: 0x01)                          */
#define USART_ICR_RIMIC_Pos                       (0UL)                        /*!< RIMIC (Bit 0)                                         */
#define USART_ICR_RIMIC_Msk                       (0x00000001UL)               /*!< RIMIC (Bitfield-Mask: 0x01)                           */
/* =============================  DMACR  ==================================== */
#define USART0_DMACR_DMAONERR_Pos                 (2UL)                        /*!< DMAONERR (Bit 2)                                      */
#define USART0_DMACR_DMAONERR_Msk                 (0x00000004UL)               /*!< DMAONERR (Bitfield-Mask: 0x01)                        */
#define USART0_DMACR_TXDMAE_Pos                   (1UL)                        /*!< TXDMAE (Bit 1)                                        */
#define USART0_DMACR_TXDMAE_Msk                   (0x00000002UL)               /*!< TXDMAE (Bitfield-Mask: 0x01)                          */
#define USART0_DMACR_RXDMAE_Pos                   (0UL)                        /*!< RXDMAE (Bit 0)                                        */
#define USART0_DMACR_RXDMAE_Msk                   (0x00000001UL)               /*!< RXDMAE (Bitfield-Mask: 0x01)                          */
/* ============================  LINCON1  =================================== */
#define USART_LINCON1_LINSLP_Pos                  (8UL)                        /*!< LINSLP (Bit 8)                                        */
#define USART_LINCON1_LINSLP_Msk                  (0x00000100UL)               /*!< LINSLP (Bitfield-Mask: 0x01)                          */
#define USART_LINCON1_LZEN_Pos                    (7UL)                        /*!< LZEN (Bit 7)                                          */
#define USART_LINCON1_LZEN_Msk                    (0x00000080UL)               /*!< LZEN (Bitfield-Mask: 0x01)                            */
#define USART_LINCON1_ABD_Pos                     (6UL)                        /*!< ABD (Bit 6)                                           */
#define USART_LINCON1_ABD_Msk                     (0x00000040UL)               /*!< ABD (Bitfield-Mask: 0x01)                             */
#define USART_LINCON1_CSI_Pos                     (5UL)                        /*!< CSI (Bit 5)                                           */
#define USART_LINCON1_CSI_Msk                     (0x00000020UL)               /*!< CSI (Bitfield-Mask: 0x01)                             */
#define USART_LINCON1_CSEN_Pos                    (4UL)                        /*!< CSEN (Bit 4)                                          */
#define USART_LINCON1_CSEN_Msk                    (0x00000010UL)               /*!< CSEN (Bitfield-Mask: 0x01)                            */
#define USART_LINCON1_SCM_Pos                     (3UL)                        /*!< SCM (Bit 3)                                           */
#define USART_LINCON1_SCM_Msk                     (0x00000008UL)               /*!< SCM (Bitfield-Mask: 0x01)                             */
#define USART_LINCON1_MS_Pos                      (0UL)                        /*!< MS (Bit 0)                                            */
#define USART_LINCON1_MS_Msk                      (0x00000001UL)               /*!< MS (Bitfield-Mask: 0x01)                              */
/* ============================  LINCON2  =================================== */
#define USART_LINCON2_WUTR_Pos                    (3UL)                        /*!< WUTR (Bit 3)                                          */
#define USART_LINCON2_WUTR_Msk                    (0x00000008UL)               /*!< WUTR (Bitfield-Mask: 0x01)                            */
#define USART_LINCON2_RDR_Pos                     (2UL)                        /*!< RDR (Bit 2)                                           */
#define USART_LINCON2_RDR_Msk                     (0x00000004UL)               /*!< RDR (Bitfield-Mask: 0x01)                             */
#define USART_LINCON2_RTR_Pos                     (1UL)                        /*!< RTR (Bit 1)                                           */
#define USART_LINCON2_RTR_Msk                     (0x00000002UL)               /*!< RTR (Bitfield-Mask: 0x01)                             */
#define USART_LINCON2_HTR_Pos                     (0UL)                        /*!< HTR (Bit 0)                                           */
#define USART_LINCON2_HTR_Msk                     (0x00000001UL)               /*!< HTR (Bitfield-Mask: 0x01)                             */
/* ===========================  FRAMECON  =================================== */
#define USART_FRAMECON_CEN_Pos                    (6UL)                        /*!< CEN (Bit 6)                                           */
#define USART_FRAMECON_CEN_Msk                    (0x00000040UL)               /*!< CEN (Bitfield-Mask: 0x01)                             */
#define USART_FRAMECON_LEAD_Pos                   (3UL)                        /*!< LEAD (Bit 3)                                          */
#define USART_FRAMECON_LEAD_Msk                   (0x00000038UL)               /*!< LEAD (Bitfield-Mask: 0x07)                            */
#define USART_FRAMECON_IDLE_Pos                   (0UL)                        /*!< IDLE (Bit 0)                                          */
#define USART_FRAMECON_IDLE_Msk                   (0x00000007UL)               /*!< IDLE (Bitfield-Mask: 0x07)                            */
/* ============================  LINSTS  ==================================== */
#define USART_LINSTS_STS_Pos                      (1UL)                        /*!< STS (Bit 1)                                           */
#define USART_LINSTS_STS_Msk                      (0x0000001EUL)               /*!< STS (Bitfield-Mask: 0x01)                             */
#define USART_LINSTS_PS_Pos                       (0UL)                        /*!< PS (Bit 0)                                            */
#define USART_LINSTS_PS_Msk                       (0x00000001UL)               /*!< PS (Bitfield-Mask: 0x01)                              */
/* ============================  DATCON  ==================================== */
#define USART_DATCON_RESPONSE_Pos                 (8UL)                        /*!< RESPONSE (Bit 8)                                      */
#define USART_DATCON_RESPONSE_Msk                 (0x0000FF00UL)               /*!< RESPONSE (Bitfield-Mask: 0xFF)                        */
#define USART_DATCON_CSM_Pos                      (5UL)                        /*!< CSM (Bit 5)                                           */
#define USART_DATCON_CSM_Msk                      (0x00000020UL)               /*!< CSM (Bitfield-Mask: 0x01)                             */
#define USART_DATCON_RM_Pos                       (4UL)                        /*!< RM (Bit 4)                                            */
#define USART_DATCON_RM_Msk                       (0x00000010UL)               /*!< RM (Bitfield-Mask: 0x01)                              */
#define USART_DATCON_HO_Pos                       (3UL)                        /*!< HO (Bit 3)                                            */
#define USART_DATCON_HO_Msk                       (0x00000008UL)               /*!< HO (Bitfield-Mask: 0x01)                              */
#define USART_DATCON_DATLEN_Pos                   (0UL)                        /*!< DATLEN (Bit 0)                                        */
#define USART_DATCON_DATLEN_Msk                   (0x00000007UL)               /*!< DATLEN (Bitfield-Mask: 0x01)                          */
/* ============================  BRDMSU  ==================================== */
#define USART_BRDMSU_MEASURED_Pos                 (0UL)                        /*!< MEASURED (Bit 0)                                      */
#define USART_BRDMSU_MEASURED_Msk                 (0x0000FFFFUL)               /*!< MEASURED (Bitfield-Mask: 0xFFFF)                      */
/* ===========================  BRDUPPER  =================================== */
#define USART_BRDUPPER_UPPERLIMIT_Pos             (0UL)                        /*!< UPPERLIMIT (Bit 0)                                    */
#define USART_BRDUPPER_UPPERLIMIT_Msk             (0x0000FFFFUL)               /*!< UPPERLIMIT (Bitfield-Mask: 0xFFFF)                    */
/* ===========================  BRDLOWER  =================================== */
#define USART_BRDLOWER_LOWERLIMIT_Pos             (0UL)                        /*!< LOWERLIMIT (Bit 0)                                    */
#define USART_BRDLOWER_LOWERLIMIT_Msk             (0x0000FFFFUL)               /*!< LOWERLIMIT (Bitfield-Mask: 0xFFFF)                    */
/* ===========================  LINBTIMER  ===================================*/
#define USART_LINBTIMER_LOWERLIMIT_Pos            (0UL)                        /*!< BREAK (Bit 0)                                         */
#define USART_LINBTIMER_LOWERLIMIT_Msk            (0x0000003FUL)               /*!< BREAK (Bitfield-Mask: 0x3F)                           */
/* ===========================  LINHTIMER  ================================== */
#define USART_LINHTIMER_HEADER_Pos                (0UL)                        /*!< HEADER (Bit 0)                                        */
#define USART_LINHTIMER_HEADER_Msk                (0x000000FFUL)               /*!< HEADER (Bitfield-Mask: 0xFF)                          */
/* =============================  IMSC1  ==================================== */
#define USART_IMSC1_SFIM_Pos                      (12UL)                       /*!< SFIM (Bit 12)                                         */
#define USART_IMSC1_SFIM_Msk                      (0x00001000UL)               /*!< SFIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC1_LZIM_Pos                      (11UL)                       /*!< LZIM (Bit 11)                                         */
#define USART_IMSC1_LZIM_Msk                      (0x00000800UL)               /*!< LZIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC1_REDIM_Pos                     (10UL)                       /*!< REDIM (Bit 10)                                        */
#define USART_IMSC1_REDIM_Msk                     (0x00000400UL)               /*!< REDIM (Bitfield-Mask: 0x01)                           */
#define USART_IMSC1_FEDIM_Pos                     (9UL)                        /*!< FEDIM (Bit 9)                                         */
#define USART_IMSC1_FEDIM_Msk                     (0x00000200UL)               /*!< FEDIM (Bitfield-Mask: 0x01)                           */
#define USART_IMSC1_LPIM_Pos                      (8UL)                        /*!< LPIM (Bit 8)                                          */
#define USART_IMSC1_LPIM_Msk                      (0x00000100UL)               /*!< LPIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC1_LCIM_Pos                      (7UL)                        /*!< LCIM (Bit 7)                                          */
#define USART_IMSC1_LCIM_Msk                      (0x00000080UL)               /*!< LCIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC1_LAIM_Pos                      (6UL)                        /*!< LAIM (Bit 6)                                          */
#define USART_IMSC1_LAIM_Msk                      (0x00000040UL)               /*!< LAIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC1_RTIM_Pos                      (5UL)                        /*!< RTIM (Bit 5)                                          */
#define USART_IMSC1_RTIM_Msk                      (0x00000020UL)               /*!< RTIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC1_HTIM_Pos                      (4UL)                        /*!< HTIM (Bit 4)                                          */
#define USART_IMSC1_HTIM_Msk                      (0x00000010UL)               /*!< HTIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC1_TRIM_Pos                      (3UL)                        /*!< TRIM (Bit 3)                                          */
#define USART_IMSC1_TRIM_Msk                      (0x00000008UL)               /*!< TRIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC1_THIM_Pos                      (2UL)                        /*!< THIM (Bit 2)                                          */
#define USART_IMSC1_THIM_Msk                      (0x00000004UL)               /*!< THIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC1_RRIM_Pos                      (1UL)                        /*!< RRIM (Bit 1)                                          */
#define USART_IMSC1_RRIM_Msk                      (0x00000002UL)               /*!< RRIM (Bitfield-Mask: 0x01)                            */
#define USART_IMSC1_RHIM_Pos                      (0UL)                        /*!< RHIM (Bit 0)                                          */
#define USART_IMSC1_RHIM_Msk                      (0x00000001UL)               /*!< RHIM (Bitfield-Mask: 0x01)                            */
/* ===============================  RIS1  =================================== */
#define USART_RIS1_SFMIS_Pos                      (12UL)                       /*!< SFMIS (Bit 12)                                        */
#define USART_RIS1_SFMIS_Msk                      (0x00001000UL)               /*!< SFMIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS1_LZMIS_Pos                      (11UL)                       /*!< LZMIS (Bit 11)                                        */
#define USART_RIS1_LZMIS_Msk                      (0x00000800UL)               /*!< LZMIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS1_REDMIS_Pos                     (10UL)                       /*!< REDMIS (Bit 10)                                       */
#define USART_RIS1_REDMIS_Msk                     (0x00000400UL)               /*!< REDMIS (Bitfield-Mask: 0x01)                          */
#define USART_RIS1_FEDMIS_Pos                     (9UL)                        /*!< FEDMIS (Bit 9)                                        */
#define USART_RIS1_FEDMIS_Msk                     (0x00000200UL)               /*!< FEDMIS (Bitfield-Mask: 0x01)                          */
#define USART_RIS1_LPMIS_Pos                      (8UL)                        /*!< LPMIS (Bit 8)                                         */
#define USART_RIS1_LPMIS_Msk                      (0x00000100UL)               /*!< LPMIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS1_LCMIS_Pos                      (7UL)                        /*!< LCMIS (Bit 7)                                         */
#define USART_RIS1_LCMIS_Msk                      (0x00000080UL)               /*!< LCMIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS1_LAMIS_Pos                      (6UL)                        /*!< LAMIS (Bit 6)                                         */
#define USART_RIS1_LAMIS_Msk                      (0x00000040UL)               /*!< LAMIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS1_RTMIS_Pos                      (5UL)                        /*!< RTMIS (Bit 5)                                         */
#define USART_RIS1_RTMIS_Msk                      (0x00000020UL)               /*!< RTMIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS1_HTMIS_Pos                      (4UL)                        /*!< HTMIS (Bit 4)                                         */
#define USART_RIS1_HTMIS_Msk                      (0x00000010UL)               /*!< HTMIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS1_TRMIS_Pos                      (3UL)                        /*!< TRMIS (Bit 3)                                         */
#define USART_RIS1_TRMIS_Msk                      (0x00000008UL)               /*!< TRMIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS1_THMIS_Pos                      (2UL)                        /*!< THMIS (Bit 2)                                         */
#define USART_RIS1_THMIS_Msk                      (0x00000004UL)               /*!< THMIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS1_RRMIS_Pos                      (1UL)                        /*!< RRMIS (Bit 1)                                         */
#define USART_RIS1_RRMIS_Msk                      (0x00000002UL)               /*!< RRMIS (Bitfield-Mask: 0x01)                           */
#define USART_RIS1_RHMIS_Pos                      (0UL)                        /*!< RHMIS (Bit 0)                                         */
#define USART_RIS1_RHMIS_Msk                      (0x00000001UL)               /*!< RHMIS (Bitfield-Mask: 0x01)                           */
/* ===============================  MIS1  =================================== */
#define USART_MIS1_SFRIS_Pos                      (12UL)                       /*!< SFRIS (Bit 12)                                        */
#define USART_MIS1_SFRIS_Msk                      (0x00001000UL)               /*!< SFRIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS1_LZRIS_Pos                      (11UL)                       /*!< LZRIS (Bit 11)                                        */
#define USART_MIS1_LZRIS_Msk                      (0x00000800UL)               /*!< LZRIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS1_REDRIS_Pos                     (10UL)                       /*!< REDRIS (Bit 10)                                       */
#define USART_MIS1_REDRIS_Msk                     (0x00000400UL)               /*!< REDRIS (Bitfield-Mask: 0x01)                          */
#define USART_MIS1_FEDRIS_Pos                     (9UL)                        /*!< FEDRIS (Bit 9)                                        */
#define USART_MIS1_FEDRIS_Msk                     (0x00000200UL)               /*!< FEDRIS (Bitfield-Mask: 0x01)                          */
#define USART_MIS1_LPRIS_Pos                      (8UL)                        /*!< LPRIS (Bit 8)                                         */
#define USART_MIS1_LPRIS_Msk                      (0x00000100UL)               /*!< LPRIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS1_LCRIS_Pos                      (7UL)                        /*!< LCRIS (Bit 7)                                         */
#define USART_MIS1_LCRIS_Msk                      (0x00000080UL)               /*!< LCRIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS1_LARIS_Pos                      (6UL)                        /*!< LARIS (Bit 6)                                         */
#define USART_MIS1_LARIS_Msk                      (0x00000040UL)               /*!< LARIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS1_RTRIS_Pos                      (5UL)                        /*!< RTRIS (Bit 5)                                         */
#define USART_MIS1_RTRIS_Msk                      (0x00000020UL)               /*!< RTRIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS1_HTRIS_Pos                      (4UL)                        /*!< HTRIS (Bit 4)                                         */
#define USART_MIS1_HTRIS_Msk                      (0x00000010UL)               /*!< HTRIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS1_TRRIS_Pos                      (3UL)                        /*!< TRRIS (Bit 3)                                         */
#define USART_MIS1_TRRIS_Msk                      (0x00000008UL)               /*!< TRRIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS1_THRIS_Pos                      (2UL)                        /*!< THRIS (Bit 2)                                         */
#define USART_MIS1_THRIS_Msk                      (0x00000004UL)               /*!< THRIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS1_RRRIS_Pos                      (1UL)                        /*!< RRRIS (Bit 1)                                         */
#define USART_MIS1_RRRIS_Msk                      (0x00000002UL)               /*!< RRRIS (Bitfield-Mask: 0x01)                           */
#define USART_MIS1_RHRIS_Pos                      (0UL)                        /*!< RHRIS (Bit 0)                                         */
#define USART_MIS1_RHRIS_Msk                      (0x00000001UL)               /*!< RHRIS (Bitfield-Mask: 0x01)                           */
/* ===============================  ICR1  =================================== */
#define USART_ICR1_SFIC_Pos                       (12UL)                       /*!< SFIC (Bit 12)                                         */
#define USART_ICR1_SFIC_Msk                       (0x00001000UL)               /*!< SFIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR1_LZIC_Pos                       (11UL)                       /*!< LZIC (Bit 11)                                         */
#define USART_ICR1_LZIC_Msk                       (0x00000800UL)               /*!< LZIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR1_REIC_Pos                       (10UL)                       /*!< REDIC (Bit 10)                                        */
#define USART_ICR1_REIC_Msk                       (0x00000400UL)               /*!< REDIC (Bitfield-Mask: 0x01)                           */
#define USART_ICR1_FEIC_Pos                       (9UL)                        /*!< FEDIC (Bit 9)                                         */
#define USART_ICR1_FEIC_Msk                       (0x00000200UL)               /*!< FEDIC (Bitfield-Mask: 0x01)                           */
#define USART_ICR1_LPIC_Pos                       (8UL)                        /*!< LPIC (Bit 8)                                          */
#define USART_ICR1_LPIC_Msk                       (0x00000100UL)               /*!< LPIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR1_LCIC_Pos                       (7UL)                        /*!< LCIC (Bit 7)                                          */
#define USART_ICR1_LCIC_Msk                       (0x00000080UL)               /*!< LCIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR1_LAIC_Pos                       (6UL)                        /*!< LAIC (Bit 6)                                          */
#define USART_ICR1_LAIC_Msk                       (0x00000040UL)               /*!< LAIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR1_RTIC_Pos                       (5UL)                        /*!< RTIC (Bit 5)                                          */
#define USART_ICR1_RTIC_Msk                       (0x00000020UL)               /*!< RTIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR1_HTIC_Pos                       (4UL)                        /*!< HTIC (Bit 4)                                          */
#define USART_ICR1_HTIC_Msk                       (0x00000010UL)               /*!< HTIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR1_TRIC_Pos                       (3UL)                        /*!< TRIC (Bit 3)                                          */
#define USART_ICR1_TRIC_Msk                       (0x00000008UL)               /*!< TRIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR1_THIC_Pos                       (2UL)                        /*!< THIC (Bit 2)                                          */
#define USART_ICR1_THIC_Msk                       (0x00000004UL)               /*!< THIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR1_RRIC_Pos                       (1UL)                        /*!< RRIC (Bit 1)                                          */
#define USART_ICR1_RRIC_Msk                       (0x00000002UL)               /*!< RRIC (Bitfield-Mask: 0x01)                            */
#define USART_ICR1_RHIC_Pos                       (0UL)                        /*!< RHIC (Bit 0)                                          */
#define USART_ICR1_RHIC_Msk                       (0x00000001UL)               /*!< RHIC (Bitfield-Mask: 0x01)                            */

/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */

/* ==============================  USART  =================================== */
void USART_DeInit(USART_TypeDef *USARTx);
void USART_BaudRateConfig(USART_TypeDef *USARTx, uint32_t Baud);
void USART_Init(USART_TypeDef *USARTx, USART_InitTypeDef *USART_InitStruct);
void USART_StructInit(USART_InitTypeDef *USART_InitStruct);
void USART_Cmd(USART_TypeDef *USARTx, FunctionalState NewState);
void USART_DirectionModeCmd(USART_TypeDef *USARTx, uint32_t USART_DirectionMode, FunctionalState NewState);
void USART_SendData(USART_TypeDef *USARTx, uint8_t Data);
void USART_HalfDuplesCmd(USART_TypeDef *USARTx,uint32_t OutputMode_Sel, FunctionalState NewState);
void USART_SynchronousModeCmd(USART_TypeDef *USARTx, uint32_t CPHA_Mode_Sel, uint32_t CPOL_Mode_Sel,FunctionalState NewState);
uint16_t USART_ReceiveData(USART_TypeDef *USARTx);
void USART_SendBreak(USART_TypeDef *USARTx);
void USART_LPUSARTCmd(USART_TypeDef *USARTx, FunctionalState NewState);
void USART_LowPowerWakeConfig(USART_TypeDef *USARTx, uint32_t Event);
void USART_FIFOLevelConfig(USART_TypeDef *USARTx, uint32_t RxFIFO, uint32_t TxFIFO);
void USART_DMACmd(USART_TypeDef *USARTx, uint32_t USART_DMAReq, FunctionalState NewState);
void USART_ITConfig(USART_TypeDef *USARTx, uint32_t USART_IT, FunctionalState NewState);
FlagStatus USART_GetFlagStatus(USART_TypeDef *USARTx, uint32_t USART_Flag);
ITStatus USART_GetITStatus(USART_TypeDef *USARTx, uint32_t USART_IT);
ITStatus USART_GetRawITStatus(USART_TypeDef *USARTx, uint32_t USART_IT);
void USART_ClearITPendingBit(USART_TypeDef *USARTx, uint32_t USART_IT);
void USART_FIFOEnable(USART_TypeDef *USARTx, uint32_t NewState);

/* ================================  LIN  =================================== */
void USART_LIN_Init(USART_TypeDef *USARTx, LIN_InitTypeDef *LIN_InitStruct);
void LIN_StructInit(LIN_InitTypeDef *LIN_InitStruct);
void USART_LINCmd(USART_TypeDef *USARTx, uint8_t Type, FunctionalState NewState);
void BandrateClockMeasure(USART_TypeDef *USARTx, uint32_t UpperLimitClock, uint32_t LowerLimitClock);
void LIN_CurrentStatus(USART_TypeDef *USARTx, uint32_t LIN_CurrentStatus);
void LIN_Bus_LongZero_Check(USART_TypeDef *USARTx, uint32_t NewState);
uint16_t LIN_Baudrate_Read(USART_TypeDef *USARTx);
void LIN_AutoBaudrateSync(USART_TypeDef *USARTx, uint32_t NewState);
void LIN_HardwareCheckSum(USART_TypeDef *USARTx, uint32_t NewState);
FlagStatus LIN_GetModeStatus(USART_TypeDef *USARTx, uint32_t LIN_ModeStatus);
FlagStatus LIN_GetPinLeaveStatus(USART_TypeDef *USARTx, uint32_t LIN_PinStatus);
void LIN_ResponseTimeoutSet(USART_TypeDef *USARTx, uint32_t LIN_ResponseTime);
void LIN_SetBreakPulse(USART_TypeDef *USARTx, uint32_t LIN_BreakTime);
void LIN_FrameHeadTimeOut(USART_TypeDef *USARTx, uint32_t TimeOut);
void LIN_ITConfig(USART_TypeDef *USARTx, uint32_t LIN_IT, FunctionalState NewState);
ITStatus LIN_GetRawITStatus(USART_TypeDef *USARTx, uint32_t LIN_IT);
ITStatus LIN_GetITStatus(USART_TypeDef *USARTx, uint32_t LIN_IT);
void LIN_ClearITPendingBit(USART_TypeDef *USARTx, uint32_t LIN_IT);
void LIN_Request(USART_TypeDef *USARTx, uint32_t Request);

#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_USART_H__
