/**
  ******************************************************************************
  * @file    lcm32f06x_spi.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for spi.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_SPI_H__
#define __LCM32F06X_SPI_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"
#include "lcm32f06x_rcc.h"

#ifdef __cplusplus
  extern "C" {
#endif

typedef struct
{
  uint16_t SPI_Mode;               /*!< EN: Master-slave mode selection, this bit can only be configured when SSP is disabled (SSE=0).
                                        CN: ģʽѡ񣬸λֻ SSP ֹSSE=0ʱá
                                        @Register:SPICR1 @Bit:[2]MS
                                        @default SPI_Mode_Master */

  uint16_t SPI_DataSize;           /*!< EN: Data length selection, which controls the number of bits of one transmission frame.
                                        CN: ݳѡ񣬸ֶοÿ֡λĿ
                                        @Register:SPICR0 @Bits:[3:0]DSS
                                        @default SPI_DataSize_4b */

  uint16_t SPI_CPOL;               /*!< EN: SSPCLKOUT polarity, only available in the Motorola SPI frame format.
                                        CN: SSPCLKOUT ԣֻ Motorola SPI ֡ʽ
                                        @Register:SPICR0 @Bit:[6]SPO
                                        @default SPI_CPOL_Low */

  uint16_t SPI_CPHA;               /*!< EN: SSPCLKOUT phase, only available in the Motorola SPI frame format.
                                        CN: SSPCLKOUT λֻ Motorola SPI ֡ʽ
                                        @Register:SPICR0 @Bit:[7]SPH
                                        @default SPI_CPHA_1Edge */

  uint16_t SPI_BaudRatePrescaler;  /*!< EN: Clock divider.
                                        CN: ʱӷƵ
                                        @Register:SPICPSR @Bits:[15:8]SCR
                                        @default SPI_BaudRatePrescaler_2 */

  uint16_t SPI_FirstBit;           /*!< EN: Transmission priority bit.
                                        CN: λ
                                        @Register:SPICR2 @Bit:[7]LSB
                                        @default SPI_FirstBit_MSB */

  uint16_t SPI_SlaveTx;            /*!< EN: Slave mode output disabled, this bit is only related to slave mode (MS=1).
                                        CN: ӻģʽʹֹܽλֻӻģʽйأMS=1
                                        @Register:SPICR1 @Bit:[3]SOD
                                        @default SPI_SlaveTx_Enable */

  uint16_t SPI_SpeedMode;          /*!< EN: SPI speed mode configuration.
                                        CN: SPI ٶģʽá
                                        @Register:SPICR2 @Bit:[0]HR
                                        @default SPI_Speed_High */
} SPI_InitTypeDef;


#define IS_SPI_ALL_PERIPH(PERIPH) (((ERIPH) == SPI0))

#define IS_SPI_0_2_PERIPH(PERIPH) (((PERIPH) == SPI0))

/* @defgroup SPI_Mode */
#define SPI_Mode_Master                      ((uint16_t)0x0000) /*@EN: Master mode  @CN: ģʽ*/
#define SPI_Mode_Slave                       ((uint16_t)0x0004) /*@EN: Slave mode  @CN: ӻģʽ*/
#define IS_SPI_MODE(MODE)                    (((MODE) == SPI_Mode_Master) || \
                                              ((MODE) == SPI_Mode_Slave))
/* @end */

/* @defgroup SPI_DataSize */
#define SPI_DataSize_4b                      ((uint16_t)0x0003) /*@EN: 4-bit data  @CN: 4λ*/
#define SPI_DataSize_5b                      ((uint16_t)0x0004) /*@EN: 5-bit data  @CN: 5λ*/
#define SPI_DataSize_6b                      ((uint16_t)0x0005) /*@EN: 6-bit data  @CN: 6λ*/
#define SPI_DataSize_7b                      ((uint16_t)0x0006) /*@EN: 7-bit data  @CN: 7λ*/
#define SPI_DataSize_8b                      ((uint16_t)0x0007) /*@EN: 8-bit data  @CN: 8λ*/
#define SPI_DataSize_9b                      ((uint16_t)0x0008) /*@EN: 9-bit data  @CN: 9λ*/
#define SPI_DataSize_10b                     ((uint16_t)0x0009) /*@EN: 10-bit data  @CN: 10λ*/
#define SPI_DataSize_11b                     ((uint16_t)0x000A) /*@EN: 11-bit data  @CN: 11λ*/
#define SPI_DataSize_12b                     ((uint16_t)0x000B) /*@EN: 12-bit data  @CN: 12λ*/
#define SPI_DataSize_13b                     ((uint16_t)0x000C) /*@EN: 13-bit data  @CN: 13λ*/
#define SPI_DataSize_14b                     ((uint16_t)0x000D) /*@EN: 14-bit data  @CN: 14λ*/
#define SPI_DataSize_15b                     ((uint16_t)0x000E) /*@EN: 15-bit data  @CN: 15λ*/
#define SPI_DataSize_16b                     ((uint16_t)0x000F) /*@EN: 16-bit data  @CN: 16λ*/
#define IS_SPI_DATA_SIZE(SIZE)               (((SIZE) == SPI_DataSize_4b) ||  \
                                              ((SIZE) == SPI_DataSize_5b) ||  \
                                              ((SIZE) == SPI_DataSize_6b) ||  \
                                              ((SIZE) == SPI_DataSize_7b) ||  \
                                              ((SIZE) == SPI_DataSize_8b) ||  \
                                              ((SIZE) == SPI_DataSize_9b) ||  \
                                              ((SIZE) == SPI_DataSize_10b) || \
                                              ((SIZE) == SPI_DataSize_11b) || \
                                              ((SIZE) == SPI_DataSize_12b) || \
                                              ((SIZE) == SPI_DataSize_13b) || \
                                              ((SIZE) == SPI_DataSize_14b) || \
                                              ((SIZE) == SPI_DataSize_15b) || \
                                              ((SIZE) == SPI_DataSize_16b))
/* @end */

/* @defgroup SPI_CPOL */
#define SPI_CPOL_Low                         ((uint16_t)0x0000) /*@EN: SSP controller keeps the bus clock low between frame transmissions
                                                                  @CN: SSPʹʱÿ֮֡䱣ֵ͵ƽ*/
#define SPI_CPOL_High                        ((uint16_t)0x0040) /*@EN: SSP controller keeps the bus clock high between frame transmissions
                                                                  @CN: SSPʹʱÿ֮֡䱣ָߵƽ*/
#define IS_SPI_CPOL(CPOL)                    (((CPOL) == SPI_CPOL_Low) || \
                                              ((CPOL) == SPI_CPOL_High))
/* @end */

/* @defgroup SPI_CPHA */
#define SPI_CPHA_1Edge                       ((uint16_t)0x0000) /*@EN: SSP controller captures serial data on the first clock transition of frame transmission
                                                                  @CN: SSP֡ĵһʱز*/
#define SPI_CPHA_2Edge                       ((uint16_t)0x0080) /*@EN: SSP controller captures serial data on the second clock transition of frame transmission
                                                                  @CN: SSP֡ĵڶʱز*/
#define IS_SPI_CPHA(CPHA)                    (((CPHA) == SPI_CPHA_1Edge) || \
                                              ((CPHA) == SPI_CPHA_2Edge))
/* @end */

/* @defgroup SPI_BaudRatePrescaler */
#define SPI_BaudRatePrescaler_2              ((uint16_t)0x0000) /*@EN: SPI serial clock rate Prescaler 2 @CN: SPI ʱԤƵ 2 */
#define SPI_BaudRatePrescaler_4              ((uint16_t)0x0100) /*@EN: SPI serial clock rate Prescaler 4 @CN: SPI ʱԤƵ 4 */
#define SPI_BaudRatePrescaler_8              ((uint16_t)0x0300) /*@EN: SPI serial clock rate Prescaler 8 @CN: SPI ʱԤƵ 8 */
#define SPI_BaudRatePrescaler_16             ((uint16_t)0x0700) /*@EN: SPI serial clock rate Prescaler 16 @CN: SPI ʱԤƵ 16 */
#define SPI_BaudRatePrescaler_32             ((uint16_t)0x0F00) /*@EN: SPI serial clock rate Prescaler 32 @CN: SPI ʱԤƵ 32 */
#define SPI_BaudRatePrescaler_64             ((uint16_t)0x1F00) /*@EN: SPI serial clock rate Prescaler 64 @CN: SPI ʱԤƵ 64 */
#define SPI_BaudRatePrescaler_128            ((uint16_t)0x3F00) /*@EN: SPI serial clock rate Prescaler 128 @CN: SPI ʱԤƵ 128 */
#define SPI_BaudRatePrescaler_256            ((uint16_t)0x7F00) /*@EN: SPI serial clock rate Prescaler 256 @CN: SPI ʱԤƵ 256 */
#define IS_SPI_BAUDRATE_PRESCALER(PRESCALER) (((PRESCALER) == SPI_BaudRatePrescaler_2) ||   \
                                              ((PRESCALER) == SPI_BaudRatePrescaler_4) ||   \
                                              ((PRESCALER) == SPI_BaudRatePrescaler_8) ||   \
                                              ((PRESCALER) == SPI_BaudRatePrescaler_16) ||  \
                                              ((PRESCALER) == SPI_BaudRatePrescaler_32) ||  \
                                              ((PRESCALER) == SPI_BaudRatePrescaler_64) ||  \
                                              ((PRESCALER) == SPI_BaudRatePrescaler_128) || \
                                              ((PRESCALER) == SPI_BaudRatePrescaler_256))
/* @end */

/* @defgroup SPI_FirstBit */
#define SPI_FirstBit_MSB                     ((uint16_t)0x0000) /*@EN: High bit transmission  @CN: λ*/
#define SPI_FirstBit_LSB                     ((uint16_t)0x0080) /*@EN: Low bit transmission  @CN: λ*/
#define IS_SPI_FIRST_BIT(BIT)                (((BIT) == SPI_FirstBit_MSB) || \
                                              ((BIT) == SPI_FirstBit_LSB))
/* @end */

/* @defgroup SPI_SlaveTx */
#define SPI_SlaveTx_Enable                   ((uint16_t)0x0000) /*@EN: SPI controller driving to transmit data line TXD is enabled @CN:  SPI  TXD*/
#define SPI_SlaveTx_Disable                  ((uint16_t)0x0008) /*@EN: SPI controller driving to transmit data line TXD is disabled @CN: ֹ SPI  TXD*/
#define IS_SPI_SLAVE_TX(STATUS)              (((STATUS) == SPI_SlaveTx_Enable) || \
                                              ((STATUS) == SPI_SlaveTx_Disable))
/* @end */

/* @defgroup SPI_SpeedMode
 */
#define SPI_Speed_Normol                     ((uint16_t)0x0000) /*@EN: Normal mode @CN: ͨģʽ*/
#define SPI_Speed_High                       ((uint16_t)0x0001) /*@EN: High speed mode @CN: ģʽ*/
/* @end */

/* @defgroup SPI_DMAReq */
#define SPI_DMAReq_Tx                        ((uint16_t)0x0002) /*@EN: SPI TX DMA Enable @CN: spi DMAʹ*/
#define SPI_DMAReq_Rx                        ((uint16_t)0x0001) /*@EN: SPI RX DMA Enable @CN: spi DMAʹ*/
#define IS_SPI_DMA_REQ(REQ)                  ((REQ == SPI_DMAReq_Tx) || (REQ == SPI_DMAReq_Rx))
/* @end */

/* @defgroup SPI_IT */
#define SPI_IT_Tx                            ((uint16_t)0x0008) /*@EN: send FIFO half full interrupt @CN: FIFOж */
#define SPI_IT_Rx                            ((uint16_t)0x0004) /*@EN: Receive FIFO half full interrupt @CN: FIFOж */
#define SPI_IT_RT                            ((uint16_t)0x0002) /*@EN: Receive timeout interrupt @CN: ճʱж */
#define SPI_IT_ROR                           ((uint16_t)0x0001) /*@EN: Receive overflow interrupt @CN: ж */
#define SPI_IT_ALL                           ((uint16_t)0x00FF) /*@EN: all interrupt @CN: ȫж */
#define IS_SPI_CONFIG_IT(IT)                 (((IT) == SPI_IT_Tx) ||  \
                                              ((IT) == SPI_IT_Rx) ||  \
                                              ((IT) == SPI_IT_RT) ||  \
                                              ((IT) == SPI_IT_ROR) || \
                                              ((IT) == SPI_IT_ALL))
/* @end */

/* @defgroup SPI_FLAG */
#define SPI_FLAG_BSY                         ((uint16_t)0x0010) /*@EN: SPI busy flag @CN: SPI æ־ */
#define SPI_FLAG_RFF                         ((uint16_t)0x0008) /*@EN: Receive FIFO full flag @CN:  FIFO ־ */
#define SPI_FLAG_RNE                         ((uint16_t)0x0004) /*@EN: Receive FIFO non empty flag @CN:  FIFO ǿձ־ */
#define SPI_FLAG_TNF                         ((uint16_t)0x0002) /*@EN: Send FIFO non full flag @CN:  FIFO ־ */
#define SPI_FLAG_TFE                         ((uint16_t)0x0001) /*@EN: Send FIFO empty flag @CN: FIFOΪձ־ */
#define IS_SPI_GET_FLAG(FLAG)                (((FLAG) == SPI_FLAG_BSY) || ((FLAG) == SPI_FLAG_RFF) || \
                                              ((FLAG) == SPI_FLAG_RNE) || ((FLAG) == SPI_FLAG_TNF) || \
                                              ((FLAG) == SPI_FLAG_TFE))
/* @end */

/* @defgroup SPI_FLAG */
#define SPI_ERROR_FLAG_RT                    ((uint16_t)0x0002) /*@EN: Receive timeout interrupt @CN: ճʱж */
#define SPI_ERROR_FLAF_ROR                   ((uint16_t)0x0001) /*@EN: Receive overflow interrupt @CN: ж */
#define IS_SPI_CLEAR_FLAG(ERROR_FLAG)        (((ERROR_FLAG) == SPI_FLAG_CRCERR) || ((ERROR_FLAG) == SPI_ERROR_FLAF_ROR))
/* @end */

/* @defgroup SPI_DelayTime */
#define SPI_DELAY_TIME_00NS                   ((uint16_t)0x0000) /*@EN: SPI controller receives data directly (default) @CN: SPIֱӽݣĬϣ */
#define SPI_DELAY_TIME_10NS                   ((uint16_t)0x0004) /*@EN: SPI controller receives data after a delay of 10ns @CN: SPIӳ10ns */
#define SPI_DELAY_TIME_20NS                   ((uint16_t)0x0008) /*@EN: SPI controller receives data after a delay of 20ns @CN: SPIӳ10ns */
#define SPI_DELAY_TIME_30NS                   ((uint16_t)0x000C) /*@EN: SPI controller receives data after a delay of 30ns @CN: SPIӳ10ns */
#define IS_SPI_DELAY_TIME(TIME)               (((TIME) == SPI_DELAY_TIME_00NS) || \
                                               ((TIME) == SPI_DELAY_TIME_10NS) || \
                                               ((TIME) == SPI_DELAY_TIME_20NS) || \
                                               ((TIME) == SPI_DELAY_TIME_30NS) )
/* @end */

/* ========================================================================== */
/* ================             SPI  REGISTER BIT               ============= */
/* ========================================================================== */

/* ===============================  SSPCR0  ================================= */
#define SPI_SSPCR0_SCR_Pos                        (8UL)                        /*!< SCR (Bit 8)                         */
#define SPI_SSPCR0_SCR_Msk                        (0x0000FF00UL)               /*!< SCR (Bitfield-Mask: 0xFF)           */
#define SPI_SSPCR0_SPH_Pos                        (7UL)                        /*!< SPH (Bit 7)                         */
#define SPI_SSPCR0_SPH_Msk                        (0x00000080UL)               /*!< SPH (Bitfield-Mask: 0x01)           */
#define SPI_SSPCR0_SPO_Pos                        (6UL)                        /*!< SPO (Bit 6)                         */
#define SPI_SSPCR0_SPO_Msk                        (0x00000040UL)               /*!< SPO (Bitfield-Mask: 0x01)           */
#define SPI_SSPCR0_FRF_Pos                        (4UL)                        /*!< FRF (Bit 4)                         */
#define SPI_SSPCR0_FRF_Msk                        (0x00000030UL)               /*!< FRF (Bitfield-Mask: 0x03)           */
#define SPI_SSPCR0_DSS_Pos                        (0UL)                        /*!< DSS (Bit 0)                         */
#define SPI_SSPCR0_DSS_Msk                        (0x0000000FUL)               /*!< DSS (Bitfield-Mask: 0x0F)           */
/* ===============================  SSPCR1  ================================= */
#define SPI_SSPCR1_SOD_Pos                        (3UL)                        /*!< SOD (Bit 3)                         */
#define SPI_SSPCR1_SOD_Msk                        (0x00000008UL)               /*!< SOD (Bitfield-Mask: 0x01)           */
#define SPI_SSPCR1_MS_Pos                         (2UL)                        /*!< MS (Bit 2)                          */
#define SPI_SSPCR1_MS_Msk                         (0x00000004UL)               /*!< MS (Bitfield-Mask: 0x01)            */
#define SPI_SSPCR1_SSE_Pos                        (1UL)                        /*!< SSE (Bit 1)                         */
#define SPI_SSPCR1_SSE_Msk                        (0x00000002UL)               /*!< SSE (Bitfield-Mask: 0x01)           */
#define SPI_SSPCR1_LBM_Pos                        (0UL)                        /*!< LBM (Bit 0)                         */
#define SPI_SSPCR1_LBM_Msk                        (0x00000001UL)               /*!< LBM (Bitfield-Mask: 0x01)           */
/* ===============================  SSPCR2  ================================= */
#define SPI_SSPCR2_LSB_Pos                        (7UL)                        /*!< LSB (Bit 7)                         */
#define SPI_SSPCR2_LSB_Msk                        (0x00000080UL)               /*!< LSB (Bitfield-Mask: 0x01)           */
#define SPI_SSPCR2_SPXDD_Pos                      (6UL)                        /*!< SPXDD (Bit 6)                       */
#define SPI_SSPCR2_SPXDD_Msk                      (0x00000040UL)               /*!< SPXDD (Bitfield-Mask: 0x01)         */
#define SPI_SSPCR2_SFSSD_Pos                      (5UL)                        /*!< SFSSD  (Bit 5)                      */
#define SPI_SSPCR2_SFSSD_Msk                      (0x00000020UL)               /*!< SFSSD (Bitfield-Mask: 0x01)         */
#define SPI_SSPCR2_SCLKD_Pos                      (4UL)                        /*!< SCLKD (Bit 4)                       */
#define SPI_SSPCR2_SCLKD_Msk                      (0x00000010UL)               /*!< SCLKD (Bitfield-Mask: 0x01)         */
#define SPI_SSPCR2_MRXDDS_Pos                     (2UL)                        /*!< MRXDDS (Bit 2)                      */
#define SPI_SSPCR2_MRXDDS_Msk                     (0x0000000CUL)               /*!< MRXDDS (Bitfield-Mask: 0x03)        */
#define SPI_SSPCR2_FSSE_Pos                       (1UL)                        /*!< SFSSE (Bit 1)                       */
#define SPI_SSPCR2_FSSE_Msk                       (0x00000002UL)               /*!< SFSSE (Bitfield-Mask: 0x01)         */
#define SPI_SSPCR2_HR_Pos                         (0UL)                        /*!< SODHR (Bit 0)                       */
#define SPI_SSPCR2_HR_Msk                         (0x00000001UL)               /*!< SODHR (Bitfield-Mask: 0x01)         */
/* ================================  SSPDR  ================================= */
#define SPI_SSPDR_DATA_Pos                        (0UL)                        /*!< DATA (Bit 0)                        */
#define SPI_SSPDR_DATA_Msk                        (0x0000FFFFUL)               /*!< DATA (Bitfield-Mask: 0xFFFF)        */
/* ================================  SSPSR  ================================= */
#define SPI_SSPSR_BSY_Pos                         (4UL)                        /*!< BSY (Bit 4)                         */
#define SPI_SSPSR_BSY_Msk                         (0x00000010UL)               /*!< BSY (Bitfield-Mask: 0x01)           */
#define SPI_SSPSR_RFF_Pos                         (3UL)                        /*!< RFF (Bit 3)                         */
#define SPI_SSPSR_RFF_Msk                         (0x00000008UL)               /*!< RFF (Bitfield-Mask: 0x01)           */
#define SPI_SSPSR_RNE_Pos                         (2UL)                        /*!< RNE (Bit 2)                         */
#define SPI_SSPSR_RNE_Msk                         (0x00000004UL)               /*!< RNE (Bitfield-Mask: 0x01)           */
#define SPI_SSPSR_TNF_Pos                         (1UL)                        /*!< TNF (Bit 1)                         */
#define SPI_SSPSR_TNF_Msk                         (0x00000002UL)               /*!< TNF (Bitfield-Mask: 0x01)           */
#define SPI_SSPSR_TFE_Pos                         (0UL)                        /*!< TFE (Bit 0)                         */
#define SPI_SSPSR_TFE_Msk                         (0x00000001UL)               /*!< TFE (Bitfield-Mask: 0x01)           */
/* ===============================  SSPCPSR  ================================ */
#define SPI_SSPCPSR_CPSDVSR_Pos                   (0UL)                        /*!< CPSDVSR (Bit 0)                     */
#define SPI_SSPCPSR_CPSDVSR_Msk                   (0x000000FFUL)               /*!< CPSDVSR (Bitfield-Mask: 0xFF)       */
/* ===============================  SSPIMSC  ================================ */
#define SPI_SSPIMSC_TXIM_Pos                      (3UL)                        /*!< TXIM (Bit 3)                        */
#define SPI_SSPIMSC_TXIM_Msk                      (0x00000008UL)               /*!< TXIM (Bitfield-Mask: 0x01)          */
#define SPI_SSPIMSC_RXIM_Pos                      (2UL)                        /*!< RXIM (Bit 2)                        */
#define SPI_SSPIMSC_RXIM_Msk                      (0x00000004UL)               /*!< RXIM (Bitfield-Mask: 0x01)          */
#define SPI_SSPIMSC_RTIM_Pos                      (1UL)                        /*!< RTIM (Bit 1)                        */
#define SPI_SSPIMSC_RTIM_Msk                      (0x00000002UL)               /*!< RTIM (Bitfield-Mask: 0x01)          */
#define SPI_SSPIMSC_RORIM_Pos                     (0UL)                        /*!< RORIM (Bit 0)                       */
#define SPI_SSPIMSC_RORIM_Msk                     (0x00000001UL)               /*!< RORIM (Bitfield-Mask: 0x01)         */
/* ===============================  SSPRIS  ================================= */
#define SPI_SSPRIS_TXRIS_Pos                      (3UL)                        /*!< TXRIS (Bit 3)                       */
#define SPI_SSPRIS_TXRIS_Msk                      (0x00000008UL)               /*!< TXRIS (Bitfield-Mask: 0x01)         */
#define SPI_SSPRIS_RXRIS_Pos                      (2UL)                        /*!< RXRIS (Bit 2)                       */
#define SPI_SSPRIS_RXRIS_Msk                      (0x00000004UL)               /*!< RXRIS (Bitfield-Mask: 0x01)         */
#define SPI_SSPRIS_RTRIS_Pos                      (1UL)                        /*!< RTRIS (Bit 1)                       */
#define SPI_SSPRIS_RTRIS_Msk                      (0x00000002UL)               /*!< RTRIS (Bitfield-Mask: 0x01)         */
#define SPI_SSPRIS_RORRIS_Pos                     (0UL)                        /*!< RORRIS (Bit 0)                      */
#define SPI_SSPRIS_RORRIS_Msk                     (0x00000001UL)               /*!< RORRIS (Bitfield-Mask: 0x01)        */
/* ===============================  SSPMIS  ================================= */
#define SPI_SSPMIS_TXMIS_Pos                      (3UL)                        /*!< TXMIS (Bit 3)                       */
#define SPI_SSPMIS_TXMIS_Msk                      (0x00000008UL)               /*!< TXMIS (Bitfield-Mask: 0x01)         */
#define SPI_SSPMIS_RXMIS_Pos                      (2UL)                        /*!< RXMIS (Bit 2)                       */
#define SPI_SSPMIS_RXMIS_Msk                      (0x00000004UL)               /*!< RXMIS (Bitfield-Mask: 0x01)         */
#define SPI_SSPMIS_RTMIS_Pos                      (1UL)                        /*!< RTMIS (Bit 1)                       */
#define SPI_SSPMIS_RTMIS_Msk                      (0x00000002UL)               /*!< RTMIS (Bitfield-Mask: 0x01)         */
#define SPI_SSPMIS_RORMIS_Pos                     (0UL)                        /*!< RORMIS (Bit 0)                      */
#define SPI_SSPMIS_RORMIS_Msk                     (0x00000001UL)               /*!< RORMIS (Bitfield-Mask: 0x01)        */
/* ===============================  SSPICR  ================================= */
#define SPI_SSPICR_RTIC_Pos                       (1UL)                        /*!< RTIC (Bit 1)                        */
#define SPI_SSPICR_RTIC_Msk                       (0x00000002UL)               /*!< RTIC (Bitfield-Mask: 0x01)          */
#define SPI_SSPICR_RORIC_Pos                      (0UL)                        /*!< RORIC (Bit 0)                       */
#define SPI_SSPICR_RORIC_Msk                      (0x00000001UL)               /*!< RORIC (Bitfield-Mask: 0x01)         */
/* ==============================  SSPDMACR  ================================ */
#define SPI_SSPDMACR_TXDMAE_Pos                   (1UL)                        /*!< TXDMAE (Bit 1)                      */
#define SPI_SSPDMACR_TXDMAE_Msk                   (0x00000002UL)               /*!< TXDMAE (Bitfield-Mask: 0x01)        */
#define SPI_SSPDMACR_RXDMAE_Pos                   (0UL)                        /*!< RXDMAE (Bit 0)                      */
#define SPI_SSPDMACR_RXDMAE_Msk                   (0x00000001UL)               /*!< RXDMAE (Bitfield-Mask: 0x01)        */

/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */
void SPI_DeInit(SPI_TypeDef *SPIx);
void SPI_StructInit(SPI_InitTypeDef *SPI_InitStruct);
void SPI_Init(SPI_TypeDef *SPIx, SPI_InitTypeDef *SPI_InitStruct);
void SPI_Cmd(SPI_TypeDef *SPIx, FunctionalState NewState);
void SPI_DataSizeConfig(SPI_TypeDef *SPIx, uint16_t SPI_DataSize);
void SPI_SendData8(SPI_TypeDef *SPIx, uint8_t Data);
void SPI_SendData16(SPI_TypeDef *SPIx, uint16_t Data);
uint8_t SPI_ReceiveData8(SPI_TypeDef *SPIx);
uint16_t SPI_ReceiveData16(SPI_TypeDef *SPIx);
void SPI_DMACmd(SPI_TypeDef *SPIx, uint16_t SPI_DMAReq, FunctionalState NewState);
void SPI_ITConfig(SPI_TypeDef *SPIx, uint8_t SPI_IT, FunctionalState NewState);
FlagStatus SPI_GetFlagStatus(SPI_TypeDef *SPIx, uint16_t SPI_FLAG);
void SPI_ClearFlag(SPI_TypeDef *SPIx, uint16_t SPI_ERROR_FLAG);
ITStatus SPI_GetITStatus(SPI_TypeDef *SPIx, uint8_t SPI_IT);
ITStatus SPI_GetITRawStatus(SPI_TypeDef *SPIx, uint8_t SPI_IT);
void SPI_MasterModeDelaySelect(SPI_TypeDef *SPIx, uint16_t SPI_DelayTime);
void SPI_SlaveModeDelayRxDataCmd(SPI_TypeDef *SPIx, FunctionalState NewState);
void SPI_SlaveModeDelayRxFilmSelectCmd(SPI_TypeDef *SPIx, FunctionalState NewState);
void SPI_SlaveModeDelayRxClockCmd(SPI_TypeDef *SPIx, FunctionalState NewState);
void SPI_SlaveModeFilmSelectCmd(SPI_TypeDef *SPIx, FunctionalState NewState);
#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_SPI_H__
