/**
  ******************************************************************************
  * @file    lcm32f06x_pwr.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for pwr.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_PWR_H__
#define __LCM32F06X_PWR_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

#ifdef __cplusplus
  extern "C" {
#endif

/* @defgroup PWR_SLEEPEntry */
#define PWR_SLEEPEntry_WFI                   ((uint8_t)0x01) /*@EN: enter SLEEP mode with WFI instruction @CN: ʹWFIָ˯ģʽ */
#define PWR_SLEEPEntry_WFE                   ((uint8_t)0x02) /*@EN: enter SLEEP mode with WFE instruction @CN: ʹWFEָ˯ģʽ */
#define IS_PWR_SLEEP_ENTRY(ENTRY)            (((ENTRY) == PWR_SLEEPEntry_WFI) || ((ENTRY) == PWR_SLEEPEntry_WFE))
/* @end */

/* @defgroup PWR_STOPEntry */
#define PWR_STOPEntry_WFI                    ((uint8_t)0x01) /*@EN: enter STOP mode with WFI instruction @CN: ʹWFIָSTOPģʽ */
#define PWR_STOPEntry_WFE                    ((uint8_t)0x02) /*@EN: enter STOP mode with WFE instruction @CN: ʹWFEָSTOPģʽ */
#define IS_PWR_STOP_ENTRY(ENTRY)             (((ENTRY) == PWR_STOPEntry_WFI) || ((ENTRY) == PWR_STOPEntry_WFE))
/* @end */

/* @defgroup PWR_LDODRV */
#define PWR_AOUT_SEL_VBG                     ((uint8_t)0x00) /*@EN: High precision reference voltage @CN: ߾Ȼ׼ѹ */
#define PWR_AOUT_SEL_FLASH                   ((uint8_t)0x01) /*@EN: Flash reference voltage @CN: Flash οѹ */
#define PWR_AOUT_SEL_LOWPOWER                ((uint8_t)0x02) /*@EN: Low power reference voltage @CN: ͹Ļ׼ѹ */
#define PWR_AOUT_SEL_ACMPCVREF               ((uint8_t)0x03) /*@EN: Internal reference voltage CVREF of ACMP @CN: ACMP ڲοѹ CVREF */
#define PWR_AOUT_SEL_HALL_MID                ((uint8_t)0x04) /*@EN: HALL MID voltage output OUT @CN: HALL_MID ѹ */
#define PWR_AOUT_SEL_VDDA_2                  ((uint8_t)0x05) /*@EN: VDDA/2 voltage output @CN: VDDA/2 ѹ */

#define IS_PWR_AOUT_SEL_MODE(MODE)           (((MODE) == PWR_AOUT_SEL_VBG) || (MODE) == PWR_AOUT_SEL_FLASH) \
                                              ((MODE) == PWR_AOUT_SEL_LOWPOWER) || (MODE) == PWR_AOUT_SEL_ACMPCVREF) \
                                              ((MODE) == PWR_AOUT_SEL_HALL_MID) || (MODE) == PWR_AOUT_SEL_VDDA_2))
/* @end */

/* @defgroup PWR_LVDInternal */
#define PWR_LVDInternal_2V                   ((uint8_t)0x00) /*@EN: LVD low-voltage detection level 2V @CN: LVD ѹƽ 2V */
#define PWR_LVDInternal_2V2                  ((uint8_t)0x01) /*@EN: LVD low-voltage detection level 2.2V @CN: LVD ѹƽ 2.2V  */
#define PWR_LVDInternal_2V4                  ((uint8_t)0x02) /*@EN: LVD low-voltage detection level 2.4V @CN: LVD ѹƽ 2.4V  */
#define PWR_LVDInternal_2V7                  ((uint8_t)0x03) /*@EN: LVD low-voltage detection level 2.7V @CN: LVD ѹƽ 2.7V  */
#define PWR_LVDInternal_2V9                  ((uint8_t)0x04) /*@EN: LVD low-voltage detection level 2.9V @CN: LVD ѹƽ 2.9V  */
#define PWR_LVDInternal_3V1                  ((uint8_t)0x05) /*@EN: LVD low-voltage detection level 3.1V @CN: LVD ѹƽ 3.1V  */
#define PWR_LVDInternal_3V6                  ((uint8_t)0x06) /*@EN: LVD low-voltage detection level 3.6V @CN: LVD ѹƽ 3.6V  */
#define PWR_LVDInternal_4V5                  ((uint8_t)0x07) /*@EN: LVD low-voltage detection level 4.5V @CN: LVD ѹƽ 4.5V  */
#define IS_PWR_LVDInternal_MODE(LVDInternal) ((LVDInternal == PWR_LVDInternal_2V) || (LVDInternal == PWR_LVDInternal_2V2)  \
                                              (LVDInternal == PWR_LVDInternal_2V4) || (LVDInternal == PWR_LVDInternal_2V7) \
                                              (LVDInternal == PWR_LVDInternal_2V9) || (LVDInternal == PWR_LVDInternal_3V1) \
                                              (LVDInternal == PWR_LVDInternal_3V6) || (LVDInternal == PWR_LVDInternal_4V5))
/* @end */
/* @end */

/* @defgroup PWR_LVRLevel */
#define PWR_LVRLevel_1V6                     ((uint8_t)0x00) /*@EN: LVR Low voltage reset point 1.6V @CN: LVR ѹλ 1.6V */
#define PWR_LVRLevel_1V8                     ((uint8_t)0x01) /*@EN: LVR Low voltage reset point 1.8V @CN: LVR ѹλ 1.8V */
#define PWR_LVRLevel_2V0                     ((uint8_t)0x02) /*@EN: LVR Low voltage reset point 2.0V @CN: LVR ѹλ 2.0V */
#define PWR_LVRLevel_2V5                     ((uint8_t)0x03) /*@EN: LVR Low voltage reset point 2.5V @CN: LVR ѹλ 2.5V */
#define PWR_LVRLevel_2V8                     ((uint8_t)0x04) /*@EN: LVR Low voltage reset point 2.8V @CN: LVR ѹλ 2.8V */
#define PWR_LVRLevel_3V0                     ((uint8_t)0x05) /*@EN: LVR Low voltage reset point 3.0V @CN: LVR ѹλ 3.0V */
#define PWR_LVRLevel_3V5                     ((uint8_t)0x06) /*@EN: LVR Low voltage reset point 3.5V @CN: LVR ѹλ 3.5V */
#define PWR_LVRLevel_4V0                     ((uint8_t)0x07) /*@EN: LVR Low voltage reset point 4.0V @CN: LVR ѹλ 4.0V */

#define IS_PWR_LVRLevel(LVRLevel)            ((LVRLevel == PWR_LVRLevel_1V6) || (LVRLevel == PWR_LVRLevel_1V8)  \
                                              (LVRLevel == PWR_LVRLevel_2V0) || (LVRLevel == PWR_LVRLevel_2V5) \
                                              (LVRLevel == PWR_LVRLevel_2V8) || (LVRLevel == PWR_LVRLevel_3V0) \
                                              (LVRLevel == PWR_LVRLevel_3V5) || (LVRLevel == PWR_LVRLevel_4V0))
/* @end */

/* @defgroup PWR_LVD */
#define PWR_LVDInternal                      ((uint8_t)0x00) /*@EN: Select to detect internal voltage (default)@CN: ѡڲѹĬϣ */
#define PWR_LVDExternal                      ((uint8_t)0x01) /*@EN: Select to detect external power supply @CN: ѡⲿԴ */
#define IS_PWR_LVDIE(IE)                     ((IE == PWR_LVDInternal) || (IE == PWR_LVDExternal))
/* @end */

/* @defgroup PWR_LDODRV */
#define PWR_LDODRV_10uA                      ((uint8_t)0x00) /*@EN:10uA self consumption current low-power mode 1.2V @CN:10uA Ժĵ͹ģʽ1.2V */
#define PWR_LDODRV_50uA                      ((uint8_t)0x01) /*@EN:50uA self consumption current low-power mode 1.2V @CN:50uA Ժĵ͹ģʽ1.2V */
#define PWR_LDODRV_150uA                     ((uint8_t)0x02) /*@EN:150uA self consumption current low-power mode 1.2V @CN:150uA Ժĵ͹ģʽ1.2V */
#define PWR_LDODRV_200uA                     ((uint8_t)0x03) /*@EN:200uA self consumption current low-power mode 1.38V @CN:200uA Ժĵ͹ģʽ1.38V */
#define IS_PWR_LDODRV_CURRENT_MODE(MODE)     (((MODE) == PWR_LDODRV_10uA) || (MODE) == PWR_LDODRV_50uA) \
                                              ((MODE) == PWR_LDODRV_150uA) || (MODE) == PWR_LDODRV_200uA)) 
/* @end */

/* @defgroup PWR_LDODRV */
#define ChipCtrl_FLAG_LVD                    ((uint8_t)0x01) /*@EN: LVD low-voltage monitoring sign CN: LVD ѹ־*/
#define ChipCtrl_FLAG_LVR                    ((uint8_t)0x02) /*@EN: Low voltage monitoring reset flag CN: ѹ⸴λ־*/
#define ChipCtrl_FLAG_POR                    ((uint8_t)0x03) /*@EN: Power on/power off reset flag CN: ϵ/縴λ־*/
#define IS_ChipCtrl_FLAG(FLAG)               ((FLAG == ChipCtrl_FLAG_LVD) || \
                                              (FLAG == ChipCtrl_FLAG_LVR) || \
                                              (FLAG == ChipCtrl_FLAG_POR))
/* @end */

/* @defgroup OPA_Bisa_current */
#define OPA_BISA_CURRENT_2UA                    ((uint8_t)0x00) /*@EN: OPA Bias current 2uA CN: OPAƫõ2uA */
#define OPA_BISA_CURRENT_4UA                    ((uint8_t)0x01) /*@EN: OPA Bias current 4uA CN: OPAƫõ4uA */
#define IS_OPA_BISA_CURRENT(CURRENT)            ((CURRENT == OPA_BISA_CURRENT_2UA) || \
                                                 (CURRENT == OPA_BISA_CURRENT_4UA))
/* @end */

void PWR_EnterSleepMode(uint32_t PWR_SLEEPEntry);
void PWR_EnterUR_STOPMode(uint32_t PWR_STOPEntry);
void PWR_EnterSTOPMode(uint32_t PWR_STOPEntry);
void PWR_EnterLowPowerSTOPMode(uint32_t PWR_STOPEntry);
void PWR_EnterSTANDBYMode(void);

void PWR_AOUTConfig(uint8_t PWR_AOUT);
void PWR_AOUTcmd(FunctionalState NewState);
void PWR_LVDConfig(uint8_t IE, uint8_t PWR_LVDLevel);
void PWR_LVDCmd(FunctionalState NewState);
void PWR_LVRConfig(uint32_t PWR_LVRLevel);
void PWR_LVRCmd(FunctionalState NewState);
#if defined (LCM32F067) || defined (LCM32F063)  || defined (LCM32CF6990)
void PWR_OPA_BiasCurrentSel(OPA_TypeDef *OPAx, uint8_t Bisa_current);
#elif defined (LCM32F062)
  /* None OPA */
#endif
void PWR_LVRClearFlag(void);
void PWR_POR_PDRClearFlag(void);
void PWR_UltraLowPowerDeepSleep(FunctionalState NewState);
void PWR_FlashPowerDownDeepSleep(FunctionalState NewState);
void PWR_LowPowerCmd(FunctionalState NewState);
void PWR_LowPowerDeepSleep(FunctionalState NewState);
  
void PWR_LDODriverLevel(uint8_t PWR_DRV);
uint8_t Chipctrl_ReadFLAG(uint32_t FLAG);
#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_PWR_H__
