/**
  ******************************************************************************
  * @file    lcm32f06x_opa.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for opa.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_OPA_H__
#define __LCM32F06X_OPA_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"
#include "lcm32f06x_rcc.h"

#ifdef __cplusplus
  extern "C" {
#endif

/** 
  * @brief OPA Init structure definition
  */

typedef struct
{
  uint32_t OPA_PositiveInput;     /*!< EN: OPA positive input selection.
                                       CN: OPA ѡ
                                       @Register: OPAx_CSR @Bits:[26]OPxPSEL.
                                       @default:  OPA_PositiveInput_P0 */

  uint32_t OPA_NegativeInput;     /*!< EN: OPA negative input selection.
                                       CN: OPA ѡ
                                       @Register: OPAx_CSR @Bits:[24]OPxNSEL.
                                       @default:  OPA_NegativeInput_N0 */

  uint32_t OPA_FeedbackResSingal; /*!< EN: OPA live resistor output enabled.
                                       CN: OPAʹܡ
                                       @Register: OPAx_CSR @Bits:[14]OPxRFB.
                                       @default:  OPA_FeedbackResSingal_DISEN */

  uint32_t OPA_InputRes;          /*!< EN: OPA input resistor.
                                       CN: OPA 衣
                                       @Register: OPAx_CSR @Bits:[13]OPxRIN.
                                       @default:  OPA_InputRes_36K */

  uint32_t OPA_PositiveADCSwitch; /*!< EN: Trigger positive input switching enable after ADC sampling.
                                       CN: ADC 󴥷лʹܡ
                                       @Register: OPAx_CSR @Bits:[12]ADC_P_EN.
                                       @default:  OPA_PositiveADCSwitch_DISEN */

  uint32_t OPA_NegativeADCSwitch; /*!< EN: Trigger negative input switching enable after ADC sampling.
                                       CN: ADC 󴥷лʹܡ
                                       @Register: OPAx_CSR @Bits:[11]ADC_N_EN.
                                       @default:  OPA_NegativeADCSwitch_DISEN */

  uint32_t OPA_Gain;              /*!< EN: Specify the magnification of OPA.
                                       CN: ָ OPA ķŴ
                                       @Register: OPAx_CSR @Bits:[10:8]OPxGS.
                                       @default:  OPA_Gain_1 */

  uint32_t OPA_BiasVoltageSource; /*!< EN: Selection of bias voltage source.
                                       CN: ƫõѹԴѡ
                                       @Register: OPAx_CSR @Bits:[6]VM_SEL.
                                       @default:  OPA_BiasVoltageSource_ADC */

  uint32_t OPA_BiasVoltage;       /*!< EN: Positive bias voltage enable.
                                       CN: ƫõѹʹܡ
                                       @Register: OPAx_CSR @Bits:[5]OPxPS.
                                       @default:  OPA_BiasVoltage_DISEN */
  
  uint32_t OPA_FeedbackRes;       /*!< EN: Negative feedback resistor enable.
                                       CN: ˷ʹܡ
                                       @Register: OPAx_CSR @Bits:[4]OPxNS.
                                       @default:  OPA_FeedbackRes_DISEN */

  uint32_t OPA_OppRES_Short;      /*!< EN: Short circuit in positive input resistance.
                                       CN: ·
                                       @Register: OPAx_CSR @Bits:[2]OPxPRS.
                                       @default:  OPA_OppRES_Short_DISEN */

  uint32_t OPA_OpnRES_Short;      /*!< EN: Short circuit in negative input resistance.
                                       CN: ·
                                       @Register: OPAx_CSR @Bits:[1]OPxNRS.
                                       @default:  OPA_OpnRES_Short_DISEN */
} OPA_InitTypeDef;

/* @defgroup OPA_PositiveInput */
#define OPA_PositiveInput_P0         ((uint32_t)0x00000000) /*@EN: OPAx-P0 as positive input @CN: OPAx_P0 Ϊ */
#define OPA_PositiveInput_P1         ((uint32_t)0x04000000) /*@EN: OPAx-P1 as positive input @CN: OPAx_P1 Ϊ */
#define OPA_PositiveInput_GND        ((uint32_t)0x20000000) /*@EN: Positive input pulled down to ground @CN:  */
#define IS_OPA_PositiveInput(Input)  ((Input == OPA_PositiveInput_P0) ||\
                                      (Input == OPA_PositiveInput_P1) ||\
                                      (Input == OPA_PositiveInput_GND))
/* @end */

/* @defgroup OPA_NegativeInput */
#define OPA_NegativeInput_N0         ((uint32_t)0x00000000) /*@EN: OPAx-N0 as negative input @CN: OPAx_N0 Ϊ */
#define OPA_NegativeInput_N1         ((uint32_t)0x01000000) /*@EN: OPAx-N1 as negative input @CN: OPAx_N1 Ϊ */
#define OPA_NegativeInput_GND        ((uint32_t)0x10000000) /*@EN: Negative input pulled down to ground @CN:  */
#define IS_OPA_NegativeInput(Input)  ((Input == OPA_NegativeInput_N0) ||\
                                      (Input == OPA_NegativeInput_N1) ||\
                                      (Input == OPA_NegativeInput_GND))
/* @end */

/* @defgroup OPA_FeedbackResSingal */
#define OPA_FeedbackResSingal_EN     ((uint32_t)0x00004000) /*@EN: OPA live resistor output enabled @CN: OPAʹ */
#define OPA_FeedbackResSingal_DISEN  ((uint32_t)0x00000000) /*@EN: OPA live resistor output is disabled @CN: OPAֹ */
#define IS_OPA_FeedbackResSingal(Res)((Res == OPA_FeedbackResSingal_EN) ||\
                                      (Res == OPA_FeedbackResSingal_DISEN))
/* @end */

/* @defgroup OPA_InputRes */
#define OPA_InputRes_36K             ((uint32_t)0x00000000) /*@EN: OPAx input resistance is 36K @CN: OPAx Ϊ 36K */
#define OPA_InputRes_18K             ((uint32_t)0x00002000) /*@EN: OPAx input resistance is 18K @CN: OPAx Ϊ 18K */
#define IS_OPA_InputRes(InputRes)    ((InputRes == OPA_InputRes_36K) ||\
                                      (InputRes == OPA_InputRes_18K))
/* @end */

/* @defgroup OPA_PositiveADCSwitch */
#define OPA_PositiveADCSwitch_EN     ((uint32_t)0x00001000) /*@EN: Enable positive input switching @CN: лʹ */
#define OPA_PositiveADCSwitch_DISEN  ((uint32_t)0x00000000) /*@EN: Disable positive input switching @CN: лֹ */
#define IS_OPA_PositiveADCSwitch(ADC)((ADC == OPA_PositiveADCSwitch_EN) ||\
                                      (ADC == OPA_PositiveADCSwitch_DISEN))
/* @end */

/* @defgroup OPA_NegativeADCSwitch */
#define OPA_NegativeADCSwitch_EN     ((uint32_t)0x00000800) /*@EN: Enable negative input switching @CN: лʹ */
#define OPA_NegativeADCSwitch_DISEN  ((uint32_t)0x00000000) /*@EN: Disable negative input switching @CN: лֹ */
#define IS_OPA_NegativeADCSwitch(ADC)((ADC == OPA_NegativeADCSwitch_EN) ||\
                                      (ADC == OPA_NegativeADCSwitch_DISEN))
/* @end */

/* @defgroup OPA_Gain */
#define OPA_Gain_1                   ((uint32_t)0x00000000) /*@EN: x1 @CN: x1*/
#define OPA_Gain_2                   ((uint32_t)0x00000100) /*@EN: x2 @CN: x2*/
#define OPA_Gain_4                   ((uint32_t)0x00000200) /*@EN: x4 @CN: x4*/
#define OPA_Gain_6                   ((uint32_t)0x00000300) /*@EN: x6 @CN: x6*/
#define OPA_Gain_8                   ((uint32_t)0x00000400) /*@EN: x8 @CN: x8*/
#define OPA_Gain_10                  ((uint32_t)0x00000500) /*@EN: x10 @CN: x10*/
#define OPA_Gain_16                  ((uint32_t)0x00000600) /*@EN: x16 @CN: x16*/
#define OPA_Gain_32                  ((uint32_t)0x00000700) /*@EN: x32 @CN: x32*/
#define IS_OPA_Gain(Gain)            (((Gain) == OPA_Gain_1)  ||\
                                      ((Gain) == OPA_Gain_2)  ||\
                                      ((Gain) == OPA_Gain_4)  ||\
                                      ((Gain) == OPA_Gain_6)  ||\
                                      ((Gain) == OPA_Gain_8)  ||\
                                      ((Gain) == OPA_Gain_10) ||\
                                      ((Gain) == OPA_Gain_16) ||\
                                      ((Gain) == OPA_Gain_32))
/* @end */

/* @defgroup OPA_BiasVoltageSource */
#define OPA_BiasVoltageSource_PMU_AOUT ((uint32_t)0x00000000) /*@EN: Bias voltage sourcePMU_AOUT @CN: ƫõѹԴPMU_AOUT */
#define OPA_BiasVoltageSource_ADC_2    ((uint32_t)0x00000040) /*@EN: Bias voltage sourceHalf of the ADC reference voltage @CN: ADC οѹһ */
#define IS_OPA_BiasVoltageSource(Soc)  ((Soc == OPA_BiasVoltageSource_PMU_AOUT) ||\
                                        (Soc == OPA_BiasVoltageSource_ADC_2))
/* @end */

/* @defgroup OPA_BiasVoltage */
#define OPA_BiasVoltage_EN           ((uint32_t)0x00000020) /*@EN: Positive bias Disable @CN: ƫʹ */
#define OPA_BiasVoltage_DISEN        ((uint32_t)0x00000000) /*@EN: Positive bias Enable  @CN: ƫýֹ */
#define IS_OPA_BiasVoltage(Voltage)  ((Voltage == OPA_BiasVoltage_EN) ||\
                                      (Voltage == OPA_BiasVoltage_DISEN))
/* @end */

/* @defgroup OPA_FeedbackRes */
#define OPA_FeedbackRes_EN           ((uint32_t)0x00000010) /*@EN: Negative Feedback resistor Disable @CN: ˷ʹ */
#define OPA_FeedbackRes_DISEN        ((uint32_t)0x00000000) /*@EN: Nositive Feedback resistor Enable  @CN: ˷ֹ */
#define IS_OPA_FeedbackRes(Feedback) ((Feedback == OPA_FeedbackRes_EN) ||\
                                      (Feedback == OPA_FeedbackRes_DISEN))
/* @end */

/* @defgroup OPA_OppRES_Short */
#define OPA_OppRES_Short_EN          ((uint32_t)0x00000004) /*@EN: Positive input resistance short circuit @CN: · */
#define OPA_OppRES_Short_DISEN       ((uint32_t)0x00000000) /*@EN: Positive input resistance not short circuited @CN: 費· */
#define IS_OPA_OppRES_Short(Short)   ((Short == OPA_OppRES_Short_EN) ||\
                                      (Short == OPA_OppRES_Short_DISEN))
/* @end */

/* @defgroup OPA_OpnRES_Short */
#define OPA_OpnRES_Short_EN          ((uint32_t)0x00000002) /*@EN: Negative input resistance short circuit @CN: · */
#define OPA_OpnRES_Short_DISEN       ((uint32_t)0x00000000) /*@EN: Negative input resistance not short circuited @CN: 費· */
#define IS_OPA_OpnRES_Short(Short)   ((Short == OPA_OpnRES_Short_EN) ||\
                                      (Short == OPA_OpnRES_Short_DISEN))
/* @end */

/* ========================================================================== */
/* ================             OPA  REGISTER BIT               ============= */
/* ========================================================================== */

/* ===============================  CSR   =================================== */
#define OPAX_CSR_OPxTRIMO_Pos                     (31UL)                       /*!< OPxTRIMO (Bit 31)                          */
#define OPAX_CSR_OPxTRIMO_Msk                     (0x80000000UL)               /*!< OPxTRIMO (Bitfield-Mask: 0x1)              */
#define OPAX_CSR_OPxTRIMEN_Pos                    (30UL)                       /*!< OPxTRIMEN (Bit 30)                         */
#define OPAX_CSR_OPxTRIMEN_Msk                    (0x40000000UL)               /*!< OPxTRIMEN (Bitfield-Mask: 0x1)             */
#define OPAX_CSR_OPxP_PD_Pos                      (29UL)                       /*!< OPxP_PD (Bit 29)                           */
#define OPAX_CSR_OPxP_PD_Msk                      (0x20000000UL)               /*!< OPxP_PD (Bitfield-Mask: 0x1)               */
#define OPAX_CSR_OPxN_PD_Pos                      (28UL)                       /*!< OPxN_PD (Bit 28)                           */
#define OPAX_CSR_OPxN_PD_Msk                      (0x10000000UL)               /*!< OPxN_PD (Bitfield-Mask: 0x1)               */
#define OPAX_CSR_OPxPSEL_Pos                      (26UL)                       /*!< OPxPSEL (Bit 26)                           */
#define OPAX_CSR_OPxPSEL_Msk                      (0x04000000UL)               /*!< OPxPSEL (Bitfield-Mask: 0x1)               */
#define OPAX_CSR_OPxNSEL_Pos                      (24UL)                       /*!< OPxNSEL (Bit 24)                           */
#define OPAX_CSR_OPxNSEL_Msk                      (0x01000000UL)               /*!< OPxNSEL (Bitfield-Mask: 0x1)               */
#define OPAX_CSR_OPxOS_Pos                        (16UL)                       /*!< OPxOS (Bit 16)                             */
#define OPAX_CSR_OPxOS_Msk                        (0x001F0000UL)               /*!< OPxOS (Bitfield-Mask: 0x1F)                */
#define OPAX_CSR_OPxRFB_Pos                       (14UL)                       /*!< OPxRFB (Bit 14)                            */
#define OPAX_CSR_OPxRFB_Msk                       (0x00004000UL)               /*!< OPxRFB (Bitfield-Mask: 0x1)                */
#define OPAX_CSR_OPxRIN_Pos                       (13UL)                       /*!< OPxRIN (Bit 13)                            */
#define OPAX_CSR_OPxRIN_Msk                       (0x00002000UL)               /*!< OPxRIN (Bitfield-Mask: 0x1)                */
#define OPAX_CSR_ADC_P_EN_Pos                     (12UL)                       /*!< ADC_P_EN (Bit 12)                          */
#define OPAX_CSR_ADC_P_EN_Msk                     (0x00001000UL)               /*!< ADC_P_EN (Bitfield-Mask: 0x1)              */
#define OPAX_CSR_ADC_N_EN_Pos                     (11UL)                       /*!< ADC_N_EN (Bit 11)                          */
#define OPAX_CSR_ADC_N_EN_Msk                     (0x00000800UL)               /*!< ADC_N_EN (Bitfield-Mask: 0x1)              */
#define OPAX_CSR_OPxGS_Pos                        (8UL)                        /*!< OPxGS (Bit 8)                              */
#define OPAX_CSR_OPxGS_Msk                        (0x00000700UL)               /*!< OPxGS (Bitfield-Mask: 0x7)                 */
#define OPAX_CSR_VM_SEL_Pos                       (6UL)                        /*!< VM_SEL (Bit 6)                             */
#define OPAX_CSR_VM_SEL_Msk                       (0x00000040UL)               /*!< VM_SEL (Bitfield-Mask: 0x1)                */
#define OPAX_CSR_OPxPS_Pos                        (5UL)                        /*!< OPxPS (Bit 5)                              */
#define OPAX_CSR_OPxPS_Msk                        (0x00000020UL)               /*!< OPxPS (Bitfield-Mask: 0x1)                 */
#define OPAX_CSR_OPxNS_Pos                        (4UL)                        /*!< OPxNS (Bit 4)                              */
#define OPAX_CSR_OPxNS_Msk                        (0x00000010UL)               /*!< OPxNS (Bitfield-Mask: 0x1)                 */
#define OPAX_CSR_OPxPRS_Pos                       (2UL)                        /*!< OPxPRS (Bit 2)                             */
#define OPAX_CSR_OPxPRS_Msk                       (0x00000004UL)               /*!< OPxPRS (Bitfield-Mask: 0x1)                */
#define OPAX_CSR_OPxNRS_Pos                       (1UL)                        /*!< OPxNRS (Bit 1)                             */
#define OPAX_CSR_OPxNRS_Msk                       (0x00000002UL)               /*!< OPxNRS (Bitfield-Mask: 0x1)                */
#define OPAX_CSR_OPxEN_Pos                        (0UL)                        /*!< OPxEN (Bit 0)   d                          */
#define OPAX_CSR_OPxEN_Msk                        (0x00000001UL)               /*!< OPxEN (Bitfield-Mask: 0x1)                 */

/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */

void OPA_DeInit(void);
void OPA_Init(OPA_TypeDef *OPAx, OPA_InitTypeDef *OPA_InitStruct);
void OPA_StructInit(OPA_InitTypeDef *OPA_InitStruct);
void OPA_Cmd(OPA_TypeDef *OPAx, FunctionalState NewState);
void Opa_trim(OPA_TypeDef *OPAx, uint8_t trim);
uint8_t get_opa_trim(OPA_TypeDef *OPAx);
void OPA_TRIM(OPA_TypeDef *OPAx);
uint32_t get_opa_trim_FLAG(OPA_TypeDef *OPAx);
#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_OPA_H__
