/**
  ******************************************************************************
  * @file    lcm32f06x_iwdg.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for iwdg.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_IWDG_H__
#define __LCM32F06X_IWDG_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

#ifdef __cplusplus
  extern "C" {
#endif

/* @defgroup IWDG_WriteAccess */
#define IWDG_WriteAccess_Enable      ((uint16_t)0x5555) /*@EN: Enable write access to IWDG_PR and IWDG_RLR registers @CN: öIWDG_PRIWDG_RLRĴд */
#define IWDG_WriteAccess_Disable     ((uint16_t)0x0000) /*@EN: Disable write access to IWDG_PR and IWDG_RLR registers @CN: öIWDG_PRIWDG_RLRĴд */
#define IS_IWDG_WRITE_ACCESS(ACCESS) (((ACCESS) == IWDG_WriteAccess_Enable) || \
                                      ((ACCESS) == IWDG_WriteAccess_Disable))
/* @end */

/* @defgroup IWDG_prescaler  */
#define IWDG_Prescaler_4             ((uint8_t)0x0000) /*@EN: IWDG prescaler set to 4 @CN: IWDGԤƵΪ4 */
#define IWDG_Prescaler_8             ((uint8_t)0x0001) /*@EN: IWDG prescaler set to 8 @CN: IWDGԤƵΪ8 */
#define IWDG_Prescaler_16            ((uint8_t)0x0002) /*@EN: IWDG prescaler set to 16 @CN: IWDGԤƵΪ16 */
#define IWDG_Prescaler_32            ((uint8_t)0x0003) /*@EN: IWDG prescaler set to 32 @CN: IWDGԤƵΪ32 */
#define IWDG_Prescaler_64            ((uint8_t)0x0004) /*@EN: IWDG prescaler set to 64 @CN: IWDGԤƵΪ64 */
#define IWDG_Prescaler_128           ((uint8_t)0x0005) /*@EN: IWDG prescaler set to 128 @CN: IWDGԤƵΪ128 */
#define IWDG_Prescaler_256           ((uint8_t)0x0006) /*@EN: IWDG prescaler set to 256 @CN: IWDGԤƵΪ256 */
#define IS_IWDG_PRESCALER(PRESCALER) (((PRESCALER) == IWDG_Prescaler_4) ||   \
                                      ((PRESCALER) == IWDG_Prescaler_8) ||   \
                                      ((PRESCALER) == IWDG_Prescaler_16) ||  \
                                      ((PRESCALER) == IWDG_Prescaler_32) ||  \
                                      ((PRESCALER) == IWDG_Prescaler_64) ||  \
                                      ((PRESCALER) == IWDG_Prescaler_128) || \
                                      ((PRESCALER) == IWDG_Prescaler_256))
/* @end */

/* @defgroup IWDG_FLAG  */
#define IWDG_FLAG_PVU                ((uint8_t)0x0001) /*@EN:Prescaler Value Update on going @CN: ڽԤƵֵ */
#define IWDG_FLAG_RVU                ((uint8_t)0x0002) /*@EN:Reload Value Update on going @CN: ¼ֵ */
#define IWDG_FLAG_WVU                ((uint8_t)0x0004) /*@EN:Counter Window Value Update on going @CN: ֵڽ */
#define IS_IWDG_FLAG(FLAG)           (((FLAG) == IWDG_FLAG_PVU) || \
                                      ((FLAG) == IWDG_FLAG_RVU) || \
                                      ((FLAG) == IWDG_FLAG_WVU))
/* @end */

#define IS_IWDG_RELOAD(RELOAD)       ((RELOAD) <= 0xFFF)

#define IS_IWDG_WINDOW_VALUE(VALUE)  ((VALUE) <= 0xFFF)


/* ========================================================================== */
/* ================            IWDG  REGISTER BIT               ============= */
/* ========================================================================== */

/* =================================  KR  =================================== */
#define IWDG_KR_KEY_Pos                           (0UL)                        /*!< KEY (Bit 0)                          */
#define IWDG_KR_KEY_Msk                           (0xffUL)                     /*!< KEY (Bitfield-Mask: 0xffff)          */
/* =================================  PR  =================================== */
#define IWDG_PR_PR_Pos                            (0UL)                        /*!< PR (Bit 0)                           */
#define IWDG_PR_PR_Msk                            (0x7UL)                      /*!< PR (Bitfield-Mask: 0x07)             */
/* ================================  RLR  =================================== */
#define IWDG_RLR_RL_Pos                           (0UL)                        /*!< RL (Bit 0)                           */
#define IWDG_RLR_RL_Msk                           (0xfffUL)                    /*!< RL (Bitfield-Mask: 0xfff)            */
/* =================================  SR  =================================== */
#define IWDG_SR_WVU_Pos                           (2UL)                        /*!< WVU (Bit 2)                          */
#define IWDG_SR_WVU_Msk                           (0x4UL)                      /*!< WVU (Bitfield-Mask: 0x01)            */
#define IWDG_SR_RVU_Pos                           (1UL)                        /*!< RVU (Bit 1)                          */
#define IWDG_SR_RVU_Msk                           (0x2UL)                      /*!< RVU (Bitfield-Mask: 0x01)            */
#define IWDG_SR_PVU_Pos                           (0UL)                        /*!< PVU (Bit 0)                          */
#define IWDG_SR_PVU_Msk                           (0x1UL)                      /*!< PVU (Bitfield-Mask: 0x01)            */
/* ================================  WINTR  ================================= */
#define IWDG_WINTR_WIN_Pos                        (0UL)                        /*!< WIN (Bit 0)                          */
#define IWDG_WINTR_WIN_Msk                        (0xfffUL)                    /*!< WIN (Bitfield-Mask: 0xfff)           */

/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */

#ifdef __cplusplus
}
#endif

/* Prescaler and Counter configuration functions ******************************/
void IWDG_WriteAccessCmd(uint16_t IWDG_WriteAccess);
void IWDG_SetPrescaler(uint8_t IWDG_Prescaler);
void IWDG_SetReload(uint16_t Reload);
void IWDG_ReloadCounter(void);
void IWDG_SetWindowValue(uint16_t WindowValue);

/* IWDG activation function ***************************************************/
void IWDG_Enable(void);

/* Flag management function ***************************************************/
FlagStatus IWDG_GetFlagStatus(uint16_t IWDG_FLAG);

#endif // __LCM32F06X_IWDG_H__
