/**
  ******************************************************************************
  * @file    lcm32f06x_gpio.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for gpio.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_GPIO_H__
#define __LCM32F06X_GPIO_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"
#include "lcm32f06x_rcc.h"

#ifdef __cplusplus
  extern "C" {
#endif

/* @defgroup GPIO_Mode */
typedef enum
{
  GPIO_Mode_IN  = 0x00, /*!< GPIO Input Mode              */
  GPIO_Mode_OUT = 0x01, /*!< GPIO Output Mode             */
  GPIO_Mode_AF  = 0x02, /*!< GPIO Alternate function Mode */
  GPIO_Mode_AN  = 0x03  /*!< GPIO Analog In/Out Mode      */
} GPIOMode_TypeDef;

#define IS_GPIO_MODE(MODE)            (((MODE) == GPIO_Mode_IN)  || \
                                       ((MODE) == GPIO_Mode_OUT) || \
                                       ((MODE) == GPIO_Mode_AF)  || \
                                       ((MODE) == GPIO_Mode_AN))
/* @end */

/* @defgroup GPIO_Speed */
typedef enum
{
  GPIO_Speed_Level_1 = 0x01, /*!< Slow slope of IO port */
  GPIO_Speed_Level_2 = 0x00  /*!< Fast slope of IO port */
} GPIOSpeed_TypeDef;

#define IS_GPIO_SPEED(SPEED)          (((SPEED) == GPIO_Speed_Level_1) || \
                                       ((SPEED) == GPIO_Speed_Level_2))
/* @end */

/* @defgroup GPIO_OType */
typedef enum
{
  GPIO_OType_PP = 0x00,
  GPIO_OType_OD = 0x01,
  GPIO_OType_OS = 0x02
} GPIOOType_TypeDef;

#define IS_GPIO_OTYPE(OTYPE)          (((OTYPE) == GPIO_OType_PP) || \
                                       ((OTYPE) == GPIO_OType_OD)|| \
                                       ((OTYPE) == GPIO_OType_OS))
/* @end */

/* @defgroup GPIO_PuPd */
typedef enum
{
  GPIO_PuPd_NOPULL = 0x00, /* GPIO no pull mode      */
  GPIO_PuPd_UP     = 0x01, /* GPIO up pull mode      */
  GPIO_PuPd_DOWN   = 0x02, /* GPIO down pull mode    */
  GPIO_PuPd_UPDOWN = 0x03  /* GPIO up/down pull mode */
} GPIOPuPd_TypeDef;

#define IS_GPIO_PUPD(PUPD)            (((PUPD) == GPIO_PuPd_NOPULL) || \
                                       ((PUPD) == GPIO_PuPd_UP)     || \
                                       ((PUPD) == GPIO_PuPd_DOWN)   || \
                                       ((PUPD) == GPIO_PuPd_UPDOWN))
/* @end */

/* @defgroup Bit_SET_and_Bit_RESET */
typedef enum
{
  Bit_RESET = 0,
  Bit_SET   = 1
} BitAction;

#define IS_GPIO_BIT_ACTION(ACTION)    (((ACTION) == Bit_RESET) || \
                                       ((ACTION) == Bit_SET))
/* @end */

/** 
  * @brief GPIO Init structure definition
  */

typedef struct
{
  uint32_t GPIO_Pin;            /*!< EN: Specifies the GPIO pins to be configured.
                                     CN: ָҪõ GPIO                 */

  GPIOMode_TypeDef GPIO_Mode;   /*!< EN: Specifies the operating mode for the selected pins.
                                     CN: ָѡ GPIO ģʽ               
                                     @Register: GPIOx_MODER @Bits:[1:0]MODERx 
                                     @default: GPIO_Mode_IN                   */

  GPIOSpeed_TypeDef GPIO_Speed; /*!< EN: Specify the slope of the selected GPIO port.
                                     CN: ָѡ GPIO ˿ڵб               
                                     @Register: GPIOx_CS_BSRR @Bits:[15:0]CSy BSy 
                                     @default: GPIO_Speed_Level_2             */

  GPIOOType_TypeDef GPIO_OType; /*!< EN: Specifies the operating output type for the selected pins.
                                     CN: ָѡ GPIO                
                                     @Register: GPIOx_OD_BSRR @Bits:[15:0]ODy BSy BRy
                                                GPIOx_OS_BSRR @Bits:[15:0]OSy BSy BRy
                                     @default: GPIO_OType_PP                  */

  GPIOPuPd_TypeDef GPIO_PuPd;   /*!< EN: Specifies the operating Pull-up/Pull down for the selected pins.
                                     CN: ָѡ GPIO               
                                     @Register: GPIOx_PU_BSRR @Bits:[15:0]PUy BSy BRy
                                                GPIOx_PD_BSRR @Bits:[15:0]PDy BSy BRy
                                     @default: GPIO_PuPd_NOPULL                 */
} GPIO_InitTypeDef;

/* @defgroup GPIOx */
#define IS_GPIO_ALL_PERIPH(PERIPH)    (((PERIPH) == GPIOA) || \
                                    ((PERIPH) == GPIOB))
/* @end */

/* @defgroup GPIO_Pin */
#define GPIO_Pin_0                    ((uint32_t)0x0001) /* @EN: Pin 0  selected @CN: ѡ Pin0   */
#define GPIO_Pin_1                    ((uint32_t)0x0002) /* @EN: Pin 1  selected @CN: ѡ Pin1   */
#define GPIO_Pin_2                    ((uint32_t)0x0004) /* @EN: Pin 2  selected @CN: ѡ Pin2   */
#define GPIO_Pin_3                    ((uint32_t)0x0008) /* @EN: Pin 3  selected @CN: ѡ Pin3   */
#define GPIO_Pin_4                    ((uint32_t)0x0010) /* @EN: Pin 4  selected @CN: ѡ Pin4   */
#define GPIO_Pin_5                    ((uint32_t)0x0020) /* @EN: Pin 5  selected @CN: ѡ Pin5   */
#define GPIO_Pin_6                    ((uint32_t)0x0040) /* @EN: Pin 6  selected @CN: ѡ Pin6   */
#define GPIO_Pin_7                    ((uint32_t)0x0080) /* @EN: Pin 7  selected @CN: ѡ Pin7   */
#define GPIO_Pin_8                    ((uint32_t)0x0100) /* @EN: Pin 8  selected @CN: ѡ Pin8   */
#define GPIO_Pin_9                    ((uint32_t)0x0200) /* @EN: Pin 9  selected @CN: ѡ Pin9   */
#define GPIO_Pin_10                   ((uint32_t)0x0400) /* @EN: Pin 10 selected @CN: ѡ Pin10  */
#define GPIO_Pin_11                   ((uint32_t)0x0800) /* @EN: Pin 11 selected @CN: ѡ Pin11  */
#define GPIO_Pin_12                   ((uint32_t)0x1000) /* @EN: Pin 12 selected @CN: ѡ Pin12  */
#define GPIO_Pin_13                   ((uint32_t)0x2000) /* @EN: Pin 13 selected @CN: ѡ Pin13  */
#define GPIO_Pin_14                   ((uint32_t)0x4000) /* @EN: Pin 14 selected @CN: ѡ Pin14  */
#define GPIO_Pin_15                   ((uint32_t)0x8000) /* @EN: Pin 15 selected @CN: ѡ Pin15  */
#define GPIO_Pin_All                  ((uint32_t)0xFFFF) /* @EN: All pins selected @CN: ѡ   */ 
#define IS_GPIO_PIN(PIN)              ((PIN) != (uint16_t)0x00)
#define IS_GET_GPIO_PIN(PIN)          (((PIN) == GPIO_Pin_0)  || \
                                       ((PIN) == GPIO_Pin_1)  || \
                                       ((PIN) == GPIO_Pin_2)  || \
                                       ((PIN) == GPIO_Pin_3)  || \
                                       ((PIN) == GPIO_Pin_4)  || \
                                       ((PIN) == GPIO_Pin_5)  || \
                                       ((PIN) == GPIO_Pin_6)  || \
                                       ((PIN) == GPIO_Pin_7)  || \
                                       ((PIN) == GPIO_Pin_8)  || \
                                       ((PIN) == GPIO_Pin_9)  || \
                                       ((PIN) == GPIO_Pin_10) || \
                                       ((PIN) == GPIO_Pin_11) || \
                                       ((PIN) == GPIO_Pin_12) || \
                                       ((PIN) == GPIO_Pin_13) || \
                                       ((PIN) == GPIO_Pin_14) || \
                                       ((PIN) == GPIO_Pin_15))
/* @end */

/* @defgroup GPIO_PinSource */
#define GPIO_PinSource0               ((uint8_t)0x00) /* @EN: Pin 0  alternate @CN:  Pin0   */
#define GPIO_PinSource1               ((uint8_t)0x01) /* @EN: Pin 1  alternate @CN:  Pin1   */
#define GPIO_PinSource2               ((uint8_t)0x02) /* @EN: Pin 2  alternate @CN:  Pin2   */
#define GPIO_PinSource3               ((uint8_t)0x03) /* @EN: Pin 3  alternate @CN:  Pin3   */
#define GPIO_PinSource4               ((uint8_t)0x04) /* @EN: Pin 4  alternate @CN:  Pin4   */
#define GPIO_PinSource5               ((uint8_t)0x05) /* @EN: Pin 5  alternate @CN:  Pin5   */
#define GPIO_PinSource6               ((uint8_t)0x06) /* @EN: Pin 6  alternate @CN:  Pin6   */
#define GPIO_PinSource7               ((uint8_t)0x07) /* @EN: Pin 7  alternate @CN:  Pin7   */
#define GPIO_PinSource8               ((uint8_t)0x08) /* @EN: Pin 8  alternate @CN:  Pin8   */
#define GPIO_PinSource9               ((uint8_t)0x09) /* @EN: Pin 9  alternate @CN:  Pin9   */
#define GPIO_PinSource10              ((uint8_t)0x0A) /* @EN: Pin 10 alternate @CN:  Pin10  */
#define GPIO_PinSource11              ((uint8_t)0x0B) /* @EN: Pin 11 alternate @CN:  Pin11  */
#define GPIO_PinSource12              ((uint8_t)0x0C) /* @EN: Pin 12 alternate @CN:  Pin12  */
#define GPIO_PinSource13              ((uint8_t)0x0D) /* @EN: Pin 13 alternate @CN:  Pin13  */
#define GPIO_PinSource14              ((uint8_t)0x0E) /* @EN: Pin 14 alternate @CN:  Pin14  */
#define GPIO_PinSource15              ((uint8_t)0x0F) /* @EN: Pin 15 alternate @CN:  Pin15  */
#define IS_GPIO_PIN_SOURCE(PINSOURCE) (((PINSOURCE) == GPIO_PinSource0)  || \
                                       ((PINSOURCE) == GPIO_PinSource1)  || \
                                       ((PINSOURCE) == GPIO_PinSource2)  || \
                                       ((PINSOURCE) == GPIO_PinSource3)  || \
                                       ((PINSOURCE) == GPIO_PinSource4)  || \
                                       ((PINSOURCE) == GPIO_PinSource5)  || \
                                       ((PINSOURCE) == GPIO_PinSource6)  || \
                                       ((PINSOURCE) == GPIO_PinSource7)  || \
                                       ((PINSOURCE) == GPIO_PinSource8)  || \
                                       ((PINSOURCE) == GPIO_PinSource9)  || \
                                       ((PINSOURCE) == GPIO_PinSource10) || \
                                       ((PINSOURCE) == GPIO_PinSource11) || \
                                       ((PINSOURCE) == GPIO_PinSource12) || \
                                       ((PINSOURCE) == GPIO_PinSource13) || \
                                       ((PINSOURCE) == GPIO_PinSource14) || \
                                       ((PINSOURCE) == GPIO_PinSource15))
/* @end */

/* @defgroup GPIO_AF */
#define GPIO_AF_0                     ((uint8_t)0x00) /* @EN: alternate function AF0  @CN:  AF0  */
#define GPIO_AF_1                     ((uint8_t)0x01) /* @EN: alternate function AF1  @CN:  AF1  */
#define GPIO_AF_2                     ((uint8_t)0x02) /* @EN: alternate function AF2  @CN:  AF2  */
#define GPIO_AF_3                     ((uint8_t)0x03) /* @EN: alternate function AF3  @CN:  AF3  */
#define GPIO_AF_4                     ((uint8_t)0x04) /* @EN: alternate function AF4  @CN:  AF4  */
#define GPIO_AF_5                     ((uint8_t)0x05) /* @EN: alternate function AF5  @CN:  AF5  */
#define GPIO_AF_6                     ((uint8_t)0x06) /* @EN: alternate function AF6  @CN:  AF6  */
#define GPIO_AF_7                     ((uint8_t)0x07) /* @EN: alternate function AF7  @CN:  AF7  */
#define IS_GPIO_AF(AF)                (((AF) == GPIO_AF_0) || ((AF) == GPIO_AF_1) || \
                                       ((AF) == GPIO_AF_2) || ((AF) == GPIO_AF_3) || \
                                       ((AF) == GPIO_AF_4) || ((AF) == GPIO_AF_5) || \
                                       ((AF) == GPIO_AF_6) || ((AF) == GPIO_AF_7))
/* @end */

/* @defgroup GPIO_AF */
#define GPIO_AN_ENABLE                ((uint8_t)0x01) /* @EN: Enable alternate function  @CN: øù */
#define GPIO_AN_DISABLE               ((uint8_t)0x00) /* @EN: Disable alternate function  @CN: øù */
#define IS_GPIO_AN(AN)                (((AN) == GPIO_AN_ENABLE) || \
                                       ((AN) == GPIO_AN_DISABLE))
/* @end */

/* @defgroup GPIO_Drive */
#define GPIO_Drive_Level_strong       ((uint32_t)0x000000000) /* @EN: strong Drive Mode  @CN: ģʽ */
#define GPIO_Drive_Level_weak         ((uint32_t)0x000000001) /* @EN: weak Drive Mode  @CN: ģʽ */
#define IS_GPIO_LEVEL(GPIO_Drive)     (((GPIO_Drive) == GPIO_Drive_Level_weak) || \
                                       ((GPIO_Drive) == GPIO_Drive_Level_strong))
/* @end */

/* ========================================================================== */
/* ================             GPIO REGISTER BIT               ============= */
/* ========================================================================== */

/* ==============================  MODER  ==================================  */
#define GPIOF_MODER_MODER15_Pos                   (30UL)                       /*!< MODER15 (Bit 30)               */
#define GPIOF_MODER_MODER15_Msk                   (0xC0000000UL)               /*!< MODER15 (Bitfield-Mask: 0x03)  */
#define GPIOF_MODER_MODER14_Pos                   (28UL)                       /*!< MODER14 (Bit 28)               */
#define GPIOF_MODER_MODER14_Msk                   (0x30000000UL)               /*!< MODER14 (Bitfield-Mask: 0x03)  */
#define GPIOF_MODER_MODER13_Pos                   (26UL)                       /*!< MODER13 (Bit 26)               */
#define GPIOF_MODER_MODER13_Msk                   (0x0C000000UL)               /*!< MODER13 (Bitfield-Mask: 0x03)  */
#define GPIOF_MODER_MODER12_Pos                   (24UL)                       /*!< MODER12 (Bit 24)               */
#define GPIOF_MODER_MODER12_Msk                   (0x03000000UL)               /*!< MODER12 (Bitfield-Mask: 0x03)  */
#define GPIOF_MODER_MODER11_Pos                   (22UL)                       /*!< MODER11 (Bit 22)               */
#define GPIOF_MODER_MODER11_Msk                   (0x00C00000UL)               /*!< MODER11 (Bitfield-Mask: 0x03)  */
#define GPIOF_MODER_MODER10_Pos                   (20UL)                       /*!< MODER10 (Bit 20)               */
#define GPIOF_MODER_MODER10_Msk                   (0x00300000UL)               /*!< MODER10 (Bitfield-Mask: 0x03)  */
#define GPIOF_MODER_MODER9_Pos                    (18UL)                       /*!< MODER9 (Bit 18)                */
#define GPIOF_MODER_MODER9_Msk                    (0x000C0000UL)               /*!< MODER9 (Bitfield-Mask: 0x03)   */
#define GPIOF_MODER_MODER8_Pos                    (16UL)                       /*!< MODER8 (Bit 16)                */
#define GPIOF_MODER_MODER8_Msk                    (0x00030000UL)               /*!< MODER8 (Bitfield-Mask: 0x03)   */
#define GPIOF_MODER_MODER7_Pos                    (14UL)                       /*!< MODER7 (Bit 14)                */
#define GPIOF_MODER_MODER7_Msk                    (0x0000C000UL)               /*!< MODER7 (Bitfield-Mask: 0x03)   */
#define GPIOF_MODER_MODER6_Pos                    (12UL)                       /*!< MODER6 (Bit 12)                */
#define GPIOF_MODER_MODER6_Msk                    (0x00003000UL)               /*!< MODER6 (Bitfield-Mask: 0x03)   */
#define GPIOF_MODER_MODER5_Pos                    (10UL)                       /*!< MODER5 (Bit 10)                */
#define GPIOF_MODER_MODER5_Msk                    (0x00000C00UL)               /*!< MODER5 (Bitfield-Mask: 0x03)   */
#define GPIOF_MODER_MODER4_Pos                    (8UL)                        /*!< MODER4 (Bit 8)                 */
#define GPIOF_MODER_MODER4_Msk                    (0x00000300UL)               /*!< MODER4 (Bitfield-Mask: 0x03)   */
#define GPIOF_MODER_MODER3_Pos                    (6UL)                        /*!< MODER3 (Bit 6)                 */
#define GPIOF_MODER_MODER3_Msk                    (0x000000C0UL)               /*!< MODER3 (Bitfield-Mask: 0x03)   */
#define GPIOF_MODER_MODER2_Pos                    (4UL)                        /*!< MODER2 (Bit 4)                 */
#define GPIOF_MODER_MODER2_Msk                    (0x00000030UL)               /*!< MODER2 (Bitfield-Mask: 0x03)   */
#define GPIOF_MODER_MODER1_Pos                    (2UL)                        /*!< MODER1 (Bit 2)                 */
#define GPIOF_MODER_MODER1_Msk                    (0x0000000CUL)               /*!< MODER1 (Bitfield-Mask: 0x03)   */
#define GPIOF_MODER_MODER0_Pos                    (0UL)                        /*!< MODER0 (Bit 0)                 */
#define GPIOF_MODER_MODER0_Msk                    (0x00000003UL)               /*!< MODER0 (Bitfield-Mask: 0x03)   */
/* =================================  OD  =================================== */
#define GPIOF_OD_OD15_Pos                         (15UL)                       /*!< OD15 (Bit 15)                  */
#define GPIOF_OD_OD15_Msk                         (0x00008000UL)               /*!< OD15 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_OD14_Pos                         (14UL)                       /*!< OD14 (Bit 14)                  */
#define GPIOF_OD_OD14_Msk                         (0x00004000UL)               /*!< OD14 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_OD13_Pos                         (13UL)                       /*!< OD13 (Bit 13)                  */
#define GPIOF_OD_OD13_Msk                         (0x00002000UL)               /*!< OD13 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_OD12_Pos                         (12UL)                       /*!< OD12 (Bit 12)                  */
#define GPIOF_OD_OD12_Msk                         (0x00001000UL)               /*!< OD12 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_OD11_Pos                         (11UL)                       /*!< OD11 (Bit 11)                  */
#define GPIOF_OD_OD11_Msk                         (0x00000800UL)               /*!< OD11 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_OD10_Pos                         (10UL)                       /*!< OD10 (Bit 10)                  */
#define GPIOF_OD_OD10_Msk                         (0x00000400UL)               /*!< OD10 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_OD9_Pos                          (9UL)                        /*!< OD9 (Bit 9)                    */
#define GPIOF_OD_OD9_Msk                          (0x00000200UL)               /*!< OD9 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_OD8_Pos                          (8UL)                        /*!< OD8 (Bit 8)                    */
#define GPIOF_OD_OD8_Msk                          (0x00000100UL)               /*!< OD8 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_OD7_Pos                          (7UL)                        /*!< OD7 (Bit 7)                    */
#define GPIOF_OD_OD7_Msk                          (0x00000080UL)               /*!< OD7 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_OD6_Pos                          (6UL)                        /*!< OD6 (Bit 6)                    */
#define GPIOF_OD_OD6_Msk                          (0x00000040UL)               /*!< OD6 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_OD5_Pos                          (5UL)                        /*!< OD5 (Bit 5)                    */
#define GPIOF_OD_OD5_Msk                          (0x00000020UL)               /*!< OD5 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_OD4_Pos                          (4UL)                        /*!< OD4 (Bit 4)                    */
#define GPIOF_OD_OD4_Msk                          (0x00000010UL)               /*!< OD4 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_OD3_Pos                          (3UL)                        /*!< OD3 (Bit 3)                    */
#define GPIOF_OD_OD3_Msk                          (0x00000008UL)               /*!< OD3 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_OD2_Pos                          (2UL)                        /*!< OD2 (Bit 2)                    */
#define GPIOF_OD_OD2_Msk                          (0x00000004UL)               /*!< OD2 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_OD1_Pos                          (1UL)                        /*!< OD1 (Bit 1)                    */
#define GPIOF_OD_OD1_Msk                          (0x00000002UL)               /*!< OD1 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_OD0_Pos                          (0UL)                        /*!< OD0 (Bit 0)                    */
#define GPIOF_OD_OD0_Msk                          (0x00000001UL)               /*!< OD0 (Bitfield-Mask: 0x01)      */
/* ===============================  OD_BSRR  ================================ */
#define GPIOF_OD_BSRR_BR15_Pos                    (31UL)                       /*!< BR15 (Bit 31)                  */
#define GPIOF_OD_BSRR_BR15_Msk                    (0x80000000UL)               /*!< BR15 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BR14_Pos                    (30UL)                       /*!< BR14 (Bit 30)                  */
#define GPIOF_OD_BSRR_BR14_Msk                    (0x40000000UL)               /*!< BR14 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BR13_Pos                    (29UL)                       /*!< BR13 (Bit 29)                  */
#define GPIOF_OD_BSRR_BR13_Msk                    (0x20000000UL)               /*!< BR13 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BR12_Pos                    (28UL)                       /*!< BR12 (Bit 28)                  */
#define GPIOF_OD_BSRR_BR12_Msk                    (0x10000000UL)               /*!< BR12 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BR11_Pos                    (27UL)                       /*!< BR11 (Bit 27)                  */
#define GPIOF_OD_BSRR_BR11_Msk                    (0x08000000UL)               /*!< BR11 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BR10_Pos                    (26UL)                       /*!< BR10 (Bit 26)                  */
#define GPIOF_OD_BSRR_BR10_Msk                    (0x04000000UL)               /*!< BR10 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BR9_Pos                     (25UL)                       /*!< BR9 (Bit 25)                   */
#define GPIOF_OD_BSRR_BR9_Msk                     (0x02000000UL)               /*!< BR9 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BR8_Pos                     (24UL)                       /*!< BR8 (Bit 24)                   */
#define GPIOF_OD_BSRR_BR8_Msk                     (0x01000000UL)               /*!< BR8 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BR7_Pos                     (23UL)                       /*!< BR7 (Bit 23)                   */
#define GPIOF_OD_BSRR_BR7_Msk                     (0x00800000UL)               /*!< BR7 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BR6_Pos                     (22UL)                       /*!< BR6 (Bit 22)                   */
#define GPIOF_OD_BSRR_BR6_Msk                     (0x00400000UL)               /*!< BR6 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BR5_Pos                     (21UL)                       /*!< BR5 (Bit 21)                   */
#define GPIOF_OD_BSRR_BR5_Msk                     (0x00200000UL)               /*!< BR5 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BR4_Pos                     (20UL)                       /*!< BR4 (Bit 20)                   */
#define GPIOF_OD_BSRR_BR4_Msk                     (0x00100000UL)               /*!< BR4 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BR3_Pos                     (19UL)                       /*!< BR3 (Bit 19)                   */
#define GPIOF_OD_BSRR_BR3_Msk                     (0x00080000UL)               /*!< BR3 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BR2_Pos                     (18UL)                       /*!< BR2 (Bit 18)                   */
#define GPIOF_OD_BSRR_BR2_Msk                     (0x00040000UL)               /*!< BR2 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BR1_Pos                     (17UL)                       /*!< BR1 (Bit 17)                   */
#define GPIOF_OD_BSRR_BR1_Msk                     (0x00020000UL)               /*!< BR1 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BR0_Pos                     (16UL)                       /*!< BR0 (Bit 16)                   */
#define GPIOF_OD_BSRR_BR0_Msk                     (0x00010000UL)               /*!< BR0 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BS15_Pos                    (15UL)                       /*!< BS15 (Bit 15)                  */
#define GPIOF_OD_BSRR_BS15_Msk                    (0x00008000UL)               /*!< BS15 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BS14_Pos                    (14UL)                       /*!< BS14 (Bit 14)                  */
#define GPIOF_OD_BSRR_BS14_Msk                    (0x00004000UL)               /*!< BS14 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BS13_Pos                    (13UL)                       /*!< BS13 (Bit 13)                  */
#define GPIOF_OD_BSRR_BS13_Msk                    (0x00002000UL)               /*!< BS13 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BS12_Pos                    (12UL)                       /*!< BS12 (Bit 12)                  */
#define GPIOF_OD_BSRR_BS12_Msk                    (0x00001000UL)               /*!< BS12 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BS11_Pos                    (11UL)                       /*!< BS11 (Bit 11)                  */
#define GPIOF_OD_BSRR_BS11_Msk                    (0x00000800UL)               /*!< BS11 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BS10_Pos                    (10UL)                       /*!< BS10 (Bit 10)                  */
#define GPIOF_OD_BSRR_BS10_Msk                    (0x00000400UL)               /*!< BS10 (Bitfield-Mask: 0x01)     */
#define GPIOF_OD_BSRR_BS9_Pos                     (9UL)                        /*!< BS9 (Bit 9)                    */
#define GPIOF_OD_BSRR_BS9_Msk                     (0x00000200UL)               /*!< BS9 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BS8_Pos                     (8UL)                        /*!< BS8 (Bit 8)                    */
#define GPIOF_OD_BSRR_BS8_Msk                     (0x00000100UL)               /*!< BS8 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BS7_Pos                     (7UL)                        /*!< BS7 (Bit 7)                    */
#define GPIOF_OD_BSRR_BS7_Msk                     (0x00000080UL)               /*!< BS7 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BS6_Pos                     (6UL)                        /*!< BS6 (Bit 6)                    */
#define GPIOF_OD_BSRR_BS6_Msk                     (0x00000040UL)               /*!< BS6 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BS5_Pos                     (5UL)                        /*!< BS5 (Bit 5)                    */
#define GPIOF_OD_BSRR_BS5_Msk                     (0x00000020UL)               /*!< BS5 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BS4_Pos                     (4UL)                        /*!< BS4 (Bit 4)                    */
#define GPIOF_OD_BSRR_BS4_Msk                     (0x00000010UL)               /*!< BS4 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BS3_Pos                     (3UL)                        /*!< BS3 (Bit 3)                    */
#define GPIOF_OD_BSRR_BS3_Msk                     (0x00000008UL)               /*!< BS3 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BS2_Pos                     (2UL)                        /*!< BS2 (Bit 2)                    */
#define GPIOF_OD_BSRR_BS2_Msk                     (0x00000004UL)               /*!< BS2 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BS1_Pos                     (1UL)                        /*!< BS1 (Bit 1)                    */
#define GPIOF_OD_BSRR_BS1_Msk                     (0x00000002UL)               /*!< BS1 (Bitfield-Mask: 0x01)      */
#define GPIOF_OD_BSRR_BS0_Pos                     (0UL)                        /*!< BS0 (Bit 0)                    */
#define GPIOF_OD_BSRR_BS0_Msk                     (0x00000001UL)               /*!< BS0 (Bitfield-Mask: 0x01)      */
/* ==================================  SR  ================================== */
#define GPIOF_SR_SR15_Pos                         (15UL)                       /*!< SR15 (Bit 15)                  */
#define GPIOF_SR_SR15_Msk                         (0x00008000UL)               /*!< SR15 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_SR14_Pos                         (14UL)                       /*!< SR14 (Bit 14)                  */
#define GPIOF_SR_SR14_Msk                         (0x00004000UL)               /*!< SR14 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_SR13_Pos                         (13UL)                       /*!< SR13 (Bit 13)                  */
#define GPIOF_SR_SR13_Msk                         (0x00002000UL)               /*!< SR13 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_SR12_Pos                         (12UL)                       /*!< SR12 (Bit 12)                  */
#define GPIOF_SR_SR12_Msk                         (0x00001000UL)               /*!< SR12 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_SR11_Pos                         (11UL)                       /*!< SR11 (Bit 11)                  */
#define GPIOF_SR_SR11_Msk                         (0x00000800UL)               /*!< SR11 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_SR10_Pos                         (10UL)                       /*!< SR10 (Bit 10)                  */
#define GPIOF_SR_SR10_Msk                         (0x00000400UL)               /*!< SR10 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_SR9_Pos                          (9UL)                        /*!< SR9 (Bit 9)                    */
#define GPIOF_SR_SR9_Msk                          (0x00000200UL)               /*!< SR9 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_SR8_Pos                          (8UL)                        /*!< SR8 (Bit 8)                    */
#define GPIOF_SR_SR8_Msk                          (0x00000100UL)               /*!< SR8 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_SR7_Pos                          (7UL)                        /*!< SR7 (Bit 7)                    */
#define GPIOF_SR_SR7_Msk                          (0x00000080UL)               /*!< SR7 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_SR6_Pos                          (6UL)                        /*!< SR6 (Bit 6)                    */
#define GPIOF_SR_SR6_Msk                          (0x00000040UL)               /*!< SR6 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_SR5_Pos                          (5UL)                        /*!< SR5 (Bit 5)                    */
#define GPIOF_SR_SR5_Msk                          (0x00000020UL)               /*!< SR5 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_SR4_Pos                          (4UL)                        /*!< SR4 (Bit 4)                    */
#define GPIOF_SR_SR4_Msk                          (0x00000010UL)               /*!< SR4 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_SR3_Pos                          (3UL)                        /*!< SR3 (Bit 3)                    */
#define GPIOF_SR_SR3_Msk                          (0x00000008UL)               /*!< SR3 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_SR2_Pos                          (2UL)                        /*!< SR2 (Bit 2)                    */
#define GPIOF_SR_SR2_Msk                          (0x00000004UL)               /*!< SR2 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_SR1_Pos                          (1UL)                        /*!< SR1 (Bit 1)                    */
#define GPIOF_SR_SR1_Msk                          (0x00000002UL)               /*!< SR1 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_SR0_Pos                          (0UL)                        /*!< SR0 (Bit 0)                    */
#define GPIOF_SR_SR0_Msk                          (0x00000001UL)               /*!< SR0 (Bitfield-Mask: 0x01)      */
/* ==============================  SR_BSRR  ==================================*/
#define GPIOF_SR_BSRR_BR15_Pos                    (31UL)                       /*!< BR15 (Bit 31)                  */
#define GPIOF_SR_BSRR_BR15_Msk                    (0x80000000UL)               /*!< BR15 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BR14_Pos                    (30UL)                       /*!< BR14 (Bit 30)                  */
#define GPIOF_SR_BSRR_BR14_Msk                    (0x40000000UL)               /*!< BR14 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BR13_Pos                    (29UL)                       /*!< BR13 (Bit 29)                  */
#define GPIOF_SR_BSRR_BR13_Msk                    (0x20000000UL)               /*!< BR13 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BR12_Pos                    (28UL)                       /*!< BR12 (Bit 28)                  */
#define GPIOF_SR_BSRR_BR12_Msk                    (0x10000000UL)               /*!< BR12 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BR11_Pos                    (27UL)                       /*!< BR11 (Bit 27)                  */
#define GPIOF_SR_BSRR_BR11_Msk                    (0x08000000UL)               /*!< BR11 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BR10_Pos                    (26UL)                       /*!< BR10 (Bit 26)                  */
#define GPIOF_SR_BSRR_BR10_Msk                    (0x04000000UL)               /*!< BR10 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BR9_Pos                     (25UL)                       /*!< BR9 (Bit 25)                   */
#define GPIOF_SR_BSRR_BR9_Msk                     (0x02000000UL)               /*!< BR9 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BR8_Pos                     (24UL)                       /*!< BR8 (Bit 24)                   */
#define GPIOF_SR_BSRR_BR8_Msk                     (0x01000000UL)               /*!< BR8 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BR7_Pos                     (23UL)                       /*!< BR7 (Bit 23)                   */
#define GPIOF_SR_BSRR_BR7_Msk                     (0x00800000UL)               /*!< BR7 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BR6_Pos                     (22UL)                       /*!< BR6 (Bit 22)                   */
#define GPIOF_SR_BSRR_BR6_Msk                     (0x00400000UL)               /*!< BR6 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BR5_Pos                     (21UL)                       /*!< BR5 (Bit 21)                   */
#define GPIOF_SR_BSRR_BR5_Msk                     (0x00200000UL)               /*!< BR5 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BR4_Pos                     (20UL)                       /*!< BR4 (Bit 20)                   */
#define GPIOF_SR_BSRR_BR4_Msk                     (0x00100000UL)               /*!< BR4 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BR3_Pos                     (19UL)                       /*!< BR3 (Bit 19)                   */
#define GPIOF_SR_BSRR_BR3_Msk                     (0x00080000UL)               /*!< BR3 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BR2_Pos                     (18UL)                       /*!< BR2 (Bit 18)                   */
#define GPIOF_SR_BSRR_BR2_Msk                     (0x00040000UL)               /*!< BR2 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BR1_Pos                     (17UL)                       /*!< BR1 (Bit 17)                   */
#define GPIOF_SR_BSRR_BR1_Msk                     (0x00020000UL)               /*!< BR1 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BR0_Pos                     (16UL)                       /*!< BR0 (Bit 16)                   */
#define GPIOF_SR_BSRR_BR0_Msk                     (0x00010000UL)               /*!< BR0 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BS15_Pos                    (15UL)                       /*!< BS15 (Bit 15)                  */
#define GPIOF_SR_BSRR_BS15_Msk                    (0x00008000UL)               /*!< BS15 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BS14_Pos                    (14UL)                       /*!< BS14 (Bit 14)                  */
#define GPIOF_SR_BSRR_BS14_Msk                    (0x00004000UL)               /*!< BS14 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BS13_Pos                    (13UL)                       /*!< BS13 (Bit 13)                  */
#define GPIOF_SR_BSRR_BS13_Msk                    (0x00002000UL)               /*!< BS13 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BS12_Pos                    (12UL)                       /*!< BS12 (Bit 12)                  */
#define GPIOF_SR_BSRR_BS12_Msk                    (0x00001000UL)               /*!< BS12 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BS11_Pos                    (11UL)                       /*!< BS11 (Bit 11)                  */
#define GPIOF_SR_BSRR_BS11_Msk                    (0x00000800UL)               /*!< BS11 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BS10_Pos                    (10UL)                       /*!< BS10 (Bit 10)                  */
#define GPIOF_SR_BSRR_BS10_Msk                    (0x00000400UL)               /*!< BS10 (Bitfield-Mask: 0x01)     */
#define GPIOF_SR_BSRR_BS9_Pos                     (9UL)                        /*!< BS9 (Bit 9)                    */
#define GPIOF_SR_BSRR_BS9_Msk                     (0x00000200UL)               /*!< BS9 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BS8_Pos                     (8UL)                        /*!< BS8 (Bit 8)                    */
#define GPIOF_SR_BSRR_BS8_Msk                     (0x00000100UL)               /*!< BS8 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BS7_Pos                     (7UL)                        /*!< BS7 (Bit 7)                    */
#define GPIOF_SR_BSRR_BS7_Msk                     (0x00000080UL)               /*!< BS7 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BS6_Pos                     (6UL)                        /*!< BS6 (Bit 6)                    */
#define GPIOF_SR_BSRR_BS6_Msk                     (0x00000040UL)               /*!< BS6 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BS5_Pos                     (5UL)                        /*!< BS5 (Bit 5)                    */
#define GPIOF_SR_BSRR_BS5_Msk                     (0x00000020UL)               /*!< BS5 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BS4_Pos                     (4UL)                        /*!< BS4 (Bit 4)                    */
#define GPIOF_SR_BSRR_BS4_Msk                     (0x00000010UL)               /*!< BS4 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BS3_Pos                     (3UL)                        /*!< BS3 (Bit 3)                    */
#define GPIOF_SR_BSRR_BS3_Msk                     (0x00000008UL)               /*!< BS3 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BS2_Pos                     (2UL)                        /*!< BS2 (Bit 2)                    */
#define GPIOF_SR_BSRR_BS2_Msk                     (0x00000004UL)               /*!< BS2 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BS1_Pos                     (1UL)                        /*!< BS1 (Bit 1)                    */
#define GPIOF_SR_BSRR_BS1_Msk                     (0x00000002UL)               /*!< BS1 (Bitfield-Mask: 0x01)      */
#define GPIOF_SR_BSRR_BS0_Pos                     (0UL)                        /*!< BS0 (Bit 0)                    */
#define GPIOF_SR_BSRR_BS0_Msk                     (0x00000001UL)               /*!< BS0 (Bitfield-Mask: 0x01)      */
/* =================================  PU  =================================== */
#define GPIOF_PU_PU15_Pos                         (15UL)                       /*!< PU15 (Bit 15)                  */
#define GPIOF_PU_PU15_Msk                         (0x00008000UL)               /*!< PU15 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_PU14_Pos                         (14UL)                       /*!< PU14 (Bit 14)                  */
#define GPIOF_PU_PU14_Msk                         (0x00004000UL)               /*!< PU14 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_PU13_Pos                         (13UL)                       /*!< PU13 (Bit 13)                  */
#define GPIOF_PU_PU13_Msk                         (0x00002000UL)               /*!< PU13 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_PU12_Pos                         (12UL)                       /*!< PU12 (Bit 12)                  */
#define GPIOF_PU_PU12_Msk                         (0x00001000UL)               /*!< PU12 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_PU11_Pos                         (11UL)                       /*!< PU11 (Bit 11)                  */
#define GPIOF_PU_PU11_Msk                         (0x00000800UL)               /*!< PU11 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_PU10_Pos                         (10UL)                       /*!< PU10 (Bit 10)                  */
#define GPIOF_PU_PU10_Msk                         (0x00000400UL)               /*!< PU10 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_PU9_Pos                          (9UL)                        /*!< PU9 (Bit 9)                    */
#define GPIOF_PU_PU9_Msk                          (0x00000200UL)               /*!< PU9 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_PU8_Pos                          (8UL)                        /*!< PU8 (Bit 8)                    */
#define GPIOF_PU_PU8_Msk                          (0x00000100UL)               /*!< PU8 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_PU7_Pos                          (7UL)                        /*!< PU7 (Bit 7)                    */
#define GPIOF_PU_PU7_Msk                          (0x00000080UL)               /*!< PU7 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_PU6_Pos                          (6UL)                        /*!< PU6 (Bit 6)                    */
#define GPIOF_PU_PU6_Msk                          (0x00000040UL)               /*!< PU6 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_PU5_Pos                          (5UL)                        /*!< PU5 (Bit 5)                    */
#define GPIOF_PU_PU5_Msk                          (0x00000020UL)               /*!< PU5 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_PU4_Pos                          (4UL)                        /*!< PU4 (Bit 4)                    */
#define GPIOF_PU_PU4_Msk                          (0x00000010UL)               /*!< PU4 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_PU3_Pos                          (3UL)                        /*!< PU3 (Bit 3)                    */
#define GPIOF_PU_PU3_Msk                          (0x00000008UL)               /*!< PU3 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_PU2_Pos                          (2UL)                        /*!< PU2 (Bit 2)                    */
#define GPIOF_PU_PU2_Msk                          (0x00000004UL)               /*!< PU2 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_PU1_Pos                          (1UL)                        /*!< PU1 (Bit 1)                    */
#define GPIOF_PU_PU1_Msk                          (0x00000002UL)               /*!< PU1 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_PU0_Pos                          (0UL)                        /*!< PU0 (Bit 0)                    */
#define GPIOF_PU_PU0_Msk                          (0x00000001UL)               /*!< PU0 (Bitfield-Mask: 0x01)      */
/* ===============================  PU_BSRR  ================================ */
#define GPIOF_PU_BSRR_BR15_Pos                    (31UL)                       /*!< BR15 (Bit 31)                  */
#define GPIOF_PU_BSRR_BR15_Msk                    (0x80000000UL)               /*!< BR15 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BR14_Pos                    (30UL)                       /*!< BR14 (Bit 30)                  */
#define GPIOF_PU_BSRR_BR14_Msk                    (0x40000000UL)               /*!< BR14 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BR13_Pos                    (29UL)                       /*!< BR13 (Bit 29)                  */
#define GPIOF_PU_BSRR_BR13_Msk                    (0x20000000UL)               /*!< BR13 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BR12_Pos                    (28UL)                       /*!< BR12 (Bit 28)                  */
#define GPIOF_PU_BSRR_BR12_Msk                    (0x10000000UL)               /*!< BR12 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BR11_Pos                    (27UL)                       /*!< BR11 (Bit 27)                  */
#define GPIOF_PU_BSRR_BR11_Msk                    (0x08000000UL)               /*!< BR11 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BR10_Pos                    (26UL)                       /*!< BR10 (Bit 26)                  */
#define GPIOF_PU_BSRR_BR10_Msk                    (0x04000000UL)               /*!< BR10 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BR9_Pos                     (25UL)                       /*!< BR9 (Bit 25)                   */
#define GPIOF_PU_BSRR_BR9_Msk                     (0x02000000UL)               /*!< BR9 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BR8_Pos                     (24UL)                       /*!< BR8 (Bit 24)                   */
#define GPIOF_PU_BSRR_BR8_Msk                     (0x01000000UL)               /*!< BR8 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BR7_Pos                     (23UL)                       /*!< BR7 (Bit 23)                   */
#define GPIOF_PU_BSRR_BR7_Msk                     (0x00800000UL)               /*!< BR7 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BR6_Pos                     (22UL)                       /*!< BR6 (Bit 22)                   */
#define GPIOF_PU_BSRR_BR6_Msk                     (0x00400000UL)               /*!< BR6 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BR5_Pos                     (21UL)                       /*!< BR5 (Bit 21)                   */
#define GPIOF_PU_BSRR_BR5_Msk                     (0x00200000UL)               /*!< BR5 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BR4_Pos                     (20UL)                       /*!< BR4 (Bit 20)                   */
#define GPIOF_PU_BSRR_BR4_Msk                     (0x00100000UL)               /*!< BR4 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BR3_Pos                     (19UL)                       /*!< BR3 (Bit 19)                   */
#define GPIOF_PU_BSRR_BR3_Msk                     (0x00080000UL)               /*!< BR3 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BR2_Pos                     (18UL)                       /*!< BR2 (Bit 18)                   */
#define GPIOF_PU_BSRR_BR2_Msk                     (0x00040000UL)               /*!< BR2 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BR1_Pos                     (17UL)                       /*!< BR1 (Bit 17)                   */
#define GPIOF_PU_BSRR_BR1_Msk                     (0x00020000UL)               /*!< BR1 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BR0_Pos                     (16UL)                       /*!< BR0 (Bit 16)                   */
#define GPIOF_PU_BSRR_BR0_Msk                     (0x00010000UL)               /*!< BR0 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BS15_Pos                    (15UL)                       /*!< BS15 (Bit 15)                  */
#define GPIOF_PU_BSRR_BS15_Msk                    (0x00008000UL)               /*!< BS15 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BS14_Pos                    (14UL)                       /*!< BS14 (Bit 14)                  */
#define GPIOF_PU_BSRR_BS14_Msk                    (0x00004000UL)               /*!< BS14 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BS13_Pos                    (13UL)                       /*!< BS13 (Bit 13)                  */
#define GPIOF_PU_BSRR_BS13_Msk                    (0x00002000UL)               /*!< BS13 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BS12_Pos                    (12UL)                       /*!< BS12 (Bit 12)                  */
#define GPIOF_PU_BSRR_BS12_Msk                    (0x00001000UL)               /*!< BS12 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BS11_Pos                    (11UL)                       /*!< BS11 (Bit 11)                  */
#define GPIOF_PU_BSRR_BS11_Msk                    (0x00000800UL)               /*!< BS11 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BS10_Pos                    (10UL)                       /*!< BS10 (Bit 10)                  */
#define GPIOF_PU_BSRR_BS10_Msk                    (0x00000400UL)               /*!< BS10 (Bitfield-Mask: 0x01)     */
#define GPIOF_PU_BSRR_BS9_Pos                     (9UL)                        /*!< BS9 (Bit 9)                    */
#define GPIOF_PU_BSRR_BS9_Msk                     (0x00000200UL)               /*!< BS9 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BS8_Pos                     (8UL)                        /*!< BS8 (Bit 8)                    */
#define GPIOF_PU_BSRR_BS8_Msk                     (0x00000100UL)               /*!< BS8 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BS7_Pos                     (7UL)                        /*!< BS7 (Bit 7)                    */
#define GPIOF_PU_BSRR_BS7_Msk                     (0x00000080UL)               /*!< BS7 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BS6_Pos                     (6UL)                        /*!< BS6 (Bit 6)                    */
#define GPIOF_PU_BSRR_BS6_Msk                     (0x00000040UL)               /*!< BS6 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BS5_Pos                     (5UL)                        /*!< BS5 (Bit 5)                    */
#define GPIOF_PU_BSRR_BS5_Msk                     (0x00000020UL)               /*!< BS5 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BS4_Pos                     (4UL)                        /*!< BS4 (Bit 4)                    */
#define GPIOF_PU_BSRR_BS4_Msk                     (0x00000010UL)               /*!< BS4 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BS3_Pos                     (3UL)                        /*!< BS3 (Bit 3)                    */
#define GPIOF_PU_BSRR_BS3_Msk                     (0x00000008UL)               /*!< BS3 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BS2_Pos                     (2UL)                        /*!< BS2 (Bit 2)                    */
#define GPIOF_PU_BSRR_BS2_Msk                     (0x00000004UL)               /*!< BS2 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BS1_Pos                     (1UL)                        /*!< BS1 (Bit 1)                    */
#define GPIOF_PU_BSRR_BS1_Msk                     (0x00000002UL)               /*!< BS1 (Bitfield-Mask: 0x01)      */
#define GPIOF_PU_BSRR_BS0_Pos                     (0UL)                        /*!< BS0 (Bit 0)                    */
#define GPIOF_PU_BSRR_BS0_Msk                     (0x00000001UL)               /*!< BS0 (Bitfield-Mask: 0x01)      */
/* ===================================  PD  ================================= */
#define GPIOF_PD_PD15_Pos                         (15UL)                       /*!< PD15 (Bit 15)                  */
#define GPIOF_PD_PD15_Msk                         (0x00008000UL)               /*!< PD15 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_PD14_Pos                         (14UL)                       /*!< PD14 (Bit 14)                  */
#define GPIOF_PD_PD14_Msk                         (0x00004000UL)               /*!< PD14 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_PD13_Pos                         (13UL)                       /*!< PD13 (Bit 13)                  */
#define GPIOF_PD_PD13_Msk                         (0x00002000UL)               /*!< PD13 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_PD12_Pos                         (12UL)                       /*!< PD12 (Bit 12)                  */
#define GPIOF_PD_PD12_Msk                         (0x00001000UL)               /*!< PD12 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_PD11_Pos                         (11UL)                       /*!< PD11 (Bit 11)                  */
#define GPIOF_PD_PD11_Msk                         (0x00000800UL)               /*!< PD11 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_PD10_Pos                         (10UL)                       /*!< PD10 (Bit 10)                  */
#define GPIOF_PD_PD10_Msk                         (0x00000400UL)               /*!< PD10 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_PD9_Pos                          (9UL)                        /*!< PD9 (Bit 9)                    */
#define GPIOF_PD_PD9_Msk                          (0x00000200UL)               /*!< PD9 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_PD8_Pos                          (8UL)                        /*!< PD8 (Bit 8)                    */
#define GPIOF_PD_PD8_Msk                          (0x00000100UL)               /*!< PD8 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_PD7_Pos                          (7UL)                        /*!< PD7 (Bit 7)                    */
#define GPIOF_PD_PD7_Msk                          (0x00000080UL)               /*!< PD7 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_PD6_Pos                          (6UL)                        /*!< PD6 (Bit 6)                    */
#define GPIOF_PD_PD6_Msk                          (0x00000040UL)               /*!< PD6 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_PD5_Pos                          (5UL)                        /*!< PD5 (Bit 5)                    */
#define GPIOF_PD_PD5_Msk                          (0x00000020UL)               /*!< PD5 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_PD4_Pos                          (4UL)                        /*!< PD4 (Bit 4)                    */
#define GPIOF_PD_PD4_Msk                          (0x00000010UL)               /*!< PD4 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_PD3_Pos                          (3UL)                        /*!< PD3 (Bit 3)                    */
#define GPIOF_PD_PD3_Msk                          (0x00000008UL)               /*!< PD3 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_PD2_Pos                          (2UL)                        /*!< PD2 (Bit 2)                    */
#define GPIOF_PD_PD2_Msk                          (0x00000004UL)               /*!< PD2 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_PD1_Pos                          (1UL)                        /*!< PD1 (Bit 1)                    */
#define GPIOF_PD_PD1_Msk                          (0x00000002UL)               /*!< PD1 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_PD0_Pos                          (0UL)                        /*!< PD0 (Bit 0)                    */
#define GPIOF_PD_PD0_Msk                          (0x00000001UL)               /*!< PD0 (Bitfield-Mask: 0x01)      */
/* ================================  PD_BSRR  =============================== */
#define GPIOF_PD_BSRR_BR15_Pos                    (31UL)                       /*!< BR15 (Bit 31)                  */
#define GPIOF_PD_BSRR_BR15_Msk                    (0x80000000UL)               /*!< BR15 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BR14_Pos                    (30UL)                       /*!< BR14 (Bit 30)                  */
#define GPIOF_PD_BSRR_BR14_Msk                    (0x40000000UL)               /*!< BR14 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BR13_Pos                    (29UL)                       /*!< BR13 (Bit 29)                  */
#define GPIOF_PD_BSRR_BR13_Msk                    (0x20000000UL)               /*!< BR13 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BR12_Pos                    (28UL)                       /*!< BR12 (Bit 28)                  */
#define GPIOF_PD_BSRR_BR12_Msk                    (0x10000000UL)               /*!< BR12 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BR11_Pos                    (27UL)                       /*!< BR11 (Bit 27)                  */
#define GPIOF_PD_BSRR_BR11_Msk                    (0x08000000UL)               /*!< BR11 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BR10_Pos                    (26UL)                       /*!< BR10 (Bit 26)                  */
#define GPIOF_PD_BSRR_BR10_Msk                    (0x04000000UL)               /*!< BR10 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BR9_Pos                     (25UL)                       /*!< BR9 (Bit 25)                   */
#define GPIOF_PD_BSRR_BR9_Msk                     (0x02000000UL)               /*!< BR9 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BR8_Pos                     (24UL)                       /*!< BR8 (Bit 24)                   */
#define GPIOF_PD_BSRR_BR8_Msk                     (0x01000000UL)               /*!< BR8 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BR7_Pos                     (23UL)                       /*!< BR7 (Bit 23)                   */
#define GPIOF_PD_BSRR_BR7_Msk                     (0x00800000UL)               /*!< BR7 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BR6_Pos                     (22UL)                       /*!< BR6 (Bit 22)                   */
#define GPIOF_PD_BSRR_BR6_Msk                     (0x00400000UL)               /*!< BR6 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BR5_Pos                     (21UL)                       /*!< BR5 (Bit 21)                   */
#define GPIOF_PD_BSRR_BR5_Msk                     (0x00200000UL)               /*!< BR5 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BR4_Pos                     (20UL)                       /*!< BR4 (Bit 20)                   */
#define GPIOF_PD_BSRR_BR4_Msk                     (0x00100000UL)               /*!< BR4 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BR3_Pos                     (19UL)                       /*!< BR3 (Bit 19)                   */
#define GPIOF_PD_BSRR_BR3_Msk                     (0x00080000UL)               /*!< BR3 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BR2_Pos                     (18UL)                       /*!< BR2 (Bit 18)                   */
#define GPIOF_PD_BSRR_BR2_Msk                     (0x00040000UL)               /*!< BR2 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BR1_Pos                     (17UL)                       /*!< BR1 (Bit 17)                   */
#define GPIOF_PD_BSRR_BR1_Msk                     (0x00020000UL)               /*!< BR1 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BR0_Pos                     (16UL)                       /*!< BR0 (Bit 16)                   */
#define GPIOF_PD_BSRR_BR0_Msk                     (0x00010000UL)               /*!< BR0 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BS15_Pos                    (15UL)                       /*!< BS15 (Bit 15)                  */
#define GPIOF_PD_BSRR_BS15_Msk                    (0x00008000UL)               /*!< BS15 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BS14_Pos                    (14UL)                       /*!< BS14 (Bit 14)                  */
#define GPIOF_PD_BSRR_BS14_Msk                    (0x00004000UL)               /*!< BS14 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BS13_Pos                    (13UL)                       /*!< BS13 (Bit 13)                  */
#define GPIOF_PD_BSRR_BS13_Msk                    (0x00002000UL)               /*!< BS13 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BS12_Pos                    (12UL)                       /*!< BS12 (Bit 12)                  */
#define GPIOF_PD_BSRR_BS12_Msk                    (0x00001000UL)               /*!< BS12 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BS11_Pos                    (11UL)                       /*!< BS11 (Bit 11)                  */
#define GPIOF_PD_BSRR_BS11_Msk                    (0x00000800UL)               /*!< BS11 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BS10_Pos                    (10UL)                       /*!< BS10 (Bit 10)                  */
#define GPIOF_PD_BSRR_BS10_Msk                    (0x00000400UL)               /*!< BS10 (Bitfield-Mask: 0x01)     */
#define GPIOF_PD_BSRR_BS9_Pos                     (9UL)                        /*!< BS9 (Bit 9)                    */
#define GPIOF_PD_BSRR_BS9_Msk                     (0x00000200UL)               /*!< BS9 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BS8_Pos                     (8UL)                        /*!< BS8 (Bit 8)                    */
#define GPIOF_PD_BSRR_BS8_Msk                     (0x00000100UL)               /*!< BS8 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BS7_Pos                     (7UL)                        /*!< BS7 (Bit 7)                    */
#define GPIOF_PD_BSRR_BS7_Msk                     (0x00000080UL)               /*!< BS7 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BS6_Pos                     (6UL)                        /*!< BS6 (Bit 6)                    */
#define GPIOF_PD_BSRR_BS6_Msk                     (0x00000040UL)               /*!< BS6 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BS5_Pos                     (5UL)                        /*!< BS5 (Bit 5)                    */
#define GPIOF_PD_BSRR_BS5_Msk                     (0x00000020UL)               /*!< BS5 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BS4_Pos                     (4UL)                        /*!< BS4 (Bit 4)                    */
#define GPIOF_PD_BSRR_BS4_Msk                     (0x00000010UL)               /*!< BS4 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BS3_Pos                     (3UL)                        /*!< BS3 (Bit 3)                    */
#define GPIOF_PD_BSRR_BS3_Msk                     (0x00000008UL)               /*!< BS3 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BS2_Pos                     (2UL)                        /*!< BS2 (Bit 2)                    */
#define GPIOF_PD_BSRR_BS2_Msk                     (0x00000004UL)               /*!< BS2 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BS1_Pos                     (1UL)                        /*!< BS1 (Bit 1)                    */
#define GPIOF_PD_BSRR_BS1_Msk                     (0x00000002UL)               /*!< BS1 (Bitfield-Mask: 0x01)      */
#define GPIOF_PD_BSRR_BS0_Pos                     (0UL)                        /*!< BS0 (Bit 0)                    */
#define GPIOF_PD_BSRR_BS0_Msk                     (0x00000001UL)               /*!< BS0 (Bitfield-Mask: 0x01)      */
/* ===================================  IDR  ================================ */
#define GPIOF_IDR_IDR15_Pos                       (15UL)                       /*!< IDR15 (Bit 15)                 */
#define GPIOF_IDR_IDR15_Msk                       (0x00008000UL)               /*!< IDR15 (Bitfield-Mask: 0x01)    */
#define GPIOF_IDR_IDR14_Pos                       (14UL)                       /*!< IDR14 (Bit 14)                 */
#define GPIOF_IDR_IDR14_Msk                       (0x00004000UL)               /*!< IDR14 (Bitfield-Mask: 0x01)    */
#define GPIOF_IDR_IDR13_Pos                       (13UL)                       /*!< IDR13 (Bit 13)                 */
#define GPIOF_IDR_IDR13_Msk                       (0x00002000UL)               /*!< IDR13 (Bitfield-Mask: 0x01)    */
#define GPIOF_IDR_IDR12_Pos                       (12UL)                       /*!< IDR12 (Bit 12)                 */
#define GPIOF_IDR_IDR12_Msk                       (0x00001000UL)               /*!< IDR12 (Bitfield-Mask: 0x01)    */
#define GPIOF_IDR_IDR11_Pos                       (11UL)                       /*!< IDR11 (Bit 11)                 */
#define GPIOF_IDR_IDR11_Msk                       (0x00000800UL)               /*!< IDR11 (Bitfield-Mask: 0x01)    */
#define GPIOF_IDR_IDR10_Pos                       (10UL)                       /*!< IDR10 (Bit 10)                 */
#define GPIOF_IDR_IDR10_Msk                       (0x00000400UL)               /*!< IDR10 (Bitfield-Mask: 0x01)    */
#define GPIOF_IDR_IDR9_Pos                        (9UL)                        /*!< IDR9 (Bit 9)                   */
#define GPIOF_IDR_IDR9_Msk                        (0x00000200UL)               /*!< IDR9 (Bitfield-Mask: 0x01)     */
#define GPIOF_IDR_IDR8_Pos                        (8UL)                        /*!< IDR8 (Bit 8)                   */
#define GPIOF_IDR_IDR8_Msk                        (0x00000100UL)               /*!< IDR8 (Bitfield-Mask: 0x01)     */
#define GPIOF_IDR_IDR7_Pos                        (7UL)                        /*!< IDR7 (Bit 7)                   */
#define GPIOF_IDR_IDR7_Msk                        (0x00000080UL)               /*!< IDR7 (Bitfield-Mask: 0x01)     */
#define GPIOF_IDR_IDR6_Pos                        (6UL)                        /*!< IDR6 (Bit 6)                   */
#define GPIOF_IDR_IDR6_Msk                        (0x00000040UL)               /*!< IDR6 (Bitfield-Mask: 0x01)     */
#define GPIOF_IDR_IDR5_Pos                        (5UL)                        /*!< IDR5 (Bit 5)                   */
#define GPIOF_IDR_IDR5_Msk                        (0x00000020UL)               /*!< IDR5 (Bitfield-Mask: 0x01)     */
#define GPIOF_IDR_IDR4_Pos                        (4UL)                        /*!< IDR4 (Bit 4)                   */
#define GPIOF_IDR_IDR4_Msk                        (0x00000010UL)               /*!< IDR4 (Bitfield-Mask: 0x01)     */
#define GPIOF_IDR_IDR3_Pos                        (3UL)                        /*!< IDR3 (Bit 3)                   */
#define GPIOF_IDR_IDR3_Msk                        (0x00000008UL)               /*!< IDR3 (Bitfield-Mask: 0x01)     */
#define GPIOF_IDR_IDR2_Pos                        (2UL)                        /*!< IDR2 (Bit 2)                   */
#define GPIOF_IDR_IDR2_Msk                        (0x00000004UL)               /*!< IDR2 (Bitfield-Mask: 0x01)     */
#define GPIOF_IDR_IDR1_Pos                        (1UL)                        /*!< IDR1 (Bit 1)                   */
#define GPIOF_IDR_IDR1_Msk                        (0x00000002UL)               /*!< IDR1 (Bitfield-Mask: 0x01)     */
#define GPIOF_IDR_IDR0_Pos                        (0UL)                        /*!< IDR0 (Bit 0)                   */
#define GPIOF_IDR_IDR0_Msk                        (0x00000001UL)               /*!< IDR0 (Bitfield-Mask: 0x01)     */
/* ===================================  ODR  ================================ */
#define GPIOF_ODR_ODR15_Pos                       (15UL)                       /*!< ODR15 (Bit 15)                 */
#define GPIOF_ODR_ODR15_Msk                       (0x00008000UL)               /*!< ODR15 (Bitfield-Mask: 0x01)    */
#define GPIOF_ODR_ODR14_Pos                       (14UL)                       /*!< ODR14 (Bit 14)                 */
#define GPIOF_ODR_ODR14_Msk                       (0x00004000UL)               /*!< ODR14 (Bitfield-Mask: 0x01)    */
#define GPIOF_ODR_ODR13_Pos                       (13UL)                       /*!< ODR13 (Bit 13)                 */
#define GPIOF_ODR_ODR13_Msk                       (0x00002000UL)               /*!< ODR13 (Bitfield-Mask: 0x01)    */
#define GPIOF_ODR_ODR12_Pos                       (12UL)                       /*!< ODR12 (Bit 12)                 */
#define GPIOF_ODR_ODR12_Msk                       (0x00001000UL)               /*!< ODR12 (Bitfield-Mask: 0x01)    */
#define GPIOF_ODR_ODR11_Pos                       (11UL)                       /*!< ODR11 (Bit 11)                 */
#define GPIOF_ODR_ODR11_Msk                       (0x00000800UL)               /*!< ODR11 (Bitfield-Mask: 0x01)    */
#define GPIOF_ODR_ODR10_Pos                       (10UL)                       /*!< ODR10 (Bit 10)                 */
#define GPIOF_ODR_ODR10_Msk                       (0x00000400UL)               /*!< ODR10 (Bitfield-Mask: 0x01)    */
#define GPIOF_ODR_ODR9_Pos                        (9UL)                        /*!< ODR9 (Bit 9)                   */
#define GPIOF_ODR_ODR9_Msk                        (0x00000200UL)               /*!< ODR9 (Bitfield-Mask: 0x01)     */
#define GPIOF_ODR_ODR8_Pos                        (8UL)                        /*!< ODR8 (Bit 8)                   */
#define GPIOF_ODR_ODR8_Msk                        (0x00000100UL)               /*!< ODR8 (Bitfield-Mask: 0x01)     */
#define GPIOF_ODR_ODR7_Pos                        (7UL)                        /*!< ODR7 (Bit 7)                   */
#define GPIOF_ODR_ODR7_Msk                        (0x00000080UL)               /*!< ODR7 (Bitfield-Mask: 0x01)     */
#define GPIOF_ODR_ODR6_Pos                        (6UL)                        /*!< ODR6 (Bit 6)                   */
#define GPIOF_ODR_ODR6_Msk                        (0x00000040UL)               /*!< ODR6 (Bitfield-Mask: 0x01)     */
#define GPIOF_ODR_ODR5_Pos                        (5UL)                        /*!< ODR5 (Bit 5)                   */
#define GPIOF_ODR_ODR5_Msk                        (0x00000020UL)               /*!< ODR5 (Bitfield-Mask: 0x01)     */
#define GPIOF_ODR_ODR4_Pos                        (4UL)                        /*!< ODR4 (Bit 4)                   */
#define GPIOF_ODR_ODR4_Msk                        (0x00000010UL)               /*!< ODR4 (Bitfield-Mask: 0x01)     */
#define GPIOF_ODR_ODR3_Pos                        (3UL)                        /*!< ODR3 (Bit 3)                   */
#define GPIOF_ODR_ODR3_Msk                        (0x00000008UL)               /*!< ODR3 (Bitfield-Mask: 0x01)     */
#define GPIOF_ODR_ODR2_Pos                        (2UL)                        /*!< ODR2 (Bit 2)                   */
#define GPIOF_ODR_ODR2_Msk                        (0x00000004UL)               /*!< ODR2 (Bitfield-Mask: 0x01)     */
#define GPIOF_ODR_ODR1_Pos                        (1UL)                        /*!< ODR1 (Bit 1)                   */
#define GPIOF_ODR_ODR1_Msk                        (0x00000002UL)               /*!< ODR1 (Bitfield-Mask: 0x01)     */
#define GPIOF_ODR_ODR0_Pos                        (0UL)                        /*!< ODR0 (Bit 0)                   */
#define GPIOF_ODR_ODR0_Msk                        (0x00000001UL)               /*!< ODR0 (Bitfield-Mask: 0x01)     */
/* ================================  BSRR  ================================== */
#define GPIOF_BSRR_BR15_Pos                       (31UL)                       /*!< BR15 (Bit 31)                  */
#define GPIOF_BSRR_BR15_Msk                       (0x80000000UL)               /*!< BR15 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BR14_Pos                       (30UL)                       /*!< BR14 (Bit 30)                  */
#define GPIOF_BSRR_BR14_Msk                       (0x40000000UL)               /*!< BR14 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BR13_Pos                       (29UL)                       /*!< BR13 (Bit 29)                  */
#define GPIOF_BSRR_BR13_Msk                       (0x20000000UL)               /*!< BR13 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BR12_Pos                       (28UL)                       /*!< BR12 (Bit 28)                  */
#define GPIOF_BSRR_BR12_Msk                       (0x10000000UL)               /*!< BR12 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BR11_Pos                       (27UL)                       /*!< BR11 (Bit 27)                  */
#define GPIOF_BSRR_BR11_Msk                       (0x08000000UL)               /*!< BR11 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BR10_Pos                       (26UL)                       /*!< BR10 (Bit 26)                  */
#define GPIOF_BSRR_BR10_Msk                       (0x04000000UL)               /*!< BR10 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BR9_Pos                        (25UL)                       /*!< BR9 (Bit 25)                   */
#define GPIOF_BSRR_BR9_Msk                        (0x02000000UL)               /*!< BR9 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BR8_Pos                        (24UL)                       /*!< BR8 (Bit 24)                   */
#define GPIOF_BSRR_BR8_Msk                        (0x01000000UL)               /*!< BR8 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BR7_Pos                        (23UL)                       /*!< BR7 (Bit 23)                   */
#define GPIOF_BSRR_BR7_Msk                        (0x00800000UL)               /*!< BR7 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BR6_Pos                        (22UL)                       /*!< BR6 (Bit 22)                   */
#define GPIOF_BSRR_BR6_Msk                        (0x00400000UL)               /*!< BR6 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BR5_Pos                        (21UL)                       /*!< BR5 (Bit 21)                   */
#define GPIOF_BSRR_BR5_Msk                        (0x00200000UL)               /*!< BR5 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BR4_Pos                        (20UL)                       /*!< BR4 (Bit 20)                   */
#define GPIOF_BSRR_BR4_Msk                        (0x00100000UL)               /*!< BR4 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BR3_Pos                        (19UL)                       /*!< BR3 (Bit 19)                   */
#define GPIOF_BSRR_BR3_Msk                        (0x00080000UL)               /*!< BR3 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BR2_Pos                        (18UL)                       /*!< BR2 (Bit 18)                   */
#define GPIOF_BSRR_BR2_Msk                        (0x00040000UL)               /*!< BR2 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BR1_Pos                        (17UL)                       /*!< BR1 (Bit 17)                   */
#define GPIOF_BSRR_BR1_Msk                        (0x00020000UL)               /*!< BR1 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BR0_Pos                        (16UL)                       /*!< BR0 (Bit 16)                   */
#define GPIOF_BSRR_BR0_Msk                        (0x00010000UL)               /*!< BR0 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BS15_Pos                       (15UL)                       /*!< BS15 (Bit 15)                  */
#define GPIOF_BSRR_BS15_Msk                       (0x00008000UL)               /*!< BS15 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BS14_Pos                       (14UL)                       /*!< BS14 (Bit 14)                  */
#define GPIOF_BSRR_BS14_Msk                       (0x00004000UL)               /*!< BS14 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BS13_Pos                       (13UL)                       /*!< BS13 (Bit 13)                  */
#define GPIOF_BSRR_BS13_Msk                       (0x00002000UL)               /*!< BS13 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BS12_Pos                       (12UL)                       /*!< BS12 (Bit 12)                  */
#define GPIOF_BSRR_BS12_Msk                       (0x00001000UL)               /*!< BS12 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BS11_Pos                       (11UL)                       /*!< BS11 (Bit 11)                  */
#define GPIOF_BSRR_BS11_Msk                       (0x00000800UL)               /*!< BS11 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BS10_Pos                       (10UL)                       /*!< BS10 (Bit 10)                  */
#define GPIOF_BSRR_BS10_Msk                       (0x00000400UL)               /*!< BS10 (Bitfield-Mask: 0x01)     */
#define GPIOF_BSRR_BS9_Pos                        (9UL)                        /*!< BS9 (Bit 9)                    */
#define GPIOF_BSRR_BS9_Msk                        (0x00000200UL)               /*!< BS9 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BS8_Pos                        (8UL)                        /*!< BS8 (Bit 8)                    */
#define GPIOF_BSRR_BS8_Msk                        (0x00000100UL)               /*!< BS8 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BS7_Pos                        (7UL)                        /*!< BS7 (Bit 7)                    */
#define GPIOF_BSRR_BS7_Msk                        (0x00000080UL)               /*!< BS7 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BS6_Pos                        (6UL)                        /*!< BS6 (Bit 6)                    */
#define GPIOF_BSRR_BS6_Msk                        (0x00000040UL)               /*!< BS6 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BS5_Pos                        (5UL)                        /*!< BS5 (Bit 5)                    */
#define GPIOF_BSRR_BS5_Msk                        (0x00000020UL)               /*!< BS5 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BS4_Pos                        (4UL)                        /*!< BS4 (Bit 4)                    */
#define GPIOF_BSRR_BS4_Msk                        (0x00000010UL)               /*!< BS4 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BS3_Pos                        (3UL)                        /*!< BS3 (Bit 3)                    */
#define GPIOF_BSRR_BS3_Msk                        (0x00000008UL)               /*!< BS3 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BS2_Pos                        (2UL)                        /*!< BS2 (Bit 2)                    */
#define GPIOF_BSRR_BS2_Msk                        (0x00000004UL)               /*!< BS2 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BS1_Pos                        (1UL)                        /*!< BS1 (Bit 1)                    */
#define GPIOF_BSRR_BS1_Msk                        (0x00000002UL)               /*!< BS1 (Bitfield-Mask: 0x01)      */
#define GPIOF_BSRR_BS0_Pos                        (0UL)                        /*!< BS0 (Bit 0)                    */
#define GPIOF_BSRR_BS0_Msk                        (0x00000001UL)               /*!< BS0 (Bitfield-Mask: 0x01)      */
/* ===============================  LCKR  =================================== */
#define GPIOF_LCKR_LCKK_Pos                       (16UL)                       /*!< LCKK (Bit 16)                  */
#define GPIOF_LCKR_LCKK_Msk                       (0x00010000UL)               /*!< LCKK (Bitfield-Mask: 0x01)     */
#define GPIOF_LCKR_LCK15_Pos                      (15UL)                       /*!< LCK15 (Bit 15)                 */
#define GPIOF_LCKR_LCK15_Msk                      (0x00008000UL)               /*!< LCK15 (Bitfield-Mask: 0x01)    */
#define GPIOF_LCKR_LCK14_Pos                      (14UL)                       /*!< LCK14 (Bit 14)                 */
#define GPIOF_LCKR_LCK14_Msk                      (0x00004000UL)               /*!< LCK14 (Bitfield-Mask: 0x01)    */
#define GPIOF_LCKR_LCK13_Pos                      (13UL)                       /*!< LCK13 (Bit 13)                 */
#define GPIOF_LCKR_LCK13_Msk                      (0x00002000UL)               /*!< LCK13 (Bitfield-Mask: 0x01)    */
#define GPIOF_LCKR_LCK12_Pos                      (12UL)                       /*!< LCK12 (Bit 12)                 */
#define GPIOF_LCKR_LCK12_Msk                      (0x00001000UL)               /*!< LCK12 (Bitfield-Mask: 0x01)    */
#define GPIOF_LCKR_LCK11_Pos                      (11UL)                       /*!< LCK11 (Bit 11)                 */
#define GPIOF_LCKR_LCK11_Msk                      (0x00000800UL)               /*!< LCK11 (Bitfield-Mask: 0x01)    */
#define GPIOF_LCKR_LCK10_Pos                      (10UL)                       /*!< LCK10 (Bit 10)                 */
#define GPIOF_LCKR_LCK10_Msk                      (0x00000400UL)               /*!< LCK10 (Bitfield-Mask: 0x01)    */
#define GPIOF_LCKR_LCK9_Pos                       (9UL)                        /*!< LCK9 (Bit 9)                   */
#define GPIOF_LCKR_LCK9_Msk                       (0x00000200UL)               /*!< LCK9 (Bitfield-Mask: 0x01)     */
#define GPIOF_LCKR_LCK8_Pos                       (8UL)                        /*!< LCK8 (Bit 8)                   */
#define GPIOF_LCKR_LCK8_Msk                       (0x00000100UL)               /*!< LCK8 (Bitfield-Mask: 0x01)     */
#define GPIOF_LCKR_LCK7_Pos                       (7UL)                        /*!< LCK7 (Bit 7)                   */
#define GPIOF_LCKR_LCK7_Msk                       (0x00000080UL)               /*!< LCK7 (Bitfield-Mask: 0x01)     */
#define GPIOF_LCKR_LCK6_Pos                       (6UL)                        /*!< LCK6 (Bit 6)                   */
#define GPIOF_LCKR_LCK6_Msk                       (0x00000040UL)               /*!< LCK6 (Bitfield-Mask: 0x01)     */
#define GPIOF_LCKR_LCK5_Pos                       (5UL)                        /*!< LCK5 (Bit 5)                   */
#define GPIOF_LCKR_LCK5_Msk                       (0x00000020UL)               /*!< LCK5 (Bitfield-Mask: 0x01)     */
#define GPIOF_LCKR_LCK4_Pos                       (4UL)                        /*!< LCK4 (Bit 4)                   */
#define GPIOF_LCKR_LCK4_Msk                       (0x00000010UL)               /*!< LCK4 (Bitfield-Mask: 0x01)     */
#define GPIOF_LCKR_LCK3_Pos                       (3UL)                        /*!< LCK3 (Bit 3)                   */
#define GPIOF_LCKR_LCK3_Msk                       (0x00000008UL)               /*!< LCK3 (Bitfield-Mask: 0x01)     */
#define GPIOF_LCKR_LCK2_Pos                       (2UL)                        /*!< LCK2 (Bit 2)                   */
#define GPIOF_LCKR_LCK2_Msk                       (0x00000004UL)               /*!< LCK2 (Bitfield-Mask: 0x01)     */
#define GPIOF_LCKR_LCK1_Pos                       (1UL)                        /*!< LCK1 (Bit 1)                   */
#define GPIOF_LCKR_LCK1_Msk                       (0x00000002UL)               /*!< LCK1 (Bitfield-Mask: 0x01)     */
#define GPIOF_LCKR_LCK0_Pos                       (0UL)                        /*!< LCK0 (Bit 0)                   */
#define GPIOF_LCKR_LCK0_Msk                       (0x00000001UL)               /*!< LCK0 (Bitfield-Mask: 0x01)     */
/* ===============================  AFRL  =================================== */
#define GPIOF_AFRL_AFR7_Pos                       (28UL)                       /*!< AFR7 (Bit 28)                  */
#define GPIOF_AFRL_AFR7_Msk                       (0xF0000000UL)               /*!< AFR7 (Bitfield-Mask: 0x0f)     */
#define GPIOF_AFRL_AFR6_Pos                       (24UL)                       /*!< AFR6 (Bit 24)                  */
#define GPIOF_AFRL_AFR6_Msk                       (0x0F000000UL)               /*!< AFR6 (Bitfield-Mask: 0x0f)     */
#define GPIOF_AFRL_AFR5_Pos                       (20UL)                       /*!< AFR5 (Bit 20)                  */
#define GPIOF_AFRL_AFR5_Msk                       (0x00F00000UL)               /*!< AFR5 (Bitfield-Mask: 0x0f)     */
#define GPIOF_AFRL_AFR4_Pos                       (16UL)                       /*!< AFR4 (Bit 16)                  */
#define GPIOF_AFRL_AFR4_Msk                       (0x000F0000UL)               /*!< AFR4 (Bitfield-Mask: 0x0f)     */
#define GPIOF_AFRL_AFR3_Pos                       (12UL)                       /*!< AFR3 (Bit 12)                  */
#define GPIOF_AFRL_AFR3_Msk                       (0x0000F000UL)               /*!< AFR3 (Bitfield-Mask: 0x0f)     */
#define GPIOF_AFRL_AFR2_Pos                       (8UL)                        /*!< AFR2 (Bit 8)                   */
#define GPIOF_AFRL_AFR2_Msk                       (0x00000F00UL)               /*!< AFR2 (Bitfield-Mask: 0x0f)     */
#define GPIOF_AFRL_AFR1_Pos                       (4UL)                        /*!< AFR1 (Bit 4)                   */
#define GPIOF_AFRL_AFR1_Msk                       (0x000000F0UL)               /*!< AFR1 (Bitfield-Mask: 0x0f)     */
#define GPIOF_AFRL_AFR0_Pos                       (0UL)                        /*!< AFR0 (Bit 0)                   */
#define GPIOF_AFRL_AFR0_Msk                       (0x0000000FUL)               /*!< AFR0 (Bitfield-Mask: 0x0f)     */
/* ===============================  AFRH  =================================== */
#define GPIOF_AFRH_AFR15_Pos                      (28UL)                       /*!< AFR15 (Bit 28)                 */
#define GPIOF_AFRH_AFR15_Msk                      (0xF0000000UL)               /*!< AFR15 (Bitfield-Mask: 0x0f)    */
#define GPIOF_AFRH_AFR14_Pos                      (24UL)                       /*!< AFR14 (Bit 24)                 */
#define GPIOF_AFRH_AFR14_Msk                      (0x0F000000UL)               /*!< AFR14 (Bitfield-Mask: 0x0f)    */
#define GPIOF_AFRH_AFR13_Pos                      (20UL)                       /*!< AFR13 (Bit 20)                 */
#define GPIOF_AFRH_AFR13_Msk                      (0x00F00000UL)               /*!< AFR13 (Bitfield-Mask: 0x0f)    */
#define GPIOF_AFRH_AFR12_Pos                      (16UL)                       /*!< AFR12 (Bit 16)                 */
#define GPIOF_AFRH_AFR12_Msk                      (0x000F0000UL)               /*!< AFR12 (Bitfield-Mask: 0x0f)    */
#define GPIOF_AFRH_AFR11_Pos                      (12UL)                       /*!< AFR11 (Bit 12)                 */
#define GPIOF_AFRH_AFR11_Msk                      (0x0000F000UL)               /*!< AFR11 (Bitfield-Mask: 0x0f)    */
#define GPIOF_AFRH_AFR10_Pos                      (8UL)                        /*!< AFR10 (Bit 8)                  */
#define GPIOF_AFRH_AFR10_Msk                      (0x00000F00UL)               /*!< AFR10 (Bitfield-Mask: 0x0f)    */
#define GPIOF_AFRH_AFR9_Pos                       (4UL)                        /*!< AFR9 (Bit 4)                   */
#define GPIOF_AFRH_AFR9_Msk                       (0x000000F0UL)               /*!< AFR9 (Bitfield-Mask: 0x0f)     */
#define GPIOF_AFRH_AFR8_Pos                       (0UL)                        /*!< AFR8 (Bit 0)                   */
#define GPIOF_AFRH_AFR8_Msk                       (0x0000000FUL)               /*!< AFR8 (Bitfield-Mask: 0x0f)     */
/* ==============================  BTGLR  =================================== */
#define GPIOF_BTGLR_BTGL15_Pos                    (15UL)                       /*!< BTGL15 (Bit 15)                */
#define GPIOF_BTGLR_BTGL15_Msk                    (0x00008000UL)               /*!< BTGL15 (Bitfield-Mask: 0x01)   */
#define GPIOF_BTGLR_BTGL14_Pos                    (14UL)                       /*!< BTGL14 (Bit 14)                */
#define GPIOF_BTGLR_BTGL14_Msk                    (0x00004000UL)               /*!< BTGL14 (Bitfield-Mask: 0x01)   */
#define GPIOF_BTGLR_BTGL13_Pos                    (13UL)                       /*!< BTGL13 (Bit 13)                */
#define GPIOF_BTGLR_BTGL13_Msk                    (0x00002000UL)               /*!< BTGL13 (Bitfield-Mask: 0x01)   */
#define GPIOF_BTGLR_BTGL12_Pos                    (12UL)                       /*!< BTGL12 (Bit 12)                */
#define GPIOF_BTGLR_BTGL12_Msk                    (0x00001000UL)               /*!< BTGL12 (Bitfield-Mask: 0x01)   */
#define GPIOF_BTGLR_BTGL11_Pos                    (11UL)                       /*!< BTGL11 (Bit 11)                */
#define GPIOF_BTGLR_BTGL11_Msk                    (0x00000800UL)               /*!< BTGL11 (Bitfield-Mask: 0x01)   */
#define GPIOF_BTGLR_BTGL10_Pos                    (10UL)                       /*!< BTGL10 (Bit 10)                */
#define GPIOF_BTGLR_BTGL10_Msk                    (0x00000400UL)               /*!< BTGL10 (Bitfield-Mask: 0x01)   */
#define GPIOF_BTGLR_BTGL9_Pos                     (9UL)                        /*!< BTGL9 (Bit 9)                  */
#define GPIOF_BTGLR_BTGL9_Msk                     (0x00000200UL)               /*!< BTGL9 (Bitfield-Mask: 0x01)    */
#define GPIOF_BTGLR_BTGL8_Pos                     (8UL)                        /*!< BTGL8 (Bit 8)                  */
#define GPIOF_BTGLR_BTGL8_Msk                     (0x00000100UL)               /*!< BTGL8 (Bitfield-Mask: 0x01)    */
#define GPIOF_BTGLR_BTGL7_Pos                     (7UL)                        /*!< BTGL7 (Bit 7)                  */
#define GPIOF_BTGLR_BTGL7_Msk                     (0x00000080UL)               /*!< BTGL7 (Bitfield-Mask: 0x01)    */
#define GPIOF_BTGLR_BTGL6_Pos                     (6UL)                        /*!< BTGL6 (Bit 6)                  */
#define GPIOF_BTGLR_BTGL6_Msk                     (0x00000040UL)               /*!< BTGL6 (Bitfield-Mask: 0x01)    */
#define GPIOF_BTGLR_BTGL5_Pos                     (5UL)                        /*!< BTGL5 (Bit 5)                  */
#define GPIOF_BTGLR_BTGL5_Msk                     (0x00000020UL)               /*!< BTGL5 (Bitfield-Mask: 0x01)    */
#define GPIOF_BTGLR_BTGL4_Pos                     (4UL)                        /*!< BTGL4 (Bit 4)                  */
#define GPIOF_BTGLR_BTGL4_Msk                     (0x00000010UL)               /*!< BTGL4 (Bitfield-Mask: 0x01)    */
#define GPIOF_BTGLR_BTGL3_Pos                     (3UL)                        /*!< BTGL3 (Bit 3)                  */
#define GPIOF_BTGLR_BTGL3_Msk                     (0x00000008UL)               /*!< BTGL3 (Bitfield-Mask: 0x01)    */
#define GPIOF_BTGLR_BTGL2_Pos                     (2UL)                        /*!< BTGL2 (Bit 2)                  */
#define GPIOF_BTGLR_BTGL2_Msk                     (0x00000004UL)               /*!< BTGL2 (Bitfield-Mask: 0x01)    */
#define GPIOF_BTGLR_BTGL1_Pos                     (1UL)                        /*!< BTGL1 (Bit 1)                  */
#define GPIOF_BTGLR_BTGL1_Msk                     (0x00000002UL)               /*!< BTGL1 (Bitfield-Mask: 0x01)    */
#define GPIOF_BTGLR_BTGL0_Pos                     (0UL)                        /*!< BTGL0 (Bit 0)                  */
#define GPIOF_BTGLR_BTGL0_Msk                     (0x00000001UL)               /*!< BTGL0 (Bitfield-Mask: 0x01)    */
/* =============================  DR_BSRR  ================================== */
#define GPIOF_DR_BSRR_BR15_Pos                    (31UL)                       /*!< BR15 (Bit 31)                  */
#define GPIOF_DR_BSRR_BR15_Msk                    (0x80000000UL)               /*!< BR15 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BR14_Pos                    (30UL)                       /*!< BR14 (Bit 30)                  */
#define GPIOF_DR_BSRR_BR14_Msk                    (0x40000000UL)               /*!< BR14 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BR13_Pos                    (29UL)                       /*!< BR13 (Bit 29)                  */
#define GPIOF_DR_BSRR_BR13_Msk                    (0x20000000UL)               /*!< BR13 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BR12_Pos                    (28UL)                       /*!< BR12 (Bit 28)                  */
#define GPIOF_DR_BSRR_BR12_Msk                    (0x10000000UL)               /*!< BR12 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BR11_Pos                    (27UL)                       /*!< BR11 (Bit 27)                  */
#define GPIOF_DR_BSRR_BR11_Msk                    (0x08000000UL)               /*!< BR11 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BR10_Pos                    (26UL)                       /*!< BR10 (Bit 26)                  */
#define GPIOF_DR_BSRR_BR10_Msk                    (0x04000000UL)               /*!< BR10 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BR9_Pos                     (25UL)                       /*!< BR9 (Bit 25)                   */
#define GPIOF_DR_BSRR_BR9_Msk                     (0x02000000UL)               /*!< BR9 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BR8_Pos                     (24UL)                       /*!< BR8 (Bit 24)                   */
#define GPIOF_DR_BSRR_BR8_Msk                     (0x01000000UL)               /*!< BR8 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BR7_Pos                     (23UL)                       /*!< BR7 (Bit 23)                   */
#define GPIOF_DR_BSRR_BR7_Msk                     (0x00800000UL)               /*!< BR7 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BR6_Pos                     (22UL)                       /*!< BR6 (Bit 22)                   */
#define GPIOF_DR_BSRR_BR6_Msk                     (0x00400000UL)               /*!< BR6 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BR5_Pos                     (21UL)                       /*!< BR5 (Bit 21)                   */
#define GPIOF_DR_BSRR_BR5_Msk                     (0x00200000UL)               /*!< BR5 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BR4_Pos                     (20UL)                       /*!< BR4 (Bit 20)                   */
#define GPIOF_DR_BSRR_BR4_Msk                     (0x00100000UL)               /*!< BR4 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BR3_Pos                     (19UL)                       /*!< BR3 (Bit 19)                   */
#define GPIOF_DR_BSRR_BR3_Msk                     (0x00080000UL)               /*!< BR3 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BR2_Pos                     (18UL)                       /*!< BR2 (Bit 18)                   */
#define GPIOF_DR_BSRR_BR2_Msk                     (0x00040000UL)               /*!< BR2 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BR1_Pos                     (17UL)                       /*!< BR1 (Bit 17)                   */
#define GPIOF_DR_BSRR_BR1_Msk                     (0x00020000UL)               /*!< BR1 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BR0_Pos                     (16UL)                       /*!< BR0 (Bit 16)                   */
#define GPIOF_DR_BSRR_BR0_Msk                     (0x00010000UL)               /*!< BR0 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BS15_Pos                    (15UL)                       /*!< BS15 (Bit 15)                  */
#define GPIOF_DR_BSRR_BS15_Msk                    (0x00008000UL)               /*!< BS15 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BS14_Pos                    (14UL)                       /*!< BS14 (Bit 14)                  */
#define GPIOF_DR_BSRR_BS14_Msk                    (0x00004000UL)               /*!< BS14 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BS13_Pos                    (13UL)                       /*!< BS13 (Bit 13)                  */
#define GPIOF_DR_BSRR_BS13_Msk                    (0x00002000UL)               /*!< BS13 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BS12_Pos                    (12UL)                       /*!< BS12 (Bit 12)                  */
#define GPIOF_DR_BSRR_BS12_Msk                    (0x00001000UL)               /*!< BS12 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BS11_Pos                    (11UL)                       /*!< BS11 (Bit 11)                  */
#define GPIOF_DR_BSRR_BS11_Msk                    (0x00000800UL)               /*!< BS11 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BS10_Pos                    (10UL)                       /*!< BS10 (Bit 10)                  */
#define GPIOF_DR_BSRR_BS10_Msk                    (0x00004000UL)               /*!< BS10 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_BSRR_BS9_Pos                     (9UL)                        /*!< BS9 (Bit 9)                    */
#define GPIOF_DR_BSRR_BS9_Msk                     (0x00000200UL)               /*!< BS9 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BS8_Pos                     (8UL)                        /*!< BS8 (Bit 8)                    */
#define GPIOF_DR_BSRR_BS8_Msk                     (0x00000100UL)               /*!< BS8 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BS7_Pos                     (7UL)                        /*!< BS7 (Bit 7)                    */
#define GPIOF_DR_BSRR_BS7_Msk                     (0x00000080UL)               /*!< BS7 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BS6_Pos                     (6UL)                        /*!< BS6 (Bit 6)                    */
#define GPIOF_DR_BSRR_BS6_Msk                     (0x00000040UL)               /*!< BS6 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BS5_Pos                     (5UL)                        /*!< BS5 (Bit 5)                    */
#define GPIOF_DR_BSRR_BS5_Msk                     (0x00000020UL)               /*!< BS5 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BS4_Pos                     (4UL)                        /*!< BS4 (Bit 4)                    */
#define GPIOF_DR_BSRR_BS4_Msk                     (0x00000010UL)               /*!< BS4 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BS3_Pos                     (3UL)                        /*!< BS3 (Bit 3)                    */
#define GPIOF_DR_BSRR_BS3_Msk                     (0x00000008UL)               /*!< BS3 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BS2_Pos                     (2UL)                        /*!< BS2 (Bit 2)                    */
#define GPIOF_DR_BSRR_BS2_Msk                     (0x00000004UL)               /*!< BS2 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BS1_Pos                     (1UL)                        /*!< BS1 (Bit 1)                    */
#define GPIOF_DR_BSRR_BS1_Msk                     (0x00000002UL)               /*!< BS1 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_BSRR_BS0_Pos                     (0UL)                        /*!< BS0 (Bit 0)                    */
#define GPIOF_DR_BSRR_BS0_Msk                     (0x00000001UL)               /*!< BS0 (Bitfield-Mask: 0x01)      */
/* ==================================  DR  ================================== */
#define GPIOF_DR_DR15_Pos                         (15UL)                       /*!< DR15 (Bit 15)                  */
#define GPIOF_DR_DR15_Msk                         (0x00008000UL)               /*!< DR15 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_DR14_Pos                         (14UL)                       /*!< DR14 (Bit 14)                  */
#define GPIOF_DR_DR14_Msk                         (0x00004000UL)               /*!< DR14 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_DR13_Pos                         (13UL)                       /*!< DR13 (Bit 13)                  */
#define GPIOF_DR_DR13_Msk                         (0x00002000UL)               /*!< DR13 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_DR12_Pos                         (12UL)                       /*!< DR12 (Bit 12)                  */
#define GPIOF_DR_DR12_Msk                         (0x00001000UL)               /*!< DR12 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_DR11_Pos                         (11UL)                       /*!< DR11 (Bit 11)                  */
#define GPIOF_DR_DR11_Msk                         (0x00000800UL)               /*!< DR11 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_DR10_Pos                         (10UL)                       /*!< DR10 (Bit 10)                  */
#define GPIOF_DR_DR10_Msk                         (0x00000400UL)               /*!< DR10 (Bitfield-Mask: 0x01)     */
#define GPIOF_DR_DR9_Pos                          (9UL)                        /*!< DR9 (Bit 9)                    */
#define GPIOF_DR_DR9_Msk                          (0x00000200UL)               /*!< DR9 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_DR8_Pos                          (8UL)                        /*!< DR8 (Bit 8)                    */
#define GPIOF_DR_DR8_Msk                          (0x00000100UL)               /*!< DR8 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_DR7_Pos                          (7UL)                        /*!< DR7 (Bit 7)                    */
#define GPIOF_DR_DR7_Msk                          (0x00000080UL)               /*!< DR7 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_DR6_Pos                          (6UL)                        /*!< DR6 (Bit 6)                    */
#define GPIOF_DR_DR6_Msk                          (0x00000040UL)               /*!< DR6 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_DR5_Pos                          (5UL)                        /*!< DR5 (Bit 5)                    */
#define GPIOF_DR_DR5_Msk                          (0x00000020UL)               /*!< DR5 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_DR4_Pos                          (4UL)                        /*!< DR4 (Bit 4)                    */
#define GPIOF_DR_DR4_Msk                          (0x00000010UL)               /*!< DR4 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_DR3_Pos                          (3UL)                        /*!< DR3 (Bit 3)                    */
#define GPIOF_DR_DR3_Msk                          (0x00000008UL)               /*!< DR3 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_DR2_Pos                          (2UL)                        /*!< DR2 (Bit 2)                    */
#define GPIOF_DR_DR2_Msk                          (0x00000004UL)               /*!< DR2 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_DR1_Pos                          (1UL)                        /*!< DR1 (Bit 1)                    */
#define GPIOF_DR_DR1_Msk                          (0x00000002UL)               /*!< DR1 (Bitfield-Mask: 0x01)      */
#define GPIOF_DR_DR0_Pos                          (0UL)                        /*!< DR0 (Bit 0)                    */
#define GPIOF_DR_DR0_Msk                          (0x00000001UL)               /*!< DR0 (Bitfield-Mask: 0x01)      */
/* ===============================  CS_BSRR  ================================ */
#define GPIOF_CS_BSRR_BR15_Pos                    (31UL)                       /*!< BR15 (Bit 31)                  */
#define GPIOF_CS_BSRR_BR15_Msk                    (0x80000000UL)               /*!< BR15 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BR14_Pos                    (30UL)                       /*!< BR14 (Bit 30)                  */
#define GPIOF_CS_BSRR_BR14_Msk                    (0x40000000UL)               /*!< BR14 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BR13_Pos                    (29UL)                       /*!< BR13 (Bit 29)                  */
#define GPIOF_CS_BSRR_BR13_Msk                    (0x20000000UL)               /*!< BR13 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BR12_Pos                    (28UL)                       /*!< BR12 (Bit 28)                  */
#define GPIOF_CS_BSRR_BR12_Msk                    (0x10000000UL)               /*!< BR12 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BR11_Pos                    (27UL)                       /*!< BR11 (Bit 27)                  */
#define GPIOF_CS_BSRR_BR11_Msk                    (0x08000000UL)               /*!< BR11 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BR10_Pos                    (26UL)                       /*!< BR10 (Bit 26)                  */
#define GPIOF_CS_BSRR_BR10_Msk                    (0x04000000UL)               /*!< BR10 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BR9_Pos                     (25UL)                       /*!< BR9 (Bit 25)                   */
#define GPIOF_CS_BSRR_BR9_Msk                     (0x02000000UL)               /*!< BR9 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BR8_Pos                     (24UL)                       /*!< BR8 (Bit 24)                   */
#define GPIOF_CS_BSRR_BR8_Msk                     (0x01000000UL)               /*!< BR8 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BR7_Pos                     (23UL)                       /*!< BR7 (Bit 23)                   */
#define GPIOF_CS_BSRR_BR7_Msk                     (0x00800000UL)               /*!< BR7 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BR6_Pos                     (22UL)                       /*!< BR6 (Bit 22)                   */
#define GPIOF_CS_BSRR_BR6_Msk                     (0x00400000UL)               /*!< BR6 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BR5_Pos                     (21UL)                       /*!< BR5 (Bit 21)                   */
#define GPIOF_CS_BSRR_BR5_Msk                     (0x00200000UL)               /*!< BR5 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BR4_Pos                     (20UL)                       /*!< BR4 (Bit 20)                   */
#define GPIOF_CS_BSRR_BR4_Msk                     (0x00100000UL)               /*!< BR4 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BR3_Pos                     (19UL)                       /*!< BR3 (Bit 19)                   */
#define GPIOF_CS_BSRR_BR3_Msk                     (0x00080000UL)               /*!< BR3 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BR2_Pos                     (18UL)                       /*!< BR2 (Bit 18)                   */
#define GPIOF_CS_BSRR_BR2_Msk                     (0x00040000UL)               /*!< BR2 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BR1_Pos                     (17UL)                       /*!< BR1 (Bit 17)                   */
#define GPIOF_CS_BSRR_BR1_Msk                     (0x00020000UL)               /*!< BR1 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BR0_Pos                     (16UL)                       /*!< BR0 (Bit 16)                   */
#define GPIOF_CS_BSRR_BR0_Msk                     (0x00010000UL)               /*!< BR0 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BS15_Pos                    (15UL)                       /*!< BS15 (Bit 15)                  */
#define GPIOF_CS_BSRR_BS15_Msk                    (0x00008000UL)               /*!< BS15 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BS14_Pos                    (14UL)                       /*!< BS14 (Bit 14)                  */
#define GPIOF_CS_BSRR_BS14_Msk                    (0x00004000UL)               /*!< BS14 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BS13_Pos                    (13UL)                       /*!< BS13 (Bit 13)                  */
#define GPIOF_CS_BSRR_BS13_Msk                    (0x00002000UL)               /*!< BS13 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BS12_Pos                    (12UL)                       /*!< BS12 (Bit 12)                  */
#define GPIOF_CS_BSRR_BS12_Msk                    (0x00001000UL)               /*!< BS12 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BS11_Pos                    (11UL)                       /*!< BS11 (Bit 11)                  */
#define GPIOF_CS_BSRR_BS11_Msk                    (0x00000800UL)               /*!< BS11 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BS10_Pos                    (10UL)                       /*!< BS10 (Bit 10)                  */
#define GPIOF_CS_BSRR_BS10_Msk                    (0x00000400UL)               /*!< BS10 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_BSRR_BS9_Pos                     (9UL)                        /*!< BS9 (Bit 9)                    */
#define GPIOF_CS_BSRR_BS9_Msk                     (0x00000200UL)               /*!< BS9 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BS8_Pos                     (8UL)                        /*!< BS8 (Bit 8)                    */
#define GPIOF_CS_BSRR_BS8_Msk                     (0x00000100UL)               /*!< BS8 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BS7_Pos                     (7UL)                        /*!< BS7 (Bit 7)                    */
#define GPIOF_CS_BSRR_BS7_Msk                     (0x00000080UL)               /*!< BS7 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BS6_Pos                     (6UL)                        /*!< BS6 (Bit 6)                    */
#define GPIOF_CS_BSRR_BS6_Msk                     (0x00000040UL)               /*!< BS6 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BS5_Pos                     (5UL)                        /*!< BS5 (Bit 5)                    */
#define GPIOF_CS_BSRR_BS5_Msk                     (0x00000020UL)               /*!< BS5 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BS4_Pos                     (4UL)                        /*!< BS4 (Bit 4)                    */
#define GPIOF_CS_BSRR_BS4_Msk                     (0x00000010UL)               /*!< BS4 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BS3_Pos                     (3UL)                        /*!< BS3 (Bit 3)                    */
#define GPIOF_CS_BSRR_BS3_Msk                     (0x00000008UL)               /*!< BS3 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BS2_Pos                     (2UL)                        /*!< BS2 (Bit 2)                    */
#define GPIOF_CS_BSRR_BS2_Msk                     (0x00000004UL)               /*!< BS2 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BS1_Pos                     (1UL)                        /*!< BS1 (Bit 1)                    */
#define GPIOF_CS_BSRR_BS1_Msk                     (0x00000002UL)               /*!< BS1 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_BSRR_BS0_Pos                     (0UL)                        /*!< BS0 (Bit 0)                    */
#define GPIOF_CS_BSRR_BS0_Msk                     (0x00000001UL)               /*!< BS0 (Bitfield-Mask: 0x01)      */
/* ================================  CS  ==================================== */
#define GPIOF_CS_CS15_Pos                         (15UL)                       /*!< CS15 (Bit 15)                  */
#define GPIOF_CS_CS15_Msk                         (0x00008000UL)               /*!< CS15 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_CS14_Pos                         (14UL)                       /*!< CS14 (Bit 14)                  */
#define GPIOF_CS_CS14_Msk                         (0x00004000UL)               /*!< CS14 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_CS13_Pos                         (13UL)                       /*!< CS13 (Bit 13)                  */
#define GPIOF_CS_CS13_Msk                         (0x00002000UL)               /*!< CS13 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_CS12_Pos                         (12UL)                       /*!< CS12 (Bit 12)                  */
#define GPIOF_CS_CS12_Msk                         (0x00001000UL)               /*!< CS12 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_CS11_Pos                         (11UL)                       /*!< CS11 (Bit 11)                  */
#define GPIOF_CS_CS11_Msk                         (0x00000800UL)               /*!< CS11 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_CS10_Pos                         (10UL)                       /*!< CS10 (Bit 10)                  */
#define GPIOF_CS_CS10_Msk                         (0x00000400UL)               /*!< CS10 (Bitfield-Mask: 0x01)     */
#define GPIOF_CS_CS9_Pos                          (9UL)                        /*!< CS9 (Bit 9)                    */
#define GPIOF_CS_CS9_Msk                          (0x00000200UL)               /*!< CS9 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_CS8_Pos                          (8UL)                        /*!< CS8 (Bit 8)                    */
#define GPIOF_CS_CS8_Msk                          (0x00000100UL)               /*!< CS8 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_CS7_Pos                          (7UL)                        /*!< CS7 (Bit 7)                    */
#define GPIOF_CS_CS7_Msk                          (0x00000080UL)               /*!< CS7 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_CS6_Pos                          (6UL)                        /*!< CS6 (Bit 6)                    */
#define GPIOF_CS_CS6_Msk                          (0x00000040UL)               /*!< CS6 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_CS5_Pos                          (5UL)                        /*!< CS5 (Bit 5)                    */
#define GPIOF_CS_CS5_Msk                          (0x00000020UL)               /*!< CS5 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_CS4_Pos                          (4UL)                        /*!< CS4 (Bit 4)                    */
#define GPIOF_CS_CS4_Msk                          (0x00000010UL)               /*!< CS4 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_CS3_Pos                          (3UL)                        /*!< CS3 (Bit 3)                    */
#define GPIOF_CS_CS3_Msk                          (0x00000008UL)               /*!< CS3 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_CS2_Pos                          (2UL)                        /*!< CS2 (Bit 2)                    */
#define GPIOF_CS_CS2_Msk                          (0x00000004UL)               /*!< CS2 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_CS1_Pos                          (1UL)                        /*!< CS1 (Bit 1)                    */
#define GPIOF_CS_CS1_Msk                          (0x00000002UL)               /*!< CS1 (Bitfield-Mask: 0x01)      */
#define GPIOF_CS_CS0_Pos                          (0UL)                        /*!< CS0 (Bit 0)                    */
#define GPIOF_CS_CS0_Msk                          (0x00000001UL)               /*!< CS0 (Bitfield-Mask: 0x01)      */
/* ==============================  OS_BSRR  ================================= */
#define GPIOF_OS_BSRR_BR15_Pos                    (31UL)                       /*!< BR15 (Bit 31)                  */
#define GPIOF_OS_BSRR_BR15_Msk                    (0x80000000UL)               /*!< BR15 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BR14_Pos                    (30UL)                       /*!< BR14 (Bit 30)                  */
#define GPIOF_OS_BSRR_BR14_Msk                    (0x40000000UL)               /*!< BR14 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BR13_Pos                    (29UL)                       /*!< BR13 (Bit 29)                  */
#define GPIOF_OS_BSRR_BR13_Msk                    (0x20000000UL)               /*!< BR13 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BR12_Pos                    (28UL)                       /*!< BR12 (Bit 28)                  */
#define GPIOF_OS_BSRR_BR12_Msk                    (0x10000000UL)               /*!< BR12 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BR11_Pos                    (27UL)                       /*!< BR11 (Bit 27)                  */
#define GPIOF_OS_BSRR_BR11_Msk                    (0x08000000UL)               /*!< BR11 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BR10_Pos                    (26UL)                       /*!< BR10 (Bit 26)                  */
#define GPIOF_OS_BSRR_BR10_Msk                    (0x04000000UL)               /*!< BR10 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BR9_Pos                     (25UL)                       /*!< BR9 (Bit 25)                   */
#define GPIOF_OS_BSRR_BR9_Msk                     (0x02000000UL)               /*!< BR9 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BR8_Pos                     (24UL)                       /*!< BR8 (Bit 24)                   */
#define GPIOF_OS_BSRR_BR8_Msk                     (0x01000000UL)               /*!< BR8 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BR7_Pos                     (23UL)                       /*!< BR7 (Bit 23)                   */
#define GPIOF_OS_BSRR_BR7_Msk                     (0x00800000UL)               /*!< BR7 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BR6_Pos                     (22UL)                       /*!< BR6 (Bit 22)                   */
#define GPIOF_OS_BSRR_BR6_Msk                     (0x00400000UL)               /*!< BR6 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BR5_Pos                     (21UL)                       /*!< BR5 (Bit 21)                   */
#define GPIOF_OS_BSRR_BR5_Msk                     (0x00200000UL)               /*!< BR5 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BR4_Pos                     (20UL)                       /*!< BR4 (Bit 20)                   */
#define GPIOF_OS_BSRR_BR4_Msk                     (0x00100000UL)               /*!< BR4 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BR3_Pos                     (19UL)                       /*!< BR3 (Bit 19)                   */
#define GPIOF_OS_BSRR_BR3_Msk                     (0x00080000UL)               /*!< BR3 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BR2_Pos                     (18UL)                       /*!< BR2 (Bit 18)                   */
#define GPIOF_OS_BSRR_BR2_Msk                     (0x00040000UL)               /*!< BR2 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BR1_Pos                     (17UL)                       /*!< BR1 (Bit 17)                   */
#define GPIOF_OS_BSRR_BR1_Msk                     (0x00020000UL)               /*!< BR1 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BR0_Pos                     (16UL)                       /*!< BR0 (Bit 16)                   */
#define GPIOF_OS_BSRR_BR0_Msk                     (0x00010000UL)               /*!< BR0 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BS15_Pos                    (15UL)                       /*!< BS15 (Bit 15)                  */
#define GPIOF_OS_BSRR_BS15_Msk                    (0x00008000UL)               /*!< BS15 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BS14_Pos                    (14UL)                       /*!< BS14 (Bit 14)                  */
#define GPIOF_OS_BSRR_BS14_Msk                    (0x00004000UL)               /*!< BS14 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BS13_Pos                    (13UL)                       /*!< BS13 (Bit 13)                  */
#define GPIOF_OS_BSRR_BS13_Msk                    (0x00002000UL)               /*!< BS13 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BS12_Pos                    (12UL)                       /*!< BS12 (Bit 12)                  */
#define GPIOF_OS_BSRR_BS12_Msk                    (0x00001000UL)               /*!< BS12 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BS11_Pos                    (11UL)                       /*!< BS11 (Bit 11)                  */
#define GPIOF_OS_BSRR_BS11_Msk                    (0x00000800UL)               /*!< BS11 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BS10_Pos                    (10UL)                       /*!< BS10 (Bit 10)                  */
#define GPIOF_OS_BSRR_BS10_Msk                    (0x00000400UL)               /*!< BS10 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_BSRR_BS9_Pos                     (9UL)                        /*!< BS9 (Bit 9)                    */
#define GPIOF_OS_BSRR_BS9_Msk                     (0x00000200UL)               /*!< BS9 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BS8_Pos                     (8UL)                        /*!< BS8 (Bit 8)                    */
#define GPIOF_OS_BSRR_BS8_Msk                     (0x00000100UL)               /*!< BS8 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BS7_Pos                     (7UL)                        /*!< BS7 (Bit 7)                    */
#define GPIOF_OS_BSRR_BS7_Msk                     (0x00000080UL)               /*!< BS7 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BS6_Pos                     (6UL)                        /*!< BS6 (Bit 6)                    */
#define GPIOF_OS_BSRR_BS6_Msk                     (0x00000040UL)               /*!< BS6 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BS5_Pos                     (5UL)                        /*!< BS5 (Bit 5)                    */
#define GPIOF_OS_BSRR_BS5_Msk                     (0x00000020UL)               /*!< BS5 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BS4_Pos                     (4UL)                        /*!< BS4 (Bit 4)                    */
#define GPIOF_OS_BSRR_BS4_Msk                     (0x00000010UL)               /*!< BS4 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BS3_Pos                     (3UL)                        /*!< BS3 (Bit 3)                    */
#define GPIOF_OS_BSRR_BS3_Msk                     (0x00000008UL)               /*!< BS3 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BS2_Pos                     (2UL)                        /*!< BS2 (Bit 2)                    */
#define GPIOF_OS_BSRR_BS2_Msk                     (0x00000004UL)               /*!< BS2 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BS1_Pos                     (1UL)                        /*!< BS1 (Bit 1)                    */
#define GPIOF_OS_BSRR_BS1_Msk                     (0x00000002UL)               /*!< BS1 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_BSRR_BS0_Pos                     (0UL)                        /*!< BS0 (Bit 0)                    */
#define GPIOF_OS_BSRR_BS0_Msk                     (0x00000001UL)               /*!< BS0 (Bitfield-Mask: 0x01)      */
/* ================================  OS  ==================================== */
#define GPIOF_OS_OS15_Pos                         (15UL)                       /*!< OS15 (Bit 15)                  */
#define GPIOF_OS_OS15_Msk                         (0x00008000UL)               /*!< OS15 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_OS14_Pos                         (14UL)                       /*!< OS14 (Bit 14)                  */
#define GPIOF_OS_OS14_Msk                         (0x00004000UL)               /*!< OS14 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_OS13_Pos                         (13UL)                       /*!< OS13 (Bit 13)                  */
#define GPIOF_OS_OS13_Msk                         (0x00002000UL)               /*!< OS13 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_OS12_Pos                         (12UL)                       /*!< OS12 (Bit 12)                  */
#define GPIOF_OS_OS12_Msk                         (0x00001000UL)               /*!< OS12 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_OS11_Pos                         (11UL)                       /*!< OS11 (Bit 11)                  */
#define GPIOF_OS_OS11_Msk                         (0x00000800UL)               /*!< OS11 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_OS10_Pos                         (10UL)                       /*!< OS10 (Bit 10)                  */
#define GPIOF_OS_OS10_Msk                         (0x00000400UL)               /*!< OS10 (Bitfield-Mask: 0x01)     */
#define GPIOF_OS_OS9_Pos                          (9UL)                        /*!< OS9 (Bit 9)                    */
#define GPIOF_OS_OS9_Msk                          (0x00000200UL)               /*!< OS9 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_OS8_Pos                          (8UL)                        /*!< OS8 (Bit 8)                    */
#define GPIOF_OS_OS8_Msk                          (0x00000100UL)               /*!< OS8 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_OS7_Pos                          (7UL)                        /*!< OS7 (Bit 7)                    */
#define GPIOF_OS_OS7_Msk                          (0x00000080UL)               /*!< OS7 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_OS6_Pos                          (6UL)                        /*!< OS6 (Bit 6)                    */
#define GPIOF_OS_OS6_Msk                          (0x00000040UL)               /*!< OS6 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_OS5_Pos                          (5UL)                        /*!< OS5 (Bit 5)                    */
#define GPIOF_OS_OS5_Msk                          (0x00000020UL)               /*!< OS5 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_OS4_Pos                          (4UL)                        /*!< OS4 (Bit 4)                    */
#define GPIOF_OS_OS4_Msk                          (0x00000010UL)               /*!< OS4 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_OS3_Pos                          (3UL)                        /*!< OS3 (Bit 3)                    */
#define GPIOF_OS_OS3_Msk                          (0x00000008UL)               /*!< OS3 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_OS2_Pos                          (2UL)                        /*!< OS2 (Bit 2)                    */
#define GPIOF_OS_OS2_Msk                          (0x00000004UL)               /*!< OS2 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_OS1_Pos                          (1UL)                        /*!< OS1 (Bit 1)                    */
#define GPIOF_OS_OS1_Msk                          (0x00000002UL)               /*!< OS1 (Bitfield-Mask: 0x01)      */
#define GPIOF_OS_OS0_Pos                          (0UL)                        /*!< OS0 (Bit 0)                    */
#define GPIOF_OS_OS0_Msk                          (0x00000001UL)               /*!< OS0 (Bitfield-Mask: 0x01)      */

/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */

void GPIO_DeInit(GPIO_TypeDef *GPIOx);
void GPIO_Init(GPIO_TypeDef *GPIOx, GPIO_InitTypeDef *GPIO_InitStruct);
void GPIO_StructInit(GPIO_InitTypeDef *GPIO_InitStruct);
void GPIO_PinLockConfig(GPIO_TypeDef *GPIOx, uint16_t GPIO_Pin);
uint8_t GPIO_ReadInputDataBit(GPIO_TypeDef *GPIOx, uint16_t GPIO_Pin);
uint16_t GPIO_ReadInputData(GPIO_TypeDef *GPIOx);
uint8_t GPIO_ReadOutputDataBit(GPIO_TypeDef *GPIOx, uint16_t GPIO_Pin);
uint16_t GPIO_ReadOutputData(GPIO_TypeDef *GPIOx);
void GPIO_SetBits(GPIO_TypeDef *GPIOx, uint16_t GPIO_Pin);
void GPIO_ResetBits(GPIO_TypeDef *GPIOx, uint16_t GPIO_Pin);
void GPIO_WriteBit(GPIO_TypeDef *GPIOx, uint16_t GPIO_Pin, BitAction BitVal);
void GPIO_Write(GPIO_TypeDef *GPIOx, uint16_t PortVal);
void GPIO_PinAFConfig(GPIO_TypeDef *GPIOx, uint16_t GPIO_PinSource, uint8_t GPIO_AF);
void GPIO_DriveConfig(GPIO_TypeDef *GPIOx, uint16_t GPIO_Pin, uint16_t GPIO_Drive);
void GPIO_BitToggle(GPIO_TypeDef *GPIOx, uint16_t GPIO_Pin);
void GPIO_InputCMOSCmd(GPIO_TypeDef *GPIOx, uint16_t GPIO_Pin, FunctionalState NewState);
void GPIO_AnaModeSet(GPIO_TypeDef *GPIOx, uint16_t GPIO_PinSource, uint32_t GPIO_AN1, uint32_t GPIO_AN2);
void GPIO_ResetPB2Config(uint32_t NewState);
#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_GPIO_H__
