/**
  ******************************************************************************
  * @file    lcm32f06x_eeprom.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for eeprom.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_EEPROM_H__
#define __LCM32F06X_EEPROM_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

#ifdef __cplusplus
  extern "C" {
#endif

/* Define the size of the sectors to be used */
#define PAGE_SIZE            ((uint32_t)0x0200) /*@EN: One page size of 512 bytes @CN: ÿҳС 512 bytes  */

/* EEPROM start address in Flash */
#define EEPROM_START_ADDRESS ((uint32_t)0x1FFFF000) /*@EN: EEPROM emulation start address: Data memory start address
                                                      @CN: EEPROMģʼַ: û洢ʼַ */

/* Pages 0 and 1 base and end addresses */
#define PAGE0_BASE_ADDRESS   ((uint32_t)(EEPROM_START_ADDRESS + (PAGE_SIZE * 0))) /*@EN: PAGE0 base address @CN: PAGE0 ַ */
#define PAGE0_HALF_ADDRESS   ((uint32_t)(PAGE0_BASE_ADDRESS   + (PAGE_SIZE / 2))) /*@EN: PAGE0 half address @CN: PAGE0 ҳַ */
#define PAGE0_END_ADDRESS    ((uint32_t)(PAGE0_BASE_ADDRESS   + ((PAGE_SIZE) - 1))) /*@EN: PAGE0 end address  @CN: PAGE0 βַ */
#define PAGE1_BASE_ADDRESS   ((uint32_t)(EEPROM_START_ADDRESS + (PAGE_SIZE * 1))) /*@EN: PAGE1 base address @CN: PAGE1 ַ */
#define PAGE1_HALF_ADDRESS   ((uint32_t)(PAGE1_BASE_ADDRESS   + (PAGE_SIZE / 2))) /*@EN: PAGE0 half address @CN: PAGE0 ҳַ */
#define PAGE1_END_ADDRESS    ((uint32_t)(PAGE1_BASE_ADDRESS   + (PAGE_SIZE - 1))) /*@EN: PAGE1 end address  @CN: PAGE1 βַ */

/* Used Flash pages for EEPROM emulation */
#define PAGE0                ((uint16_t)0x0000)  /*@EN: PAGE0 flag @CN: PAGE0 ־ */
#define PAGE1                ((uint16_t)0x0001)  /*@EN: PAGE1 flag @CN: PAGE1 ־ */
#define NO_VALID_PAGE        ((uint16_t)0x00AB)  /*@EN: No valid page @CN: ûЧҳ */

/* Page status definitions */
#define ERASED               ((uint32_t)0xFFFFFFFF) /*@EN: Page is empty @CN: ҳΪ */
#define RECEIVE_DATA         ((uint32_t)0xFFFFEEEE) /*@EN: Page marked as receiving data @CN: ҳ汻Ϊ */
#define VALID_PAGE           ((uint32_t)0x0000EEEE) /*@EN: Pages containing valid data @CN: Чݵҳ */

#define VALID_PAGE_H         ((uint16_t)0x0000) /*@EN: Page containing valid data @CN: Чݵҳ */
#define VALID_PAGE_L         ((uint16_t)0xEEEE) /*@EN: Page containing valid data @CN: Чݵҳ */

/* Valid pages in read and write defines */
#define READ_FROM_VALID_PAGE ((uint8_t)0x00)  /*@EN: Read Effectively @CN: Ч */
#define WRITE_IN_VALID_PAGE  ((uint8_t)0x01)  /*@EN: Write valid @CN: дЧ */

/* Page full define */
#define PAGE_FULL            ((uint8_t)0x80)  /*@EN: Page Full @CN: ҳ */

/* Variables' number */
#define NB_OF_VAR            ((uint8_t)0x08)  /*@EN: Variables' number @CN:  */

extern uint16_t VirtAddVarTab[NB_OF_VAR];
uint16_t EE_Init(void);
uint16_t EE_ReadVariable(uint16_t VirtAddress, uint16_t *Data);
uint16_t EE_WriteVariable(uint16_t VirtAddress, uint16_t Data);

#ifdef __cplusplus
}
#endif

#endif /* __LCM32F06X_EEPROM_H__ */
