/**
  ******************************************************************************
  * @file    lcm32f06x_dma.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for dma.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_DMA_H__
#define __LCM32F06X_DMA_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

#ifdef __cplusplus
  extern "C" {
#endif

/**
  * @brief  DMA Init structures definition
  */
  typedef struct
  {
    uint32_t DMA_PeripheralBaseAddr; /*!< EN: Specifies the peripheral base address for DMAy Channelx.              
                                          CN: ָ DMAy Channelx ַ
                                          @Register: DMA_SARx/DMA_SARx
                                          @range 0x0 - 0xFFFFFFFF
                                          @default: 0x00000000                */

    uint32_t DMA_MemoryBaseAddr;     /*!< EN: Specifies the memory base address for DMAy Channelx. 
                                          CN: ָ DMAy Channelx ڴַ                                         
                                          @Register: DMA_SARx/DMA_SARx
                                          @range 0x0 - 0xFFFFFFFF
                                          @default: 0x0                       */

    uint32_t DMA_DIR;                /*!< EN: Specifies if the peripheral is the source or destination.
                                          CN: ָԴĿꡣ                                 
                                          @Register: None
                                          @default: DMA_DIR_PeripheralSRC     */

    uint32_t DMA_BufferSize;         /*!< EN: Specifies the buffer size, in data unit, of the specified Channel.
                                          CN: ָָͨĻСΪλ                                         
                                          @Register: DMA_CTLx_H @Bits:[11:0]BLOCK_TS
                                          @range 0x0 - 0x1F
                                          @default: 0x0                       */

    uint32_t DMA_PeripheralInc;      /*!< EN: Specifies whether the Peripheral address register is incremented or not.
                                          CN: ַָĴǷ                                          
                                          @Register: DMA_CTLx_L @Bits:[10:9]SINC @Bits:[8:7]DINC
                                          @default: DMA_PeripheralInc_Enable  */

    uint32_t DMA_MemoryInc;          /*!< EN: Specifies whether the memory address register is incremented or not.
                                          CN: ָڴַĴǷ                                          
                                          @Register: DMA_CTLx_L @Bits:[10:9]SINC @Bits:[8:7]DINC
                                          @default: DMA_MemoryInc_Enable      */

    uint32_t DMA_PeripheralDataSize; /*!< EN: Specifies the Peripheral data width.
                                          CN: ָݿȡ                                          
                                          @Register: DMA_CTLx_L @Bits:[6:4]SRC_TR_WIDTH @Bits:[6:4]DST_TR_WIDTH
                                          @default: DMA_PeripheralDataSize_Byte */

    uint32_t DMA_MemoryDataSize;     /*!< EN: Specifies the Memory data width.
                                          CN: ָڴݿȡ                                          
                                          @Register: DMA_CTLx_L @Bits:[6:4]SRC_TR_WIDTH @Bits:[6:4]DST_TR_WIDTH
                                          @default: DMA_MemoryDataSize_Byte   */

    uint32_t DMA_M2M;                /*!< EN: Specifies if the DMAy Channelx will be used in memory-to-memory transfer.
                                          CN: ָ DMAy Channelx Ƿڴ浽ڴĴ䡣                                          
                                          @Register: DMA_CTLx_L @Bits:[22:20]TT_FC
                                          @default: DMA_P2P_Enable            */

    uint32_t DMA_MSIZE;              /*!< EN: Specifies the size of each transfer for DMAy Channelx.
                                          CN: ָ DMAy Channelx ÿδС                                     
                                          @Register: DMA_CTLx_L @Bits:[16:14]SRC_MSIZE @Bits:[13:11]DST_MSIZE
                                          @default: DMA_MSIZE_1               */
  } DMA_InitTypeDef;


 /* @defgroup DMA_DIR */
#define DMA_DIR_PeripheralSRC               ((uint32_t)0x00000000) /*@EN: P2M @CN: P2M */
#define DMA_DIR_PeripheralDST               ((uint32_t)0x00000001) /*@EN: M2P @CN: M2P */
#define IS_DMA_DIR(DIR)                     (((DIR) == DMA_DIR_PeripheralSRC) || ((DIR) == DMA_DIR_PeripheralDST))
/* @end */
  
/* @defgroup DMA_PeripheralInc */
#define DMA_PeripheralInc_Disable           ((uint8_t)0x03) /*@EN: The P pointer points to a fixed position @CN: P̶ָָλ */
#define DMA_PeripheralInc_Enable            ((uint8_t)0x00) /*@EN: P pointer increment @CN: Pָ */

#define IS_DMA_PERIPHERAL_INC_STATE(STATE)  (((STATE) == DMA_PeripheralInc_Disable) || ((STATE) == DMA_PeripheralInc_Enable))
/* @end */

/* @defgroup DMA_MemoryInc */
#define DMA_MemoryInc_Disable               ((uint8_t)0x03) /*@EN: The M pointer points to a fixed position @CN: M̶ָָλ */
#define DMA_MemoryInc_Enable                ((uint8_t)0x00) /*@EN: M pointer increment @CN: Mָ */
#define IS_DMA_MEMORY_INC_STATE(STATE)      (((STATE) == DMA_MemoryInc_Disable) || ((STATE) == DMA_MemoryInc_Enable))
/* @end */

/* @defgroup DMA_PeripheralDataSize */
#define DMA_PeripheralDataSize_Byte         ((uint8_t)0x00) /*@EN: ÿδ*Pȡ8bits @CN: Read 8bits at a time from *P */
#define DMA_PeripheralDataSize_HalfWord     ((uint8_t)0x01) /*@EN: ÿδ*Pȡ16bits @CN: Read 16bits at a time from *P */
#define DMA_PeripheralDataSize_Word         ((uint8_t)0x02) /*@EN: ÿδ*Pȡ32bits @CN: Read 32bits at a time from *P */
#define IS_DMA_PERIPHERAL_DATA_SIZE(SIZE)   (((SIZE) == DMA_PeripheralDataSize_Byte) ||     \
                                             ((SIZE) == DMA_PeripheralDataSize_HalfWord) || \
                                             ((SIZE) == DMA_PeripheralDataSize_Word))
/* @end */

/* @defgroup DMA_MemoryDataSize */
#define DMA_MemoryDataSize_Byte             ((uint8_t)0x00) /*@EN: ÿδ*Mȡ8bits @CN: Read 8bits at a time from *M */
#define DMA_MemoryDataSize_HalfWord         ((uint8_t)0x01) /*@EN: ÿδ*Mȡ16bits @CN: Read 16bits at a time from *M */
#define DMA_MemoryDataSize_Word             ((uint8_t)0x02) /*@EN: ÿδ*Mȡ32bits @CN: Read 32bits at a time from *M */
#define IS_DMA_MEMORY_DATA_SIZE(SIZE)       (((SIZE) == DMA_MemoryDataSize_Byte) ||     \
                                             ((SIZE) == DMA_MemoryDataSize_HalfWord) || \
                                             ((SIZE) == DMA_MemoryDataSize_Word))
/* @end */

/* @defgroup DMA_M2M */
#define DMA_M2M_Enable                      ((uint8_t)0x00) /*@EN: Memory to Memory @CN: ͣ洢洢  Ҫ */
#define DMA_M2P_Enable                      ((uint8_t)0x01) /*@EN: Memory to Peripheral @CN: ͣ洢 */
#define DMA_P2M_Enable                      ((uint8_t)0x02) /*@EN: Peripheral to Memory @CN: ͣ赽洢 */
#define DMA_P2P_Enable                      ((uint8_t)0x03) /*@EN: Peripheral to Peripheral @CN: ͣ赽 */
#define IS_DMA_M2M_STATE(STATE)             (((STATE) == DMA_M2M_Enable) || ((STATE) == DMA_M2P_Enable) || \
                                             ((STATE) == DMA_P2M_Enable) || ((STATE) == DMA_P2P_Enable))
/* @end */

/* @defgroup DMA_MSIZE */
#define DMA_MSIZE_1                         ((uint8_t)0x00) /*@EN: Continuous transmission length : 1 @CN: 䳤ȣ1 */
#define DMA_MSIZE_4                         ((uint8_t)0x01) /*@EN: Continuous transmission length : 4 @CN: 䳤ȣ4 */
#define DMA_MSIZE_8                         ((uint8_t)0x02) /*@EN: Continuous transmission length : 8 @CN: 䳤ȣ8 */
#define IS_DMA_MSIZE(MSIZE)                 (((MSIZE) == DMA_MSIZE_1) || ((STATE) == DMA_MSIZE_4) || ((STATE) == DMA_MSIZE_8))
/* @end */

/* @defgroup DMA_ReqNum */
#define DMA_ReqNum0                         ((uint8_t)0x00) /*@EN: DMA hardware request interface 0 @CN: DMAӲӿ 0 */
#define DMA_ReqNum1                         ((uint8_t)0x01) /*@EN: DMA hardware request interface 1 @CN: DMAӲӿ 1 */
#define DMA_ReqNum2                         ((uint8_t)0x02) /*@EN: DMA hardware request interface 2 @CN: DMAӲӿ 2 */
#define DMA_ReqNum3                         ((uint8_t)0x03) /*@EN: DMA hardware request interface 3 @CN: DMAӲӿ 3 */
#define DMA_ReqNum4                         ((uint8_t)0x04) /*@EN: DMA hardware request interface 4 @CN: DMAӲӿ 4 */
#define DMA_ReqNum5                         ((uint8_t)0x05) /*@EN: DMA hardware request interface 5 @CN: DMAӲӿ 5 */
#define DMA_ReqNum6                         ((uint8_t)0x06) /*@EN: DMA hardware request interface 6 @CN: DMAӲӿ 6 */
#define DMA_ReqNum7                         ((uint8_t)0x07) /*@EN: DMA hardware request interface 7 @CN: DMAӲӿ 7 */
#define IS_REQ_NUM(DMA_ReqNum)              ((DMA_ReqNum == DMA_ReqNum0) || \
                                             (DMA_ReqNum == DMA_ReqNum1) || \
                                             (DMA_ReqNum == DMA_ReqNum2) || \
                                             (DMA_ReqNum == DMA_ReqNum3) || \
                                             (DMA_ReqNum == DMA_ReqNum4) || \
                                             (DMA_ReqNum == DMA_ReqNum5) || \
                                             (DMA_ReqNum == DMA_ReqNum6) || \
                                             (DMA_ReqNum == DMA_ReqNum7))
/* @end */

/* @defgroup DMA1_Channel */
#define IS_DMA_ALL_PERIPH(PERIPH)           (((PERIPH) == DMA1_Channel0) || ((PERIPH) == DMA1_Channel1) )
/* @end */

/* @defgroup DMAy_FLAG */
#define DMA1_FLAG_TC0                       ((uint8_t)0x00) /*@EN: Channel 0 Block transfer completed @CN: ͨ0鴫 */  
#define DMA1_FLAG_TE0                       ((uint8_t)0x10) /*@EN: Channel 0 Transmission error @CN: ͨ0 */
#define DMA1_FLAG_TC1                       ((uint8_t)0x01) /*@EN: Channel 1 Block transfer completed @CN: ͨ1鴫 */ 
#define DMA1_FLAG_TE1                       ((uint8_t)0x11) /*@EN: Channel 1 Transmission error @CN: ͨ1 */
/* end */

/* @defgroup DMA_IT */
#define DMA1_IT_TC0                          DMA1_FLAG_TC0
#define DMA1_IT_TE0                          DMA1_FLAG_TE0
#define DMA1_IT_TC1                          DMA1_FLAG_TC1
#define DMA1_IT_TE1                          DMA1_FLAG_TE1

#define IS_DMA_CONFIG_IT(IT)                ((IT == DMA1_IT_TC0) || \
                                             (IT == DMA1_IT_TE0) || \
                                             (IT == DMA1_IT_TC1) || \
                                             (IT == DMA1_IT_TE1))

#define IS_DMA_CLEAR_FLAG(IT)               ((IT == DMA1_IT_TC0) || \
                                             (IT == DMA1_IT_TE0) || \
                                             (IT == DMA1_IT_TC1) || \
                                             (IT == DMA1_IT_TE1))

#define IS_DMA_GET_FLAG(DMAy_IT)            ((DMAy_IT == DMA1_IT_TC0) || \
                                             (DMAy_IT == DMA1_IT_TE0) || \
                                             (DMAy_IT == DMA1_IT_TC1) || \
                                             (DMAy_IT == DMA1_IT_TE1))
/* end */

/* @defgroup DMA_Request */
/* REQ7,REQ6,REQ5,REQ4   */
#define DMA_REQ_TIM1_0                      ((uint8_t)0x00) /*@EN: DMA request source TIM1 DMA request 0 @CN: DMAԴ TIM1 DMA0 */
#define DMA_REQ_TIM1_1                      ((uint8_t)0x01) /*@EN: DMA request source TIM1 DMA request 1 @CN: DMAԴ TIM1 DMA1 */
#define DMA_REQ_TIM1_2                      ((uint8_t)0x02) /*@EN: DMA request source TIM1 DMA request 2 @CN: DMAԴ TIM1 DMA2 */
#define DMA_REQ_TIM1_3                      ((uint8_t)0x03) /*@EN: DMA request source TIM1 DMA request 3 @CN: DMAԴ TIM1 DMA3 */
#define DMA_REQ_ADC                         ((uint8_t)0x04) /*@EN: DMA request source ADC @CN: DMAԴ ADC */
#define DMA_REQ_TIM2_CH1                    ((uint8_t)0x05) /*@EN: DMA request source TIM2 CH1 @CN: DMAԴ TIM2 CH1 */
#define DMA_REQ_TIM2_TRIG                   ((uint8_t)0x05) /*@EN: DMA request source TIM2 TRIG @CN: DMAԴ TIM2 TRIG */
#define DMA_REQ_TIM2_CH2                    ((uint8_t)0x06) /*@EN: DMA request source TIM2 CH2 @CN: DMAԴ TIM2 CH2 */
#define DMA_REQ_TIM2_CH3                    ((uint8_t)0x06) /*@EN: DMA request source TIM2 CH3 @CN: DMAԴ TIM2 CH3 */
#define DMA_REQ_TIM2_CH4                    ((uint8_t)0x07) /*@EN: DMA request source TIM2 CH4 @CN: DMAԴ TIM2 CH4 */
#define DMA_REQ_TIM2_UP                     ((uint8_t)0x07) /*@EN: DMA request source TIM2 UP @CN: DMAԴ TIM2 UP */ 
#define DMA_REQ_TIM15                       ((uint8_t)0x09) /*@EN: DMA request source TIM15 @CN: DMAԴ TIM15 */
#define DMA_REQ_TIM16                       ((uint8_t)0x0A) /*@EN: DMA request source TIM16 @CN: DMAԴ TIM16 */
#define DMA_REQ_TIM17                       ((uint8_t)0x0B) /*@EN: DMA request source TIM17 @CN: DMAԴ TIM17 */
#define DMA_REQ_DAC0                        ((uint8_t)0x0F) /*@EN: DMA request source DAC @CN: DMAԴ DAC */
                                                                                          
/* REQ3,REQ2,REQ1,REQ0  */                                                                
#define DMA_REQ_USART0_TX                   ((uint8_t)0x00) /*@EN: DMA request source USART0 TX @CN: DMAԴ USART0 TX */
#define DMA_REQ_USART0_RX                   ((uint8_t)0x01) /*@EN: DMA request source USART0 RX @CN: DMAԴ USART0 RX */
#define DMA_REQ_USART1_TX                   ((uint8_t)0x02) /*@EN: DMA request source USART1 TX @CN: DMAԴ USART1 TX */
#define DMA_REQ_USART1_RX                   ((uint8_t)0x03) /*@EN: DMA request source USART1 RX @CN: DMAԴ USART1 RX */
#define DMA_REQ_I2C0_TX                     ((uint8_t)0x04) /*@EN: DMA request source I2C0 TX @CN: DMAԴ I2C0 TX */
#define DMA_REQ_I2C0_RX                     ((uint8_t)0x05) /*@EN: DMA request source I2C0 RX @CN: DMAԴ I2C0 RX */
#define DMA_REQ_SPI0_TX                     ((uint8_t)0x06) /*@EN: DMA request source SPI0 TX @CN: DMAԴ SPI0 TX */
#define DMA_REQ_SPI0_RX                     ((uint8_t)0x07) /*@EN: DMA request source SPI0 RX @CN: DMAԴ SPI0 RX */
/* end */
#define IS_DMA_REQ(DMA_Request)             ((DMA_Request >= 0x00) && (DMA_Request <= 0x0F))

/* ========================================================================== */
/* ================            DMAC REGISTER BIT               ============== */
/* ========================================================================== */

/* =================================  SAR   ================================= */
#define DMAC_SAR_SAR_Pos                          (0UL)                        /*!< SAR (Bit 0)   */
#define DMAC_SAR_SAR_Msk                          (0xFFFFFFFFUL)               /*!< SAR (Bitfield-Mask: 0xFFFFFFFF)     */
/* =================================  DAR   ================================= */ 
#define DMAC_DAR_DAR_Pos                          (0UL)                        /*!< DAR (Bit 0)                         */
#define DMAC_DAR_DAR_Msk                          (0xFFFFFFFFUL)               /*!< DAR (Bitfield-Mask: 0xFFFFFFFF)     */
/* =================================  CTL_L  ================================ */ 
#define DMAC_CTL_L_TT_FC_Pos                      (20UL)                       /*!< TT_FC (Bit 20)                      */
#define DMAC_CTL_L_TT_FC_Msk                      (0x00700000UL)               /*!< TT_FC (Bitfield-Mask: 0x07)         */
#define DMAC_CTL_L_SRC_MSIZE_Pos                  (14UL)                       /*!< SRC_MSIZE (Bit 14)                  */
#define DMAC_CTL_L_SRC_MSIZE_Msk                  (0x0001C000UL)               /*!< SRC_MSIZE (Bitfield-Mask: 0x07)     */
#define DMAC_CTL_L_DEST_MSIZE_Pos                 (11UL)                       /*!< DEST_MSIZE (Bit 11)                 */
#define DMAC_CTL_L_DEST_MSIZE_Msk                 (0x00003800UL)               /*!< DEST_MSIZE (Bitfield-Mask: 0x07)    */
#define DMAC_CTL_L_SINC_Pos                       (9UL)                        /*!< SINC (Bit 9)                        */
#define DMAC_CTL_L_SINC_Msk                       (0x00000600UL)               /*!< SINC (Bitfield-Mask: 0x03)          */
#define DMAC_CTL_L_DINC_Pos                       (7UL)                        /*!< DINC (Bit 7)                        */
#define DMAC_CTL_L_DINC_Msk                       (0x00000180UL)               /*!< DINC (Bitfield-Mask: 0x03)          */
#define DMAC_CTL_L_SRC_TR_WIDTH_Pos               (4UL)                        /*!< SRC_TR_WIDTH (Bit 4)                */
#define DMAC_CTL_L_SRC_TR_WIDTH_Msk               (0x00000070UL)               /*!< SRC_TR_WIDTH (Bitfield-Mask: 0x07)  */
#define DMAC_CTL_L_DST_TR_WIDTH_Pos               (1UL)                        /*!< DST_TR_WIDTH (Bit 1)                */
#define DMAC_CTL_L_DST_TR_WIDTH_Msk               (0x0000000EUL)               /*!< DST_TR_WIDTH (Bitfield-Mask: 0x07)  */
#define DMAC_CTL_L_INT_EN_Pos                     (0UL)                        /*!< INT_EN (Bit 0)                      */
#define DMAC_CTL_L_INT_EN_Msk                     (0x00000001UL)               /*!< INT_EN (Bitfield-Mask: 0x01)        */
/* ==================================  CTL_H  ================================ */
#define DMAC_CTL_H_BLOCK_TS_Pos                   (0UL)                         /*!< BLOCK_TS (Bit 0)                   */
#define DMAC_CTL_H_BLOCK_TS_Msk                   (0x00000FFFUL)                /*!< BLOCK_TS (Bitfield-Mask: 0xFFF)    */
/* =================================   CFG_L  ================================ */
#define DMAC_CFG_L_HS_SEL_SRC_Pos                 (11UL)                        /*!< HS_SEL_SRC (Bit 11)                */
#define DMAC_CFG_L_HS_SEL_SRC_Msk                 (0x00000800UL)                /*!< HS_SEL_SRC (Bitfield-Mask: 0x01)   */
#define DMAC_CFG_L_HS_SEL_DST_Pos                 (10UL)                        /*!< HS_SEL_DST (Bit 10)                */
#define DMAC_CFG_L_HS_SEL_DST_Msk                 (0x00000400UL)                /*!< HS_SEL_DST (Bitfield-Mask: 0x01)   */
/* =================================   CFG_H  ================================ */
#define DMAC_CFG_H_DEST_PER_Pos                   (11UL)                        /*!< DEST_PER (Bit 11)                  */
#define DMAC_CFG_H_DEST_PER_Msk                   (0x00003800UL)                /*!< DEST_PER (Bitfield-Mask: 0x07)     */
#define DMAC_CFG_H_SRC_PER_Pos                    (7UL)                         /*!< SRC_PER (Bit 7)                    */
#define DMAC_CFG_H_SRC_PER_Msk                    (0x00000380UL)                /*!< SRC_PER (Bitfield-Mask: 0x07)      */
/* ==================================  RawTfr  =============================== */
#define DMAC_RawTfr_RAW_Pos                       (0UL)                         /*!< RAW (Bit 0)                        */
#define DMAC_RawTfr_RAW_Msk                       (0x00000003UL)                /*!< RAW (Bitfield-Mask: 0x3)           */
/* =================================  RawBlock  ============================== */
#define DMAC_RawBlock_RAW_Pos                     (0UL)                         /*!< RAW (Bit 0)                        */
#define DMAC_RawBlock_RAW_Msk                     (0x00000003UL)                /*!< RAW (Bitfield-Mask: 0x3)           */
/* ================================  RawSrcTran  ============================= */
#define DMAC_RawSrcTran_RAW_Pos                   (0UL)                         /*!< RAW (Bit 0)                        */
#define DMAC_RawSrcTran_RAW_Msk                   (0x00000003UL)                /*!< RAW (Bitfield-Mask: 0x3)           */
/* ================================  RawDstTran  ============================= */
#define DMAC_RawDstTran_RAW_Pos                   (0UL)                         /*!< RAW (Bit 0)                        */
#define DMAC_RawDstTran_RAW_Msk                   (0x00000003UL)                /*!< RAW (Bitfield-Mask: 0x3)           */
/* ================================    RawErr    ============================= */
#define DMAC_RawErr_RAW_Pos                       (0UL)                         /*!< RAW (Bit 0)                        */
#define DMAC_RawErr_RAW_Msk                       (0x00000003UL)                /*!< RAW (Bitfield-Mask: 0x3)           */
/* ================================  StatusTfr  ============================== */
#define DMAC_StatusTfr_STATUS_Pos                 (0UL)                         /*!< STATUS (Bit 0)                     */
#define DMAC_StatusTfr_STATUS_Msk                 (0x00000003UL)                /*!< STATUS (Bitfield-Mask: 0x3)        */
/* ===============================  StatusBlock  ============================= */
#define DMAC_StatusBlock_STATUS_Pos               (0UL)                         /*!< STATUS (Bit 0)                     */
#define DMAC_StatusBlock_STATUS_Msk               (0x00000003UL)                /*!< STATUS (Bitfield-Mask: 0x3)        */
/* =============================== StatusSrcTran  ============================ */
#define DMAC_StatusSrcTran_STATUS_Pos             (0UL)                         /*!< STATUS (Bit 0)                     */
#define DMAC_StatusSrcTran_STATUS_Msk             (0x00000003UL)                /*!< STATUS (Bitfield-Mask: 0x3)        */
/* ==============================  StatusDstTran  ============================ */
#define DMAC_StatusDstTran_STATUS_Pos             (0UL)                         /*!< STATUS (Bit 0)                     */
#define DMAC_StatusDstTran_STATUS_Msk             (0x00000003UL)                /*!< STATUS (Bitfield-Mask: 0x3)        */
/* ================================  StatusErr  ============================== */
#define DMAC_StatusErr_STATUS_Pos                 (0UL)                         /*!< STATUS (Bit 0)                     */
#define DMAC_StatusErr_STATUS_Msk                 (0x00000003UL)                /*!< STATUS (Bitfield-Mask: 0x3)        */
/* =================================  MaskTfr  =============================== */
#define DMAC_MaskTfr_INT_MASK_WE_Pos              (8UL)                         /*!< INT_MASK_WE (Bit 8)                */
#define DMAC_MaskTfr_INT_MASK_WE_Msk              (0x00000300UL)                /*!< INT_MASK_WE (Bitfield-Mask: 0x3)   */
#define DMAC_MaskTfr_INT_MASK_Pos                 (0UL)                         /*!< INT_MASK (Bit 0)                   */
#define DMAC_MaskTfr_INT_MASK_Msk                 (0x00000003UL)                /*!< INT_MASK (Bitfield-Mask: 0x3)      */
/* ================================  MaskBlock  ============================== */
#define DMAC_MaskBlock_INT_MASK_WE_Pos            (8UL)                         /*!< INT_MASK_WE (Bit 8)                */
#define DMAC_MaskBlock_INT_MASK_WE_Msk            (0x00000300UL)                /*!< INT_MASK_WE (Bitfield-Mask: 0x3)   */
#define DMAC_MaskBlock_INT_MASK_Pos               (0UL)                         /*!< INT_MASK (Bit 0)                   */
#define DMAC_MaskBlock_INT_MASK_Msk               (0x00000003UL)                /*!< INT_MASK (Bitfield-Mask: 0x3)      */
/* ===============================  MaskSrcTran  ============================= */
#define DMAC_MaskSrcTran_INT_MASK_WE_Pos          (8UL)                         /*!< INT_MASK_WE (Bit 8)                */
#define DMAC_MaskSrcTran_INT_MASK_WE_Msk          (0x00000300UL)                /*!< INT_MASK_WE (Bitfield-Mask: 0x3)   */
#define DMAC_MaskSrcTran_INT_MASK_Pos             (0UL)                         /*!< INT_MASK (Bit 0)                   */
#define DMAC_MaskSrcTran_INT_MASK_Msk             (0x00000003UL)                /*!< INT_MASK (Bitfield-Mask: 0x3)      */
/* ===============================  MaskDstTran  ============================= */
#define DMAC_MaskDstTran_INT_MASK_WE_Pos          (8UL)                         /*!< INT_MASK_WE (Bit 8)                */
#define DMAC_MaskDstTran_INT_MASK_WE_Msk          (0x00000300UL)                /*!< INT_MASK_WE (Bitfield-Mask: 0x3)   */
#define DMAC_MaskDstTran_INT_MASK_Pos             (0UL)                         /*!< INT_MASK (Bit 0)                   */
#define DMAC_MaskDstTran_INT_MASK_Msk             (0x00000003UL)                /*!< INT_MASK (Bitfield-Mask: 0x3)      */
/* ================================== MaskErr  =============================== */
#define DMAC_MaskErr_INT_MASK_WE_Pos              (8UL)                         /*!< INT_MASK_WE (Bit 8)                */
#define DMAC_MaskErr_INT_MASK_WE_Msk              (0x00000300UL)                /*!< INT_MASK_WE (Bitfield-Mask: 0x3)   */
#define DMAC_MaskErr_INT_MASK_Pos                 (0UL)                         /*!< INT_MASK (Bit 0)                   */
#define DMAC_MaskErr_INT_MASK_Msk                 (0x00000003UL)                /*!< INT_MASK (Bitfield-Mask: 0x3)      */
/* =================================  ClearTfr  ============================== */
#define DMAC_ClearTfr_CLEAR_Pos                   (0UL)                         /*!< CLEAR (Bit 0)                      */
#define DMAC_ClearTfr_CLEAR_Msk                   (0x00000003UL)                /*!< CLEAR (Bitfield-Mask: 0x3)         */
/* ================================  ClearBlock  ============================= */
#define DMAC_ClearBlock_CLEAR_Pos                 (0UL)                         /*!< CLEAR (Bit 0)                      */
#define DMAC_ClearBlock_CLEAR_Msk                 (0x00000003UL)                /*!< CLEAR (Bitfield-Mask: 0x3)         */
/* ===============================  ClearSrcTran  ============================ */
#define DMAC_ClearSrcTran_CLEAR_Pos               (0UL)                         /*!< CLEAR (Bit 0)                      */
#define DMAC_ClearSrcTran_CLEAR_Msk               (0x00000003UL)                /*!< CLEAR (Bitfield-Mask: 0x3)         */
/* ===============================  ClearDstTran  ============================ */
#define DMAC_ClearDstTran_CLEAR_Pos               (0UL)                         /*!< CLEAR (Bit 0)                      */
#define DMAC_ClearDstTran_CLEAR_Msk               (0x00000003UL)                /*!< CLEAR (Bitfield-Mask: 0x3)         */
/* =================================  ClearErr  ============================== */
#define DMAC_ClearErr_CLEAR_Pos                   (0UL)                         /*!< CLEAR (Bit 0)                      */
#define DMAC_ClearErr_CLEAR_Msk                   (0x00000003UL)                /*!< CLEAR (Bitfield-Mask: 0x3)         */
/* =================================  StatusInt  ============================= */
#define DMAC_StatusInt_ERR_Pos                    (4UL)                         /*!< ERR (Bit 4)                        */
#define DMAC_StatusInt_ERR_Msk                    (0x00000010UL)                /*!< ERR (Bitfield-Mask: 0x01)          */
#define DMAC_StatusInt_DSTT_Pos                   (3UL)                         /*!< DSTT (Bit 3)                       */
#define DMAC_StatusInt_DSTT_Msk                   (0x00000008UL)                /*!< DSTT (Bitfield-Mask: 0x01)         */
#define DMAC_StatusInt_SRCT_Pos                   (2UL)                         /*!< SRCT (Bit 2)                       */
#define DMAC_StatusInt_SRCT_Msk                   (0x00000004UL)                /*!< SRCT (Bitfield-Mask: 0x01)         */
#define DMAC_StatusInt_BLOCK_Pos                  (1UL)                         /*!< BLOCK (Bit 1)                      */
#define DMAC_StatusInt_BLOCK_Msk                  (0x00000002UL)                /*!< BLOCK (Bitfield-Mask: 0x01)        */
#define DMAC_StatusInt_TFR_Pos                    (0UL)                         /*!< TFR (Bit 0)                        */
#define DMAC_StatusInt_TFR_Msk                    (0x00000001UL)                /*!< TFR (Bitfield-Mask: 0x01)          */
/* =================================  ReqSrcReg  ============================= */
#define DMAC_ReqSrcReg_SRC_REQ_WE_Pos             (8UL)                         /*!< SRC_REQ_WE (Bit 8)                 */
#define DMAC_ReqSrcReg_SRC_REQ_WE_Msk             (0x00000300UL)                /*!< SRC_REQ_WE (Bitfield-Mask: 0x3)    */
#define DMAC_ReqSrcReg_SRC_REQ_Pos                (0UL)                         /*!< SRC_REQ (Bit 0)                    */
#define DMAC_ReqSrcReg_SRC_REQ_Msk                (0x00000003UL)                /*!< SRC_REQ (Bitfield-Mask: 0x3)       */
/* =================================  ReqDstReg  ============================= */
#define DMAC_ReqDstReg_DST_REQ_WE_Pos             (8UL)                         /*!< DST_REQ_WE (Bit 8)                 */
#define DMAC_ReqDstReg_DST_REQ_WE_Msk             (0x00000300UL)                /*!< DST_REQ_WE (Bitfield-Mask: 0x3)    */
#define DMAC_ReqDstReg_DST_REQ_Pos                (0UL)                         /*!< DST_REQ (Bit 0)                    */
#define DMAC_ReqDstReg_DST_REQ_Msk                (0x00000003UL)                /*!< DST_REQ (Bitfield-Mask: 0x3)       */
/* ================================  SglReqSrcReg  =========================== */
#define DMAC_SglReqSrcReg_SRC_SGLREQ_WE_Pos       (8UL)                         /*!< SRC_SGLREQ_WE (Bit 8)              */
#define DMAC_SglReqSrcReg_SRC_SGLREQ_WE_Msk       (0x00000300UL)                /*!< SRC_SGLREQ_WE (Bitfield-Mask: 0x3) */
#define DMAC_SglReqSrcReg_SRC_SGLREQ_Pos          (0UL)                         /*!< SRC_SGLREQ (Bit 0)                 */
#define DMAC_SglReqSrcReg_SRC_SGLREQ_Msk          (0x00000003UL)                /*!< SRC_SGLREQ (Bitfield-Mask: 0x3)    */
/* ================================  SglReqDstReg  =========================== */
#define DMAC_SglReqDstReg_DST_SGLREQ_WE_Pos       (8UL)                         /*!< DST_SGLREQ_WE (Bit 8)              */
#define DMAC_SglReqDstReg_DST_SGLREQ_WE_Msk       (0x00000300UL)                /*!< DST_SGLREQ_WE (Bitfield-Mask: 0x3) */
#define DMAC_SglReqDstReg_DST_SGLREQ_Pos          (0UL)                         /*!< DST_SGLREQ (Bit 0)                 */
#define DMAC_SglReqDstReg_DST_SGLREQ_Msk          (0x00000003UL)                /*!< DST_SGLREQ (Bitfield-Mask: 0x3)    */
/* ==================================  DmaCfgReg  ============================ */
#define DMAC_DmaCfgReg_DMA_EN_Pos                 (0UL)                         /*!< DMA_EN (Bit 0)                     */
#define DMAC_DmaCfgReg_DMA_EN_Msk                 (0x00000001UL)                /*!< DMA_EN (Bitfield-Mask: 0x01)       */
/* ===================================  ChEnReg  ============================== */
#define DMAC_ChEnReg_CH_EN_Pos                    (0UL)                         /*!< CH_EN (Bit 0)                      */
#define DMAC_ChEnReg_CH_EN_Msk                    (0x00000300UL)                /*!< CH_EN (Bitfield-Mask: 0x3)         */
#define DMAC_ChEnReg_CH_EN_WE_Pos                 (8UL)                         /*!< CH_EN_WE (Bit 8)                   */
#define DMAC_ChEnReg_CH_EN_WE_Msk                 (0x00000003UL)                /*!< CH_EN_WE (Bitfield-Mask: 0x3)      */

/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */


  void DMA_DeInit(DMA_Channel_TypeDef *DMAy_Channelx);

  /* Initialization and Configuration functions *********************************/
  void DMA_Init(DMA_Channel_TypeDef *DMAy_Channelx, DMA_InitTypeDef *DMA_InitStruct);
  void DMA_StructInit(DMA_InitTypeDef *DMA_InitStruct);
  void DMA_Cmd(DMA_Channel_TypeDef *DMAy_Channelx, FunctionalState NewState);
  void DMA_RemapConfig(DMA_Channel_TypeDef *DMAy_Channelx, uint32_t req_num, uint32_t DMA_Request);

  /* Data Counter functions******************************************************/
  void DMA_SetCurrDataCounter(DMA_Channel_TypeDef *DMAy_Channelx, uint16_t DataNumber);
  uint16_t DMA_GetCurrDataCounter(DMA_Channel_TypeDef *DMAy_Channelx);

  /* Interrupts and flags management functions **********************************/
  void DMA_ITConfig(DMA_Channel_TypeDef *DMAy_Channelx, uint32_t DMA_IT, FunctionalState NewState);
  FlagStatus DMA_GetFlagStatus(uint32_t DMAy_FLAG);
  void DMA_ClearFlag(uint32_t DMAy_FLAG);
  ITStatus DMA_GetITStatus(uint32_t DMAy_IT);
  void DMA_ClearITPendingBit(uint32_t DMAy_IT);
  void DMA_ReEnable_Config(DMA_Channel_TypeDef *DMAy_Channelx, uint32_t SAdress, uint32_t DAdress,FunctionalState NewState);
  void DMA_One_Config(DMA_Channel_TypeDef *DMAy_Channelx, uint32_t SAdress, uint32_t DAdress,uint32_t Block_size);

#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_DMA_H__
