/**
  ******************************************************************************
  * @file    lcm32f06x_div.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for div.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_DIV_H__
#define __LCM32F06X_DIV_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"
#include "lcm32f06x_rcc.h"

#ifdef __cplusplus
  extern "C" {
#endif

typedef struct
{
    uint32_t discuss;     //
    uint32_t remainder;   //y
} result_t;

/* ========================================================================== */
/* ================             DIV REGISTER BIT               ============== */
/* ========================================================================== */

/* =================================  CTRL  ================================= */
#define DIV_CTRL_DIV0_INTREN_Pos                  (25UL)                       /* DIV0_INTREN (Bits 25)                */
#define DIV_CTRL_DIV0_INTREN_Msk                  (0x0200000UL)                /* DIV0_INTREN (Bitfield-Mask: 0x01)    */
#define DIV_CTRL_DIV0_Pos                         (24UL)                       /* DIV0 (Bits 24)                       */
#define DIV_CTRL_DIV0_Msk                         (0x0010000UL)                /* DIV0 (Bitfield-Mask: 0x01)           */
#define DIV_CTRL_DIV16_Pos                        (8UL)                        /* DIV16 (Bits 8)                       */
#define DIV_CTRL_DIV16_Msk                        (0x00000100UL)               /* DIV16 (Bitfield-Mask: 0x01)          */
#define DIV_CTRL_B_WRITED_Pos                     (4UL)                        /* B_WRITED (Bits 4)                    */
#define DIV_CTRL_B_WRITED_Msk                     (0x00000010UL)               /* B_WRITED (Bitfield-Mask: 0x01)       */
#define DIV_CTRL_ALO_WRITED_Pos                   (2UL)                        /* ALO_WRITED (Bits 2)                  */
#define DIV_CTRL_ALO_WRITED_Msk                   (0x00000004UL)               /* ALO_WRITED (Bitfield-Mask: 0x01)     */
#define DIV_CTRL_IN_PROCCEED_Pos                  (1UL)                        /* IN_PROCCEED (Bits 1)                 */
#define DIV_CTRL_IN_PROCCEED_Msk                  (0x00000002UL)               /* IN_PROCCEED (Bitfield-Mask: 0x01)    */
#define DIV_CTRL_RST_Pos                          (0UL)                        /* RST (Bits 0)                         */
#define DIV_CTRL_RST_Msk                          (0x00000001UL)               /* RST (Bitfield-Mask: 0x01)            */
/* ===================================  ALO  ================================ */
#define DIV_ALO_Pos                               (0UL)                        /* ALO (Bits 0)                         */
#define DIV_ALO_Msk                               (0xFFFFFFFFUL)               /* ALO (Bitfield-Mask: 0xFFFFFFFF)      */
/* ==================================  DIV_B  =============================== */
#define DIV_B_Pos                                 (0UL)                        /* DIV_B (Bits 0)                       */
#define DIV_B_Msk                                 (0xFFFFFFFFUL)               /* DIV_B (Bitfield-Mask: 0xFFFFFFFF)    */
/* =================================  DIV_QUOT  ============================= */
#define DIV_QUOT_Pos                              (0UL)                        /* DIV_QUOT (Bits 0)                    */
#define DIV_QUOT_Msk                              (0xFFFFFFFFUL)               /* DIV_QUOT (Bitfield-Mask: 0xFFFFFFFF) */
/* ==================================  DIV_REM  ============================= */
#define DIV_REM_Pos                               (0UL)                        /* DIV_REM (Bits 0)                     */
#define DIV_REM_Msk                               (0xFFFFFFFFUL)               /* DIV_REM (Bitfield-Mask: 0xFFFFFFFF)  */

/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */

int Fun_32_DIV_16(int dividend, int divisor, result_t *result);
int Fun_16_DIV_16(int dividend, int divisor, result_t *result);
#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_DIV_H__
