/**
  ******************************************************************************
  * @file    lcm32f06x_dbgmcu.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for acmp.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_DBGMCU_H__
#define __LCM32F06X_DBGMCU_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

#ifdef __cplusplus
extern "C"
{
#endif

#define IS_DBGMCU_PERIPH(PERIPH)     ((((PERIPH)&0xFFFFFFF9) == 0x00) && ((PERIPH) != 0x00))

#define DBGMCU_TIM1_STOP             (1 << 0) /*@EN: TIM1 counter stopped when Core is halted @CN: Core?1TIM1??y?¨?1 */
#define DBGMCU_TIM15_STOP            (1 << 4) /*@EN: TIM15 counter stopped when Core is halted @CN: Core?1TIM15??y?¨?1 */
#define DBGMCU_TIM16_STOP            (1 << 5) /*@EN: TIM16 counter stopped when Core is halted @CN: Core?1TIM16??y?¨?1 */
#define DBGMCU_TIM17_STOP            (1 << 6) /*@EN: TIM17 counter stopped when Core is halted @CN: Core?1TIM17??y?¨?1 */
#define DBGMCU_WT_STOP               (1 << 7) /*@EN: WT counter stopped when Core is halted @CN: Core?1WT??y?¨?1 */
#define DBGMCU_IWDG_STOP             (1 << 9) /*@EN: IWDG counter stopped when Core is halted @CN: Core?1IWDG??y?¨?1 */
#define DBGMCU_TIM2_STOP             (1 << 10) /*@EN: TIM2 counter stopped when Core is halted @CN: Core?1TIM2??y?¨?1 */

#define IS_DBGMCU_APB0PERIPH(PERIPH) ((PERIPH == DBGMCU_TIM1_STOP) || (PERIPH == DBGMCU_TIM15_STOP) || \
                                      (PERIPH == DBGMCU_TIM16_STOP) || (PERIPH == DBGMCU_TIM17_STOP) || \
                                      (PERIPH == DBGMCU_WT_STOP) || (PERIPH == DBGMCU_IWDG_STOP) || \
                                      (PERIPH == DBGMCU_TIM2_STOP))

uint32_t DBGMCU_GetREVID(void);
uint32_t DBGMCU_GetDEVID(void);

void DBGMCU_Config(uint32_t DBGMCU_Periph, FunctionalState NewState);
void DBGMCU_APB0PeriphConfig(uint32_t DBGMCU_Periph, FunctionalState NewState);

#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_DBGMCU_H__
