/**
  ******************************************************************************
  * @file    lcm32f06x_dac.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for dac.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_DAC_H__
#define __LCM32F06X_DAC_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

#ifdef __cplusplus
  extern "C" {
#endif

typedef struct
{
  uint32_t DAC_WaveGeneration;                    /*!< EN: DAC noise or triangular waveform generator enable control.
                                                       CN: DAC ǲηʹܿơ
                                                       @Register: DAC_CR @Bits:[7:6]WAVE.
                                                       @default: DAC_WaveGeneration_None */

  uint32_t DAC_LFSRUnmask_TriangleAmplitude;      /*!< EN: DAC shielding/amplification factor selection factor.
                                                       CN: DAC /Ŵϵѡӡ
                                                       @Register: DAC_CR @Bits:[11:8]MAMP.
                                                       @default: DAC_LFSRUnmask_Bit0 */

  uint32_t DAC_OutputBuffer;                      /*!< EN: DACOUT output BUFF.
                                                       CN: DACOUT  BUFF
                                                       @Register: ANA_CTRL @Bits:[4]DAC_BUFEN.
                                                       @default: DAC_OutputBuffer_Disable */

  uint32_t DAC_Vref_Select;                       /*!< EN: Dac reference voltage selection.
                                                       CN: Dacοѹѡ
                                                       @Register: DAC_CR @Bits:[14]VREF_SEL.
                                                       @default: DAC_Vref_ADCref */

  FunctionalState DAC_DmaMode;                    /*!< EN: The DAC DMA mode was enabled. Procedure.
                                                       CN: DAC dmaģʽʹܡ
                                                       @Register: DAC_CR @Bits:[12]DMAEN.
                                                       @default: DISABLE */

  FunctionalState DAC_DMAUDR_IE;                  /*!< EN: DAC DMA Underload Interrupt Enable.
                                                       CN: DAC DMA Ƿжʹܡ
                                                       @Register: DAC_CR @Bits:[13]DMAUDRIE.
                                                       @default: DISABLE */

} DAC_InitTypeDef;


/* @defgroup DAC_WaveGeneratio */
#define DAC_WaveGeneration_None             ((uint32_t)0x00000000) /*@EN: Prohibit waveform generation @CN: ֹ */
#define DAC_WaveGeneration_Noise            ((uint32_t)0x00000040) /*@EN: Enable noise waveform generation @CN: ʹβ */
#define DAC_WaveGeneration_Triangle         ((uint32_t)0x00000080) /*@EN: Triangle waveform enable @CN: ǲʹ */
#define IS_DAC_WaveGeneration(WAVE)         ((WAVE == DAC_WaveGeneration_None)  ||\
                                             (WAVE == DAC_WaveGeneration_Noise) ||\
                                             (WAVE == DAC_WaveGeneration_Triangle))
/* @end */

/* @defgroup DAC_LFSRUnmask_TriangleAmplitude */
#define DAC_LFSRUnmask_Bit0                 ((uint32_t)0x00000000) /*@EN: Release the 0th bit of LFSR/Delta waveform amplification 1 (default) @CN: ſ LFSR ĵ 0 λ/ǲֵ 1Ĭϣ */
#define DAC_LFSRUnmask_Bits1_0              ((uint32_t)0x00000100) /*@EN: Release LFSR [1:0]/Delta waveform amplification 3 @CN: ſ LFSR [1:0]/ǲֵ 3 */
#define DAC_LFSRUnmask_Bits2_0              ((uint32_t)0x00000200) /*@EN: Release LFSR [2:0]/Delta waveform amplification 7 @CN: ſ LFSR [2:0]/ǲֵ 7 */
#define DAC_LFSRUnmask_Bits3_0              ((uint32_t)0x00000300) /*@EN: Release LFSR [3:0]/Delta waveform amplification 15 @CN: ſ LFSR [3:0]/ǲֵ 15 */
#define DAC_LFSRUnmask_Bits4_0              ((uint32_t)0x00000400) /*@EN: Release LFSR [4:0]/Delta waveform amplification 31 @CN: ſ LFSR [4:0]/ǲֵ 31 */
#define DAC_LFSRUnmask_Bits5_0              ((uint32_t)0x00000500) /*@EN: Release LFSR [5:0]/Delta waveform amplification 63 @CN: ſ LFSR [5:0]/ǲֵ 63 */
#define DAC_LFSRUnmask_Bits6_0              ((uint32_t)0x00000600) /*@EN: Release LFSR [6:0]/Delta waveform amplification 127 @CN: ſ LFSR [6:0]/ǲֵ 127 */
#define DAC_LFSRUnmask_Bits7_0              ((uint32_t)0x00000700) /*@EN: Release LFSR [7:0]/Delta waveform amplification 255 @CN: ſ LFSR [7:0]/ǲֵ 255 */
#define DAC_LFSRUnmask_Bits8_0              ((uint32_t)0x00000800) /*@EN: Release LFSR [8:0]/Delta waveform amplification 511 @CN: ſ LFSR [8:0]/ǲֵ 511 */
#define DAC_LFSRUnmask_Bits9_0              ((uint32_t)0x00000900) /*@EN: Release LFSR [9:0]/Delta waveform amplification 1023 @CN: ſ LFSR [9:0]/ǲֵ 1023 */
/* @end */

/* @defgroup DAC_OutputBuffer */
#define DAC_OutputBuffer_Disable            ((uint32_t)0x00000000) /*@EN: DACOUT output BUFF disable @CN: DACOUT  BUFF ʹ */
#define DAC_OutputBuffer_Enable             ((uint32_t)0x00000010) /*@EN: DACOUT output BUFF enable @CN: DACOUT  BUFF ʹ */
/* @end */

/* @defgroup DAC_Vref_Select */
#define DAC_Vref_ADCref                     ((uint32_t)0x00000000) /*@EN: ADC reference voltage (default) @CN: ADC οѹĬϣ */
#define DAC_Vref_VDDA                       ((uint32_t)0x00004000) /*@EN: VDDA @CN: VDDA */
/* @end */


/* @defgroup DAC_Align */
#define DAC_Align_10B_R                     ((uint32_t)0x00000000) /*@EN: Right aligned @CN: Ҷ */
#define DAC_Align_10B_L                     ((uint32_t)0x00008000) /*@EN: Left aligned  @CN:  */
#define IS_DAC_Align(MODE)                  ((MODE == DAC_Align_10B_R) ||\
                                             (MODE == DAC_Align_10B_L))
/* @end */

/* @defgroup DAC_IT */
#define DAC_IT_DMAUDR                       ((uint32_t)0x00002000) /*@EN: DAC DMA under load interrupt @CN: DAC DMA Ƿж */
#define IS_DAC_IT_CONFIG(IT)                ((IT == DAC_IT_DMAUDR))
/* @end */

/* @defgroup DAC_GET_IT */
#define DAC_GET_IT_DMAUDR                   ((uint32_t)0x00000100) /*@EN: DAC DMA under load interrupt @CN: DAC DMA Ƿж */
#define IS_DAC_GET_IT_CONFIG(IT)            ((IT == DAC_GET_IT_DMAUDR))
/* @end */

/* @defgroup DAC_FLAG */
#define DAC_FLAG_DMAUDR                     ((uint32_t)0x00000100) /*@EN: DAC DMA under load Flag @CN: DAC DMA Ƿر־ */
#define DAC_FLAG_DACSOFT                    ((uint32_t)0x00000001) /*@EN: DAC Software Trigger Flag @CN: DAC ־ */
#define IS_DAC_FLAG_CONFIG(FLAG)            ((FLAG == DAC_FLAG_DMAUDR) || \
                                             (FLAG == DAC_FLAG_DACSOFT))
/* @end */

/* @defgroup DAC_TiggerSource */
#define DAC_TiggerSource_EXTI9              ((uint32_t)0x00000070) /*@EN: DAC trigger source: EXTI9 @CN: DAC ԴEXTI9 */
#define DAC_TiggerSource_EXTI1              ((uint32_t)0x00000060) /*@EN: DAC trigger source: EXTI1 @CN: DAC ԴEXTI1 */
#define DAC_TiggerSource_TIM14_TRIG_OC1     ((uint32_t)0x00000050) /*@EN: DAC trigger source: TIM14 TRIG OC1 @CN: DAC ԴTIM14 TRIG OC1 */
#define DAC_TiggerSource_TIM16_TRIG_OC1     ((uint32_t)0x00000040) /*@EN: DAC trigger source: TIM16 TRIG OC1 @CN: DAC ԴTIM16 TRIG OC1 */
#define DAC_TiggerSource_TIM15_TRGO         ((uint32_t)0x00000030) /*@EN: DAC trigger source: TIM15 TRGO @CN: DAC ԴTIM15 TRGO */
#define DAC_TiggerSource_TIM3_TRGO          ((uint32_t)0x00000020) /*@EN: DAC trigger source: TIM3 TRGO  @CN: DAC ԴTIM3 TRGO  */
#define DAC_TiggerSource_TIM1_TRGO          ((uint32_t)0x00000010) /*@EN: DAC trigger source: TIM1 TRGO  @CN: DAC ԴTIM1 TRGO  */
#define DAC_TiggerSource_SOFTWARE           ((uint32_t)0x00000000) /*@EN: DAC trigger source: software @CN: DAC Դ */
#define IS_DAC_TiggerSource(Source)         ((Source == DAC_TiggerSource_EXTI9)          || \
                                             (Source == DAC_TiggerSource_EXTI1)          || \
                                             (Source == DAC_TiggerSource_TIM14_TRIG_OC1) || \
                                             (Source == DAC_TiggerSource_TIM16_TRIG_OC1) || \
                                             (Source == DAC_TiggerSource_TIM15_TRGO)     || \
                                             (Source == DAC_TiggerSource_TIM3_TRGO)      || \
                                             (Source == DAC_TiggerSource_TIM1_TRGO)      || \
                                             (Source == DAC_TiggerSource_SOFTWARE))
/* @end */

/* @defgroup DAC_TiggerMode */
#define DAC_TiggerMode_NoExternalTrigger    ((uint32_t)0x00000003) /*@EN: Prohibit external triggering @CN: ֹⲿ */
#define DAC_TiggerMode_Externnal_DoubleEdge ((uint32_t)0x00000002) /*@EN: External dual edge trigger @CN: ⲿ˫ش */
#define DAC_TiggerMode_Externnal_FallEdge   ((uint32_t)0x00000001) /*@EN: External falling edge trigger @CN: ⲿ½ش */
#define DAC_TiggerMode_Externnal_RiseEdge   ((uint32_t)0x00000000) /*@EN: External rising edge trigger @CN: ⲿش */
#define IS_DAC_TiggerMode(Mode)             ((Mode == DAC_TiggerMode_NoExternalTrigger)    || \
                                             (Mode == DAC_TiggerMode_Externnal_DoubleEdge) || \
                                             (Mode == DAC_TiggerMode_Externnal_FallEdge)   || \
                                             (Mode == DAC_TiggerMode_Externnal_RiseEdge))
/* @end */


/* ========================================================================== */
/* ================             DAC REGISTER BIT               ============== */
/* ========================================================================== */

/* ==================================  CR  ================================== */
#define ANACTRL_DACX_CR_ALIGN_Pos                 (15UL)                       /*!< ALIGN (Bit 16)                */
#define ANACTRL_DACX_CR_ALIGN_Msk                 (0x00008000UL)               /*!< ALIGN (Bitfield-Mask: 0x1)    */
#define ANACTRL_DACX_CR_VREF_SEL_Pos              (14UL)                       /*!< VREF_SEL (Bit 14)             */
#define ANACTRL_DACX_CR_VREF_SEL_Msk              (0x00004000UL)               /*!< VREF_SEL (Bitfield-Mask: 0x1) */
#define ANACTRL_DACX_CR_DMAUDRIE_Pos              (13UL)                       /*!< DMAUDRIE (Bit 13)             */
#define ANACTRL_DACX_CR_DMAUDRIE_Msk              (0x00002000UL)               /*!< DMAUDRIE (Bitfield-Mask: 0x1) */
#define ANACTRL_DACX_CR_DMAEN_Pos                 (12UL)                       /*!< DMAEN (Bit 12)                */
#define ANACTRL_DACX_CR_DMAEN_Msk                 (0x00001000UL)               /*!< DMAEN (Bitfield-Mask: 0x1)    */
#define ANACTRL_DACX_CR_MAMP_Pos                  (8UL)                        /*!< MAMP (Bit 8)                  */
#define ANACTRL_DACX_CR_MAMP_Msk                  (0x00000F00UL)               /*!< MAMP (Bitfield-Mask: 0xF)     */
#define ANACTRL_DACX_CR_WAVE_Pos                  (6UL)                        /*!< WAVE (Bit 6)                  */
#define ANACTRL_DACX_CR_WAVE_Msk                  (0x000000C0UL)               /*!< WAVE (Bitfield-Mask: 0x3)     */
#define ANACTRL_DACX_CR_EN_Pos                    (0UL)                        /*!< EN (Bit 0)                    */
#define ANACTRL_DACX_CR_EN_Msk                    (0x00000001UL)               /*!< EN (Bitfield-Mask: 0x1)       */
/* ====================================  SR  ================================ */
#define ANACTRL_DACX_SR_DMAUDR_Pos                (8UL)                        /*!< DMAUDR (Bit 8)                */
#define ANACTRL_DACX_SR_DMAUDR_Msk                (0x00000100UL)               /*!< DMAUDR (Bitfield-Mask: 0x1)   */
#define ANACTRL_DACX_SR_SWTRIG_Pos                (0UL)                        /*!< SWTRIG (Bit 0)                */
#define ANACTRL_DACX_SR_SWTRIG_Msk                (0x00000001UL)               /*!< SWTRIG (Bitfield-Mask: 0x1)   */
/* ====================================  DHR  =============================== */
#define ANACTRL_DACX_DHR_Pos                      (0UL)                        /*!< DHR (Bit 0)                   */
#define ANACTRL_DACX_DHR_Msk                      (0x0000FFFFUL)               /*!< DHR (Bitfield-Mask: 0xFFFF)   */
/* ====================================  DOR  =============================== */
#define ANACTRL_DACX_DOR_Pos                      (0UL)                        /*!< DOR (Bit 0)                   */
#define ANACTRL_DACX_DOR_Msk                      (0x0000FFFFUL)               /*!< DOR (Bitfield-Mask: 0xFFFF)   */
/* ==================================  ANA_CTRL  ============================ */
#define ANACTRL_ANA_CTRL_DAC_BUFEN_Pos            (4UL)                        /*!< DAC_BUFEN (Bit 4)              */
#define ANACTRL_ANA_CTRL_DAC_BUFEN_Msk            (0x00000010UL)               /*!< DAC_BUFEN (Bitfield-Mask: 0x1) */
/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */

void DAC_DeInit(void);
void DAC_Init(DAC_TypeDef *DACx, DAC_InitTypeDef *DAC_InitStruct);
void DAC_StructInit(DAC_InitTypeDef *DAC_InitStruct);
void DAC_Cmd(DAC_TypeDef *DACx, FunctionalState NewState);
void DAC_SoftwareTriggerCmd(DAC_TypeDef *dac_ptr, FunctionalState NewState);
void DAC_WaveGenerationCmd(DAC_TypeDef *DACx, uint32_t DAC_Wave, FunctionalState NewState);
void DAC_SetDac_10B_Data(DAC_TypeDef *DACx, uint32_t DAC_Align, uint16_t Data);
uint16_t DAC_GetDataOutputValue_10bit(DAC_TypeDef *DACx);
void DAC_ITConfig(DAC_TypeDef *DACx, uint32_t DAC_IT, FunctionalState NewState);
void DAC_ClearITPendingBit(DAC_TypeDef *DACx, uint32_t DAC_IT);
FlagStatus DAC_GetFlagStatus(DAC_TypeDef *DACx, uint32_t DAC_FLAG);
void DAC_TriggerSourceConfig(DAC_TypeDef *DACx, uint32_t DAC_TriggerSource, uint32_t DAC_TriggerMode);
void DAC_OutputBuff(DAC_TypeDef *DACx, FunctionalState NewState);

#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_DAC_H__
