/**
  ******************************************************************************
  * @file    lcm32f06x_crc.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for crc.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_CRC_H__
#define __LCM32F06X_CRC_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

#ifdef __cplusplus
  extern "C" {
#endif

/** @defgroup Crc 8 Configuration Mode enumeration
  * @{
  */
typedef enum CRC_8_MODE
{
    CRC_8,
    CRC_8_ITU,
    CRC_8_ROHC
}CRC_8_MODE_TypeDef;
/**
  * @}
  */

/** @defgroup Crc 16A Configuration Mode enumeration
  * @{
  */
typedef enum CRC_16A_MODE
{
    CRC_16A_IBM,
    CRC_16A_MAXIM,
    CRC_16A_USB,
    CRC_16A_MODBUS
}CRC_16A_MODE_TypeDef;
/**
  * @}
  */

/** @defgroup Crc 16B Configuration Mode enumeration
  * @{
  */
typedef enum CRC_16B_MODE
{
    CRC_16B_CCITT,
    CRC_16B_CCITT_FALSE,
    CRC_16B_X25,
    CRC_16B_XMODEM
}CRC_16B_MODE_TypeDef;
/**
  * @}
  */

/** @defgroup Crc 32 Configuration Mode enumeration
  * @{
  */
typedef enum CRC_32_MODE
{
    CRC_32,
    CRC_32_MPEG_2
}CRC_32_MODE_TypeDef;
/**
  * @}
  */

/* @defgroup CRC_GPS */
#define CRC_GPS_CRC8            ((uint32_t)0x00000000) /*@EN:CRC8 0x07 Generate Polynomial (default) @CN:CRC80x07 ɶʽĬϣ*/
#define CRC_GPS_CRC16a          ((uint32_t)0x01000000) /*@EN:CRC16 0x8005 Generate Polynomial @CN:CRC160x8005 ɶʽ*/
#define CRC_GPS_CRC16b          ((uint32_t)0x02000000) /*@EN:CRC16 0x1021 Generate Polynomial @CN:CRC160x1021 ɶʽ*/
#define CRC_GPS_CRC32           ((uint32_t)0x03000000) /*@EN:CRC32 0x04C11DB7 Generate Polynomial @CN:CRC160x04C11DB7 ɶʽ*/
/* @end */

/* @defgroup CRC_SWAP */
#define CRC_SWAP_00             ((uint32_t)0x00000000) /*@EN:The byte arrangement of the data to be verified remains unchanged (default) @CN:Уֽв䣨Ĭϣ*/
#define CRC_SWAP_01             ((uint32_t)0x00020000) /*@EN:The data to be verified is converted to {bit [23:16], bit [31:24], bit [7:0], bit [15:8]} @CN:УתΪ{bit[23:16], bit[31:24], bit[7:0], bit[15:8]}*/
#define CRC_SWAP_10             ((uint32_t)0x00040000) /*@EN:The data to be verified is converted to {bit[15:0], bit[31:16]} @CN:УתΪ{bit[15:0], bit[31:16]}*/
#define CRC_SWAP_11             ((uint32_t)0x00060000) /*@EN:The data to be verified is converted to {bit[7:0], bit[15:8], bit[23:16:], bit[31:24]} @CN:УתΪ{bit[7:0], bit[15:8], bit[23:16:], bit[31:24]}*/
/* @end */

/* @defgroup CRC_LM */
#define CRC_LM_LSB              ((uint32_t)0x00000000) /*@EN:LSB, low bit first operation (default) @CN:LSBͱ㣨Ĭϣ*/
#define CRC_LM_MSB              ((uint32_t)0x00010000) /*@EN:MSB, high bit first operation @CN:MSB߱*/
/* @end */

/* @defgroup CRC_INVEN */
#define CRC_INVEN_LSB           ((uint32_t)0x00000000) /*@EN:LSB stored in CRC_ RESULT register lowest bit (default) @CN:LSB  CRC_RESULT ĴλĬϣ*/
#define CRC_INVEN_MSB           ((uint32_t)0x00008000) /*@EN:MSB stored in CRC_ RESULT register lowest bit @CN:MSB  CRC_RESULT Ĵλ*/
/* @end */

/* @defgroup CRC_BYTE */
#define CRC_BYTE_1              ((uint32_t)0x00000000) /*@EN:One byte is valid, bit7-0 (default) @CN:һֽЧ bit7-0Ĭϣ*/
#define CRC_BYTE_2              ((uint32_t)0x00000100) /*@EN:Two byte is valid, bit15-0 @CN:ֽЧ bit15-0*/
#define CRC_BYTE_3              ((uint32_t)0x00000200) /*@EN:Three byte is valid, bit23-0 @CN:ֽЧ bit23-0*/
#define CRC_BYTE_4              ((uint32_t)0x00000300) /*@EN:Four byte is valid, bit31-0 @CN:ĸֽЧ bit31-0*/
/* @end */

/* @defgroup CRC_RESET_RESULT */
#define CRC_RESET_RESULT_OFF    ((uint32_t)0x00000000) /*@EN:Don't reset (default) @CN:λĬϣ*/
#define CRC_RESET_RESULT_EN     ((uint32_t)0x00000002) /*@EN:Reset the CRC result register @CN:λ CRC Ĵ*/
/* @end */

/* @defgroup CRC_RESET */
#define CRC_RESET_OFF           ((uint32_t)0x00000000) /*@EN:Don't reset (default) @CN:λĬϣ*/
#define CRC_RESET_ON            ((uint32_t)0x00000001) /*@EN:Reset the entire CRC related logic, and automatically clear the zero after one cycle @CN:λ CRC ߼һںԶ*/
/* @end */


/* ========================================================================== */
/* ================             CRC REGISTER BIT               ============== */
/* ========================================================================== */

/* ===============================  CRC_CTRL  =============================== */
#define CRC_CTRL_CRC_GPS_Pos                      (24UL)                       /* CRC_GPS (Bits 24)                        */
#define CRC_CTRL_CRC_GPS_Msk                      (0x03000000UL)               /* CRC_GPS (Bitfield-Mask: 0x03)            */
#define CRC_CTRL_CRC_SWAP_Pos                     (17UL)                       /* CRC_SWAP (Bits 17)                       */
#define CRC_CTRL_CRC_SWAP_Msk                     (0x00060000UL)               /* CRC_SWAP (Bitfield-Mask: 0x03)           */
#define CRC_CTRL_CRC_LMS_Pos                      (16UL)                       /* CRC_LMS (Bits 16)                        */
#define CRC_CTRL_CRC_LMS_Msk                      (0x00010000UL)               /* CRC_LMS (Bitfield-Mask: 0x01)            */
#define CRC_CTRL_CRC_INTV_EN_Pos                  (15UL)                       /* CRC_INTV_EN (Bits 15)                    */
#define CRC_CTRL_CRC_INTV_EN_Msk                  (0x00008000UL)               /* CRC_INTV_EN (Bitfield-Mask: 0x01)        */
#define CRC_CTRL_CRC_BYTE_Pos                     (8UL)                        /* CRC_BYTE (Bits 8)                        */
#define CRC_CTRL_CRC_BYTE_Msk                     (0x00000300UL)               /* CRC_BYTE (Bitfield-Mask: 0x03)           */
#define CRC_CTRL_CRC_VALID_Pos                    (2UL)                        /* CRC_VALID (Bits 2)                       */
#define CRC_CTRL_CRC_VALID_Msk                    (0x00000004UL)               /* CRC_VALID (Bitfield-Mask: 0x01)          */
#define CRC_CTRL_CRC_SRST_Pos                     (1UL)                        /* CRC_SRST (Bits 1)                        */
#define CRC_CTRL_CRC_SRST_Msk                     (0x00000002UL)               /* CRC_SRST (Bitfield-Mask: 0x01)           */
#define CRC_CTRL_CRC_SRSTALL_Pos                  (0UL)                        /* CRC_SRSTALL (Bits 0)                     */
#define CRC_CTRL_CRC_SRSTALL_Msk                  (0x00000001UL)               /* CRC_SRSTALL (Bitfield-Mask: 0x01)        */
/* ===============================  CRC_DATA  =============================== */
#define CRC_DATA_Pos                              (0UL)                        /* CRC_DATA (Bits 0)                        */
#define CRC_DATA_Msk                              (0xFFFFFFFFUL)               /* CRC_DATA (Bitfield-Mask: 0xFFFFFFFF)     */
/* ==============================  CRC_RESULT  ============================== */
#define CRC_RESULT_Pos                            (0UL)                        /* CRC_RESULT (Bits 0)                      */
#define CRC_RESULT_Msk                            (0xFFFFFFFFUL)               /* CRC_RESULT (Bitfield-Mask: 0xFFFFFFFF)   */
/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */


/* Exported functions ------------------------------------------------------- */

/* Initialization and Configuration functions *********************************/
void Crc_initial_config_8(CRC_TypeDef *CRCx, CRC_8_MODE_TypeDef CrcMode);
void Crc_initial_config_16a(CRC_TypeDef *CRCx, CRC_16A_MODE_TypeDef CrcMode);
void Crc_initial_config_16b(CRC_TypeDef *CRCx, CRC_16B_MODE_TypeDef CrcMode);
void Crc_initial_config_32(CRC_TypeDef *CRCx, CRC_32_MODE_TypeDef CrcMode);
/* CRC result acquisition functions *******************************************/
uint8_t CRC_CalcBlockCRC8(CRC_TypeDef *CRCx, CRC_8_MODE_TypeDef CrcMode, uint8_t pBuffer[], uint8_t BufferLength);
uint16_t CRC_CalcBlockCRC16a(CRC_TypeDef *CRCx, CRC_16A_MODE_TypeDef CrcMode, uint8_t pBuffer[], uint8_t BufferLength);
uint16_t CRC_CalcBlockCRC16b(CRC_TypeDef *CRCx, CRC_16B_MODE_TypeDef CrcMode, uint8_t pBuffer[], uint8_t BufferLength);
uint32_t CRC_CalcBlockCRC32(CRC_TypeDef *CRCx, CRC_32_MODE_TypeDef CrcMode, uint8_t pBuffer[], uint8_t BufferLength);

/* CRC read and write functions ***********************************************/
void Crc_write_crc_data(CRC_TypeDef *CRCx, uint32_t crc_data);
uint32_t Crc_read_result(CRC_TypeDef *CRCx);
void Crc_write_result(CRC_TypeDef *CRCx, uint32_t Data);

#ifdef __cplusplus
}
#endif

#endif /* __LCM32F06X_CRC_H__ */
