/**
  ******************************************************************************
  * @file    lcm32f06x_acmp.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   Header for acmp.c module
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCM32F06X_ACMP_H__
#define __LCM32F06X_ACMP_H__

/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

#ifdef __cplusplus
  extern "C" {
#endif

typedef struct
{
  uint32_t ACMP_TrigMode;       /*!< EN: Comparator trigger mode selection.
                                     CN: Ƚģʽѡ
                                     @Register: ACMPx_MUXCSR @Bits:[31]TRIG_MODE.
                                     @default: ACMP_TrigMode_Software */

  uint32_t ACMP_WorkMode;       /*!< EN: Comparator Work mode selection.
                                     CN: Ƚģʽѡ
                                     @Register: ACMPx_MUXCSR @Bits:[28:27]CMP_MODE.
                                     @default: ACMP_WorkMode_SingleCompar */

  uint32_t ACMP_P_Select;       /*!< EN: Comparator positive-end input selection.
                                     CN: Ƚѡ
                                     @Register: ACMPx_MUXCSR @Bits:[20:16]ACMP_P_SEL.
                                     @default: CP_PS_P0 */

  uint32_t ACMP_N_Select;       /*!< EN: Comparator negative-end input selection.
                                     CN: Ƚѡ
                                     @Register: ACMPx_MUXCSR @Bits:[28:24]ACMP_N_SEL.
                                     @default: CP_NS_N0 */

  uint32_t ACMP_CNT_CFG;        /*!< EN: Selection of clock cycles for switching between channels.
                                     CN: ͨлʱѡ
                                     @Register: ACMPx_MUXCSR @Bits:[7:1]CHNL_CNT_CFG.
                                     @range 0x0 - 0x7F.
                                     @default: 0 */

  uint32_t ACMP_FILTER_SEL;     /*!< EN: Comparator Digital filtering gear selection .
                                     CN: Ƚ˲λѡ
                                     @Register: ACMPx_CSR @Bits:[27:23]FILTER_SEL.
                                     @range 0x0 - 0x1F.
                                     @default: 0 */

  FunctionalState ACMP_LPS;     /*!< EN: ACMP low power mode.
                                     CN: ͹ģʽ
                                     @Register: ACMPx_CSR @Bits:[12]CP_LPS.
                                     @default: DISABLE */

  FunctionalState ACMP_FS;      /*!< EN: Enable configuration of output filtering.
                                     CN: ˲ʹá
                                     @Register: ACMPx_CSR @Bits:[11]CP_FS.
                                     @default: DISABLE */

  uint32_t ACMP_Delay_time;     /*!< EN: Output delay Configuration.
                                     CN: ӳá
                                     @Register: ACMPx_CSR @Bits:[10:9]CP_DLY.
                                     @range 0x0 - 0xFF.
                                     @default: 0 */

  uint32_t ACMP_Is;             /*!< EN: Comparator output polarity.
                                     CN: Ƚԡ
                                     @Register: ACMPx_CSR @Bits:[3]CP_IS.
                                     @default: CP_IS_POS */

  FunctionalState ACMP_HYSEN;   /*!< EN: Enable configuration of hysteresis.
                                     CN: ʹá
                                     @Register: ACMPx_CSR @Bits:[2]CP_HYSEN.
                                     @default: DISABLE */

  FunctionalState ACMP_FREN;    /*!< EN: Enable configuration of quick response.
                                     CN: Ӧʹܡ
                                     @Register: ACMPx_CSR @Bits:[1]CP_FREN.
                                     @default: DISABLE */

  uint32_t EXTSELECT;           /*!< EN: Enable two sets of trigger sources for ACMP.
                                     CN: ACMP 鴥Դʹܡ
                                     @Register: ACMPx_EXTCFG @Bits:[28:27]EXTSE.
                                     @default: ACMP_EXTSELG_DIS */

  uint32_t TRIG_DELAY_TIME;     /*!< EN: ACMP external trigger delay clock.
                                     CN: ACMP ⲿӳʱӡ
                                     @Register: ACMPx_EXTCFG @Bits:[11:4]EXTDTG.
                                     @default: TRIG_DELAY_TIME_0CLK */

  uint32_t EXTEN_MODE_SEL;      /*!< EN: Enable two sets of trigger sources for ACMP.
                                     CN: ACMP ⲿģʽѡ
                                     @Register: SysCtrl_EDU_CFG16 @Bits:[1:0]CP0_EXTEN [3:2]CP1_EXTEN.
                                     @default: ACMP_EXTEN_RISE */

  uint32_t TRIG_SOURCE;         /*!< EN: ACMP external trigger source selection.
                                     CN: ACMP ⲿԴѡ
                                     @Register: SysCtrl_EDU_CFG16 @Bits:[11:4]CPx_EXTSELx.
                                     @default: EXTSELG0_TIM1_TRIG_OC1 */

  uint32_t CP_EXTSP;            /*!< EN: Trigger source polarity selection.
                                     CN: Դѡ
                                     @Register: SysCtrl_EDU_CFG16 @Bits:[15:14]CP1_EXTSP [13:12]CP0_EXTSP.
                                     @default: CP_EXTSP_POS */
  
} ACMP_InitTypeDef;

/* @defgroup ACMP_TrigMode */
#define ACMP_TrigMode_Software        ((uint32_t)0x00000000) /*@EN: Software trigger mode          @CN: ģʽ     */
#define ACMP_TrigMode_External        ((uint32_t)0x80000000) /*@EN: External hardware trigger mode @CN: ⲿӲģʽ */
/* @end */

/* @defgroup ACMP_WorkMode */
#define ACMP_WorkMode_SingleCompar    ((uint32_t)0x00000000) /*@EN: Single comparison     @CN: αȽ */
#define ACMP_WorkMode_Single          ((uint32_t)0x08000000) /*@EN: Single sequence       @CN:  */
#define ACMP_WorkMode_IntermittentSeq ((uint32_t)0x10000000) /*@EN: Intermittent sequence @CN:  */
#define ACMP_WorkMode_ContinuousSeq   ((uint32_t)0x18000000) /*@EN: Continuous sequence   @CN:  */
/* @end */

/* @defgroup ACMP_P_Select */
#define CP_PS_P0                      ((uint32_t)0x00000000) /*@EN: External port input ACMP_P0 @CN: ⲿ˿ ACMP_P0 */
#define CP_PS_P1                      ((uint32_t)0x00010000) /*@EN: External port input ACMP_P1 @CN: ⲿ˿ ACMP_P1 */
#define CP_PS_P2                      ((uint32_t)0x00020000) /*@EN: External port input ACMP_P2 @CN: ⲿ˿ ACMP_P2 */
#define CP_PS_P3                      ((uint32_t)0x00030000) /*@EN: External port input ACMP_P3 @CN: ⲿ˿ ACMP_P3 */
#define CP_PS_P4                      ((uint32_t)0x00040000) /*@EN: External port input ACMP_P4 @CN: ⲿ˿ ACMP_P4 */
#define CP_PS_P5                      ((uint32_t)0x00050000) /*@EN: External port input ACMP_P5 @CN: ⲿ˿ ACMP_P5 */
#define CP_PS_P6                      ((uint32_t)0x00060000) /*@EN: External port input ACMP_P6 @CN: ⲿ˿ ACMP_P6 */
#define CP_PS_P7                      ((uint32_t)0x00070000) /*@EN: External port input ACMP_P7 @CN: ⲿ˿ ACMP_P7 */
#define CP_PS_HALL_MID                ((uint32_t)0x00080000) /*@EN: HALL_MID output             @CN: HALL_MID output      */
#define CP_PS_DACBUF_OUT              ((uint32_t)0x00100000) /*@EN: DACBUF_OUT output           @CN: DACBUF_OUT       */
#define CP_PS_CVREF                   ((uint32_t)0x00180000) /*@EN: CVREF                       @CN: CVREF                */
/* @end */

/* @defgroup ACMP_N_Select */
#define CP_NS_N0                      ((uint32_t)0x00000000) /*@EN: External port input ACMP_P0 @CN: ⲿ˿ ACMP_P0         */
#define CP_NS_N1                      ((uint32_t)0x01000000) /*@EN: External port input ACMP_P1 @CN: ⲿ˿ ACMP_P1         */
#define CP_NS_N2                      ((uint32_t)0x02000000) /*@EN: External port input ACMP_P2 @CN: ⲿ˿ ACMP_P2         */
#define CP_NS_N3                      ((uint32_t)0x03000000) /*@EN: External port input ACMP_P3 @CN: ⲿ˿ ACMP_P3         */
#define CP_NS_N4                      ((uint32_t)0x04000000) /*@EN: External port input ACMP_P4 @CN: ⲿ˿ ACMP_P4         */
#define CP_NS_HALL_MID                ((uint32_t)0x05000000) /*@EN: HALL_MID output   @CN: HALL_MID    */
#define CP_NS_DACBUF_OUT              ((uint32_t)0x06000000) /*@EN: DACBUF_OUT output @CN: DACBUF_OUT  */
#define CP_NS_CVREF                   ((uint32_t)0x07000000) /*@EN: CVREF             @CN: CVREF           */
/* @end */

/* @defgroup ACMP_Delay_time */
#define CP_Delay_20NS                 ((uint32_t)0x00000000) /*@EN: 20ns  @CN: 20ns  */
#define CP_Delay_100NS                ((uint32_t)0x00000200) /*@EN: 100ns @CN: 100ns */
#define CP_Delay_1US                  ((uint32_t)0x00000400) /*@EN: 1us   @CN: 1us   */
#define CP_Delay_2US                  ((uint32_t)0x00000600) /*@EN: 2us   @CN: 2us   */
/* @end */

/* @defgroup ACMP_Is */
#define CP_IS_POS                     ((uint32_t)0x00000000) /*@EN: ACMP positive phase output @CN: ACMP  */
#define CP_IS_REV                     ((uint32_t)0x00000008) /*@EN: ACMP reverse phase output  @CN: ACMP  */
/* @end */

/* @defgroup EXTSELECT */
#define ACMP_EXTSELG_DIS              ((uint32_t)0x00000000) /*@EN: Prohibit the corresponding trigger source from triggering ACMPx @CN: ֹӦԴ ACMPx */
#define ACMP_EXTSELG_0                ((uint32_t)0x08000000) /*@EN: Enable EXTSELG0 @CN: ʹ EXTSELG0 */
#define ACMP_EXTSELG_1                ((uint32_t)0x10000000) /*@EN: Enable EXTSELG1 @CN: ʹ EXTSELG1 */
/* @end */

/* @defgroup EXTEN_MODE_SEL */
#define ACMP_EXTEN_RISE               ((uint32_t)0x00000000) /*@EN: External rising edge trigger  @CN: ⲿش */
#define ACMP_EXTEN_FALL               ((uint32_t)0x00000001) /*@EN: External falling edge trigger @CN: ⲿ½ش */
#define ACMP_EXTEN_RISEANDFALL        ((uint32_t)0x00000002) /*@EN: External dual edge trigger    @CN: ⲿ˫ش   */
#define ACMP_EXTEN_DISABLE            ((uint32_t)0x00000003) /*@EN: External triggering is prohibited, only software triggering is supported @CN: ֹⲿ֧ */
/* @end */

/* @defgroup TRIG_SOURCE */
#define EXTSELG0_TIM1_TRIG_OC1        ((uint32_t)0x00000000) /*@EN: ACMP Group 1 Trigger SourceTIM1_TRIG_OC1  @CN: ACMP1鴥ԴTIM1_TRIG_OC1  */
#define EXTSELG0_TIM1_TRIG_OC2        ((uint32_t)0x00000010) /*@EN: ACMP Group 1 Trigger SourceTIM1_TRIG_OC2  @CN: ACMP1鴥ԴTIM1_TRIG_OC2  */
#define EXTSELG0_TIM2_TRGO            ((uint32_t)0x00000020) /*@EN: ACMP Group 1 Trigger SourceTIM2_TRGO      @CN: ACMP1鴥ԴTIM2_TRGO      */
#define EXTSELG0_TIM15_TRGO           ((uint32_t)0x00000030) /*@EN: ACMP Group 1 Trigger SourceTIM15_TRGO     @CN: ACMP1鴥ԴTIM15_TRGO     */
#define EXTSELG1_TIM1_TRIG_OC3        ((uint32_t)0x00000000) /*@EN: ACMP Group 2 Trigger SourceTIM1_TRIG_OC3  @CN: ACMP2鴥ԴTIM1_TRIG_OC3  */
#define EXTSELG1_TIM1_TRIG_OC5        ((uint32_t)0x00000040) /*@EN: ACMP Group 2 Trigger SourceTIM1_TRIG_OC5  @CN: ACMP2鴥ԴTIM1_TRIG_OC5  */
#define EXTSELG1_TIM16_TRIG_OC1       ((uint32_t)0x00000080) /*@EN: ACMP Group 2 Trigger SourceTIM16_TRIG_OC1 @CN: ACMP2鴥ԴTIM16_TRIG_OC1 */
#define EXTSELG1_TIM17_TRIG_OC1       ((uint32_t)0x000000C0) /*@EN: ACMP Group 2 Trigger SourceTIM17_TRIG_OC1 @CN: ACMP2鴥ԴTIM17_TRIG_OC1 */
/* @end */

/* @defgroup CP_EXTSP */
#define CP_EXTSP_POS                  ((uint32_t)0x00000000) /*@EN: non-inverting input @CN: ͬ */
#define CP_EXTSP0_NOS                 ((uint32_t)0x00000001) /*@EN: The second set of trigger sources Inverted input @CN: һ鴥Դ  */
#define CP_EXTSP1_NOS                 ((uint32_t)0x00000002) /*@EN: The first set of trigger sources Inverted input @CN: ڶ鴥Դ  */
/* @end */

/* @defgroup TRIG_DELAY_TIME */
#define TRIG_DELAY_TIME_0CLK          ((uint32_t)0x00000000) /*@EN: 0 PCLK  @CN: 0 PCLK  */
#define TRIG_DELAY_TIME_64CLK         ((uint32_t)0x00000040) /*@EN: 64 PCLK @CN: 64 PCLK */
/* @end */

/* @defgroup HALL_IP1_ACMP0 */
#define HALL_IP1_ACMP0_P4             ((uint8_t)0x0000) /*@EN: HALL_IP1 channel selection ACMP0_P4 @CN: HALL_IP1 ͨѡ ACMP0_P4 */
#define HALL_IP1_ACMP0_P0             ((uint8_t)0x0001) /*@EN: HALL_IP1 channel selection ACMP0_P0 @CN: HALL_IP1 ͨѡ ACMP0_P0 */
#define IS_HALL_IP1(IP1)              ((IP1 == HALL_IP1_ACMP0_P4) || (IP1 == (HALL_IP1_ACMP0_P0)))
/* @end */

/* @defgroup HALL_IP2_ACMP0 */
#define HALL_IP2_ACMP0_P5             ((uint8_t)0x0000) /*@EN: HALL_IP2 channel selection ACMP0_P5 @CN: HALL_IP2 ͨѡ ACMP0_P5 */
#define HALL_IP2_ACMP0_P1             ((uint8_t)0x0001) /*@EN: HALL_IP2 channel selection ACMP0_P1 @CN: HALL_IP2 ͨѡ ACMP0_P1 */
#define IS_HALL_IP2(IP2)              ((IP2 == HALL_IP2_ACMP0_P5) || (IP2 == (HALL_IP2_ACMP0_P1)))
/* @end */

/* @defgroup HALL_IP3_ACMP0 */
#define HALL_IP3_ACMP0_P6             ((uint8_t)0x0000) /*@EN: HALL_IP3 channel selection ACMP0_P6 @CN: HALL_IP3 ͨѡ ACMP0_P6 */
#define HALL_IP3_ACMP0_P2             ((uint8_t)0x0001) /*@EN: HALL_IP3 channel selection ACMP0_P2 @CN: HALL_IP3 ͨѡ ACMP0_P2 */
#define IS_HALL_IP3(IP3)              ((IP3 == HALL_IP3_ACMP0_P6) || (IP3 == (HALL_IP3_ACMP0_P2)))
/* @end */

/* @defgroup VRH_SEL */
#define VRH_SEL_VDDA_0                ((uint32_t)0x00000000) /*@EN: VRRH:0 VRRL:0 VRHVS:VDDA     @CN: VRRH:0 VRRL:0 VRHVS:VDDA */
#define VRH_SEL_VDDA_1                ((uint32_t)0x40000000) /*@EN: VRRH:0 VRRL:1 VRHVS:VDDA     @CN: VRRH:0 VRRL:1 VRHVS:VDDA */
#define VRH_SEL_VDDA_2                ((uint32_t)0x80000000) /*@EN: VRRH:1 VRRL:0 VRHVS:VDDA     @CN: VRRH:1 VRRL:0 VRHVS:VDDA */
#define VRH_SEL_VDDA_3                ((uint32_t)0xC0000000) /*@EN: VRRH:1 VRRL:1 VRHVS:VDDA     @CN: VRRH:1 VRRL:1 VRHVS:VDDA */
#define VRH_SEL_ADC_VREF_0            ((uint32_t)0x20000000) /*@EN: VRRH:0 VRRL:0 VRHVS:ADC_VREF @CN: VRRH:0 VRRL:0 VRHVS:ADC_VREF */
#define VRH_SEL_ADC_VREF_1            ((uint32_t)0x60000000) /*@EN: VRRH:0 VRRL:1 VRHVS:ADC_VREF @CN: VRRH:0 VRRL:1 VRHVS:ADC_VREF */
#define VRH_SEL_ADC_VREF_2            ((uint32_t)0xA0000000) /*@EN: VRRH:1 VRRL:0 VRHVS:ADC_VREF @CN: VRRH:1 VRRL:0 VRHVS:ADC_VREF */
#define VRH_SEL_ADC_VREF_3            ((uint32_t)0xE0000000) /*@EN: VRRH:1 VRRL:1 VRHVS:ADC_VREF @CN: VRRH:1 VRRL:1 VRHVS:ADC_VREF */
#define IS_VRH_SEL(VRH)               ((VRH == VRH_SEL_VDDA_0) || (VRH == (VRH_SEL_VDDA_1)) || \
                                       (VRH == VRH_SEL_VDDA_2) || (VRH == (VRH_SEL_VDDA_3)) || \
                                       (VRH == VRH_SEL_ADC_VREF_0) || (VRH == (VRH_SEL_ADC_VREF_1)) || \
                                       (VRH == VRH_SEL_ADC_VREF_2) || (VRH == (VRH_SEL_ADC_VREF_3)))
/* @end */

/* @defgroup BlankingSource */
#define Blanking_Software             ((uint32_t)0x00000080)  /*@EN: ACMP Hidden Source Selection : Blanking_Software @CN:ACMPԴѡ: Blanking_Software*/
#define Blanking_TIM2_TRIG_OC4        ((uint32_t)0x00000040)  /*@EN: ACMP Hidden Source Selection : Blanking_TIM2_TRIG_OC4 @CN:ACMPԴѡ: Blanking_TIM2_TRIG_OC4*/
#define Blanking_TIM15_TRIG_OC2       ((uint32_t)0x00000020)  /*@EN: ACMP Hidden Source Selection : Blanking_TIM15_TRIG_OC2 @CN:ACMPԴѡ: Blanking_TIM15_TRIG_OC2*/
#define Blanking_TIM15_TRIG_OC1       ((uint32_t)0x00000010)  /*@EN: ACMP Hidden Source Selection : Blanking_TIM15_TRIG_OC1 @CN:ACMPԴѡ: Blanking_TIM15_TRIG_OC1*/
#define Blanking_TIM1_TRIG_OC5        ((uint32_t)0x00000008)  /*@EN: ACMP Hidden Source Selection : Blanking_TIM1_TRIG_OC5 @CN:ACMPԴѡ: Blanking_TIM1_TRIG_OC5*/
#define Blanking_TIM1_TRIG_OC3        ((uint32_t)0x00000004)  /*@EN: ACMP Hidden Source Selection : Blanking_TIM1_TRIG_OC3 @CN:ACMPԴѡ: Blanking_TIM1_TRIG_OC3*/
#define Blanking_TIM1_TRIG_OC2        ((uint32_t)0x00000002)  /*@EN: ACMP Hidden Source Selection : Blanking_TIM1_TRIG_OC2 @CN:ACMPԴѡ: Blanking_TIM1_TRIG_OC2*/
#define Blanking_TIM1_TRIG_OC1        ((uint32_t)0x00000001)  /*@EN: ACMP Hidden Source Selection : Blanking_TIM1_TRIG_OC1 @CN:ACMPԴѡ: Blanking_TIM1_TRIG_OC1*/
/* @end */

/* @defgroup Poll_Mode */
#define POLL_MODE_POSITIVE            ((uint32_t)0x00000000) /*@EN: Positive end polling @CN: ѯ */
#define POLL_MODE_NEGATIVE            ((uint32_t)0x10000000) /*@EN: Negative end polling @CN: ѯ */
/* @end */

/* @defgroup Poll_ChannelNum */
#define POLL_CHANNEL_NUM_1            ((uint32_t)0x00000000) /*@EN: 1 channel polling @CN: 1ͨѯ */
#define POLL_CHANNEL_NUM_2            ((uint32_t)0x01000000) /*@EN: 2 channel polling @CN: 2ͨѯ */
#define POLL_CHANNEL_NUM_3            ((uint32_t)0x02000000) /*@EN: 3 channel polling @CN: 3ͨѯ */
#define POLL_CHANNEL_NUM_4            ((uint32_t)0x03000000) /*@EN: 4 channel polling @CN: 4ͨѯ */
/* @end */

/* @defgroup Poll_OutputType */
#define POLL_OUTTYPE_Normal           ((uint32_t)0x00000000) /*@EN: normal comparison results @CN: ıȽϽ */
#define POLL_OUTTYPE_SEQ0             ((uint32_t)0x00800000) /*@EN: Output CPOUT-SEQ [0] result @CN: CPOUT_SEQ[0] */
#define POLL_OUTTYPE_SEQ1             ((uint32_t)0x00900000) /*@EN: Output CPOUT-SEQ [1] result @CN: CPOUT_SEQ[1] */
#define POLL_OUTTYPE_SEQ2             ((uint32_t)0x00A00000) /*@EN: Output CPOUT-SEQ [2] result @CN: CPOUT_SEQ[2] */
#define POLL_OUTTYPE_SEQ3             ((uint32_t)0x00B00000) /*@EN: Output CPOUT-SEQ [3] result @CN: CPOUT_SEQ[3] */
#define POLL_OUTTYPE_SEQ4             ((uint32_t)0x00C00000) /*@EN: Output CPOUT-SEQ [4] result @CN: CPOUT_SEQ[4] */
#define POLL_OUTTYPE_SEQ5             ((uint32_t)0x00D00000) /*@EN: Output CPOUT-SEQ [5] result @CN: CPOUT_SEQ[5] */
#define POLL_OUTTYPE_SEQ6             ((uint32_t)0x00E00000) /*@EN: Output CPOUT-SEQ [6] result @CN: CPOUT_SEQ[6] */
#define POLL_OUTTYPE_SEQ7             ((uint32_t)0x00F00000) /*@EN: Output CPOUT-SEQ [7] result @CN: CPOUT_SEQ[7] */
/* @end */

/* @defgroup Poll_Position */
#define POLL_POSITION_0               ((uint8_t)0x00) /*@EN: Polling comparison channel position 0 @CN: ѯȽͨλ0 */
#define POLL_POSITION_1               ((uint8_t)0x04) /*@EN: Polling comparison channel position 1 @CN: ѯȽͨλ1 */
#define POLL_POSITION_2               ((uint8_t)0x08) /*@EN: Polling comparison channel position 2 @CN: ѯȽͨλ2 */
#define POLL_POSITION_3               ((uint8_t)0x0C) /*@EN: Polling comparison channel position 3 @CN: ѯȽͨλ3 */
/* @end */

/* @defgroup Poll_ChannelSel */
#define POLL_CHANNEL_0               ((uint8_t)0x00) /*@EN: Polling comparison channel 0 @CN: ѯȽͨ0 */
#define POLL_CHANNEL_1               ((uint8_t)0x01) /*@EN: Polling comparison channel 1 @CN: ѯȽͨ1 */
#define POLL_CHANNEL_2               ((uint8_t)0x02) /*@EN: Polling comparison channel 2 @CN: ѯȽͨ2 */
#define POLL_CHANNEL_3               ((uint8_t)0x03) /*@EN: Polling comparison channel 3 @CN: ѯȽͨ3 */
#define POLL_CHANNEL_4               ((uint8_t)0x04) /*@EN: Polling comparison channel 4 @CN: ѯȽͨ4 */
#define POLL_CHANNEL_5               ((uint8_t)0x05) /*@EN: Polling comparison channel 5 @CN: ѯȽͨ5 */
#define POLL_CHANNEL_6               ((uint8_t)0x06) /*@EN: Polling comparison channel 6 @CN: ѯȽͨ6 */
#define POLL_CHANNEL_7               ((uint8_t)0x07) /*@EN: Polling comparison channel 7 @CN: ѯȽͨ7 */
/* @end */

/* ========================================================================== */
/* ================             ACMP REGISTER BIT               ============= */
/* ========================================================================== */

/* =================================  CSR  ================================== */
#define ANACTRL_ACMPX_CSR_CP_OUT_Pos              (28UL)                       /*!< CP_OUT (Bit 28)                     */
#define ANACTRL_ACMPX_CSR_CP_OUT_Msk              (0x10000000UL)               /*!< CP_OUT (Bitfield-Mask: 0x1)         */
#define ANACTRL_ACMPX_CSR_FILTER_SEL_Pos          (23UL)                       /*!< FILTER_SEL (Bit 23)                 */
#define ANACTRL_ACMPX_CSR_FILTER_SEL_Msk          (0x0F800000UL)               /*!< FILTER_SEL (Bitfield-Mask: 0x1F)    */
#define ANACTRL_ACMPX_CSR_MISS_TRIG_Pos           (21UL)                       /*!< MISS_TRIG (Bit 21)                  */
#define ANACTRL_ACMPX_CSR_MISS_TRIG_Msk           (0x00200000UL)               /*!< MISS_TRIG (Bitfield-Mask: 0x1)      */
#define ANACTRL_ACMPX_CSR_CP_PF_Pos               (16UL)                       /*!< CP_PF (Bit 16)                      */
#define ANACTRL_ACMPX_CSR_CP_PF_Msk               (0x001F0000UL)               /*!< CP_PF (Bitfield-Mask: 0x1F)         */
#define ANACTRL_ACMPX_CSR_CP_LPS_Pos              (15UL)                       /*!< CP_LPS (Bit 15)                     */
#define ANACTRL_ACMPX_CSR_CP_LPS_Msk              (0x00008000UL)               /*!< CP_LPS (Bitfield-Mask: 0x1)         */
#define ANACTRL_ACMPX_CSR_CP_FS_Pos               (11UL)                       /*!< CP_FS (Bit 11)                      */
#define ANACTRL_ACMPX_CSR_CP_FS_Msk               (0x00000800UL)               /*!< CP_FS (Bitfield-Mask: 0x1)          */
#define ANACTRL_ACMPX_CSR_CP_DLY_Pos              (9UL)                        /*!< CP_DLY (Bit 9)                      */
#define ANACTRL_ACMPX_CSR_CP_DLY_Msk              (0x00000600UL)               /*!< CP_DLY (Bitfield-Mask: 0x3)         */
#define ANACTRL_ACMPX_CSR_CP_IS_Pos               (3UL)                        /*!< CP_IS (Bit 3)                       */
#define ANACTRL_ACMPX_CSR_CP_IS_Msk               (0x00000008UL)               /*!< CP_IS (Bitfield-Mask: 0x3)          */
#define ANACTRL_ACMPX_CSR_CP_HYSEN_Pos            (2UL)                        /*!< CP_HYSEN (Bit 8)                    */
#define ANACTRL_ACMPX_CSR_CP_HYSEN_Msk            (0x00000004UL)               /*!< CP_HYSEN (Bitfield-Mask: 0x1)       */
#define ANACTRL_ACMPX_CSR_CP_FREN_Pos             (1UL)                        /*!< CP_FREN (Bit 3)                     */
#define ANACTRL_ACMPX_CSR_CP_FREN_Msk             (0x00000002UL)               /*!< CP_FREN (Bitfield-Mask: 0x1)        */
#define ANACTRL_ACMPX_CSR_CP_EN_Pos               (0UL)                        /*!< CP_EN (Bit 0)                       */
#define ANACTRL_ACMPX_CSR_CP_EN_Msk               (0x00000001UL)               /*!< CP_EN (Bitfield-Mask: 0x1)          */
/* =================================  MUXCSR  =============================== */
#define ANACTRL_ACMPX_MUXCSR_TRIG_MODE_Pos        (31UL)                       /*!< TRIG_MODE (Bit 31)                  */
#define ANACTRL_ACMPX_MUXCSR_TRIG_MODE_Msk        (0x80000000UL)               /*!< TRIG_MODE (Bitfield-Mask: 0x1)      */
#define ANACTRL_ACMPX_MUXCSR_CMP_INT_FLG_Pos      (30UL)                       /*!< CMP_INT_FLG (Bit 30)                */
#define ANACTRL_ACMPX_MUXCSR_CMP_INT_FLG_Msk      (0x40000000UL)               /*!< CMP_INT_FLG (Bitfield-Mask: 0x1)    */
#define ANACTRL_ACMPX_MUXCSR_CMP_INTEN_Pos        (29UL)                       /*!< CMP_INTEN (Bit 29)                  */
#define ANACTRL_ACMPX_MUXCSR_CMP_INTEN_Msk        (0x20000000UL)               /*!< CMP_INTEN (Bitfield-Mask: 0x1)      */
#define ANACTRL_ACMPX_MUXCSR_CMP_MODE_Pos         (27UL)                       /*!< CMP_MODE (Bit 27)                   */
#define ANACTRL_ACMPX_MUXCSR_CMP_MODE_Msk         (0x18000000UL)               /*!< CMP_MODE (Bitfield-Mask: 0x1)       */
#define ANACTRL_ACMPX_MUXCSR_ACMP_N_SEL_Pos       (24UL)                       /*!< ACMP_N_SEL (Bit 24)                 */
#define ANACTRL_ACMPX_MUXCSR_ACMP_N_SEL_Msk       (0x07000000UL)               /*!< ACMP_N_SEL (Bitfield-Mask: 0x7)     */
#define ANACTRL_ACMPX_MUXCSR_ACMP_P_SEL1_Pos      (19UL)                       /*!< ACMP_P_SEL1 (Bit 19)                */
#define ANACTRL_ACMPX_MUXCSR_ACMP_P_SEL1_Msk      (0x00180000UL)               /*!< ACMP_P_SEL1 (Bitfield-Mask: 0x3)    */
#define ANACTRL_ACMPX_MUXCSR_ACMP_P_SEL0_Pos      (16UL)                       /*!< ACMP_P_SEL0 (Bit 16)                */
#define ANACTRL_ACMPX_MUXCSR_ACMP_P_SEL0_Msk      (0x00070000UL)               /*!< ACMP_P_SEL0 (Bitfield-Mask: 0x7)    */
#define ANACTRL_ACMPX_MUXCSR_CPOUT_SEQ_Pos        (8UL)                        /*!< CPOUT_SEQ (Bit 8)                   */
#define ANACTRL_ACMPX_MUXCSR_CPOUT_SEQ_Msk        (0x0000FF00UL)               /*!< CPOUT_SEQ (Bitfield-Mask: 0xFF)     */
#define ANACTRL_ACMPX_MUXCSR_CHNL_CNT_CFG_Pos     (1UL)                        /*!< CHNL_CNT_CFG (Bit 1)                */
#define ANACTRL_ACMPX_MUXCSR_CHNL_CNT_CFG_Msk     (0x000000F7UL)               /*!< CHNL_CNT_CFG (Bitfield-Mask: 0x7F)  */
#define ANACTRL_ACMPX_MUXCSR_CMP_SEQ_START_Pos    (0UL)                        /*!< CMP_SEQ_START (Bit 0)               */
#define ANACTRL_ACMPX_MUXCSR_CMP_SEQ_START_Msk    (0x00000001UL)               /*!< CMP_SEQ_START (Bitfield-Mask: 0x1)  */
/* =================================  EXTCFG  =============================== */
#define ANACTRL_ACMPX_EXTCFG_EXTSE_Pos            (27UL)                       /*!< EXTCFG_EXTSE (Bit 27)               */
#define ANACTRL_ACMPX_EXTCFG_EXTSE_Msk            (0x18000FF0UL)               /*!< EXTCFG_EXTSE (Bitfield-Mask: 0x3)   */
#define ANACTRL_ACMPX_EXTCFG_EXTDTG_Pos           (4UL)                        /*!< EXTCFG_EXTDTG (Bit 4)               */
#define ANACTRL_ACMPX_EXTCFG_EXTDTG_Msk           (0x00000FF0UL)               /*!< EXTCFG_EXTDTG (Bitfield-Mask: 0xFF) */
/* =================================  CHNLSEL  ============================== */
#define ANACTRL_ACMPX_CHNLSEL_POLL_PS_Pos         (28UL)                       /*!< POLL_PS (Bit 28)                    */
#define ANACTRL_ACMPX_CHNLSEL_POLL_PS_Msk         (0x10000000UL)               /*!< POLL_PS (Bitfield-Mask: 0x1)        */
#define ANACTRL_ACMPX_CHNLSEL_CHNL_NUM_Pos        (24UL)                       /*!< CHNL_NUM (Bit 24)                   */
#define ANACTRL_ACMPX_CHNLSEL_CHNL_NUM_Msk        (0x03000000UL)               /*!< CHNL_NUM (Bitfield-Mask: 0x3)       */
#define ANACTRL_ACMPX_CHNLSEL_OUT_TYPE_Pos        (23UL)                       /*!< OUT_TYPE (Bit 23)                   */
#define ANACTRL_ACMPX_CHNLSEL_OUT_TYPE_Msk        (0x00800000UL)               /*!< OUT_TYPE (Bitfield-Mask: 0x1)       */
#define ANACTRL_ACMPX_CHNLSEL_CHNLSEL_OUT_Pos     (20UL)                       /*!< CHNLSEL_OUT (Bit 20)                */
#define ANACTRL_ACMPX_CHNLSEL_CHNLSEL_OUT_Msk     (0x00700000UL)               /*!< CHNLSEL_OUT (Bitfield-Mask: 0x7)    */
#define ANACTRL_ACMPX_CHNLSEL_CHNLSEL3_Pos        (12UL)                       /*!< CHNLSEL3 (Bit 12)                   */
#define ANACTRL_ACMPX_CHNLSEL_CHNLSEL3_Msk        (0x00007000UL)               /*!< CHNLSEL3 (Bitfield-Mask: 0x7)       */
#define ANACTRL_ACMPX_CHNLSEL_CHNLSEL2_Pos        (8UL)                        /*!< CHNLSEL2 (Bit 8)                    */
#define ANACTRL_ACMPX_CHNLSEL_CHNLSEL2_Msk        (0x00000700UL)               /*!< CHNLSEL2 (Bitfield-Mask: 0x7)       */
#define ANACTRL_ACMPX_CHNLSEL_CHNLSEL1_Pos        (4UL)                        /*!< CHNLSEL1 (Bit 4)                    */
#define ANACTRL_ACMPX_CHNLSEL_CHNLSEL1_Msk        (0x00000070UL)               /*!< CHNLSEL1 (Bitfield-Mask: 0x7)       */
#define ANACTRL_ACMPX_CHNLSEL_CHNLSEL0_Pos        (0UL)                        /*!< CHNLSEL0(Bit 0)                     */
#define ANACTRL_ACMPX_CHNLSEL_CHNLSEL0_Msk        (0x00000007UL)               /*!< CHNLSEL0 (Bitfield-Mask: 0x7)       */
/* ================================== HALL_CR   ============================= */
#define ANACTRL_HALL_CR_HALL_SW3_Pos              (6UL)                        /*!< SW3 (Bit 6)                         */
#define ANACTRL_HALL_CR_HALL_SW3_Msk              (0x00000003UL)               /*!< SW3 (Bitfield-Mask: 0x1)            */
#define ANACTRL_HALL_CR_HALL_SW2_Pos              (5UL)                        /*!< SW2 (Bit 5)                         */
#define ANACTRL_HALL_CR_HALL_SW2_Msk              (0x00000002UL)               /*!< SW2 (Bitfield-Mask: 0x1)            */
#define ANACTRL_HALL_CR_HALL_SW1_Pos              (4UL)                        /*!< SW1 (Bit 4)                         */
#define ANACTRL_HALL_CR_HALL_SW1_Msk              (0x00000001UL)               /*!< SW1 (Bitfield-Mask: 0x1)            */
#define ANACTRL_HALL_CR_HALL_IP3_SEL_Pos          (3UL)                        /*!< IP3_SEL (Bit 3)                     */
#define ANACTRL_HALL_CR_HALL_IP3_SEL_Msk          (0x00000004UL)               /*!< IP3_SEL (Bitfield-Mask: 0x1)        */
#define ANACTRL_HALL_CR_HALL_IP2_SEL_Pos          (2UL)                        /*!< IP2_SEL (Bit 2)                     */
#define ANACTRL_HALL_CR_HALL_IP2_SEL_Msk          (0x00000003UL)               /*!< IP2_SEL (Bitfield-Mask: 0x1)        */
#define ANACTRL_HALL_CR_HALL_IP1_SEL_Pos          (1UL)                        /*!< IP1_SEL (Bit 1)                     */
#define ANACTRL_HALL_CR_HALL_IP1_SEL_Msk          (0x00000002UL)               /*!< IP1_SEL (Bitfield-Mask: 0x1)        */
#define ANACTRL_HALL_CR_HALL_MID_EN_Pos           (0UL)                        /*!< MID_EN (Bit 0)                      */
#define ANACTRL_HALL_CR_HALL_MID_EN_Msk           (0x00000001UL)               /*!< MID_EN (Bitfield-Mask: 0x1)         */
/* ==================================  ANA_CTRL  ============================ */
#define ANACTRL_ANA_CTRL_VRHH_Pos                 (31UL)                       /*!< VRHH (Bit 31)                       */
#define ANACTRL_ANA_CTRL_VRHH_Msk                 (0x80000000UL)               /*!< VRHH (Bitfield-Mask: 0x1)           */
#define ANACTRL_ANA_CTRL_VRHL_Pos                 (30UL)                       /*!< VRHL (Bit 30)                       */
#define ANACTRL_ANA_CTRL_VRHL_Msk                 (0x40000000UL)               /*!< VRHL (Bitfield-Mask: 0x1)           */
#define ANACTRL_ANA_CTRL_VRHVS_Pos                (29UL)                       /*!< VRHVS (Bit 29)                      */
#define ANACTRL_ANA_CTRL_VRHVS_Msk                (0x20000000UL)               /*!< VRHVS (Bitfield-Mask: 0x1)          */
#define ANACTRL_ANA_CTRL_RDS_Pos                  (25UL)                       /*!< RDS (Bit 25)                        */
#define ANACTRL_ANA_CTRL_RDS_Msk                  (0x1E000000UL)               /*!< RDS (Bitfield-Mask: 0xF)            */
#define ANACTRL_ANA_CTRL_CVERFEN_Pos              (24UL)                       /*!< CVERFEN (Bit 24)                    */
#define ANACTRL_ANA_CTRL_CVERFEN_Msk              (0x01000000UL)               /*!< CVERFEN (Bitfield-Mask: 0x1)        */
/* =================================  ANACTRL_KEY  ========================== */
#define ANACTRL_KEY_Pos                           0                            /*!< KEY (Bit 0)                         */
#define ANACTRL_KEY_Msk                           (0xFFFFFFFFUL)               /*!< KEY (Bitfield-Mask: 0xFFFFFFFFUL)   */
#define ANACTRL_KEY_VALUE                         0xA98BC56D

/* ========================================================================== */
/* ================                  END                      =============== */
/* ========================================================================== */

void ACMP0_Init(ACMP_InitTypeDef *ACMP_InitStruct);
void ACMP1_Init(ACMP_InitTypeDef *ACMP_InitStruct);
void ACMP_StructInit(ACMP_InitTypeDef *ACMP_InitStruct);
void ACMP0_SoftWareTrigger(void);
void ACMP1_SoftWareTrigger(void);
uint32_t GET_ACMP0_SEQ_RESLUT(void);
uint32_t GET_ACMP1_SEQ_RESLUT(void);
void ACMP0_Cmd(FunctionalState NewState);
void ACMP1_Cmd(FunctionalState NewState);
void ACMP0_FREN_Cmd(FunctionalState NewState);
void ACMP1_FREN_Cmd(FunctionalState NewState);

void Acmp0_trim(uint8_t trim);
void Acmp1_trim(uint8_t trim);
uint8_t get_acmp0_trim(void);
uint8_t get_acmp1_trim(void);
void ACMP0_TrimInit(void);
void ACMP1_TrimInit(void);

void Hallmid_IP1_Config(uint32_t HALL_IP1, FunctionalState NewState);
void Hallmid_IP2_Config(uint32_t HALL_IP2, FunctionalState NewState);
void Hallmid_IP3_Config(uint32_t HALL_IP3, FunctionalState NewState);
void Hallmid_Cmd(FunctionalState NewState);

void ACMP_ANA_CVREFCfg(FunctionalState NewState, uint32_t VRH_SEL,uint8_t RDS_SEL);

void ACMP0_BlankingCfg(uint32_t BlankingSource, FunctionalState NewState);
void ACMP1_BlankingCfg(uint32_t BlankingSource, FunctionalState NewState);

void ACMP0_PollModeCfg(uint32_t Poll_Mode, uint32_t Poll_ChannelNum, uint32_t Poll_OutputType);
void ACMP1_PollModeCfg(uint32_t Poll_Mode, uint32_t Poll_ChannelNum, uint32_t Poll_OutputType);

void ACMP0_PollChannelSelxCfg(uint32_t Poll_Position, uint32_t Poll_ChannelSel);
void ACMP1_PollChannelSelxCfg(uint32_t Poll_Position, uint32_t Poll_ChannelSel);
#ifdef __cplusplus
}
#endif

#endif /* __LCM32F06X_ACMP_H__ */
