/**
  ******************************************************************************
  * @file    lcm32f06x_system.c
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   This file provides all the system firmware functions.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Includes ------------------------------------------------------------------*/
#include "lcm32f06x.h"

/**
  * @name   SystemInit
  * @brief  EN: System Init.
  *         CN: 系统初始化。
  * @return None
  */
void SystemInit(void)
{
  
  PWR_LVRCmd(DISABLE);
  PWR_LVRConfig(PWR_LVRLevel_2V5);
  PWR_LVRCmd(ENABLE);
  PWR_LVDCmd(DISABLE);
  PWR_LVDConfig(PWR_LVDInternal, PWR_LVDInternal_2V7);
  PWR_LVDCmd(ENABLE);

  chipctrl_access();
  CHIPCTRL->CLK_CFG = 0x00081000;
  __dekey();
  chipctrl_access();
  CHIPCTRL->CTRL = 0x00000000;
  __dekey();
  chipctrl_access();
  CHIPCTRL->BDCR_b.BDRST = 1; // 0：WT domain software not reset
  __dekey();
  chipctrl_access();
  if(RD_REG(0x1FFFF71C) & 0x1)  /* PB2 引脚的切换与选项字节中SWD_SEL有关系，因此不能强制赋值1。根据SWD_SEL选择切换 */
  {
    CHIPCTRL->BDCR = 0x0000F004;
  }
  else
  {
    CHIPCTRL->BDCR = 0x0000B004;
  }
  __dekey();
  sysctrl_access();
  SYSCTRL->ClkEnR0 = 0x00060000; // SRAM0、SRAM1 enable
  __dekey();
}
