/**
  ******************************************************************************
  * @file    lcm32f06x.h 
  * @author  System R&D Team
  * @version V2.0.2
  * @date    10-April-2025
  * @brief   CMSIS Cortex-M0 Device Peripheral Access Layer Header File. 
  *          This file contains all the peripheral register's definitions, bits 
  *          definitions and memory mapping for LCM32F06X devices.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Hangzhou Lingxin Microelectronics Co.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
/** @addtogroup
 * @{
 */

/** @addtogroup lcm32f06x
 * @{
 */

#ifndef __LCM32F06X_H__
#define __LCM32F06X_H__
 
#ifdef __cplusplus
extern "C"
{
#endif

    /** @addtogroup Configuration_of_CMSIS
     * @{
     */

    /* ======================================================================================================================= */
    /* ================Interrupt Number Definition================ */
    /* ======================================================================================================================= */

    typedef enum
    {
        /* =======================================  ARM Cortex-M0 Specific Interrupt Numbers  ================================ */
        Reset_IRQn              = -15,      /*!< -15  Reset Vector, invoked on Power up and warm reset          */
        NonMaskableInt_IRQn     = -14,      /*!< -14  Non maskable Interrupt, cannot be stopped or preempted    */
        HardFault_IRQn          = -13,      /*!< -13  Hard Fault, all classes of Fault                          */
        SVCall_IRQn             = -5,       /*!< -5 System Service Call via SVC instruction                     */
        PendSV_IRQn             = -2,       /*!< -2 Pendable request for system service                         */
        SysTick_IRQn            = -1,       /*!< -1 System Tick Timer                                           */
        /* =========================================  lcm32f06x Specific Interrupt Numbers  ================================== */

        EXTI16_LVD_IRQn         = 1,        /*!< 1  EXTI16_LVD Interrupt                    */
        EXTI17_WT_IRQn          = 2,        /*!< 2  EXTI17 Interrupt                        */
        EFLS_IRQn               = 3,        /*!< 3  falsh controller interrupt              */
        CHIPCTRL_IRQn           = 4,        /*!< 4  rcc Interrupt                           */
        EXTI0_1_IRQn            = 5,        /*!< 5  exti line from 0 to 1 interrupt         */
        EXTI2_3_IRQn            = 6,        /*!< 6  exti line from 2 to 3 interrupt         */
        EXTI4_15_IRQn           = 7,        /*!< 7  exti line from 4 to 15 interrupt        */
        ACMP_EXTI18_19_IRQn     = 8,        /*!< 8  ACMP Output and exti line from 18 to 19 interrupt       */
        DMAC_CH0_IRQn           = 9,        /*!< 9  DMAC_CH0 ISR interrupt                  */
        DMAC_CH1_IRQn           = 10,       /*!< 10 DMAC_CH1 ISR interrupt                  */
        SRAM_IRQn               = 11,       /*!< 11 SRAM interrupt                          */
        ADC_IRQn                = 12,       /*!< 12 adc interrupt                           */
        TIM1_NON_CC_IRQn        = 13,       /*!< 13 TIM1_NON_CC interrupt                   */
        TIM1_CC_IRQn            = 14,       /*!< 14 TIM1_CC interrupt                       */
        TIM2_IRQn               = 15,       /*!< 15 tim2 interrupt                          */
        EXTI22_24_LP_USART_IRQn = 16,       /*!< 16 exti line from 22 to 24 interrupt       */
        DAC0_IRQn               = 17,       /*!< 17 dac0 interrupt                          */
        ACMP_EXTI20_21_IRQn     = 18,       /*!< 18 ACMP0/1 exti20 to 21 interrupt          */

        TIM15_IRQn              = 20,       /*!< 20 tim15 interrupt                         */
        TIM16_IRQn              = 21,       /*!< 21 tim16 interrupt                         */
        TIM17_IRQn              = 22,       /*!< 22 tim17 interrupt                         */
        I2C0_IRQn               = 23,       /*!< 23 I2C0 Interrupt                          */

        SPI0_IRQn               = 25,       /*!< 25 SPI0 Interrupt                          */

        USART0_IRQn             = 27,       /*!< 27 USART0 Interrupt                        */
        USART1_IRQn             = 28,       /*!< 28 USART1 interrupt                        */


        DIV_CORDIC_IRQn         = 31,       /*!< 31 DIV and CORDIC interrupt                */
    } IRQn_Type;

    typedef enum
    {
        RESET = 0,
        SET = !RESET
    } FlagStatus,
        ITStatus;
    typedef enum
    {
        FALSE = 0,
        TRUE = !FALSE
    } bool;

    typedef enum
    {
        DISABLE = 0,
        ENABLE = !DISABLE
    } FunctionalState;
#define IS_FUNCTIONAL_STATE(STATE) (((STATE) == DISABLE) || ((STATE) == ENABLE))

    typedef enum
    {
        ERROR = 0,
        SUCCESS = !ERROR
    } ErrorStatus;

/* =============================================================================================================================== */
/* ================Processor and Core Peripheral Section================ */
/* =============================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M0 Processor and Core Peripherals  =============================== */
#define __CM0_REV               0x0100U     /*!< CM0 Core Revision */
#define __NVIC_PRIO_BITS        2           /*!< Number of Bits used for Priority Levels */
#define __Vendor_SysTickConfig  0           /*!< Set to 1 if different SysTick Config is used */
#define __MPU_PRESENT           1           /*!< MPU present */
#define __FPU_PRESENT           0           /*!< FPU present */

    /** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm0.h"         /*!< ARM Cortex-M0 processor and core peripherals*/
#include "system_lcm32f06x.h" /*!< lcm32f06x System*/

#ifndef __IM /*!< Fallback for older CMSIS versions*/
#define __IM __I
#endif
#ifndef __OM /*!< Fallback for older CMSIS versions*/
#define __OM __O
#endif
#ifndef __IOM /*!< Fallback for older CMSIS versions*/
#define __IOM __IO
#endif

/* ========================================  Start of section using anonymous unions  ============================================ */
#if defined(__CC_ARM)
#pragma push
#pragma anon_unions
#elif defined(__ICCARM__)
#pragma language = extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wc11-extensions"
#pragma clang diagnostic ignored "-Wreserved-id-macro"
#pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
#pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined(__GNUC__)
/* anonymous unions are enabled by default */
#elif defined(__TMS470__)
/* anonymous unions are enabled by default */
#elif defined(__TASKING__)
#pragma warning 586
#elif defined(__CSMC__)
/* anonymous unions are enabled by default */
#else
#warning Not supported compiler type
#endif

    /* =========================================================================================================================== */
    /* ================ Device Specific Peripheral Section  ================ */
    /* =========================================================================================================================== */

    /** @addtogroup Device_Peripheral_peripherals
     * @{
     */

    /* =========================================================================================================================== */
    /* ================    USART0    ================ */
    /* =========================================================================================================================== */

    /**
     * @brief Universal asynchronous receiver transmitter (USART0)
     */

    typedef struct
    { /*!< (@ 0x40014000) USART0 Structure */

        union
        {
            __IOM uint32_t DR; /*!< (@ 0x00000000) Data Register */

            struct
            {
                __IOM uint32_t DATA : 8; /*!< [7..0] Receive OR Transmit data character */
                __IOM uint32_t FE : 1;   /*!< [8..8] Framing error */
                __IOM uint32_t PE : 1;   /*!< [9..9] Parity error */
                __IOM uint32_t BE : 1;   /*!< [10..10] Break error */
                __IOM uint32_t OE : 1;   /*!< [11..11] Overrun error */
            } DR_b;
        };

        union
        {
            __IOM uint32_t RSR; /*!< (@ 0x00000004) Receive Status Register/Error Clear Register */
            struct
            {
                __IOM uint32_t FE : 1; /*!< [0..0] Framing error */
                __IOM uint32_t PE : 1; /*!< [1..1] Parity error */
                __IOM uint32_t BE : 1; /*!< [2..2] Break error */
                __IOM uint32_t OE : 1; /*!< [3..3] Overrun error */
            } RSR_b;
        };

        __IM uint32_t RESERVED0;

        union
        {
            __IOM uint32_t CR2; /*!< (@ 0x0000000C) Control Register */

            struct
            {
                __IOM uint32_t HDSEL : 1; /*!< [0..0] Half duplex output mode */
                __IOM uint32_t HDOD : 1;  /*!< [1..1] Half duplex mode */
                __IOM uint32_t : 3;
                __IOM uint32_t CLKEN : 1; /*!< [5..5] Transmit FIFO full */
                __IOM uint32_t CPOL : 1;  /*!< [6..6] Receive FIFO full */
                __IOM uint32_t CHPA : 1;  /*!< [7..7] Transmit FIFO empty */
            } CR2_b;
        };

        union
        {
            __IOM uint32_t CR3; /*!< (@ 0x00000010) Control Register */

            struct
            {
                __IOM uint32_t UELP : 1; /*!< [0..0] Half duplex output mode */
                __IOM uint32_t : 2;
                __IOM uint32_t WUS : 2;  /*!< [4..3] wake-up event selection */
                __IOM uint32_t : 2;
                __IOM uint32_t ADDM : 1; /*!< [7..7] Wake-up address mode selection */
                __IOM uint32_t ADDR : 8; /*!< [15..8] Wake-up address */
            } CR3_b;
        };

        __IM uint32_t RESERVED1;

        union
        {
            __IM uint32_t FR; /*!< (@ 0x00000018) Flag Register  */

            struct
            {
                __IM uint32_t CTS : 1;    /*!< [0..0] Clear to send */
                __IM uint32_t : 2;
                __IM uint32_t BUSY : 1;   /*!< [3..3] USART busy */
                __IM uint32_t RXFE : 1;   /*!< [4..4] Receive FIFO empty */
                __IM uint32_t TXFF : 1;   /*!< [5..5] Transmit FIFO full */
                __IM uint32_t RXFF : 1;   /*!< [6..6] Receive FIFO full */
                __IM uint32_t TXFE : 1;   /*!< [7..7] Transmit FIFO empty */
                __IM uint32_t : 1;
                __IM uint32_t RXBUSY : 1; /*!< [9..9] Receive busy */
            } FR_b;
        };

        __IM uint32_t RESERVED2[2];

        union
        {
            __IOM uint32_t IBRD; /*!< (@ 0x00000024) Integer Baud Rate Register */

            struct
            {
                __IOM uint32_t BAUD_DIVINT : 16; /*!< [15..0] The integer baud rate divisor */
            } IBRD_b;
        };

        union
        {
            __IOM uint32_t FBRD; /*!< (@ 0x00000028) Fractional Baud Rate Register */

            struct
            {
                __IOM uint32_t BAUD_DIVFRAC : 6; /*!< [5..0] The fractional baud rate divisor */
            } FBRD_b;
        };

        union
        {
            __IOM uint32_t LCR; /*!< (@ 0x0000002C) Line Control Register */

            struct
            {
                __IOM uint32_t BRK : 1;  /*!< [0..0] Send break */
                __IOM uint32_t PEN : 1;  /*!< [1..1] Parity enable */
                __IOM uint32_t EPS : 1;  /*!< [2..2] Even parity select */
                __IOM uint32_t STP2 : 1; /*!< [3..3] Two stop bits select */
                __IOM uint32_t FEN : 1;  /*!< [4..4] Enable FIFOs */
                __IOM uint32_t WLEN : 2; /*!< [6..5] Word length. */
                __IOM uint32_t SPS : 1;  /*!< [7..7] Stick parity select */
            } LCR_b;
        };

        union
        {
            __IOM uint32_t CR; /*!< (@ 0x00000030) Control Register */

            struct
            {
                __IOM uint32_t USARTEN : 1; /*!< [0..0] USART enable */
                __IM uint32_t : 3;
                __IOM uint32_t LINEN : 1;  /*!< [4..4] LIN mode enable */
                __IOM uint32_t TXTSP : 1;  /*!< [5..5] sender polarity reversal */
                __IOM uint32_t RXP : 1;    /*!< [6..6] Receiver polarity reversal */
                __IOM uint32_t LBE : 1;    /*!< [7..7] Loopback enable */
                __IOM uint32_t TXE : 1;    /*!< [8..8] Transmit enable */
                __IOM uint32_t RXE : 1;    /*!< [9..9] Receive enable */
                __IM uint32_t : 1;
                __IOM uint32_t RTS : 1;    /*!< [11..11] Request to send */
                __IM uint32_t : 2;
                __IOM uint32_t RTSEn : 1;  /*!< [14..14] RTS hardware flow control enable */
                __IOM uint32_t CTSEn : 1;  /*!< [15..15] CTS hardware flow control enable */
            } CR_b;
        };

        union
        {
            __IOM uint32_t IFLS; /*!< (@ 0x00000034) Interrupt FIFO Level Select Register */

            struct
            {
                __IOM uint32_t TXIFLSEL : 4; /*!< [3..0] Transmit interrupt FIFO level select */
                __IOM uint32_t RXIFLSEL : 4; /*!< [7..4] Receive interrupt FIFO level select */
            } IFLS_b;
        };

        union
        {
            __IOM uint32_t IMSC; /*!< (@ 0x00000038) Interrupt Mask Set/Clear Register */

            struct
            {
                __IM uint32_t : 1;
                __IOM uint32_t CTSIM : 1; /*!< [1..1] nUSARTCTS modem interrupt mask. chip not support parpare */
                __IM uint32_t : 2;
                __IOM uint32_t RXIM : 1;  /*!< [4..4] Receive interrupt mask */
                __IOM uint32_t TXIM : 1;  /*!< [5..5] Transmit interrupt mask */
                __IOM uint32_t RTIM : 1;  /*!< [6..6] Receive timeout interrupt mask */
                __IOM uint32_t FEIM : 1;  /*!< [7..7] Framing error interrupt mask */
                __IM uint32_t PEIM : 1;   /*!< [8..8] Parity error interrupt mask */
                __IM uint32_t BEIM : 1;   /*!< [9..9] Break error interrupt mask */
                __IOM uint32_t OEIM : 1;  /*!< [10..10] Overrun error interrupt mask */
                __IM uint32_t : 1;
                __IOM uint32_t LINIM : 1; /*!< [12..12] Receive header interrupt mask bit in LIN mode */
                __IOM uint32_t WUFIM : 1; /*!< [13..13] Wake up event masking bit in low-power mode */
                __IOM uint32_t CEIM : 1;  /*!< [14..14] Detect error interrupt mask bit */
            } IMSC_b;
        };

        union
        {
            __IM uint32_t RIS; /*!< (@ 0x0000003C) Raw Interrupt Status Register   */

            struct
            {
                __IM uint32_t : 1;
                __IM uint32_t CTSRIS : 1;  /*!< [1..1] nUSARTCTS modem interrupt status chip not support parpare */
                __IM uint32_t : 2;
                __IM uint32_t RXRIS : 1;   /*!< [4..4] Receive interrupt status */
                __IM uint32_t TXRIS : 1;   /*!< [5..5] Transmit interrupt status */
                __IM uint32_t RTRIS : 1;   /*!< [6..6] Receive timeout interrupt status */
                __IM uint32_t FERIS : 1;   /*!< [7..7] Framing error interrupt status */
                __IM uint32_t PERIS : 1;   /*!< [8..8] Parity error interrupt status */
                __IM uint32_t BERIS : 1;   /*!< [9..9] Break error interrupt mask */
                __IM uint32_t OERIS : 1;   /*!< [10..10] Overrun error interrupt status */
                __IM uint32_t : 1;
                __IOM uint32_t LINRIS : 1; /*!< [12..12] Receive header interrupt status bit in LIN mode */
                __IOM uint32_t WUFRIS : 1; /*!< [13..13] Wake-up event status */
                __IOM uint32_t CERIS : 1;  /*!< [14..14] Conflict detection breaks */
            } RIS_b;
        };

        union
        {
            __IM uint32_t MIS; /*!< (@ 0x00000040) Masked Interrupt Status Register */

            struct
            {
                __IM uint32_t : 1;
                __IM uint32_t CTSMIS : 1;  /*!< [1..1] nUSARTCTS modem masked interrupt statuschip not support parpare */
                __IM uint32_t : 2;
                __IM uint32_t RXMIS : 1;   /*!< [4..4] Receive masked interrupt status */
                __IM uint32_t TXMIS : 1;   /*!< [5..5] Transmit masked interrupt status */
                __IM uint32_t RTMIS : 1;   /*!< [6..6] Receive timeout masked interrupt status */
                __IM uint32_t FEMIS : 1;   /*!< [7..7] Framing error masked interrupt status */
                __IM uint32_t PEMIS : 1;   /*!< [8..8] Parity error masked interrupt status */
                __IM uint32_t BEMIS : 1;   /*!< [9..9] Break error masked interrupt status */
                __IM uint32_t OEMIS : 1;   /*!< [10..10] Overrun error masked interrupt status */
                __IM uint32_t : 1;
                __IOM uint32_t LINMIS : 1; /*!< [12..12] Receive header mask interrupt status bit in LIN mode */
                __IOM uint32_t WUFMIS : 1; /*!< [13..13] Wake-up masked event interrupt status */
                __IOM uint32_t CEMIS : 1;  /*!< [14..14] Conflict masked detection interrupt breaks */
            } MIS_b;
        };

        union
        {
            __OM uint32_t ICR; /*!< (@ 0x00000044) Interrupt Clear Register */

            struct
            {
                __IM uint32_t : 1;
                __OM uint32_t CTSIC : 1; /*!< [1..1] nUSARTCTS modem interrupt clear chip not support parpare */
                __IM uint32_t : 2;
                __OM uint32_t RXIC : 1; /*!< [4..4] Receive interrupt clear */
                __OM uint32_t TXIC : 1; /*!< [5..5] Transmit interrupt clear */
                __OM uint32_t RTIC : 1; /*!< [6..6] Receive timeout interrupt clear */
                __OM uint32_t FEIC : 1; /*!< [7..7] Framing error interrupt clear */
                __OM uint32_t PEIC : 1; /*!< [8..8] PEIC  */
                __OM uint32_t BEIC : 1; /*!< [9..9] Break error interrupt clear */
                __OM uint32_t OEIC : 1; /*!< [10..10] Overrun error interrupt clear */
                __IM uint32_t : 1;
                __IOM uint32_t LINIC : 1; /*!< [12..12] Receive header interrupt clear bit in LIN mode*/
                __IOM uint32_t WUFIC : 1; /*!< [13..13] Wake-up masked event interrupt clear */
                __IOM uint32_t CEIC : 1;  /*!< [14..14] Conflict masked detection interrupt clear */
            } ICR_b;
        };

        union
        {
            __IOM uint32_t DMACR; /*!< (@ 0x00000048) DMA Control Register */

            struct
            {
                __IOM uint32_t RXDMAE : 1;   /*!< [0..0] Receive DMA enable */
                __IOM uint32_t TXDMAE : 1;   /*!< [1..1] Transmit DMA enable */
                __IOM uint32_t DMAONERR : 1; /*!< [2..2] DMA on error */
            } DMACR_b;
        };

        __IM uint32_t RESERVED3[10];

        union
        {
            __IOM uint32_t LINCON1; /*!< (@ 0x00000074) LIN control register 1 */

            struct
            {
                __IOM uint32_t MS : 1;     /*!< [0..0] LIN master-slave mode selection */
                __IM uint32_t : 2;
                __IOM uint32_t SCM : 1;    /*!< [3..3] Software control mode */
                __IOM uint32_t CSEN : 1;   /*!< [4..4] Hardware checksum enable */
                __IOM uint32_t CSI : 1;    /*!< [5..5] Checksum storage selection */
                __IOM uint32_t ABD : 1;    /*!< [6..6] Automatic baud rate synchronization enable */
                __IOM uint32_t LZEN : 1;   /*!< [7..7] Enable bus long zero detection */
                __IOM uint32_t LINSLP : 1; /*!< [8..8] Configure the current working status of the LIN network */
            } LINCON1_b;
        };

        union
        {
            __IOM uint32_t LINCON2; /*!< (@ 0x00000078) LIN control register 2 */

            struct
            {
                __IOM uint32_t HTR : 1;     /*!< [0..0] Frame Hair Send request (host only) */
                __IOM uint32_t RTR : 1;     /*!< [1..1] Answer a send request (primary / slave) */
                __IOM uint32_t RDR : 1;     /*!< [2..2] Response to abort request (master / slave) */
                __IOM uint32_t WUTR : 1;    /*!< [3..3] LIN wake up send request (master / slave) */
            } LINCON2_b;
        };

        union
        {
            __IOM uint32_t FRAMECON; /*!< (@ 0x0000007C) Frame control register */

            struct
            {
                __IOM uint32_t IDLE : 3;    /*!< [2..0] The interval length of the transmission bytes, also for the frame head and the responses */
                __IOM uint32_t LEAD : 3;    /*!< [5..3] break Length of the interval between the end and the start of the synchronous byte */
                __IOM uint32_t CEN : 1;     /*!< [6..6] Bit error check is enabled */
            } FRAMECON_b;
        };

        __IM uint32_t RESERVED4[5];

        union
        {
            __IOM uint32_t LINSTS; /*!< (@ 0x00000094) The LIN status register */

            struct
            {
                __IOM uint32_t PS : 3;    /*!< [0..0] The LIN receives the pin level state */
                __IOM uint32_t STS : 4;   /*!< [4..1] The LIN mode state */
            } LINSTS_b;
        };

        union
        {
            __IOM uint32_t DATCON; /*!< (@ 0x00000098) Data configuration register */

            struct
            {
                __IOM uint32_t FATLEN : 3;      /*!< [2..0] Length of response data */
                __IOM uint32_t HO : 1;          /*!< [3..3] Header Only, defines whether the LIN frame is composed of header and response or only of header */
                __IOM uint32_t RM : 1;          /*!< [4..4] Define the use of the RESPONSE */
                __IOM uint32_t CSM : 1;         /*!< [5..5] Check and type */
                __IOM uint32_t : 2;
                __IOM uint32_t RESPONSE : 8;    /*!< [15..8] Response / Frame Timeout threshold (default 0xFF) */
            } DATCON_b;
        };

        union
        {
            __IM uint32_t BRDMSU; /*!< (@ 0x0000009C) Baud rate detection register */

            struct
            {
                __IM uint32_t MEASURED : 16;   /*!< [15..0] Porter rate measures the number of clocks, register to clear 0 after reset */
            } BRDMSU_b;
        };

        union
        {
            __IOM uint32_t BRDUPPER; /*!< (@ 0x000000A0) Baud rate detection upper limit register */

            struct
            {
                __IOM uint32_t UPPERLIMIT : 16;    /*!< [15..0] Upper limit of clock measurement */
            } BRDUPPER_b;
        };

        union
        {
            __IOM uint32_t BRDLOWER; /*!< (@ 0x000000A4) Baud rate detection lower limit register */

            struct
            {
                __IOM uint32_t LOWERLIMIT : 16;    /*!< [15..0] Lower lower limit of clock measurement */
            } BRDLOWER_b;
        };

        union
        {
            __IOM uint32_t LINBTIMER; /*!< (@ 0x000000A8) LIN BREAK, Time register */

            struct
            {
                __IOM uint32_t BREAK : 6;    /*!< [5..0] Generate and detect break pulses (default value 0xD) */
            } LINBTIMER_b;
        };

        union
        {
            __IOM uint32_t LINHTIMER; /*!< (@ 0x000000AC) The LIN frame-header timing register */

            struct
            {
                __IOM uint32_t HEADER : 8;    /*!< [7..0] Frame header timeout threshold (default 0xFF) */
            } LINHTIMER_b;
        };

        union
        {
            __IOM uint32_t USARTIMSC1; /*!< (@ 0x000000B0) USARTIMSC1 */

            struct
            {
                __IOM uint32_t RHIM : 1;    /*!< [0..0] RHIM */
                __IOM uint32_t RRIM : 1;    /*!< [1..1] RRIM */
                __IOM uint32_t THIM : 1;    /*!< [2..2] THIM */
                __IOM uint32_t TRIM : 1;    /*!< [3..3] TRIM */
                __IOM uint32_t HTIM : 1;    /*!< [4..4] HTIM */
                __IOM uint32_t RTIM : 1;    /*!< [5..5] RTIM */
                __IOM uint32_t LAIM : 1;    /*!< [6..6] LAIM */
                __IOM uint32_t LCIM : 1;    /*!< [7..7] LCIM */
                __IOM uint32_t LPIM : 1;    /*!< [8..8] LPIM */
                __IOM uint32_t FEDIM : 1;   /*!< [9..9] FEDIM */
                __IOM uint32_t REDIM : 1;   /*!< [10..10] REDIM */
                __IOM uint32_t LZIM : 1;    /*!< [11..11] LZIM */
                __IOM uint32_t SFIM : 1;    /*!< [12..12] SFIM */
            } USARTIMSC1_b;
        };

        union
        {
            __IM uint32_t USARTRIS1; /*!< (@ 0x000000B4) USARTRIS1 */

            struct
            {
                __IM uint32_t RHRIS : 1;    /*!< [0..0] RHRIS */
                __IM uint32_t RRRIS : 1;    /*!< [1..1] RRRIS */
                __IM uint32_t THRIS : 1;    /*!< [2..2] THRIS */
                __IM uint32_t TRRIS : 1;    /*!< [3..3] TRRIS */
                __IM uint32_t HTRIS : 1;    /*!< [4..4] HTRIS */
                __IM uint32_t RTRIS : 1;    /*!< [5..5] RTRIS */
                __IM uint32_t LARIS : 1;    /*!< [6..6] LARIS */
                __IM uint32_t LCRIS : 1;    /*!< [7..7] LCRIS */
                __IM uint32_t LPRIS : 1;    /*!< [8..8] LPRIS */
                __IM uint32_t FEDRIS : 1;   /*!< [9..9] FEDRIS */
                __IM uint32_t REDRIS : 1;   /*!< [10..10] REDRIS */
                __IM uint32_t LZRIS : 1;    /*!< [11..11] LZRIS */
                __IM uint32_t SFRIS : 1;    /*!< [12..12] SFRIS */
            } USARTRIS1_b;
        };

        union
        {
            __IM uint32_t USARTMIS1; /*!< (@ 0x000000B8) USARTMIS1 */

            struct
            {
                __IM uint32_t RHMIS : 1;    /*!< [0..0] RHMIS */
                __IM uint32_t RRMIS : 1;    /*!< [1..1] RRMIS */
                __IM uint32_t THMIS : 1;    /*!< [2..2] THMIS */
                __IM uint32_t TRMIS : 1;    /*!< [3..3] TRMIS */
                __IM uint32_t HTMIS : 1;    /*!< [4..4] HTMIS */
                __IM uint32_t RTMIS : 1;    /*!< [5..5] RTMIS */
                __IM uint32_t LAMIS : 1;    /*!< [6..6] LAMIS */
                __IM uint32_t LCMIS : 1;    /*!< [7..7] LCMIS */
                __IM uint32_t LPMIS : 1;    /*!< [8..8] LPMIS */
                __IM uint32_t FEDMIS : 1;   /*!< [9..9] FEDMIS */
                __IM uint32_t REDMIS : 1;   /*!< [10..10] REDMIS */
                __IM uint32_t LZMIS : 1;    /*!< [11..11] LZMIS */
                __IM uint32_t SFMIS : 1;    /*!< [12..12] SFMIS */
            } USARTMIS1_b;
        };

        union
        {
            __OM uint32_t USARTICR1; /*!< (@ 0x000000BC) USARTICR1 */

            struct
            {
                __OM uint32_t RHIC : 1;    /*!< [0..0] RHIC */
                __OM uint32_t RRIC : 1;    /*!< [1..1] RRIC */
                __OM uint32_t THIC : 1;    /*!< [2..2] THIC */
                __OM uint32_t TRIC : 1;    /*!< [3..3] TRIC */
                __OM uint32_t HTIC : 1;    /*!< [4..4] HTIC */
                __OM uint32_t RTIC : 1;    /*!< [5..5] RTIC */
                __OM uint32_t LAIC : 1;    /*!< [6..6] LAIC */
                __OM uint32_t LCIC : 1;    /*!< [7..7] LCIC */
                __OM uint32_t LPIC : 1;    /*!< [8..8] LPIC */
                __OM uint32_t FEDIC : 1;   /*!< [9..9] FEDIC */
                __OM uint32_t REDIC : 1;   /*!< [10..10] REDIC */
                __OM uint32_t LZIC : 1;    /*!< [11..11] LZIC */
                __OM uint32_t SFIC : 1;    /*!< [12..12] SFIC */
            } USARTICR1_b;
        };


    } USART_TypeDef; /*!< Size = 184 (0xB8) */

    /* =========================================================================================================================== */
    /* ================    I2C0================ */
    /* =========================================================================================================================== */

    /**
     * @brief I2C communication interface (I2C0)
     */

    typedef struct
    { /*!< (@ 0x40013000) I2C0 Structure */

        union
        {
            __IOM uint32_t CON; /*!< (@ 0x00000000) I2C Control */

            struct
            {
                __IOM uint32_t MST_MODE : 1;       /*!< [0..0] MST_MODE */
                __IOM uint32_t SPEED : 2;          /*!< [2..1] SPEED */
                __IOM uint32_t CON_10ADDR_SLV : 1; /*!< [3..3] 10ADDR_SLV */
                __IM uint32_t CON_10ADDR_MAS : 1;  /*!< [4..4] 10ADDR_MAS */
                __IOM uint32_t RESTEN : 1;         /*!< [5..5] RESTEN */
                __IOM uint32_t SLVDIS : 1;         /*!< [6..6] SLVDIS */
                __IOM uint32_t SDIAD : 1;          /*!< [7..7] SDIAD */
                __IOM uint32_t TXEC : 1;           /*!< [8..8] TXEC */
                __IOM uint32_t RFFHC : 1;          /*!< [9..9] RFFHC */
                __IOM uint32_t SDIMA : 1;          /*!< [10..10] SDIMA */
                __IOM uint32_t DUAL_ADDR : 1;      /*!< [11..11] DUAL_ADDR */
                __IOM uint32_t SMB_MODE : 1;       /*!< [12..12] SMB_MODE */
                __IOM uint32_t PEC_CE : 1;         /*!< [13..13] PE_CE */
                __IOM uint32_t TXT_EN : 1;         /*!< [14..14] TXT_EN */
                __IOM uint32_t TIEMOUT_EN : 1;     /*!< [15..15] TIEMOUT_EN */
            } CON_b;
        };

        union
        {
            __IOM uint32_t TAR; /*!< (@ 0x00000004) I2C Target Address */

            struct
            {
                __IOM uint32_t IC_TAR : 10;        /*!< [9..0] IC_TAR */
                __IOM uint32_t GC_STR : 1;         /*!< [10..10] GC_OR_START */
                __IOM uint32_t SPECIAL : 1;        /*!< [11..11] SPECIAL */
                __IOM uint32_t TAR_10ADDR_MAS : 1; /*!< [12..12] 10ADDR_MAS */
            } TAR_b;
        };

        union
        {
            __IOM uint32_t SAR; /*!< (@ 0x00000008) I2C Slave Address */

            struct
            {
                __IOM uint32_t IC_SAR0 : 10; /*!< [9..0] IC_SAR */
                __IOM uint32_t : 6;          /*!< [15..10] IC_SAR */
                __IOM uint32_t IC_SAR1 : 10; /*!< [16..25] IC_SAR */
            } SAR_b;
        };

        __IM uint32_t RESERVED0;

        union
        {
            __IOM uint32_t DATACMD; /*!< (@ 0x00000010) I2C Rx/Tx Data Buffer and Command */

            struct
            {
                __IOM uint32_t DAT : 8;     /*!< [7..0] DAT */
                __IOM uint32_t CMD : 1;     /*!< [8..8] CMD */
                __IOM uint32_t STOP : 1;    /*!< [9..9] STOP */
                __IOM uint32_t RESTART : 1; /*!< [10..10] RESTART */
                __IOM uint32_t FDB : 1;     /*!< [11..11] FIRST_DATA_BYTE */
            } DATACMD_b;
        };

        union
        {
            __IOM uint32_t SSHCNT; /*!< (@ 0x00000014) Standard speed I2C Clock SCL High Count */

            struct
            {
                __IOM uint32_t SS_SCL_HCNT : 16; /*!< [15..0] SS_SCL_HCNT */
            } SSHCNT_b;
        };

        union
        {
            __IOM uint32_t SSLCNT; /*!< (@ 0x00000018) Standard speed I2C Clock SCL High Count */

            struct
            {
                __IOM uint32_t SS_SCL_LCNT : 16; /*!< [15..0] SS_SCL_LCNT */
            } SSLCNT_b;
        };

        union
        {
            __IOM uint32_t FSHCNT; /*!< (@ 0x0000001C) Fast Mode and Fast Mode Plus I2C Clock SCL */

            struct
            {
                __IOM uint32_t FS_SCL_HCNT : 16; /*!< [15..0] The fractional baud rate divisor  */
            } FSHCNT_b;
        };

        union
        {
            __IOM uint32_t FSLCNT; /*!< (@ 0x00000020) Fast Mode and Fast Mode Plus I2C Clock SCL */

            struct
            {
                __IOM uint32_t FS_SCL_LCNT : 16; /*!< [15..0] The fractional baud rate divisor */
            } FSLCNT_b;
        };
    
        __IM uint32_t RESERVED1[2];

        union
        {
            __IM uint32_t INTRSTAT; /*!< (@ 0x0000002C) I2C Interrupt Status*/

            struct
            {
                __IM uint32_t R_RX_UNDER : 1;     /*!< [0..0] R_RX_UNDER */
                __IM uint32_t R_RX_OVER : 1;      /*!< [1..1] R_RX_OVER */
                __IM uint32_t R_RX_FULL : 1;      /*!< [2..2] R_RX_FULL */
                __IM uint32_t R_TX_OVER : 1;      /*!< [3..3] R_TX_OVER */
                __IM uint32_t R_TX_EMPTY : 1;     /*!< [4..4] R_TX_EMPTY */
                __IM uint32_t R_RD_REQ : 1;       /*!< [5..5] R_RD_REQ */
                __IM uint32_t R_TX_ABRT : 1;      /*!< [6..6] R_TX_ABRT */
                __IM uint32_t R_RX_DONE : 1;      /*!< [7..7] R_RX_DONE */
                __IM uint32_t R_ACTIVITY : 1;     /*!< [8..8] R_ACTIVITY */
                __IM uint32_t R_STOP_DET : 1;     /*!< [9..9] R_STOP_DET */
                __IM uint32_t R_START_DET : 1;    /*!< [10..10] R_START_DET */
                __IM uint32_t R_GEN_CALL : 1;     /*!< [11..11] R_GEN_CALL */
                __IM uint32_t R_RESTART_DET : 1;  /*!< [12..12] R_RESTART_DET */
                __IM uint32_t R_MST_ON_HOLD : 1;  /*!< [13..13] R_MST_ON_HOLD */
                __IM uint32_t R_SMBUS_ALERT : 1;  /*!< [14..14] R_SMBUS_ALERT */
                __IM uint32_t R_TIM_EOUT : 1;     /*!< [15..15] R_TIM_EOUT */
                __IM uint32_t R_PEC_ERROR : 1;    /*!< [16..16] R_PEC_ERROR */
                __IM uint32_t R_ADDR0_MATCH : 1;  /*!< [17..17] R_ADDR0_MATCH */
                __IM uint32_t R_ADDR1_MATCH : 1;  /*!< [18..18] R_ADDR1_MATCH */
            } INTRSTAT_b;
        };

        union
        {
            __IOM uint32_t INTRMASK; /*!< (@ 0x00000030) I2C Interrupt Mask  */

            struct
            {
                __IOM uint32_t M_RX_UNDER : 1;     /*!< [0..0] M_RX_UNDER */
                __IOM uint32_t M_RX_OVER : 1;      /*!< [1..1] M_RX_OVER */
                __IOM uint32_t M_RX_FULL : 1;      /*!< [2..2] M_RX_FULL */
                __IOM uint32_t M_TX_OVER : 1;      /*!< [3..3] M_TX_OVER */
                __IOM uint32_t M_TX_EMPTY : 1;     /*!< [4..4] M_TX_EMPTY */
                __IOM uint32_t M_RD_REQ : 1;       /*!< [5..5] M_RD_REQ */
                __IOM uint32_t M_TX_ABRT : 1;      /*!< [6..6] M_TX_ABRT */
                __IOM uint32_t M_RX_DONE : 1;      /*!< [7..7] M_RX_DONE */
                __IOM uint32_t M_ACTIVITY : 1;     /*!< [8..8] M_ACTIVITY */
                __IOM uint32_t M_STOP_DET : 1;     /*!< [9..9] M_STOP_DET */
                __IOM uint32_t M_START_DET : 1;    /*!< [10..10] M_START_DET */
                __IOM uint32_t M_GEN_CALL : 1;     /*!< [11..11] M_GEN_CALL */
                __IOM uint32_t M_RESTART_DET : 1;  /*!< [12..12] M_RESTART_DET */
                __IOM uint32_t M_MST_ON_HOLD : 1;  /*!< [13..13] M_MST_ON_HOLD */
                __IOM uint32_t M_SMBUS_ALERT : 1;  /*!< [14..14] M_SMBUS_ALERT */
                __IOM uint32_t M_TIM_EOUT : 1;     /*!< [15..15] M_TIM_EOUT */
                __IOM uint32_t M_PEC_ERROR : 1;    /*!< [16..16] M_PEC_ERROR */
                __IOM uint32_t M_ADDR0_MATCH : 1;  /*!< [17..17] M_ADDR0_MATCH */
                __IOM uint32_t M_ADDR1_MATCH : 1;  /*!< [18..18] M_ADDR1_MATCH */
            } INTRMASK_b;
        };

        union
        {
            __IM uint32_t RAWINTRSTAT; /*!< (@ 0x00000034) I2C Raw Interrupt Status */

            struct
            {
                __IM uint32_t RX_UNDER : 1;    /*!< [0..0] RX_UNDER */
                __IM uint32_t RX_OVER : 1;     /*!< [1..1] RX_OVER */
                __IM uint32_t RX_FULL : 1;     /*!< [2..2] RX_FULL */
                __IM uint32_t TX_OVER : 1;     /*!< [3..3] TX_OVER */
                __IM uint32_t TX_EMPTY : 1;    /*!< [4..4] TX_EMPTY */
                __IM uint32_t RD_REQ : 1;      /*!< [5..5] RD_REQ */
                __IM uint32_t TX_ABRT : 1;     /*!< [6..6] TX_ABRT */
                __IM uint32_t RX_DONE : 1;     /*!< [7..7] RX_DONE */
                __IM uint32_t ACTIVITY : 1;    /*!< [8..8] ACTIVITY */
                __IM uint32_t STOP_DET : 1;    /*!< [9..9] STOP_DET */
                __IM uint32_t START_DET : 1;   /*!< [10..10] START_DET */
                __IM uint32_t GEN_CALL : 1;    /*!< [11..11] GEN_CALL */
                __IM uint32_t RESTART_DET : 1; /*!< [12..12] RESTART_DET */
                __IM uint32_t MST_ON_HOLD : 1; /*!< [13..13] MST_ON_HOLD */
                __IM uint32_t SMBUS_ALERT : 1; /*!< [14..14] SMBUS_ALERT */
                __IM uint32_t TIM_EOUT : 1;    /*!< [15..15] TIM_EOUT */
                __IM uint32_t PEC_ERROR : 1;   /*!< [16..16] PEC_ERROR */
                __IM uint32_t ADDR0_MATCH : 1; /*!< [17..17] ADDR0_MATCH */
                __IM uint32_t ADDR1_MATCH : 1; /*!< [18..18] ADDR1_MATCH */
            } RAWINTRSTAT_b;
        };

        union
        {
            __IOM uint32_t RXTL; /*!< (@ 0x00000038) I2C Receive FIFO Threshold */

            struct
            {
                __IOM uint32_t RX_TL : 3; /*!< [2..0] Receive FIFO Threshold Level */
            } RXTL_b;
        };

        union
        {
            __IOM uint32_t TXTL; /*!< (@ 0x0000003C) I2C Transmit FIFO Threshold */

            struct
            {
                __IOM uint32_t TX_TL : 3; /*!< [2..0] Transmit FIFO Threshold Level */
            } TXTL_b;
        };

        union
        {
            __IM uint32_t CLRINTR; /*!< (@ 0x00000040) Clear Combined and Individual Interrupts */

            struct
            {
                __IM uint32_t CLR_INTR : 1; /*!< [0..0] CLR_INTR */
            } CLRINTR_b;
        };

        union
        {
            __IM uint32_t CLRRXUNDER; /*!< (@ 0x00000044) Clear RX_UNDER Interrupt */

            struct
            {
                __IM uint32_t CLR_RX_UNDER : 1; /*!< [0..0] CLR_RX_UNDER */
            } CLRRXUNDER_b;
        };

        union
        {
            __IM uint32_t CLRRXOVER; /*!< (@ 0x00000048) RX_OVER Interrupt */

            struct
            {
                __IM uint32_t CLR_RX_OVER : 1; /*!< [0..0] CLR_RX_OVER */
            } CLRRXOVER_b;
        };

        union
        {
            __IM uint32_t CLRTXOVER; /*!< (@ 0x0000004C) Clear TX_OVER Interrupt */

            struct
            {
                __IM uint32_t CLR_TX_OVER : 1; /*!< [0..0] CLR_TX_OVER */
            } CLRTXOVER_b;
        };

        union
        {
            __IM uint32_t CLRRDREQ; /*!< (@ 0x00000050) Clear RD_REQ Interrupt */

            struct
            {
                __IM uint32_t CLR_RD_REQ : 1; /*!< [0..0] CLR_RD_REQ */
            } CLRRDREQ_b;
        };

        union
        {
            __IM uint32_t CLRTXABRT; /*!< (@ 0x00000054) Clear TX_ABRT Interrupt */

            struct
            {
                __IM uint32_t CLR_TX_ABRT : 1; /*!< [0..0] CLR_TX_ABRT */
            } CLRTXABRT_b;
        };

        union
        {
            __IM uint32_t CLRRXDONE; /*!< (@ 0x00000058) Clear RX_DONE Interrupt */

            struct
            {
                __IM uint32_t CLR_RX_DONE : 1; /*!< [0..0] CLR_RX_DONE */
            } CLRRXDONE_b;
        };

        union
        {
            __IM uint32_t CLRACTIVITY; /*!< (@ 0x0000005C) Clear ACTIVITY Interrupt */

            struct
            {
                __IM uint32_t CLR_ACTIVITY : 1; /*!< [0..0] CLR_ACTIVITY */
            } CLRACTIVITY_b;
        };

        union
        {
            __IM uint32_t CLRSTOP_DET; /*!< (@ 0x00000060) Clear STOP_DET Interrupt */

            struct
            {
                __IM uint32_t CLR_STOP_DET : 1; /*!< [0..0] CLR_STOP_DET */
            } CLRSTOP_DET_b;
        };

        union
        {
            __IM uint32_t CLRSTARTDET; /*!< (@ 0x00000064) Clear START_DET Interrupt*/

            struct
            {
                __IM uint32_t CLR_START_DET : 1; /*!< [0..0] CLR_START_DET*/
            } CLRSTARTDET_b;
        };

        union
        {
            __IM uint32_t CLRGENCALL; /*!< (@ 0x00000068) Clear GEN_CALL Interrupt */

            struct
            {
                __IM uint32_t CLR_GEN_CALL : 1; /*!< [0..0] CLR_GEN_CALL */
            } CLRGENCALL_b;
        };

        union
        {
            __IOM uint32_t ENABLE; /*!< (@ 0x0000006C) I2C Enable */

            struct
            {
                __IOM uint32_t ENABLE : 1;       /*!< [0..0] ENABLE */
                __IOM uint32_t ABORT : 1;        /*!< [1..1] ABORT */
                __IOM uint32_t TX_CMD_BLOCK : 1; /*!< [2..2] TX_CMD_BLOCK */
                __IOM uint32_t ACK_MODE : 1;     /*!< [3..3] ACK_MODE */
                __IOM uint32_t SMBUS_ALERT : 1;  /*!< [4..4] SMBUS_ALERT */
            } ENABLE_b;
        };

        union
        {
            __IM uint32_t STATUS; /*!< (@ 0x00000070) I2C Status register */

            struct
            {
                __IM uint32_t ACTIVITY : 1;               /*!< [0..0] I2C Activity Status */
                __IM uint32_t TFNF : 1;                   /*!< [1..1] Transmit FIFO Not Full */
                __IM uint32_t TFE : 1;                    /*!< [2..2] Transmit FIFO Completely Empty */
                __IM uint32_t RFNE : 1;                   /*!< [3..3] Receive FIFO Not Empty */
                __IM uint32_t RFF : 1;                    /*!< [4..4] Receive FIFO Completely Full */
                __IM uint32_t MST_ACTIVITY : 1;           /*!< [5..5] Master FSM Activity Status */
                __IM uint32_t SLV_ACTIVITY : 1;           /*!< [6..6] Slave FSM Activity Status */
                __IM uint32_t MST_HOLD_TX_FIFO_EMPTY : 1; /*!< [7..7] MST_HOLD_TX_FIFO_EMPTY */
                __IM uint32_t MST_HOLD_RX_FIFO_FULL : 1;  /*!< [8..8] MST_HOLD_RX_FIFO_FULL */
                __IM uint32_t SLV_HOLD_TX_FIFO_EMPTY : 1; /*!< [9..9] SLV_HOLD_TX_FIFO_EMPTY */
                __IM uint32_t SLV_HOLD_RX_FIFO_FULL : 1;  /*!< [10..10] SLV_HOLD_RX_FIFO_FULL */
            } STATUS_b;
        };

        union
        {
            __IM uint32_t TXFLR; /*!< (@ 0x00000074) Transmit FIFO Level Register */

            struct
            {
                __IM uint32_t TXFLR : 4; /*!< [3..0] TXFLR */
            } TXFLR_b;
        };

        union
        {
            __IM uint32_t RXFLR; /*!< (@ 0x00000078) Receive FIFO Level Register */

            struct
            {
                __IM uint32_t RXFLR : 4; /*!< [3..0] RXFLR */
            } RXFLR_b;
        };

        union
        {
            __IOM uint32_t SDAHOLD; /*!< (@ 0x0000007C) SDA hold time length register */

            struct
            {
                __IOM uint32_t IC_SDA_TX_HOLD : 16; /*!< [15..0] IC_SDA_TX_HOLD */
                __IOM uint32_t IC_SDA_RX_HOLD : 8;  /*!< [23..16] IC_SDA_RX_HOLD */
            } SDAHOLD_b;
        };

        union
        {
            __IM uint32_t TXABRTSOURCE; /*!< (@ 0x00000080) I2C Transmit Abort Status Register */

            struct
            {
                __IM uint32_t ABRT_7ADDR_NOACK : 1;     /*!< [0..0] ABRT_7B_ADDR_NOACK */
                __IM uint32_t ABRT_10ADDR1_NOACK : 1;   /*!< [1..1] ABRT_10ADDR1_NOACK */
                __IM uint32_t ABRT_10ADDR2_NOACK : 1;   /*!< [2..2] ABRT_10ADDR2_NOACK */
                __IM uint32_t ABRT_TXDATA_NOACK : 1;    /*!< [3..3] ABRT_TXDATA_NOACK */
                __IM uint32_t ABRT_GCALL_NOACK : 1;     /*!< [4..4] ABRT_GCALL_NOACK */
                __IM uint32_t ABRT_GCALL_READ : 1;      /*!< [5..5] ABRT_GCALL_READ */
                __IM uint32_t : 1;
                __IM uint32_t ABRT_SBYTE_ACKDET : 1;    /*!< [7..7] ABRT_SBYTE_ACKDET */
                __IM uint32_t : 1;
                __IM uint32_t ABRT_SBYTE_NORSTRT : 1;   /*!< [9..9] ABRT_SBYTE_NORSTRT */
                __IM uint32_t ABRT_10B_RD_NORSTRT : 1;  /*!< [10..10] ABRT_10B_RD_NORSTRT  */
                __IM uint32_t ABRT_MASTER_DIS : 1;      /*!< [11..11] ABRT_MASTER_DIS */
                __IM uint32_t ARB_LOST : 1;             /*!< [12..12] ARB_LOST */
                __IM uint32_t ABRT_SLVFLUSH_TXFIFO : 1; /*!< [13..13] ABRT_SLVFLUSH_TXFIFO */
                __IM uint32_t ABRT_SLV_ARBLOST : 1;     /*!< [14..14] ABRT_SLV_ARBLOST */
                __IM uint32_t ABRT_SLVRD_INTX : 1;      /*!< [15..15] ABRT_SLVRD_INTX */
                __IM uint32_t ABRT_USER_ABRT : 1;       /*!< [16..16] ABRT_USER_ABRT */
                __IM uint32_t : 6;
                __IM uint32_t TX_FLUSH_CNT : 9;         /*!< [31..23] TX_FLUSH_CNT */
            } TXABRTSOURCE_b;
        };

        union
        {
            __IOM uint32_t SLVDATANACKONLY; /*!< (@ 0x00000084) Generate SLV_DATA_NACK Register */

            struct
            {
                __IOM uint32_t NACK : 1; /*!< [0..0] NACK */
            } SLVDATANACKONLY_b;
        };

        union
        {
            __IOM uint32_t DMACR; /*!< (@ 0x00000088) DMA Control Register for transmit and receive handshaking interface */

            struct
            {
                __IOM uint32_t RDMAE : 1; /*!< [0..0] RDMAE */
                __IOM uint32_t TDMAE : 1; /*!< [1..1] TDMAE */
            } DMACR_b;
        };

        union
        {
            __IOM uint32_t DMATDLR; /*!< (@ 0x0000008C) DMA Transmit Data Level */

            struct
            {
                __IOM uint32_t DMATDL : 3; /*!< [2..0] DMATDL */
            } DMATDLR_b;
        };

        union
        {
            __IOM uint32_t DMARDLR; /*!< (@ 0x00000090) DMA Receive Data Level */

            struct
            {
                __IOM uint32_t DMARDL : 3; /*!< [3..0] DMARDL */
            } DMARDLR_b;
        };

        union
        {
            __IOM uint32_t SDASETUP; /*!< (@ 0x00000094) I2C SDA Setup Register */

            struct
            {
                __IOM uint32_t SDA_SETUP : 8; /*!< [7..0] SDA_SETUP */
            } SDASETUP_b;
        };

        union
        {
            __IOM uint32_t ACKGENERALCALL; /*!< (@ 0x00000098) I2C ACK General Call Register */

            struct
            {
                __IOM uint32_t ACK_GEN_CALL : 1; /*!< [0..0] ACK_GEN_CALL */
            } ACKGENERALCALL_b;
        };

        union
        {
            __IM uint32_t ENABLESTATUS; /*!< (@ 0x0000009C) I2C Enable Status Register */

            struct
            {
                __IM uint32_t IC_EN : 1;                   /*!< [0..0] IC_EN */
                __IM uint32_t SLV_DISABLED_WHILE_BUSY : 1; /*!< [1..1] SLV_DISABLED_WHILE_BUSY */
                __IM uint32_t SLV_RX_DATA_LOST : 1;        /*!< [2..2] SLV_RX_DATA_LOST */
            } ENABLESTATUS_b;
        };

        union
        {
            __IOM uint32_t FSSPKLEN; /*!< (@ 0x000000A0) ISS and FS spike suppression limit */

            struct
            {
                __IOM uint32_t IC_FS_SPKLEN : 8; /*!< [7..0] IC_FS_SPKLEN */
            } FSSPKLEN_b;
        };
        __IM uint32_t RESERVED2;
        union
        {
            __IM uint32_t CLRRESTARTDET; /*!< (@ 0x000000A8) Clear RESTART_DET Interrupt */

            struct
            {
                __IM uint32_t CLR_RESTAR_DET : 1; /*!< [0..0] CLR_RESTAR_DET */
            } CLRRESTARTDET_b;
        };

        union
        {
            __IM uint32_t IC_CLR_TIMEOUT; /*!< (@ 0x000000AC) IC_CLR_TIMEOUT */

            struct
            {
                __IM uint32_t CLR_TIMEOUT : 1; /*!< [0..0] CLR_TIMEOUT */
            } IC_CLR_TIMEOUT_b;
        };

        union
        {
            __IM uint32_t IC_CLR_SMBUS_ALERT; /*!< (@ 0x000000B0) IC_CLR_SMBUS_ALERT */

            struct
            {
                __IM uint32_t CLR_SMBUS_ALERT : 1; /*!< [0..0] CLR_SMBUS_ALERT */
            } IC_CLR_SMBUS_ALERT_b;
        };

        union
        {
            __IM uint32_t IC_CLR_PEC_ERROR; /*!< (@ 0x000000B4) IC_CLR_PEC_ERROR */

            struct
            {
                __IM uint32_t CLR_PEC_ERROR : 1; /*!< [0..0] CLR_PEC_ERROR */
            } IC_CLR_PEC_ERROR_b;
        };

        union
        {
            __IOM uint32_t IC_TIMEOUT_DATA; /*!< (@ 0x000000B8) IC_TIMEOUT_DATA */

            struct
            {
                __IOM uint32_t TIMEOUT_DATA : 16; /*!< [15..0] TIMEOUT_DATA */
            } IC_TIMEOUT_DATA_b;
        };

        union
        {
            __IOM uint32_t IC_PEC_DATA; /*!< (@ 0x000000BC) IC_PEC_DATA */

            struct
            {
                __IOM uint32_t PEC_DATA : 8; /*!< [7..0] PEC_DATA */
            } IC_PEC_DATA_b;
        };

        union
        {
            __IM uint32_t IC_CLR_ADDR0_MATCH; /*!< (@ 0x000000C0) IC_CLR_ADDR0_MATCH */

            struct
            {
                __IM uint32_t CLR_ADDR0_MATCH : 1; /*!< [0..0] CLR_ADDR0_MATCH */
            } IC_CLR_ADDR0_MATCH_b;
        };

        union
        {
            __IM uint32_t IC_CLR_ADDR1_MATCH; /*!< (@ 0x000000C4) IC_CLR_ADDR1_MATCH */

            struct
            {
                __IM uint32_t CLR_ADDR1_MATCH : 1; /*!< [0..0] CLR_ADDR1_MATCH */
            } IC_CLR_ADDR1_MATCH_b;
        };

    } I2C_TypeDef; /*!< Size = 500 (0xC8) */

    /* =========================================================================================================================== */
    /* ================    TIM1================ */
    /* =========================================================================================================================== */

    /**
     * @brief Advanced timer (TIM1)
     */

    typedef struct
    { /*!< (@ 0x40010000) TIM1 Structure */

        union
        {
            __IOM uint32_t CR1; /*!< (@ 0x00000000) control register 1 */

            struct
            {
                __IOM uint32_t CEN : 1;    /*!< [0..0] Counter enable */
                __IOM uint32_t UDIS : 1;   /*!< [1..1] Update disable */
                __IOM uint32_t URS : 1;    /*!< [2..2] Update request source */
                __IOM uint32_t OPM : 1;    /*!< [3..3] One-pulse mode */
                __IOM uint32_t DIR : 1;    /*!< [4..4] Direction */
                __IOM uint32_t CMS : 2;    /*!< [6..5] Center-aligned mode selection */
                __IOM uint32_t ARPE : 1;   /*!< [7..7] Auto-reload preload enable */
                __IOM uint32_t CKD : 2;    /*!< [9..8] Clock division */
                __IM uint32_t : 6;
                __IOM uint32_t FTE : 1;    /*!< [16..16] DTS clock enable */
                __IOM uint32_t ETRE : 1;   /*!< [17..17] External trigger input detection/filtering enable */
                __IOM uint32_t TI1E : 1;   /*!< [18..18] TI1 input detection/filtering enable */
                __IOM uint32_t TI2E : 1;   /*!< [19..19] TI2 input detection/filtering enable */
                __IOM uint32_t TI3E : 1;   /*!< [20..20] TI3 input detection/filtering enable */
                __IOM uint32_t TI4E : 1;   /*!< [21..21] TI4 input detection/filtering enable */
                __IOM uint32_t CENCE : 1;  /*!< [22..22] OCREF clear enable when CEN is disabled */
                __IOM uint32_t OCF : 1;    /*!< [23..23] OC/OCN asynchronous anti-glitch filter */
                __IOM uint32_t AS : 1;     /*!< [24..24] Active register selection for mcu read */
            } CR1_b;
        };

        union
        {
            __IOM uint32_t CR2; /*!< (@ 0x00000004) control register 2  */

            struct
            {
                __IOM uint32_t CCPC : 1;  /*!< [0..0] Capture/compare preloaded control */
                __IM uint32_t : 1;
                __IOM uint32_t CCUS : 1;  /*!< [2..2] Capture/compare control update selection */
                __IOM uint32_t CCDS : 1;  /*!< [3..3] Capture/compare DMA selection */
                __IOM uint32_t MMS : 3;   /*!< [6..4] Master mode selection */
                __IOM uint32_t TI1S : 1;  /*!< [7..7] TI1 input selection */
                __IOM uint32_t OIS1 : 1;  /*!< [8..8] Output Idle state 1 */
                __IOM uint32_t OIS1N : 1; /*!< [9..9] Output N Idle state 1 */
                __IOM uint32_t OIS2 : 1;  /*!< [10..10] Output Idle state 2 */
                __IOM uint32_t OIS2N : 1; /*!< [11..11] Output N Idle state 2 */
                __IOM uint32_t OIS3 : 1;  /*!< [12..12] Output Idle state 3 */
                __IOM uint32_t OIS3N : 1; /*!< [13..13] Output N Idle state 3 */
                __IOM uint32_t OIS4 : 1;  /*!< [14..14] Output Idle state 4 */
                __IOM uint32_t OIS4N : 1; /*!< [15..15] Output N Idle state 4 */
                __IOM uint32_t OIS5 : 1;  /*!< [16..16] Output Idle state 5 */
            } CR2_b;
        };

        union
        {
            __IOM uint32_t SMCR; /*!< (@ 0x00000008) slave mode control register*/

            struct
            {
                __IOM uint32_t SMS : 3;  /*!< [2..0] Slave mode selection */
                __IOM uint32_t OCCS : 1; /*!< [3..3] Slave mode selection */
                __IOM uint32_t TS : 3;   /*!< [6..4] Trigger selection */
                __IOM uint32_t MSM : 1;  /*!< [7..7] Master/Slave mode */
                __IOM uint32_t ETF : 4;  /*!< [11..8] External trigger filter */
                __IOM uint32_t ETPS : 2; /*!< [13..12] External trigger prescaler */
                __IOM uint32_t ECE : 1;  /*!< [14..14] External clock enable */
                __IOM uint32_t ETP : 1;  /*!< [15..15] External trigger polarity */
                __IOM uint32_t SMS3 : 1; /*!< [16..16] Slave mode selection - bit 3 */
                __IOM uint32_t OCCP : 1; /*!< [17..17] OCREF_CLR input polarity */
            } SMCR_b;
        };

        union
        {
            __IOM uint32_t DIER; /*!< (@ 0x0000000C) DMA/Interrupt enable register */

            struct
            {
                __IOM uint32_t UIE : 1;   /*!< [0..0] Update interrupt enable*/
                __IOM uint32_t CC1IE : 1; /*!< [1..1] Capture/Compare 1 interrupt enable */
                __IOM uint32_t CC2IE : 1; /*!< [2..2] Capture/Compare 2 interrupt enable */
                __IOM uint32_t CC3IE : 1; /*!< [3..3] Capture/Compare 3 interrupt enable */
                __IOM uint32_t CC4IE : 1; /*!< [4..4] Capture/Compare 4 interrupt enable */
                __IOM uint32_t COMIE : 1; /*!< [5..5] COM interrupt enable */
                __IOM uint32_t TIE : 1;   /*!< [6..6] Trigger interrupt enable */
                __IOM uint32_t BIE : 1;   /*!< [7..7] Break interrupt enable */
                __IOM uint32_t UDE : 1;   /*!< [8..8] Update DMA request enable */
                __IOM uint32_t CC1DE : 1; /*!< [9..9] Capture/Compare 1 DMA request enable */
                __IOM uint32_t CC2DE : 1; /*!< [10..10] Capture/Compare 2 DMA request enable */
                __IOM uint32_t CC3DE : 1; /*!< [11..11] Capture/Compare 3 DMA request enable */
                __IOM uint32_t CC4DE : 1; /*!< [12..12] Capture/Compare 4 DMA request enable */
                __IOM uint32_t COMDE : 1; /*!< [13..13] COM DMA request enable */
                __IOM uint32_t TDE : 1;   /*!< [14..14] Trigger DMA request enable */
                __IM uint32_t : 1;
                __IOM uint32_t CC5IE : 1; /*!< [16..16] Capture/Compare 5 interrupt enable */
                __IM uint32_t : 1;
                __IOM uint32_t CC5DE : 1; /*!< [18..18] Capture/Compare 5 DMA request enable */
            } DIER_b;
        };

        union
        {
            __IOM uint32_t SR; /*!< (@ 0x00000010) status register */

            struct
            {
                __IOM uint32_t UIF : 1;   /*!< [0..0] Update interrupt flag */
                __IOM uint32_t CC1IF : 1; /*!< [1..1] Capture/compare 1 interrupt flag */
                __IOM uint32_t CC2IF : 1; /*!< [2..2] Capture/Compare 2 interrupt flag */
                __IOM uint32_t CC3IF : 1; /*!< [3..3] Capture/Compare 3 interrupt flag */
                __IOM uint32_t CC4IF : 1; /*!< [4..4] Capture/Compare 4 interrupt flag */
                __IOM uint32_t COMIF : 1; /*!< [5..5] COM interrupt flag */
                __IOM uint32_t TIF : 1;   /*!< [6..6] Trigger interrupt flag */
                __IOM uint32_t BIF : 1;   /*!< [7..7] Break interrupt flag */
                __IOM uint32_t B2IF : 1;  /*!< [8..8] Break 2 interrupt flag */
                __IOM uint32_t CC1OF : 1; /*!< [9..9] Capture/Compare 1 overcapture flag */
                __IOM uint32_t CC2OF : 1; /*!< [10..10] Capture/compare 2 overcapture flag */
                __IOM uint32_t CC3OF : 1; /*!< [11..11] Capture/Compare 3 overcapture flag */
                __IOM uint32_t CC4OF : 1; /*!< [12..12] Capture/Compare 4 overcapture flag */
                __IOM uint32_t CC5OF : 1; /*!< [13..13] Capture/Compare 5 overcapture flag */
                __IM uint32_t : 2;
                __IOM uint32_t CC5IF : 1; /*!< [16..16] Capture/Compare 5 interrupt flag */
                __IM uint32_t : 9;
                __IOM uint32_t CAP1P : 1; /*!< [26..26] Channel 1 captures edge markers */
                __IOM uint32_t CAP2P : 1; /*!< [27..27] Channel 2 captures edge markers */
                __IOM uint32_t CAP3P : 1; /*!< [28..28] Channel 3 captures edge markers */
                __IOM uint32_t CAP4P : 1; /*!< [29..29] Channel 4 captures edge markers */
            } SR_b;
        };

        union
        {
            __OM uint32_t EGR; /*!< (@ 0x00000014) event generation register*/

            struct
            {
                __OM uint32_t UG : 1;   /*!< [0..0] Update generation */
                __OM uint32_t CC1G : 1; /*!< [1..1] Capture/compare 1 generation*/
                __OM uint32_t CC2G : 1; /*!< [2..2] Capture/compare 2 generation*/
                __OM uint32_t CC3G : 1; /*!< [3..3] Capture/compare 3 generation*/
                __OM uint32_t CC4G : 1; /*!< [4..4] Capture/compare 4 generation*/
                __OM uint32_t COMG : 1; /*!< [5..5] Capture/Compare control update generation    */
                __OM uint32_t TG : 1;   /*!< [6..6] Trigger generation*/
                __OM uint32_t BG : 1;   /*!< [7..7] Break generation  */
                __OM uint32_t B2G : 1;  /*!< [8..8] Break2 generation */
                __OM uint32_t CC5G : 1; /*!< [9..9] Capture/compare 5 generation*/
            } EGR_b;
        };

        union
        {
            union
            {
                __IOM uint32_t CCMR1_Output; /*!< (@ 0x00000018) capture/compare mode register (output mode) */

                struct
                {
                    __IOM uint32_t CC1S : 2;   /*!< [1..0] Capture/Compare 1 selection */
                    __IOM uint32_t OC1FE : 1;  /*!< [2..2] Output Compare 1 fast enable*/
                    __IOM uint32_t OC1PE : 1;  /*!< [3..3] Output Compare 1 preload enable  */
                    __IOM uint32_t OC1M : 3;   /*!< [6..4] Output Compare 1 mode */
                    __IOM uint32_t OC1CE : 1;  /*!< [7..7] Output Compare 1 clear enable */
                    __IOM uint32_t CC2S : 2;   /*!< [9..8] Capture/Compare 2 selection */
                    __IOM uint32_t OC2FE : 1;  /*!< [10..10] Output Compare 2 fast enable */
                    __IOM uint32_t OC2PE : 1;  /*!< [11..11] Output Compare 2 preload enable */
                    __IOM uint32_t OC2M : 3;   /*!< [14..12] Output Compare 2 mode */
                    __IOM uint32_t OC2CE : 1;  /*!< [15..15] Output Compare 2 clear enable */
                    __IOM uint32_t : 6;
                    __IOM uint32_t OC1TUE : 1; /*!< [22..22] Output Compare 1 Tuning enable */
                    __IOM uint32_t OC1TE : 1;  /*!< [23..23] Output Compare 1 Tuning update enable */
                    __IOM uint32_t : 6;
                    __IOM uint32_t OC2TUE : 1; /*!< [30..30] Output Compare 2 Tuning enable */
                    __IOM uint32_t OC2TE : 1;  /*!< [31..31] Output Compare 2 Tuning update enable */
                } CCMR1_Output_b;
            };
            union
            {
                __IOM uint32_t CCMR1_Input; /*!< (@ 0x00000018) capture/compare mode register 1 (input mode) */

                struct
                {
                    __IOM uint32_t CC1S : 2;   /*!< [1..0] Capture/Compare 1 selection */
                    __IOM uint32_t IC1PSC : 2; /*!< [3..2] Input capture 1 prescaler */
                    __IOM uint32_t IC1F : 4;   /*!< [7..4] Input capture 1 filter */
                    __IOM uint32_t CC2S : 2;   /*!< [9..8] Capture/Compare 2 selection */
                    __IOM uint32_t IC2PCS : 2; /*!< [11..10] Input capture 2 prescaler */
                    __IOM uint32_t IC2F : 4;   /*!< [15..12] Input capture 2 filter */
                } CCMR1_Input_b;
            };
            union
            {
                __IOM uint32_t CCMR1;
            };
        };

        union
        {
            union
            {
                __IOM uint32_t CCMR2_Output; /*!< (@ 0x0000001C) capture/compare mode register (output mode) */

                struct
                {
                    __IOM uint32_t CC3S : 2;   /*!< [1..0] Capture/Compare 3 selection */
                    __IOM uint32_t OC3FE : 1;  /*!< [2..2] Output compare 3 fast enable */
                    __IOM uint32_t OC3PE : 1;  /*!< [3..3] Output compare 3 preload enable */
                    __IOM uint32_t OC3M : 3;   /*!< [6..4] Output compare 3 mode */
                    __IOM uint32_t OC3CE : 1;  /*!< [7..7] Output compare 3 clear enable */
                    __IOM uint32_t CC4S : 2;   /*!< [9..8] Capture/Compare 4 selection */
                    __IOM uint32_t OC4FE : 1;  /*!< [10..10] Output compare 4 fast enable */
                    __IOM uint32_t OC4PE : 1;  /*!< [11..11] Output compare 4 preload enable */
                    __IOM uint32_t OC4M : 3;   /*!< [14..12] Output compare 4 mode */
                    __IOM uint32_t OC4CE : 1;  /*!< [15..15] Output compare 4 clear enable */
                    __IOM uint32_t OC3TUE : 1; /*!< [22..22] Output Compare 3 Tuning enable */
                    __IOM uint32_t OC3TE : 1;  /*!< [23..23] Output Compare 3 Tuning update enable */
                    __IOM uint32_t : 6;
                    __IOM uint32_t OC4TUE : 1; /*!< [30..30] Output Compare 4 Tuning enable */
                    __IOM uint32_t OC4TE : 1;  /*!< [31..31] Output Compare 4 Tuning update enable */
                } CCMR2_Output_b;
            };
            union
            {
                __IOM uint32_t CCMR2_Input; /*!< (@ 0x0000001C) capture/compare mode register 2 (input mode) */

                struct
                {
                    __IOM uint32_t CC3S : 2;   /*!< [1..0] Capture/compare 3 selection */
                    __IOM uint32_t IC3PSC : 2; /*!< [3..2] Input capture 3 prescaler */
                    __IOM uint32_t IC3F : 4;   /*!< [7..4] Input capture 3 filter */
                    __IOM uint32_t CC4S : 2;   /*!< [9..8] Capture/Compare 4 selection */
                    __IOM uint32_t IC4PSC : 2; /*!< [11..10] Input capture 4 prescaler */
                    __IOM uint32_t IC4F : 4;   /*!< [15..12] Input capture 4 filter */
                } CCMR2_Input_b;
            };
            union
            {
                __IOM uint32_t CCMR2;
            };
        };

        union
        {
            __IOM uint32_t CCER; /*!< (@ 0x00000020) capture/compare enable register */

            struct
            {
                __IOM uint32_t CC1E : 1;  /*!< [0..0] Capture/Compare 1 output enable */
                __IOM uint32_t CC1P : 1;  /*!< [1..1] Capture/Compare 1 output Polarity */
                __IOM uint32_t CC1NE : 1; /*!< [2..2] Capture/Compare 1 complementary output enable */
                __IOM uint32_t CC1NP : 1; /*!< [3..3] Capture/Compare 1 output Polarity */
                __IOM uint32_t CC2E : 1;  /*!< [4..4] Capture/Compare 2 output enable */
                __IOM uint32_t CC2P : 1;  /*!< [5..5] Capture/Compare 2 output Polarity */
                __IOM uint32_t CC2NE : 1; /*!< [6..6] Capture/Compare 2 complementary output enable */
                __IOM uint32_t CC2NP : 1; /*!< [7..7] Capture/Compare 2 output Polarity */
                __IOM uint32_t CC3E : 1;  /*!< [8..8] Capture/Compare 3 output enable */
                __IOM uint32_t CC3P : 1;  /*!< [9..9] Capture/Compare 3 output Polarity */
                __IOM uint32_t CC3NE : 1; /*!< [10..10] Capture/Compare 3 complementary output enable */
                __IOM uint32_t CC3NP : 1; /*!< [11..11] Capture/Compare 3 output Polarity */
                __IOM uint32_t CC4E : 1;  /*!< [12..12] Capture/Compare 4 output enable */
                __IOM uint32_t CC4P : 1;  /*!< [13..13] Capture/Compare 4 output Polarity */
                __IOM uint32_t CC4NE : 1; /*!< [14..14] Capture/Compare 4 complementary output enable */
                __IOM uint32_t CC4NP : 1; /*!< [15..15] Capture/Compare 4 output Polarity */
                __IOM uint32_t CC5E : 1;  /*!< [16..16] Capture/Compare 5 output enable */
                __IOM uint32_t CC5P : 1;  /*!< [17..17] Capture/Compare 5 output Polarity */
                __IOM uint32_t CC5NE : 1; /*!< [18..18] Capture/Compare 5 complementary output enable */
                __IOM uint32_t CC5NP : 1; /*!< [19..19] Capture/Compare 5 output Polarity */
            } CCER_b;
        };

        union
        {
            __IOM uint32_t CNT; /*!< (@ 0x00000024) counter */

            struct
            {
                __IOM uint32_t CNT : 16; /*!< [15..0] counter value */
            } CNT_b;
        };

        union
        {
            __IOM uint32_t PSC; /*!< (@ 0x00000028) prescaler */

            struct
            {
                __IOM uint32_t PSC : 16; /*!< [15..0] Prescaler value  */
            } PSC_b;
        };

        union
        {
            __IOM uint32_t ARR; /*!< (@ 0x0000002C) auto-reload register*/

            struct
            {
                __IOM uint32_t ARR : 16; /*!< [15..0] Auto-reload value*/
            } ARR_b;
        };

        union
        {
            __IOM uint32_t RCR; /*!< (@ 0x00000030) repetition counter register*/

            struct
            {
                __IOM uint32_t REP : 8; /*!< [7..0] Repetition counter value    */
            } RCR_b;
        };

        union
        {
            __IOM uint32_t CCR1; /*!< (@ 0x00000034) capture/compare register 1 */

            struct
            {
                __IOM uint32_t CCR1 : 16; /*!< [15..0] Capture/Compare 1 value    */
            } CCR1_b;
        };

        union
        {
            __IOM uint32_t CCR2; /*!< (@ 0x00000038) capture/compare register 2 */

            struct
            {
                __IOM uint32_t CCR2 : 16; /*!< [15..0] Capture/Compare 2 value    */
            } CCR2_b;
        };

        union
        {
            __IOM uint32_t CCR3; /*!< (@ 0x0000003C) capture/compare register 3 */

            struct
            {
                __IOM uint32_t CCR3 : 16; /*!< [15..0] Capture/Compare value */
            } CCR3_b;
        };

        union
        {
            __IOM uint32_t CCR4; /*!< (@ 0x00000040) capture/compare register 4 */

            struct
            {
                __IOM uint32_t CCR4 : 16; /*!< [15..0] Capture/Compare value */
            } CCR4_b;
        };

        union
        {
            __IOM uint32_t BDTR; /*!< (@ 0x00000044) break and dead-time register */

            struct
            {
                __IOM uint32_t DTG : 8;  /*!< [7..0] Dead-time generator setup */
                __IOM uint32_t LOCK : 2; /*!< [9..8] Lock configuration */
                __IOM uint32_t OSSI : 1; /*!< [10..10] Off-state selection for Idle mode */
                __IOM uint32_t OSSR : 1; /*!< [11..11] Off-state selection for Run mode */
                __IOM uint32_t BKE : 1;  /*!< [12..12] Break enable */
                __IOM uint32_t BKP : 1;  /*!< [13..13] Break polarity */
                __IOM uint32_t AOE : 1;  /*!< [14..14] Automatic output enable */
                __IOM uint32_t MOE : 1;  /*!< [15..15] Main output enable */
                __IOM uint32_t : 8;
                __IOM uint32_t BK2E : 1;   /*!< [24..24] Break2 enable */
                __IOM uint32_t BK2P : 1;   /*!< [25..25] Break2 polarity */
                __IOM uint32_t AOE2 : 1;   /*!< [26..26] Automatic output enable 2 */
                __IOM uint32_t BKTRIG : 1; /*!< [27..27] Trigger source selection for TIM1_trig_oci */

            } BDTR_b;
        };

        union
        {
            __IOM uint32_t DCR; /*!< (@ 0x00000048) DMA control register*/

            struct
            {
                __IOM uint32_t DBA : 5;  /*!< [4..0] DMA base address */
                __IOM uint32_t DSEL : 3; /*!< [7..5] DMA burst single transfer select */
                __IOM uint32_t DBL : 5;  /*!< [12..8] DMA burst length */
            } DCR_b;
        };

        union
        {
            __IOM uint32_t DMAR; /*!< (@ 0x0000004C) DMA address for full transfer   */

            struct
            {
                __IOM uint32_t DMAB : 16; /*!< [15..0] DMA register for burst accesses */
            } DMAR_b;
        };

        __IM uint32_t RESERVED0;

        union
        {
            __IOM uint32_t CCMR3; /*!< (@ 0x00000054) capture/compare mode register (output mode) */

            struct
            {
                __IOM uint32_t CC5S : 2;   /*!< [1..0] Capture/Compare 5 selection */
                __IOM uint32_t OC5FE : 1;  /*!< [2..2] Output compare 5 fast enable */
                __IOM uint32_t OC5PE : 1;  /*!< [3..3] Output compare 5 preload enable */
                __IOM uint32_t OC5M : 3;   /*!< [6..4] Output compare 5 mode */
                __IOM uint32_t OC5CE : 1;  /*!< [7..7] Output compare 5 clear enable */
                __IM uint32_t : 14;
                __IOM uint32_t OC5TUE : 1; /*!< [22..22] Output Compare 5 Tuning enable */
                __IOM uint32_t OC5TE : 1;  /*!< [23..23] Output Compare 5 Tuning update enable */

            } CCMR3_b;
        };

        union
        {
            __IOM uint32_t CCR5; /*!< (@ 0x00000058) capture/compare register 5 */

            struct
            {
                __IOM uint32_t CCR5 : 16; /*!< [15..0] Capture/Compare value */
            } CCR5_b;
        };


        __IM uint32_t RESERVED1[2];

        union
        {
            __IOM uint32_t CCTR1; /*!< (@ 0x00000064) Capture/compare repair register 1   */

            struct
            {
                __IOM uint32_t CCTR1 : 16; /*!< [15..0] Capture/compare repair 1 value */
            } CCTR1_b;
        };

        union
        {
            __IOM uint32_t CCTR2; /*!< (@ 0x00000068) Capture/compare repair register 2  */

            struct
            {
                __IOM uint32_t CCTR2 : 16; /*!< [15..0] Capture/compare repair 2 value */
            } CCTR2_b;
        };

        union
        {
            __IOM uint32_t CCTR3; /*!< (@ 0x0000006C) Capture/compare repair register 3   */

            struct
            {
                __IOM uint32_t CCTR3 : 16; /*!< [15..0] Capture/compare repair 3 value */
            } CCTR3_b;
        };

        union
        {
            __IOM uint32_t CCTR4; /*!< (@ 0x00000070) Capture/compare repair register 4   */

            struct
            {
                __IOM uint32_t CCTR4 : 16; /*!< [15..0] Capture/compare repair 4 value */
            } CCTR4_b;
        };

        union
        {
            __IOM uint32_t CCTR5; /*!< (@ 0x00000074) Capture/compare repair register 5 */

            struct
            {
                __IOM uint32_t CCTR5 : 16; /*!< [15..0] Capture/compare repair 5 value */
            } CCTR5_b;
        };

        __IM uint32_t RESERVED2;

        union
        {
            __IOM uint32_t DLAMT; /*!< (@ 0x0000007C)  delay and anti multiple trigger register */

            struct
            {
                __IOM uint32_t DLG : 8;   /*!< [7..0] DLG */
                __IOM uint32_t ATMG : 8;  /*!< [15..8] ATMG */
                __IOM uint32_t AMTDL : 1; /*!< [16..16] AMTDL */
                __IOM uint32_t DLS : 1;   /*!< [17..17] DLS */
            } DLAMT_b;
        };

        union
        {
            __IOM uint32_t CCOR1; /*!< (@ 0x00000080)  delay and anti multiple trigger register */
            struct
            {
                __IOM uint32_t CCOR1 : 16; /*!< [15..0] CCOR1 */
            } CCOR1_b;
        };

        union
        {
            __IOM uint32_t CCOR2; /*!< (@ 0x00000084)  delay and anti multiple trigger register */
            struct
            {
                __IOM uint32_t CCOR2 : 16; /*!< [15..0] CCOR2 */
            } CCOR2_b;
        };

        union
        {
            __IOM uint32_t CCOR3; /*!< (@ 0x00000088)  delay and anti multiple trigger register */
            struct
            {
                __IOM uint32_t CCOR3 : 16; /*!< [15..0] CCOR3 */
            } CCOR3_b;
        };

        union
        {
            __IOM uint32_t CCOR4; /*!< (@ 0x0000008C)  delay and anti multiple trigger register */
            struct
            {
                __IOM uint32_t CCOR4 : 16; /*!< [15..0] CCOR4 */
            } CCOR4_b;
        };

        union
        {
            __IOM uint32_t CCOR5; /*!< (@ 0x00000090)  delay and anti multiple trigger register */
            struct
            {
                __IOM uint32_t CCOR5 : 16; /*!< [15..0] CCOR5 */
            } CCOR5_b;
        };

        __IM uint32_t RESERVED3;

        union
        {
            __IOM uint32_t OCR; /*!< (@ 0x00000098) Compare offset control registers */
            struct
            {
                __IOM uint32_t OC1_MODE : 4; /*!< [3..0] OC1_MODE */
                __IOM uint32_t OC2_MODE : 4; /*!< [7..4] OC2_MODE */
                __IOM uint32_t OC3_MODE : 4; /*!< [11..8] OC3_MODE */
                __IOM uint32_t OC4_MODE : 4; /*!< [15..12] OC4_MODE */
                __IOM uint32_t OC5_MODE : 4; /*!< [19..16] OC5_MODE */
            } OCR_b;
        };

        union
        {
            __IOM uint32_t OMR; /*!< (@ 0x0000009C) Output mode register */
            struct
            {
                __IOM uint32_t PWM1_SEL : 4; /*!< [3..0] PWM1_SEL */
                __IOM uint32_t PWM2_SEL : 4; /*!< [7..4] PWM2_SEL */
                __IOM uint32_t PWM3_SEL : 4; /*!< [11..8] PWM3_SEL */
                __IOM uint32_t PWM4_SEL : 4; /*!< [15..12] PWM4_SEL */
                __IOM uint32_t PWM5_SEL : 4; /*!< [19..16] PWM5_SEL */
                __IOM uint32_t PWM6_SEL : 4; /*!< [23..20] PWM6_SEL */
                __IOM uint32_t PWM7_SEL : 4; /*!< [27..24] PWM7_SEL */
                __IOM uint32_t PWM8_SEL : 4; /*!< [31..28] PWM8_SEL */
            } OMR_b;
        };

    } TIM_TypeDef; /*!< Size = 148 (0x94)    */

    /* =========================================================================================================================== */
    /* ================SPI================ */
    /* =========================================================================================================================== */

    /**
     * @brief ARM PrimeCell SSP (PL022) (SPI)
     */

    typedef struct
    { /*!< (@ 0x40018000) SPI Structure  */

        union
        {
            __IOM uint32_t SPICR0; /*!< (@ 0x00000000) Control register 0  */

            struct
            {
                __IOM uint32_t DSS : 4; /*!< [3..0] Data Size Select */
                __IM uint32_t : 2;
                __IOM uint32_t SPO : 1; /*!< [6..6] SSPCLKOUT polarity, applicable to Motorola SPI frame */
                __IOM uint32_t SPH : 1; /*!< [7..7] SSPCLKOUT phase, applicable to Motorola SPI frame format only */
                __IOM uint32_t SCR : 8; /*!< [15..8] Serial clock rate */
            } SPICR0_b;
        };

        union
        {
            __IOM uint32_t SPICR1; /*!< (@ 0x00000004) Control register 1  */

            struct
            {
                __IOM uint32_t LBM : 1; /*!< [0..0] Loop back mode */
                __IOM uint32_t SSE : 1; /*!< [1..1] Synchronous serial port enable */
                __IOM uint32_t MS : 1;  /*!< [2..2] Master or slave mode select */
                __IOM uint32_t SOD : 1; /*!< [3..3] Slave-mode output disable */
            } SPICR1_b;
        };

        union
        {
            __IOM uint32_t SPIDR; /*!< (@ 0x00000008) Data register */

            struct
            {
                __IOM uint32_t DATA : 16; /*!< [15..0] Transmit/Receive FIFO */
            } SPIDR_b;
        };

        union
        {
            __IM uint32_t SPISR; /*!< (@ 0x0000000C) Status register */

            struct
            {
                __IM uint32_t TFE : 1; /*!< [0..0] Transmit FIFO empty */
                __IM uint32_t TNF : 1; /*!< [1..1] Transmit FIFO not full */
                __IM uint32_t RNE : 1; /*!< [2..2] Receive FIFO not empty */
                __IM uint32_t RFF : 1; /*!< [3..3] Receive FIFO full */
                __IM uint32_t BSY : 1; /*!< [4..4] PrimeCell SSP busy flag */
            } SPISR_b;
        };

        union
        {
            __IOM uint32_t SPICPSR; /*!< (@ 0x00000010) Clock prescale register */

            struct
            {
                __IOM uint32_t CPSDVSR : 8; /*!< [7..0] Clock prescale divisor */
            } SPICPSR_b;
        };

        union
        {
            __IOM uint32_t SPIIMSC; /*!< (@ 0x00000014) Interrupt mask set or clear register */

            struct
            {
                __IOM uint32_t RORIM : 1; /*!< [0..0] Receive overrun interrupt mask */
                __IOM uint32_t RTIM : 1;  /*!< [1..1] Receive timeout interrupt mask */
                __IOM uint32_t RXIM : 1;  /*!< [2..2] Receive FIFO interrupt mask */
                __IOM uint32_t TXIM : 1;  /*!< [3..3] Transmit FIFO interrupt mask */
            } SPIIMSC_b;
        };

        union
        {
            __IM uint32_t SPIRIS; /*!< (@ 0x00000018) Raw interrupt status register */

            struct
            {
                __IM uint32_t RORRIS : 1; /*!< [0..0] Gives the raw interrupt state, prior to masking, of the
                   SSPRORINTR interrupt */
                __IM uint32_t RTRIS : 1;  /*!< [1..1] Gives the raw interrupt state, prior to masking, of the
                   SSPRTINTR interrupt */
                __IM uint32_t RXRIS : 1;  /*!< [2..2] Gives the raw interrupt state, prior to masking, of the
                   SSPRXINTR interrupt */
                __IOM uint32_t TXRIS : 1; /*!< [3..3] Gives the raw interrupt state, prior to masking, of the
                   SSPTXINTR interrupt */
            } SPIRIS_b;
        };

        union
        {
            __IM uint32_t SPIMIS; /*!< (@ 0x0000001C) Masked interrupt status register */

            struct
            {
                __IM uint32_t RORMIS : 1; /*!< [0..0] Gives the receive over run masked interrupt status, after
                   masking, of the SSPRORINTR interrupt */
                __IM uint32_t RTMIS : 1;  /*!< [1..1] Gives the receive timeout masked interrupt state, after
                   masking, of the SSPRTINTR interrupt */
                __IM uint32_t RXMIS : 1;  /*!< [2..2] Gives the receive FIFO masked interrupt state, after
                   masking, of the SSPRXINTR interrupt */
                __IOM uint32_t TXMIS : 1; /*!< [3..3] Gives the transmit FIFO masked interrupt state, after
                   masking, of the SSPTXINTR interrupt */
            } SPIMIS_b;
        };

        union
        {
            __OM uint32_t SPIICR; /*!< (@ 0x00000020) Interrupt clear register */

            struct
            {
                __OM uint32_t RORIC : 1; /*!< [0..0] Clears the SSPRORINTR interrupt */
                __OM uint32_t RTIC : 1;  /*!< [1..1] Clears the SSPRTINTR interrupt */
            } SPIICR_b;
        };

        union
        {
            __IOM uint32_t SPIDMACR; /*!< (@ 0x00000024) DMA control register*/

            struct
            {
                __IOM uint32_t RXDMAE : 1; /*!< [0..0] Receive DMA Enable. If this bit is set to 1, DMA for
                   the receive FIFO is enabled */
                __IOM uint32_t TXDMAE : 1; /*!< [1..1] Transmit DMA Enable. If this bit is set to 1, DMA for
                   the transmit FIFO is enabled */
            } SPIDMACR_b;
        };

        union
        {
            __IOM uint32_t SPICR2; /*!< (@ 0x00000028) Control register 2  */

            struct
            {
                __IOM uint32_t HR : 1;     /*!< [0..0] High-speed mode settings */
                __IOM uint32_t FSSE : 1;   /*!< [1..1] Chip selection enable */
                __IOM uint32_t MRXDDS : 2; /*!< [3..2] Master delay time */
                __IOM uint32_t SCLKD : 1;  /*!< [4..4] Slave-mode clock enable */
                __IOM uint32_t SFSSD : 1;  /*!< [5..5] Slave-mode delay selection enable */
                __IOM uint32_t SRXDD : 1;  /*!< [6..6] Slave-mode delay receive enable */
                __IOM uint32_t LSB : 1;    /*!< [7..7] LSB or MSB */
            } SPICR2_b;
        };

    } SPI_TypeDef; /*!< Size = 54 (0x2C) */

    /* =========================================================================================================================== */
    /* ================    DMAC================ */
    /* =========================================================================================================================== */

    /**
     * @brief DMA control moudle (DMAC)
     */
    typedef struct
    {
        union
        {
            __IOM uint32_t SAR; /*!< (@ 0x00000000) Channel 0 Source Address Register */

            struct
            {
                __IOM uint32_t SAR : 32; /*!< [31..0] Current Source Address of DMA transfer */
            } SAR_b;
        };

        __IM uint32_t RESERVED0;

        union
        {
            __IOM uint32_t DAR; /*!< (@ 0x00000008) Channel 0 Destination Address Register */

            struct
            {
                __IOM uint32_t DAR : 32; /*!< [31..0] Current Destination address of DMA transfer */
            } DAR_b;
        };

        __IM uint32_t RESERVED1[3];

        union
        {
            __IOM uint32_t CTL_L; /*!< (@ 0x00000018) Channel 0 Control Register low */

            struct
            {
                __IOM uint32_t INT_EN : 1;       /*!< [0..0] Interrupt Enable Bit */
                __IOM uint32_t DST_TR_WIDTH : 3; /*!< [3..1] Destination Transfer Width */
                __IOM uint32_t SRC_TR_WIDTH : 3; /*!< [6..4] Source Transfer Width */
                __IOM uint32_t DINC : 2;         /*!< [8..7] Destination Address Increment */
                __IOM uint32_t SINC : 2;         /*!< [10..9] Source Address Increment */
                __IOM uint32_t DEST_MSIZE : 3;   /*!< [13..11] Destination Burst Transaction Length */
                __IOM uint32_t SRC_MSIZE : 3;    /*!< [16..14] Source Burst Transaction Length */
                __IOM uint32_t : 3;
                __IOM uint32_t TT_FC : 3;        /*!< [22..20] Source Burst Transaction Length */
            } CTL_L_b;
        };
        
        union
        {
            __IOM uint32_t CTL_H; /*!< (@ 0x0000001C) Channel 0 Source Status Register high*/

            struct
            {
                __IOM uint32_t BLOCK_TS : 12; /*!< [11..0] Block Transfer Size */
            } CTL_H_b;
        };

        __IM uint32_t RESERVED2[8];

        union
        {
            __IOM uint32_t CFG_L; /*!< (@ 0x00000040) Channel 0 Configuration Register (low) */

            struct
            {
                __IM uint32_t : 10;
                __IOM uint32_t HS_SEL_DST : 1; /*!< [10..10] Destination Software or Hardware Handshaking Select */
                __IOM uint32_t HS_SEL_SRC : 1; /*!< [11..11] Source Software or Hardware Handshaking Select */
            } CFG_L_b;
        };
        
        union
        {
            __IOM uint32_t CFG_H; /*!< (@ 0x00000044) Channel 0 Configuration Register (high)   */

            struct
            {
                __IM uint32_t : 7;
                __IOM uint32_t SRC_PER : 3; /*!< [9..7] Assigns a hardware handshaking interface    */
                __IOM uint32_t : 1;
                __IOM uint32_t DEST_PER : 3; /*!< [13..11] Assigns a hardware handshaking interface   */
            } CFG_H_b;
        };

        __IM uint32_t RESERVED4[4];
    } DMA_Channel_TypeDef;

    typedef struct
    { /*!< (@ 0x48004000) DMAC Structure */

        DMA_Channel_TypeDef CH0; /*0x48004000 -- 0x48004054*/
        DMA_Channel_TypeDef CH1; /*0x48004058 -- 0x480040AC*/
        DMA_Channel_TypeDef CH2; /*0x480040B0 -- 0x48004104*/ /*! reserved for future use */
        DMA_Channel_TypeDef CH3; /*0x48004108 -- 0x4800415C*/ /*! reserved for future use */
        DMA_Channel_TypeDef CH4; /*0x48004160 -- 0x480041B4*/ /*! reserved for future use */
        DMA_Channel_TypeDef CH5; /*0x480041B8 -- 0x4800420C*/ /*! reserved for future use */
        DMA_Channel_TypeDef CH6; /*0x48004210 -- 0x48004264*/ /*! reserved for future use */
        DMA_Channel_TypeDef CH7; /*0x48004268 -- 0x480042BC*/ /*! reserved for future use */
        union
        {
            __IOM uint32_t RawTfr; /*!< (@ 0x000002C0) RawTfr */

            struct
            {
                __IOM uint32_t Raw : 2; /*!< [1..0] Raw interrupt status */
            } RawTfr_b;
        };

        __IM uint32_t RESERVED5;

        union
        {
            __IOM uint32_t RawBlock; /*!< (@ 0x000002C8) RawBlock */

            struct
            {
                __IOM uint32_t Raw : 2; /*!< [1..0] Raw interrupt status */
            } RawBlock_b;
        };

        __IM uint32_t RESERVED6;

        union
        {
            __IOM uint32_t RawSrcTran; /*!< (@ 0x000002D0) RawSrcTran */

            struct
            {
                __IOM uint32_t Raw : 2; /*!< [1..0] Raw interrupt status */
            } RawSrcTran_b;
        };

        __IM uint32_t RESERVED7;

        union
        {
            __IOM uint32_t RawDstTran; /*!< (@ 0x000002D8) RawDstTran */

            struct
            {
                __IOM uint32_t Raw : 2; /*!< [1..0] Raw interrupt status */
            } RawDstTran_b;
        };
    
        __IM uint32_t RESERVED8;

        union
        {
            __IOM uint32_t RawErr; /*!< (@ 0x000002E0) RawErr */

            struct
            {
                __IOM uint32_t Raw : 2; /*!< [1..0] Raw interrupt status */
            } RawErr_b;
        };

        __IM uint32_t RESERVED9;

        union
        {
            __IOM uint32_t StatusTfr; /*!< (@ 0x000002E8) StatusTfr */

            struct
            {
                __IOM uint32_t STATUS : 2; /*!< [1..0] Interrupt status. */
            } StatusTfr_b;
        };

        __IM uint32_t RESERVED10;

        union
        {
            __IOM uint32_t StatusBlock; /*!< (@ 0x000002F0) StatusBlock */

            struct
            {
                __IOM uint32_t STATUS : 2; /*!< [1..0] Interrupt status */
            } StatusBlock_b;
        };

        __IM uint32_t RESERVED11;

        union
        {
            __IOM uint32_t StatusSrcTran; /*!< (@ 0x000002F8) StatusSrcTran */

            struct
            {
                __IOM uint32_t STATUS : 2; /*!< [1..0] Interrupt status  */
            } StatusSrcTran_b;
        };

        __IM uint32_t RESERVED12;

        union
        {
            __IOM uint32_t StatusDstTran; /*!< (@ 0x00000300) StatusDstTran */

            struct
            {
                __IOM uint32_t STATUS : 2; /*!< [1..0] Interrupt status */
            } StatusDstTran_b;
        };

        __IM uint32_t RESERVED13;

        union
        {
            __IOM uint32_t StatusErr; /*!< (@ 0x00000308) StatusErr */

            struct
            {
                __IOM uint32_t STATUS : 2; /*!< [1..0] Interrupt status */
            } StatusErr_b;
        };

        __IM uint32_t RESERVED14;

        union
        {
            __IOM uint32_t MaskTfr; /*!< (@ 0x00000310) Interrupt Mask Registers */

            struct
            {
                __IOM uint32_t INT_MASK_TFR : 2; /*!< [1..0] shield Interrupt Mask of DMA Channel */
                __IM uint32_t : 6;
                __IOM uint32_t INT_MASK_WE : 2;  /*!< [9..8] Interrupt Mask Write Enable */
            } MaskTfr_b;
        };

        __IM uint32_t RESERVED15;

        union
        {
            __IOM uint32_t MaskBlock; /*!< (@ 0x00000318) Interrupt Mask Registers */

            struct
            {
                __IOM uint32_t INT_MASK_BLOCK : 2;    /*!< [1..0] shield Interrupt Mask of DMA Channel */
                __IM uint32_t : 6;
                __IOM uint32_t INT_MASK_BLOCK_WE : 2; /*!< [9..8] Interrupt Mask Write Enable */
            } MaskBlock_b;
        };

        __IM uint32_t RESERVED16;

        union
        {
            __IOM uint32_t MaskSrcTran; /*!< (@ 0x00000320) Interrupt Mask Registers */

            struct
            {
                __IOM uint32_t INT_MASK_SRC_TRAN : 2;    /*!< [1..0] shield Interrupt Mask of DMA Channel */
                __IM uint32_t : 6;
                __IOM uint32_t INT_MASK_SRC_TRAN_WE : 2; /*!< [9..8] Interrupt Mask Write Enable*/
            } MaskSrcTran_b;
        };
    
        __IM uint32_t RESERVED17;

        union
        {
            __IOM uint32_t MaskDstTran; /*!< (@ 0x00000328) Interrupt Mask Registers */

            struct
            {
                __IOM uint32_t INT_MASK_DST_TRAN : 2;    /*!< [2..0] shield Interrupt Mask of DMA Channel */
                __IM uint32_t : 6;
                __IOM uint32_t INT_MASK_DST_TRAN_WE : 2; /*!< [9..8] Interrupt Mask Write Enable */
            } MaskDstTran_b;
        };

        __IM uint32_t RESERVED18;

        union
        {
            __IOM uint32_t MaskErr; /*!< (@ 0x00000330) Interrupt Mask Registers */

            struct
            {
                __IOM uint32_t INT_MASK_Err : 2;    /*!< [1..0] shield Interrupt Mask of DMA Channel */
                __IM uint32_t : 6;
                __IOM uint32_t INT_MASK_Err_WE : 2; /*!< [9..8] Interrupt Mask Write Enable */
            } MaskErr_b;
        };

        __IM uint32_t RESERVED19;

        union
        {
            __OM uint32_t ClearTfr; /*!< (@ 0x00000338) Interrupt Clear Registers */

            struct
            {
                __OM uint32_t CLEAR : 2; /*!< [1..0] Interrupt clear */
            } ClearTfr_b;
        };

        __IM uint32_t RESERVED20;

        union
        {
            __OM uint32_t ClearBlock; /*!< (@ 0x00000340) Interrupt Clear Registers */

            struct
            {
                __OM uint32_t CLEAR : 2; /*!< [1..0] Interrupt clear */
            } ClearBlock_b;
        };

        __IM uint32_t RESERVED21;

        union
        {
            __OM uint32_t ClearSrcTran; /*!< (@ 0x00000348) Interrupt Clear Registers */

            struct
            {
                __OM uint32_t CLEAR : 2; /*!< [1..0] Interrupt clear */
            } ClearSrcTran_b;
        };

        __IM uint32_t RESERVED22;

        union
        {
            __OM uint32_t ClearDstTran; /*!< (@ 0x00000350) Interrupt Clear Registers */

            struct
            {
                __OM uint32_t CLEAR : 2; /*!< [1..0] Interrupt clear */
            } ClearDstTran_b;
        };

        __IM uint32_t RESERVED23;

        union
        {
            __OM uint32_t ClearErr; /*!< (@ 0x00000358) Interrupt Clear Registers */

            struct
            {
                __OM uint32_t CLEAR : 2; /*!< [1..0] Interrupt clear */
            } ClearErr_b;
        };

        __IM uint32_t RESERVED24;

        union
        {
            __IM uint32_t StatusInt; /*!< (@ 0x00000360) Combined Interrupt Status Register */

            struct
            {
                __IM uint32_t TFR : 1;   /*!< [0..0] OR of the contents of StatusTfr register */
                __IM uint32_t BLOCK : 1; /*!< [1..1] OR of the contents of StatusBlock register */
                __IM uint32_t SRCT : 1;  /*!< [2..2] OR of the contents of StatusSrcTran register */
                __IM uint32_t DSCT : 1;  /*!< [3..3] OR of the contents of StatusDst register */
                __IM uint32_t ERR : 1;   /*!< [4..4] OR of the contents of StatusErr register */
            } StatusInt_b;
        };

        __IM uint32_t RESERVED25;

        union
        {
            __IOM uint32_t ReqSrcReg; /*!< (@ 0x00000368) Source Software Transaction Request Register */

            struct
            {
                __IOM uint32_t SRC_REQ : 2; /*!< [1..0] Source request */
                __IM uint32_t : 6;
                __IOM uint32_t SRC_REQ_WE : 2; /*!< [9..8] Source request write enable */
            } ReqSrcReg_b;
        };

        __IM uint32_t RESERVED26;

        union
        {
            __IOM uint32_t ReqDstReg; /*!< (@ 0x00000370) Destination Software Transaction Request Register */

            struct
            {
                __IOM uint32_t DST_REQ : 2; /*!< [1..0] Destination request */
                __IM uint32_t : 6;
                __IOM uint32_t DST_REQ_WE : 2; /*!< [9..8] Destination request write enable */
            } ReqDstReg_b;
        };

        __IM uint32_t RESERVED27;

        union
        {
            __IOM uint32_t SglReqSrcReg; /*!< (@ 0x00000378) Single Source Transaction Request Register */

            struct
            {
                __IOM uint32_t SRC_SGLREQ : 2; /*!< [1..0] Source single request */
                __IM uint32_t : 6;
                __IOM uint32_t SRC_SGLREQ_WE : 2; /*!< [9..8] Single write enable */
            } SglReqSrcReg_b;
        };

        __IM uint32_t RESERVED28;

        union
        {
            __IOM uint32_t SglReqDstReg; /*!< (@ 0x00000380) Single Destination Transaction Request Register */

            struct
            {
                __IOM uint32_t DST_SGLREQ : 2; /*!< [1..0] Destination single or burst request */
                __IM uint32_t : 6;
                __IOM uint32_t DST_SGLREQ_WE : 2; /*!< [9..8] Destination write enable */
            } SglReqDstReg_b;
        };

        __IM uint32_t RESERVED29[5];

        union
        {
            __IOM uint32_t DmaCfgReg; /*!< (@ 0x00000398) DMA Configuration Register */

            struct
            {
                __IOM uint32_t DMA_EN : 1; /*!< [0..0] DW_ahb_dmac Enable bit */
            } DmaCfgReg_b;
        };

        __IM uint32_t RESERVED30;

        union
        {
            __IOM uint32_t ChEnReg; /*!< (@ 0x000003A0) DMA Channel Enable Register */

            struct
            {
                __IOM uint32_t CH_EN : 2; /*!< [1..0] Enables/Disables the channel */
                __IM uint32_t : 6;
                __IOM uint32_t CH_EN_WE : 2; /*!< [9..8] Channel enable write enable */
            } ChEnReg_b;
        };

    } DMAC_TypeDef; /*!< Size = 932 (0x3A4) */

    /* =========================================================================================================================== */
    /* ================    FLASH    ================ */
    /* =========================================================================================================================== */

    /**
     * @brief eflash controller (FLASH)
     */

    typedef struct
    { /*!< (@ 0x4001D000) FLASH Structure*/

        union
        {
            __IOM uint32_t ACR; /*!< (@ 0x00000000) Flash access control register */

            struct
            {
                __IOM uint32_t LATENCY : 3;   /*!< [2..0] Latency */
                __IM uint32_t : 1;
                __IOM uint32_t PRFTBE : 1;    /*!< [4..4] Prefetch buffer enable */
                __IM uint32_t PRFTBS : 1;     /*!< [5..5] Prefetch buffer status */
                __IM uint32_t : 2;
                __IM uint32_t R_LATENCY : 1;  /*!< [8..8] Prefetch buffer status */
            } ACR_b;
        };

        union
        {
            __OM uint32_t KEYR; /*!< (@ 0x00000004) Flash key register */

            struct
            {
                __OM uint32_t FKEY : 32; /*!< [31..0] Flash key */
            } KEYR_b;
        };

        union
        {
            __OM uint32_t OPTKEYR; /*!< (@ 0x00000008) Flash option key register */

            struct
            {
                __OM uint32_t OPTKEY : 32; /*!< [31..0] Option byte key */
            } OPTKEYR_b;
        };

        union
        {
            __IOM uint32_t SR; /*!< (@ 0x0000000C) Flash status register */

            struct
            {
                __IM uint32_t BSY : 1;           /*!< [0..0] Busy flag */
                __IM uint32_t : 1;
                __IOM uint32_t PGERR : 1;        /*!< [2..2] Programming error */
                __IM uint32_t : 1;
                __IOM uint32_t WRPRTERR : 1;     /*!< [4..4] Write protection error */
                __IOM uint32_t EOP : 1;          /*!< [5..5] End of operation */
                __IOM uint32_t CONEOP : 1;       /*!< [6..6] CONEOP */
                __IM uint32_t : 1;
                __IOM uint32_t PG_OVRANGE : 1;   /*!< [8..8] PG_OVRANGE */
                __IOM uint32_t PG_TIMEOUT : 1;   /*!< [9..9] PG_TIMEOUT */
                __IM uint32_t : 6;
                __IM uint32_t OB_BOOT_MODE : 2;  /*!< [17..16] Device boot mode configuration in option byte */
                __IM uint32_t OB_BOOT0_PIN : 1;  /*!< [18..18] Boot0 pin value */
                __IM uint32_t OB_EMPTY_FLAG : 1; /*!< [19..19] Main memory empty flag */
                __IM uint32_t OBERR : 1;         /*!< [20..20] Option byte error */
            } SR_b;
        };

        union
        {
            __IOM uint32_t CR; /*!< (@ 0x00000010) Flash control register */

            struct
            {
                __IOM uint32_t PG : 1;          /*!< [0..0] Flash programming chosen */
                __IOM uint32_t PER : 1;         /*!< [1..1] chip not support   parpare */
                __IOM uint32_t MER : 1;         /*!< [2..2] Mass erase */
                __IOM uint32_t HALFER : 1;      /*!< [3..3] Half page erase */
                __IOM uint32_t OPTPG : 1;       /*!< [4..4] Option byte programming */
                __IOM uint32_t OPTER : 1;       /*!< [5..5] Option byte erase */
                __IOM uint32_t STRT : 1;        /*!< [6..6] Start */
                __IOM uint32_t LOCK : 1;        /*!< [7..7] in order to LOCK flash */
                __IOM uint32_t CONPG_LOCK : 1;  /*!< [8..8] CONPG_LOCK */
                __IOM uint32_t OPTWRE : 1;      /*!< [9..9] Option byte write enable */
                __IOM uint32_t ERRIE : 1;       /*!< [10..10] Error interrupt enable */
                __IM uint32_t : 1;
                __IOM uint32_t EOPIE : 1;       /*!< [12..12] End of operation interrupt enable */
                __IM uint32_t : 3;
                __IOM uint32_t SMLOCK : 1;      /*!< [16..16] System memory write lock */
                __IM uint32_t : 3;
                __IOM uint32_t CONPG : 1;       /*!< [16..16] CONPG */
                __IOM uint32_t PG_STOP : 1;     /*!< [16..16] PG_STOP */
                __IM uint32_t : 2;
                __IOM uint32_t BOOT_MODE : 2;   /*!< [25..24] Device boot mode selection */
                __IM uint32_t : 2;
                __IOM uint32_t RDONLY : 1;      /*!< [28..28] Read only mode enable bit */
            } CR_b;
        };

        union
        {
            __IOM uint32_t AR; /*!< (@ 0x00000014) Flash address register */

            struct
            {
                __IOM uint32_t FAR : 32; /*!< [31..0] Flash Address */
            } AR_b;
        };

        union
        {
            __IM uint32_t OBR; /*!< (@ 0x00000018) Flash Option byte register */

            struct
            {
                __IM uint32_t nBOOT0 : 1;   /*!< [0..0] nBOOT0 */
                __IM uint32_t nBOOT1 : 1;   /*!< [1..1] nBOOT1 */
                __IM uint32_t BOOT_SEL : 1; /*!< [2..2] BOOT_SEL */
                __IM uint32_t WDG_SW : 1;   /*!< [3..3] WDG_SW */
                __IM uint32_t : 4;
                __IM uint32_t DATA0 : 8;    /*!< [15..8] DATA0 */
                __IM uint32_t DATA1 : 8;    /*!< [23..16] DATA1 */
                __IM uint32_t DATA2 : 8;    /*!< [31..24] DATA2 */
            } OBR_b;
        };

        union
        {
            __IM uint32_t CAL1; /*!< (@ 0x0000001C) The reset value of this register depends on the
            value programmed in the option byte */

            struct
            {
                __IM uint32_t nRCHTRIM : 8;   /*!< [7..0] Inverse coder of RCH calibration value */
                __IM uint32_t nRCHPT : 4;     /*!< [11..8] Inverse coder of RCH calibration value */
                __IM uint32_t RCHTRIM : 4;    /*!< [16..12] Inverse coder of RCH calibration value */
                __IM uint32_t nBGRTRIM : 11;  /*!< [26..16] Inverse coder of VBG calibration value */
                __IM uint32_t : 1;
                __IM uint32_t nLPVRTRIM : 3;   /*!< [30..28] Inverse coder of LPVBG calibration value */
            } CAL1_b;
        };

        union
        {
            __IM uint32_t RDPR; /*!< (@ 0x00000020) Flash read protection register */

            struct
            {
                __IM uint32_t RDPRT : 8;  /*!< [7..0] The 8 flash regions read protection level status */
                __IM uint32_t RDPRT2 : 1; /*!< [8..8] The whole flash read protection level 2 status */
            } RDPR_b;
        };

        union
        {
            __IM uint32_t WRPR; /*!< (@ 0x00000024) The reset value of this register depends on the
            value programmed in the option byte */

            struct
            {
                __IM uint32_t WRP : 32; /*!< [31..0] Write protect */
            } WRPR_b;
        };

        union
        {
            __IM uint32_t CAL2; /*!< (@ 0x00000028) Flash calibration register 2 */

            struct
            {
                __IM uint32_t nRCLTRIM : 5;   /*!< [4..0] Inverse coder of RCL calibration value */
                __IM uint32_t RCLTRIM : 1;    /*!< [5..5] RCL calibration value */
                __IM uint32_t : 2;
                __IM uint32_t nLPBGRTRIM : 5; /*!< [12..8] coder of LPVBG  calibration value */
                __IM uint32_t LPBGRTRIM : 1;  /*!< [13..13] coder of LPVBG calibration value */
            } CAL2_b;
        };

        __IM uint32_t RESERVED0[4];

        union
        {
            __OM uint32_t SMKEYR; /*!< (@ 0x0000003C) SMKEYR */

            struct
            {
                __OM uint32_t SMKEY : 32; /*!< [31..0] SMKEY register */
            } SMKEYR_b;
        };

        union
        {
            __OM uint32_t CONPGKEYR; /*!< (@ 0x00000040) CONPGKEYR */

            struct
            {
                __OM uint32_t CONPGKEYR : 32; /*!< [31..0] CONPGKEYR */
            } CONPGKEYR_b;
        };

        union
        {
            __IOM uint32_t HIT0_CR; /*!< (@ 0x00000044) HIT0_CR */

            struct
            {
                __IOM uint32_t HIT0_ADDR : 17; /*!< [17..0] HIT0_ADDR */
                __IM uint32_t : 3;
                __IOM uint32_t HIT0_EN : 1;    /*!< [20..20] HIT0_EN */
            } HIT0_CR_b;
        };

        union
        {
            __IOM uint32_t HIT0_DR; /*!< (@ 0x00000048) HIT0_DR */

            struct
            {
                __IOM uint32_t HIT0_DATA : 32; /*!< [31..0] HIT0_DATA */
            } HIT0_DR_b;
        };

        union
        {
            __IOM uint32_t HIT1_CR; /*!< (@ 0x0000004C) HIT1_CR */

            struct
            {
                __IOM uint32_t HIT1_ADDR : 17; /*!< [17..0] HIT1_ADDR */
                __IM uint32_t : 3;
                __IOM uint32_t HIT1_EN : 1;    /*!< [20..20] HIT1_EN */
            } HIT1_CR_b;
        };

        union
        {
            __IOM uint32_t HIT1_DR; /*!< (@ 0x00000050) HIT1_DR */

            struct
            {
                __IOM uint32_t HIT1_DATA : 32; /*!< [31..0] HIT1_DATA */
            } HIT1_DR_b;
        };

        union
        {
            __IOM uint32_t HIT2_CR; /*!< (@ 0x0000004C) HIT2_CR */

            struct
            {
                __IOM uint32_t HIT2_ADDR : 17; /*!< [17..0] HIT2_ADDR */
                __IM uint32_t : 3;
                __IOM uint32_t HIT2_EN : 1;    /*!< [20..20] HIT2_EN */
            } HIT2_CR_b;
        };

        union
        {
            __IOM uint32_t HIT2_DR; /*!< (@ 0x00000050) HIT2_DR */

            struct
            {
                __IOM uint32_t HIT2_DATA : 32; /*!< [31..0] HIT2_DATA */
            } HIT2_DR_b;
        };
    } FLASH_TypeDef; /*!< Size = 64 (0x54)    */

    /* =========================================================================================================================== */
    /* ================    GPIOF    ================ */
    /* =========================================================================================================================== */

    /**
     * @brief General-purpose I/Os (GPIOA)
     */

    typedef struct
    { /*!< (@ 0x48000000) GPIOA Structure*/

        union
        {
            __IOM uint32_t MODER; /*!< (@ 0x00000000) GPIO port mode register  */

            struct
            {
                __IOM uint32_t MODER0 : 2;  /*!< [1..0] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER1 : 2;  /*!< [3..2] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER2 : 2;  /*!< [5..4] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER3 : 2;  /*!< [7..6] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER4 : 2;  /*!< [9..8] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER5 : 2;  /*!< [11..10] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER6 : 2;  /*!< [13..12] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER7 : 2;  /*!< [15..14] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER8 : 2;  /*!< [17..16] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER9 : 2;  /*!< [19..18] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER10 : 2; /*!< [21..20] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER11 : 2; /*!< [23..22] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER12 : 2; /*!< [25..24] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER13 : 2; /*!< [27..26] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER14 : 2; /*!< [29..28] Port x configuration bits (y = 0..15) */
                __IOM uint32_t MODER15 : 2; /*!< [31..30] Port x configuration bits (y = 0..15) */
            } MODER_b;
        };

        union
        {
            union
            {
                __IM uint32_t OD; /*!< (@ 0x00000004) GPIO port open drain bit set/reset register */

                struct
                {
                    __IM uint32_t OD0 : 1;  /*!< [0..0] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD1 : 1;  /*!< [1..1] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD2 : 1;  /*!< [2..2] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD3 : 1;  /*!< [3..3] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD4 : 1;  /*!< [4..4] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD5 : 1;  /*!< [5..5] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD6 : 1;  /*!< [6..6] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD7 : 1;  /*!< [7..7] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD8 : 1;  /*!< [8..8] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD9 : 1;  /*!< [9..9] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD10 : 1; /*!< [10..10] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD11 : 1; /*!< [11..11] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD12 : 1; /*!< [12..12] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD13 : 1; /*!< [13..13] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD14 : 1; /*!< [14..14] Port x open drain configuration bits (y = 0..15) */
                    __IM uint32_t OD15 : 1; /*!< [15..15] Port x open drain configuration bits (y = 0..15) */
                } OD_b;
            };

            union
            {
                __IOM uint32_t OD_BSRR; /*!< (@ 0x00000004) GPIO port open drain bit set/reset register */

                struct
                {
                    __IOM uint32_t BS0 : 1;  /*!< [0..0] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS1 : 1;  /*!< [1..1] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS2 : 1;  /*!< [2..2] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS3 : 1;  /*!< [3..3] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS4 : 1;  /*!< [4..4] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS5 : 1;  /*!< [5..5] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS6 : 1;  /*!< [6..6] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS7 : 1;  /*!< [7..7] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS8 : 1;  /*!< [8..8] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS9 : 1;  /*!< [9..9] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS10 : 1; /*!< [10..10] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS11 : 1; /*!< [11..11] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS12 : 1; /*!< [12..12] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS13 : 1; /*!< [13..13] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS14 : 1; /*!< [14..14] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BS15 : 1; /*!< [15..15] Port x open drain configuration set bits (y = 0..15) */
                    __IOM uint32_t BR0 : 1;  /*!< [16..16] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR1 : 1;  /*!< [17..17] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR2 : 1;  /*!< [18..18] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR3 : 1;  /*!< [19..19] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR4 : 1;  /*!< [20..20] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR5 : 1;  /*!< [21..21] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR6 : 1;  /*!< [22..22] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR7 : 1;  /*!< [23..23] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR8 : 1;  /*!< [24..24] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR9 : 1;  /*!< [25..25] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR10 : 1; /*!< [26..26] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR11 : 1; /*!< [27..27] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR12 : 1; /*!< [28..28] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR13 : 1; /*!< [29..29] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR14 : 1; /*!< [30..30] Port x open drain configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR15 : 1; /*!< [31..31] Port x open drain configuration reset bits (y = 0..15) */
                } OD_BSRR_b;
            };
        };

        __IM uint32_t RESERVED0;

        union
        {
            union
            {
                __IM uint32_t PU; /*!< (@ 0x0000000C) GPIO port pull up bit set/reset register  */

                struct
                {
                    __IM uint32_t PU0 : 1;  /*!< [0..0] Port x pull up configuration bits (y = 0..15)*/
                    __IM uint32_t PU1 : 1;  /*!< [1..1] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU2 : 1;  /*!< [2..2] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU3 : 1;  /*!< [3..3] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU4 : 1;  /*!< [4..4] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU5 : 1;  /*!< [5..5] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU6 : 1;  /*!< [6..6] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU7 : 1;  /*!< [7..7] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU8 : 1;  /*!< [8..8] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU9 : 1;  /*!< [9..9] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU10 : 1; /*!< [10..10] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU11 : 1; /*!< [11..11] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU12 : 1; /*!< [12..12] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU13 : 1; /*!< [13..13] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU14 : 1; /*!< [14..14] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PU15 : 1; /*!< [15..15] Port x slew rate configuration bits (y = 0..15) */
                } PU_b;
            };

            union
            {
                __IOM uint32_t PU_BSRR; /*!< (@ 0x0000000C) GPIO port pull up bit set/reset register  */

                struct
                {
                    __IOM uint32_t BS0 : 1;  /*!< [0..0] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS1 : 1;  /*!< [1..1] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS2 : 1;  /*!< [2..2] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS3 : 1;  /*!< [3..3] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS4 : 1;  /*!< [4..4] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS5 : 1;  /*!< [5..5] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS6 : 1;  /*!< [6..6] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS7 : 1;  /*!< [7..7] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS8 : 1;  /*!< [8..8] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS9 : 1;  /*!< [9..9] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS10 : 1; /*!< [10..10] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS11 : 1; /*!< [11..11] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS12 : 1; /*!< [12..12] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS13 : 1; /*!< [13..13] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS14 : 1; /*!< [14..14] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS15 : 1; /*!< [15..15] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BR0 : 1;  /*!< [16..16] Port x pull up configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR1 : 1;  /*!< [17..17] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR2 : 1;  /*!< [18..18] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR3 : 1;  /*!< [19..19] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR4 : 1;  /*!< [20..20] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR5 : 1;  /*!< [21..21] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR6 : 1;  /*!< [22..22] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR7 : 1;  /*!< [23..23] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR8 : 1;  /*!< [24..24] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR9 : 1;  /*!< [25..25] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR10 : 1; /*!< [26..26] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR11 : 1; /*!< [27..27] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR12 : 1; /*!< [28..28] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR13 : 1; /*!< [29..29] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR14 : 1; /*!< [30..30] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR15 : 1; /*!< [31..31] Port x slew rate configuration bits (y = 0..15) */
                } PU_BSRR_b;
            };
        };

        union
        {
            union
            {
                __IM uint32_t PD; /*!< (@ 0x00000010) GPIO port pull down bit set/reset register*/

                struct
                {
                    __IM uint32_t PD0 : 1;  /*!< [0..0] Port x pull down configuration bits (y = 0..15) */
                    __IM uint32_t PD1 : 1;  /*!< [1..1] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD2 : 1;  /*!< [2..2] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD3 : 1;  /*!< [3..3] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD4 : 1;  /*!< [4..4] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD5 : 1;  /*!< [5..5] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD6 : 1;  /*!< [6..6] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD7 : 1;  /*!< [7..7] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD8 : 1;  /*!< [8..8] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD9 : 1;  /*!< [9..9] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD10 : 1; /*!< [10..10] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD11 : 1; /*!< [11..11] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD12 : 1; /*!< [12..12] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD13 : 1; /*!< [13..13] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD14 : 1; /*!< [14..14] Port x slew rate configuration bits (y = 0..15) */
                    __IM uint32_t PD15 : 1; /*!< [15..15] Port x slew rate configuration bits (y = 0..15) */
                } PD_b;
            };

            union
            {
                __IOM uint32_t PD_BSRR; /*!< (@ 0x00000010) GPIO port pull down bit set/reset register*/

                struct
                {
                    __IOM uint32_t BS0 : 1;  /*!< [0..0] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS1 : 1;  /*!< [1..1] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS2 : 1;  /*!< [2..2] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS3 : 1;  /*!< [3..3] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS4 : 1;  /*!< [4..4] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS5 : 1;  /*!< [5..5] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS6 : 1;  /*!< [6..6] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS7 : 1;  /*!< [7..7] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS8 : 1;  /*!< [8..8] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS9 : 1;  /*!< [9..9] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS10 : 1; /*!< [10..10] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS11 : 1; /*!< [11..11] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS12 : 1; /*!< [12..12] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS13 : 1; /*!< [13..13] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS14 : 1; /*!< [14..14] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BS15 : 1; /*!< [15..15] Port x pull up configuration set bits (y = 0..15) */
                    __IOM uint32_t BR0 : 1;  /*!< [16..16] Port x pull up configuration reset bits (y = 0..15) */
                    __IOM uint32_t BR1 : 1;  /*!< [17..17] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR2 : 1;  /*!< [18..18] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR3 : 1;  /*!< [19..19] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR4 : 1;  /*!< [20..20] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR5 : 1;  /*!< [21..21] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR6 : 1;  /*!< [22..22] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR7 : 1;  /*!< [23..23] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR8 : 1;  /*!< [24..24] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR9 : 1;  /*!< [25..25] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR10 : 1; /*!< [26..26] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR11 : 1; /*!< [27..27] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR12 : 1; /*!< [28..28] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR13 : 1; /*!< [29..29] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR14 : 1; /*!< [30..30] Port x slew rate configuration bits (y = 0..15) */
                    __IOM uint32_t BR15 : 1; /*!< [31..31] Port x slew rate configuration bits (y = 0..15) */
                } PD_BSRR_b;
            };
        };

        union
        {
            __IOM uint32_t IDR; /*!< (@ 0x00000014) GPIO port input data register   */

            struct
            {
                __IOM uint32_t IDR0 : 1;  /*!< [0..0] Port x pull up configuration reset bits (y = 0..15) */
                __IOM uint32_t IDR1 : 1;  /*!< [1..1] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR2 : 1;  /*!< [2..2] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR3 : 1;  /*!< [3..3] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR4 : 1;  /*!< [4..4] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR5 : 1;  /*!< [5..5] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR6 : 1;  /*!< [6..6] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR7 : 1;  /*!< [7..7] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR8 : 1;  /*!< [8..8] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR9 : 1;  /*!< [9..9] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR10 : 1; /*!< [10..10] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR11 : 1; /*!< [11..11] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR12 : 1; /*!< [12..12] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR13 : 1; /*!< [13..13] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR14 : 1; /*!< [14..14] Port x slew rate configuration bits (y = 0..15) */
                __IOM uint32_t IDR15 : 1; /*!< [15..15] Port x slew rate configuration bits (y = 0..15) */
            } IDR_b;
        };

        union
        {
            __IOM uint32_t ODR; /*!< (@ 0x00000018) GPIO port output data register  */

            struct
            {
                __IOM uint32_t ODR0 : 1;  /*!< [0..0] ODR0  */
                __IOM uint32_t ODR1 : 1;  /*!< [1..1] ODR1  */
                __IOM uint32_t ODR2 : 1;  /*!< [2..2] ODR2  */
                __IOM uint32_t ODR3 : 1;  /*!< [3..3] ODR3  */
                __IOM uint32_t ODR4 : 1;  /*!< [4..4] ODR4  */
                __IOM uint32_t ODR5 : 1;  /*!< [5..5] ODR5  */
                __IOM uint32_t ODR6 : 1;  /*!< [6..6] ODR6  */
                __IOM uint32_t ODR7 : 1;  /*!< [7..7] ODR7  */
                __IOM uint32_t ODR8 : 1;  /*!< [8..8] ODR8  */
                __IOM uint32_t ODR9 : 1;  /*!< [9..9] ODR9  */
                __IOM uint32_t ODR10 : 1; /*!< [10..10] ODR10 */
                __IOM uint32_t ODR11 : 1; /*!< [11..11] ODR11 */
                __IOM uint32_t ODR12 : 1; /*!< [12..12] ODR12 */
                __IOM uint32_t ODR13 : 1; /*!< [13..13] ODR13 */
                __IOM uint32_t ODR14 : 1; /*!< [14..14] ODR14 */
                __IOM uint32_t ODR15 : 1; /*!< [15..15] ODR15 */
            } ODR_b;
        };

        union
        {
            __IOM uint32_t BSRR; /*!< (@ 0x0000001C) GPIO bit set reset register*/

            struct
            {
                __IOM uint32_t BS0 : 1;  /*!< [0..0] BS0   */
                __IOM uint32_t BS1 : 1;  /*!< [1..1] BS1   */
                __IOM uint32_t BS2 : 1;  /*!< [2..2] BS2   */
                __IOM uint32_t BS3 : 1;  /*!< [3..3] BS3   */
                __IOM uint32_t BS4 : 1;  /*!< [4..4] BS4   */
                __IOM uint32_t BS5 : 1;  /*!< [5..5] BS5   */
                __IOM uint32_t BS6 : 1;  /*!< [6..6] BS6   */
                __IOM uint32_t BS7 : 1;  /*!< [7..7] BS7   */
                __IOM uint32_t BS8 : 1;  /*!< [8..8] BS8   */
                __IOM uint32_t BS9 : 1;  /*!< [9..9] BS9   */
                __IOM uint32_t BS10 : 1; /*!< [10..10] BS10*/
                __IOM uint32_t BS11 : 1; /*!< [11..11] BS11*/
                __IOM uint32_t BS12 : 1; /*!< [12..12] BS12*/
                __IOM uint32_t BS13 : 1; /*!< [13..13] BS13*/
                __IOM uint32_t BS14 : 1; /*!< [14..14] BS14*/
                __IOM uint32_t BS15 : 1; /*!< [15..15] BS15*/
                __IOM uint32_t BR0 : 1;  /*!< [16..16] BR0 */
                __IOM uint32_t BR1 : 1;  /*!< [17..17] BR1 */
                __IOM uint32_t BR2 : 1;  /*!< [18..18] BR2 */
                __IOM uint32_t BR3 : 1;  /*!< [19..19] BR3 */
                __IOM uint32_t BR4 : 1;  /*!< [20..20] BR4 */
                __IOM uint32_t BR5 : 1;  /*!< [21..21] BR5 */
                __IOM uint32_t BR6 : 1;  /*!< [22..22] BR6 */
                __IOM uint32_t BR7 : 1;  /*!< [23..23] BR7 */
                __IOM uint32_t BR8 : 1;  /*!< [24..24] BR8 */
                __IOM uint32_t BR9 : 1;  /*!< [25..25] BR9 */
                __IOM uint32_t BR10 : 1; /*!< [26..26] BR10*/
                __IOM uint32_t BR11 : 1; /*!< [27..27] BR11*/
                __IOM uint32_t BR12 : 1; /*!< [28..28] BR12*/
                __IOM uint32_t BR13 : 1; /*!< [29..29] BR13*/
                __IOM uint32_t BR14 : 1; /*!< [30..30] BR14*/
                __IOM uint32_t BR15 : 1; /*!< [31..31] BR15*/
            } BSRR_b;
        };

        union
        {
            __IOM uint32_t LCKR; /*!< (@ 0x00000020) GPIO lock register  */

            struct
            {
                __IOM uint32_t LCK0 : 1;  /*!< [0..0] LCK0  */
                __IOM uint32_t LCK1 : 1;  /*!< [1..1] LCK1  */
                __IOM uint32_t LCK2 : 1;  /*!< [2..2] LCK2  */
                __IOM uint32_t LCK3 : 1;  /*!< [3..3] LCK3  */
                __IOM uint32_t LCK4 : 1;  /*!< [4..4] LCK4  */
                __IOM uint32_t LCK5 : 1;  /*!< [5..5] LCK5  */
                __IOM uint32_t LCK6 : 1;  /*!< [6..6] LCK6  */
                __IOM uint32_t LCK7 : 1;  /*!< [7..7] LCK7  */
                __IOM uint32_t LCK8 : 1;  /*!< [8..8] LCK8  */
                __IOM uint32_t LCK9 : 1;  /*!< [9..9] LCK9  */
                __IOM uint32_t LCK10 : 1; /*!< [10..10] LCK10 */
                __IOM uint32_t LCK11 : 1; /*!< [11..11] LCK11 */
                __IOM uint32_t LCK12 : 1; /*!< [12..12] LCK12 */
                __IOM uint32_t LCK13 : 1; /*!< [13..13] LCK13 */
                __IOM uint32_t LCK14 : 1; /*!< [14..14] LCK14 */
                __IOM uint32_t LCK15 : 1; /*!< [15..15] LCK15 */
                __IOM uint32_t LCKK : 1;  /*!< [16..16] LCKK*/
            } LCKR_b;
        };

        union
        {
            __IOM uint32_t AFRL; /*!< (@ 0x00000024) GPIO AF register    */

            struct
            {
                __IOM uint32_t AFR0 : 4; /*!< [3..0] AFR0  */
                __IOM uint32_t AFR1 : 4; /*!< [7..4] AFR1  */
                __IOM uint32_t AFR2 : 4; /*!< [11..8] AFR2 */
                __IOM uint32_t AFR3 : 4; /*!< [15..12] AFR3*/
                __IOM uint32_t AFR4 : 4; /*!< [19..16] AFR4*/
                __IOM uint32_t AFR5 : 4; /*!< [23..20] AFR5*/
                __IOM uint32_t AFR6 : 4; /*!< [27..24] AFR6*/
                __IOM uint32_t AFR7 : 4; /*!< [31..28] AFR7*/
            } AFRL_b;
        };

        union
        {
            __IOM uint32_t AFRH; /*!< (@ 0x00000028) GPIO AF register    */

            struct
            {
                __IOM uint32_t AFR8 : 4;  /*!< [3..0] AFR8  */
                __IOM uint32_t AFR9 : 4;  /*!< [7..4] AFR9  */
                __IOM uint32_t AFR10 : 4; /*!< [11..8] AFR10*/
                __IOM uint32_t AFR11 : 4; /*!< [15..12] AFR11 */
                __IOM uint32_t AFR12 : 4; /*!< [19..16] AFR12 */
                __IOM uint32_t AFR13 : 4; /*!< [23..20] AFR13 */
                __IOM uint32_t AFR14 : 4; /*!< [27..24] AFR14 */
                __IOM uint32_t AFR15 : 4; /*!< [31..28] AFR15 */
            } AFRH_b;
        };

        union
        {
            __IOM uint32_t BTGLR; /*!< (@ 0x0000002C) GPIO output bit troggle  */

            struct
            {
                __IOM uint32_t BTGL0 : 1;  /*!< [0..0] BTGL0 */
                __IOM uint32_t BTGL1 : 1;  /*!< [1..1] BTGL1 */
                __IOM uint32_t BTGL2 : 1;  /*!< [2..2] BTGL2 */
                __IOM uint32_t BTGL3 : 1;  /*!< [3..3] BTGL3 */
                __IOM uint32_t BTGL4 : 1;  /*!< [4..4] BTGL4 */
                __IOM uint32_t BTGL5 : 1;  /*!< [5..5] BTGL5 */
                __IOM uint32_t BTGL6 : 1;  /*!< [6..6] BTGL6 */
                __IOM uint32_t BTGL7 : 1;  /*!< [7..7] BTGL7 */
                __IOM uint32_t BTGL8 : 1;  /*!< [8..8] BTGL8 */
                __IOM uint32_t BTGL9 : 1;  /*!< [9..9] BTGL9 */
                __IOM uint32_t BTGL10 : 1; /*!< [10..10] BTGL10*/
                __IOM uint32_t BTGL11 : 1; /*!< [11..11] BTGL11*/
                __IOM uint32_t BTGL12 : 1; /*!< [12..12] BTGL12*/
                __IOM uint32_t BTGL13 : 1; /*!< [13..13] BTGL13*/
                __IOM uint32_t BTGL14 : 1; /*!< [14..14] BTGL14*/
                __IOM uint32_t BTGL15 : 1; /*!< [15..15] BTGL15*/
            } BTGLR_b;
        };

        union
        {
            union
            {
                __IOM uint32_t DR_BSRR; /*!< (@ 0x00000030) GPIO port driving strength bit set/reset register*/

                struct
                {
                    __IOM uint32_t BS0 : 1;  /*!< [0..0] BS0   */
                    __IOM uint32_t BS1 : 1;  /*!< [1..1] BS1   */
                    __IOM uint32_t BS2 : 1;  /*!< [2..2] BS2   */
                    __IOM uint32_t BS3 : 1;  /*!< [3..3] BS3   */
                    __IOM uint32_t BS4 : 1;  /*!< [4..4] BS4   */
                    __IOM uint32_t BS5 : 1;  /*!< [5..5] BS5   */
                    __IOM uint32_t BS6 : 1;  /*!< [6..6] BS6   */
                    __IOM uint32_t BS7 : 1;  /*!< [7..7] BS7   */
                    __IOM uint32_t BS8 : 1;  /*!< [8..8] BS8   */
                    __IOM uint32_t BS9 : 1;  /*!< [9..9] BS9   */
                    __IOM uint32_t BS10 : 1; /*!< [10..10] BS10*/
                    __IOM uint32_t BS11 : 1; /*!< [11..11] BS11*/
                    __IOM uint32_t BS12 : 1; /*!< [12..12] BS12*/
                    __IOM uint32_t BS13 : 1; /*!< [13..13] BS13*/
                    __IOM uint32_t BS14 : 1; /*!< [14..14] BS14*/
                    __IOM uint32_t BS15 : 1; /*!< [15..15] BS15*/
                    __IOM uint32_t BR0 : 1;  /*!< [16..16] BR0 */
                    __IOM uint32_t BR1 : 1;  /*!< [17..17] BR1 */
                    __IOM uint32_t BR2 : 1;  /*!< [18..18] BR2 */
                    __IOM uint32_t BR3 : 1;  /*!< [19..19] BR3 */
                    __IOM uint32_t BR4 : 1;  /*!< [20..20] BR4 */
                    __IOM uint32_t BR5 : 1;  /*!< [21..21] BR5 */
                    __IOM uint32_t BR6 : 1;  /*!< [22..22] BR6 */
                    __IOM uint32_t BR7 : 1;  /*!< [23..23] BR7 */
                    __IOM uint32_t BR8 : 1;  /*!< [24..24] BR8 */
                    __IOM uint32_t BR9 : 1;  /*!< [25..25] BR9 */
                    __IOM uint32_t BR10 : 1; /*!< [26..26] BR10*/
                    __IOM uint32_t BR11 : 1; /*!< [27..27] BR11*/
                    __IOM uint32_t BR12 : 1; /*!< [28..28] BR12*/
                    __IOM uint32_t BR13 : 1; /*!< [29..29] BR13*/
                    __IOM uint32_t BR14 : 1; /*!< [30..30] BR14*/
                    __IOM uint32_t BR15 : 1; /*!< [31..31] BR15*/
                } DR_BSRR_b;
            };

            union
            {
                __IM uint32_t DR; /*!< (@ 0x00000030) return GPIO port driving strength when read */

                struct
                {
                    __IM uint32_t DR0 : 1;  /*!< [0..0] DR0   */
                    __IM uint32_t DR1 : 1;  /*!< [1..1] DR1   */
                    __IM uint32_t DR2 : 1;  /*!< [2..2] DR2   */
                    __IM uint32_t DR3 : 1;  /*!< [3..3] DR3   */
                    __IM uint32_t DR4 : 1;  /*!< [4..4] DR4   */
                    __IM uint32_t DR5 : 1;  /*!< [5..5] DR5   */
                    __IM uint32_t DR6 : 1;  /*!< [6..6] DR6   */
                    __IM uint32_t DR7 : 1;  /*!< [7..7] DR7   */
                    __IM uint32_t DR8 : 1;  /*!< [8..8] DR8   */
                    __IM uint32_t DR9 : 1;  /*!< [9..9] DR9   */
                    __IM uint32_t DR10 : 1; /*!< [10..10] DR10*/
                    __IM uint32_t DR11 : 1; /*!< [11..11] DR11*/
                    __IM uint32_t DR12 : 1; /*!< [12..12] DR12*/
                    __IM uint32_t DR13 : 1; /*!< [13..13] DR13*/
                    __IM uint32_t DR14 : 1; /*!< [14..14] DR14*/
                    __IM uint32_t DR15 : 1; /*!< [15..15] DR15*/
                } DR_b;
            };
        };

        union
        {
            union
            {
                __IOM uint32_t CS_BSRR; /*!< (@ 0x00000034) GPIO port cmos/schmitt bit set/reset register    */

                struct
                {
                    __IOM uint32_t BS0 : 1;  /*!< [0..0] BS0   */
                    __IOM uint32_t BS1 : 1;  /*!< [1..1] BS1   */
                    __IOM uint32_t BS2 : 1;  /*!< [2..2] BS2   */
                    __IOM uint32_t BS3 : 1;  /*!< [3..3] BS3   */
                    __IOM uint32_t BS4 : 1;  /*!< [4..4] BS4   */
                    __IOM uint32_t BS5 : 1;  /*!< [5..5] BS5   */
                    __IOM uint32_t BS6 : 1;  /*!< [6..6] BS6   */
                    __IOM uint32_t BS7 : 1;  /*!< [7..7] BS7   */
                    __IOM uint32_t BS8 : 1;  /*!< [8..8] BS8   */
                    __IOM uint32_t BS9 : 1;  /*!< [9..9] BS9   */
                    __IOM uint32_t BS10 : 1; /*!< [10..10] BS10*/
                    __IOM uint32_t BS11 : 1; /*!< [11..11] BS11*/
                    __IOM uint32_t BS12 : 1; /*!< [12..12] BS12*/
                    __IOM uint32_t BS13 : 1; /*!< [13..13] BS13*/
                    __IOM uint32_t BS14 : 1; /*!< [14..14] BS14*/
                    __IOM uint32_t BS15 : 1; /*!< [15..15] BS15*/
                    __IOM uint32_t BR0 : 1;  /*!< [16..16] BR0 */
                    __IOM uint32_t BR1 : 1;  /*!< [17..17] BR1 */
                    __IOM uint32_t BR2 : 1;  /*!< [18..18] BR2 */
                    __IOM uint32_t BR3 : 1;  /*!< [19..19] BR3 */
                    __IOM uint32_t BR4 : 1;  /*!< [20..20] BR4 */
                    __IOM uint32_t BR5 : 1;  /*!< [21..21] BR5 */
                    __IOM uint32_t BR6 : 1;  /*!< [22..22] BR6 */
                    __IOM uint32_t BR7 : 1;  /*!< [23..23] BR7 */
                    __IOM uint32_t BR8 : 1;  /*!< [24..24] BR8 */
                    __IOM uint32_t BR9 : 1;  /*!< [25..25] BR9 */
                    __IOM uint32_t BR10 : 1; /*!< [26..26] BR10*/
                    __IOM uint32_t BR11 : 1; /*!< [27..27] BR11*/
                    __IOM uint32_t BR12 : 1; /*!< [28..28] BR12*/
                    __IOM uint32_t BR13 : 1; /*!< [29..29] BR13*/
                    __IOM uint32_t BR14 : 1; /*!< [30..30] BR14*/
                    __IOM uint32_t BR15 : 1; /*!< [31..31] BR15*/
                } CS_BSRR_b;
            };

            union
            {
                __IM uint32_t CS; /*!< (@ 0x00000034) return GPIO port cmos/schmitt when read   */

                struct
                {
                    __IM uint32_t CS0 : 1;  /*!< [0..0] CS0   */
                    __IM uint32_t CS1 : 1;  /*!< [1..1] CS1   */
                    __IM uint32_t CS2 : 1;  /*!< [2..2] CS2   */
                    __IM uint32_t CS3 : 1;  /*!< [3..3] CS3   */
                    __IM uint32_t CS4 : 1;  /*!< [4..4] CS4   */
                    __IM uint32_t CS5 : 1;  /*!< [5..5] CS5   */
                    __IM uint32_t CS6 : 1;  /*!< [6..6] CS6   */
                    __IM uint32_t CS7 : 1;  /*!< [7..7] CS7   */
                    __IM uint32_t CS8 : 1;  /*!< [8..8] CS8   */
                    __IM uint32_t CS9 : 1;  /*!< [9..9] CS9   */
                    __IM uint32_t CS10 : 1; /*!< [10..10] CS10*/
                    __IM uint32_t CS11 : 1; /*!< [11..11] CS11*/
                    __IM uint32_t CS12 : 1; /*!< [12..12] CS12*/
                    __IM uint32_t CS13 : 1; /*!< [13..13] CS13*/
                    __IM uint32_t CS14 : 1; /*!< [14..14] CS14*/
                    __IM uint32_t CS15 : 1; /*!< [15..15] CS15*/
                } CS_b;
            };
        };

        union
        {
            union
            {
                __IOM uint32_t OS_BSRR; /*!< (@ 0x00000038) GPIO port open source bit set/reset register*/

                struct
                {
                    __IOM uint32_t BS0 : 1;  /*!< [0..0] BS0   */
                    __IOM uint32_t BS1 : 1;  /*!< [1..1] BS1   */
                    __IOM uint32_t BS2 : 1;  /*!< [2..2] BS2   */
                    __IOM uint32_t BS3 : 1;  /*!< [3..3] BS3   */
                    __IOM uint32_t BS4 : 1;  /*!< [4..4] BS4   */
                    __IOM uint32_t BS5 : 1;  /*!< [5..5] BS5   */
                    __IOM uint32_t BS6 : 1;  /*!< [6..6] BS6   */
                    __IOM uint32_t BS7 : 1;  /*!< [7..7] BS7   */
                    __IOM uint32_t BS8 : 1;  /*!< [8..8] BS8   */
                    __IOM uint32_t BS9 : 1;  /*!< [9..9] BS9   */
                    __IOM uint32_t BS10 : 1; /*!< [10..10] BS10*/
                    __IOM uint32_t BS11 : 1; /*!< [11..11] BS11*/
                    __IOM uint32_t BS12 : 1; /*!< [12..12] BS12*/
                    __IOM uint32_t BS13 : 1; /*!< [13..13] BS13*/
                    __IOM uint32_t BS14 : 1; /*!< [14..14] BS14*/
                    __IOM uint32_t BS15 : 1; /*!< [15..15] BS15*/
                    __IOM uint32_t BR0 : 1;  /*!< [16..16] BR0 */
                    __IOM uint32_t BR1 : 1;  /*!< [17..17] BR1 */
                    __IOM uint32_t BR2 : 1;  /*!< [18..18] BR2 */
                    __IOM uint32_t BR3 : 1;  /*!< [19..19] BR3 */
                    __IOM uint32_t BR4 : 1;  /*!< [20..20] BR4 */
                    __IOM uint32_t BR5 : 1;  /*!< [21..21] BR5 */
                    __IOM uint32_t BR6 : 1;  /*!< [22..22] BR6 */
                    __IOM uint32_t BR7 : 1;  /*!< [23..23] BR7 */
                    __IOM uint32_t BR8 : 1;  /*!< [24..24] BR8 */
                    __IOM uint32_t BR9 : 1;  /*!< [25..25] BR9 */
                    __IOM uint32_t BR10 : 1; /*!< [26..26] BR10*/
                    __IOM uint32_t BR11 : 1; /*!< [27..27] BR11*/
                    __IOM uint32_t BR12 : 1; /*!< [28..28] BR12*/
                    __IOM uint32_t BR13 : 1; /*!< [29..29] BR13*/
                    __IOM uint32_t BR14 : 1; /*!< [30..30] BR14*/
                    __IOM uint32_t BR15 : 1; /*!< [31..31] BR15*/
                } OS_BSRR_b;
            };

            union
            {
                __IM uint32_t OS; /*!< (@ 0x00000038) return GPIO port open source when read    */

                struct
                {
                    __IM uint32_t OS0 : 1;  /*!< [0..0] OS0   */
                    __IM uint32_t OS1 : 1;  /*!< [1..1] OS1   */
                    __IM uint32_t OS2 : 1;  /*!< [2..2] OS2   */
                    __IM uint32_t OS3 : 1;  /*!< [3..3] OS3   */
                    __IM uint32_t OS4 : 1;  /*!< [4..4] OS4   */
                    __IM uint32_t OS5 : 1;  /*!< [5..5] OS5   */
                    __IM uint32_t OS6 : 1;  /*!< [6..6] OS6   */
                    __IM uint32_t OS7 : 1;  /*!< [7..7] OS7   */
                    __IM uint32_t OS8 : 1;  /*!< [8..8] OS8   */
                    __IM uint32_t OS9 : 1;  /*!< [9..9] OS9   */
                    __IM uint32_t OS10 : 1; /*!< [10..10] OS10*/
                    __IM uint32_t OS11 : 1; /*!< [11..11] OS11*/
                    __IM uint32_t OS12 : 1; /*!< [12..12] OS12*/
                    __IM uint32_t OS13 : 1; /*!< [13..13] OS13*/
                    __IM uint32_t OS14 : 1; /*!< [14..14] OS14*/
                    __IM uint32_t OS15 : 1; /*!< [15..15] OS15*/
                } OS_b;
            };
        };
    } GPIO_TypeDef; /*!< Size = 60 (0x3c)    */

    /* =========================================================================================================================== */
    /* ================    EXTI================ */
    /* =========================================================================================================================== */

    /**
     * @brief exti (EXTI)
     */

    typedef struct
    { /*!< (@ 0x40011000) EXTI Structure */

        union
        {
            __IOM uint32_t IMR; /*!< (@ 0x00000000) EXTI interrupt mask register    */

            struct
            {
                __IOM uint32_t IM0 : 1;  /*!< [0..0] Interrupt mask on external/internal line x   */
                __IOM uint32_t IM1 : 1;  /*!< [1..1] Interrupt mask on external/internal line x   */
                __IOM uint32_t IM2 : 1;  /*!< [2..2] Interrupt mask on external/internal line x   */
                __IOM uint32_t IM3 : 1;  /*!< [3..3] Interrupt mask on external/internal line x   */
                __IOM uint32_t IM4 : 1;  /*!< [4..4] Interrupt mask on external/internal line x   */
                __IOM uint32_t IM5 : 1;  /*!< [5..5] Interrupt mask on external/internal line x   */
                __IOM uint32_t IM6 : 1;  /*!< [6..6] Interrupt mask on external/internal line x   */
                __IOM uint32_t IM7 : 1;  /*!< [7..7] Interrupt mask on external/internal line x   */
                __IOM uint32_t IM8 : 1;  /*!< [8..8] Interrupt mask on external/internal line x   */
                __IOM uint32_t IM9 : 1;  /*!< [9..9] Interrupt mask on external/internal line x   */
                __IOM uint32_t IM10 : 1; /*!< [10..10] Interrupt mask on external/internal line x */
                __IOM uint32_t IM11 : 1; /*!< [11..11] Interrupt mask on external/internal line x */
                __IOM uint32_t IM12 : 1; /*!< [12..12] Interrupt mask on external/internal line x */
                __IOM uint32_t IM13 : 1; /*!< [13..13] Interrupt mask on external/internal line x */
                __IOM uint32_t IM14 : 1; /*!< [14..14] Interrupt mask on external/internal line x */
                __IOM uint32_t IM15 : 1; /*!< [15..15] Interrupt mask on external/internal line x */
                __IOM uint32_t IM16 : 1; /*!< [16..16] Interrupt mask on external/internal line x */
                __IOM uint32_t IM17 : 1; /*!< [17..17] Interrupt mask on external/internal line x */
                __IOM uint32_t IM18 : 1; /*!< [18..18] Interrupt mask on external/internal line x */
                __IOM uint32_t IM19 : 1; /*!< [19..19] Interrupt mask on external/internal line x */
                __IOM uint32_t IM20 : 1; /*!< [20..20] Interrupt mask on external/internal line x */
                __IOM uint32_t IM21 : 1; /*!< [21..21] Interrupt mask on external/internal line x */
                __IOM uint32_t IM22 : 1; /*!< [22..22] Interrupt mask on external/internal line x */
                __IOM uint32_t IM23 : 1; /*!< [23..23] Interrupt mask on external/internal line x */
            } IMR_b;
        };

        union
        {
            __IOM uint32_t EMR; /*!< (@ 0x00000004) EXTI event mask register */

            struct
            {
                __IOM uint32_t EM0 : 1;  /*!< [0..0] Event mask on external/internal line x  */
                __IOM uint32_t EM1 : 1;  /*!< [1..1] Event mask on external/internal line x  */
                __IOM uint32_t EM2 : 1;  /*!< [2..2] Event mask on external/internal line x  */
                __IOM uint32_t EM3 : 1;  /*!< [3..3] Event mask on external/internal line x  */
                __IOM uint32_t EM4 : 1;  /*!< [4..4] Event mask on external/internal line x  */
                __IOM uint32_t EM5 : 1;  /*!< [5..5] Event mask on external/internal line x  */
                __IOM uint32_t EM6 : 1;  /*!< [6..6] Event mask on external/internal line x  */
                __IOM uint32_t EM7 : 1;  /*!< [7..7] Event mask on external/internal line x  */
                __IOM uint32_t EM8 : 1;  /*!< [8..8] Event mask on external/internal line x  */
                __IOM uint32_t EM9 : 1;  /*!< [9..9] Event mask on external/internal line x  */
                __IOM uint32_t EM10 : 1; /*!< [10..10] Event mask on external/internal line x*/
                __IOM uint32_t EM11 : 1; /*!< [11..11] Event mask on external/internal line x*/
                __IOM uint32_t EM12 : 1; /*!< [12..12] Event mask on external/internal line x*/
                __IOM uint32_t EM13 : 1; /*!< [13..13] Event mask on external/internal line x*/
                __IOM uint32_t EM14 : 1; /*!< [14..14] Event mask on external/internal line x*/
                __IOM uint32_t EM15 : 1; /*!< [15..15] Event mask on external/internal line x*/
                __IOM uint32_t EM16 : 1; /*!< [16..16] Event mask on external/internal line x*/
                __IOM uint32_t EM17 : 1; /*!< [17..17] Event mask on external/internal line x*/
                __IOM uint32_t EM18 : 1; /*!< [18..18] Event mask on external/internal line x*/
                __IOM uint32_t EM19 : 1; /*!< [19..19] Event mask on external/internal line x*/
                __IOM uint32_t EM20 : 1; /*!< [20..20] Event mask on external/internal line x*/
                __IOM uint32_t EM21 : 1; /*!< [21..21] Event mask on external/internal line x*/
                __IOM uint32_t EM22 : 1; /*!< [22..22] Event mask on external/internal line x*/
                __IOM uint32_t EM23 : 1; /*!< [23..23] Event mask on external/internal line x*/
            } EMR_b;
        };

        union
        {
            __IOM uint32_t RTSR; /*!< (@ 0x00000008) RTSR */

            struct
            {
                __IOM uint32_t RT0 : 1;  /*!< [0..0] RT0 */
                __IOM uint32_t RT1 : 1;  /*!< [1..1] RT1 */
                __IOM uint32_t RT2 : 1;  /*!< [2..2] RT2 */
                __IOM uint32_t RT3 : 1;  /*!< [3..3] RT3 */
                __IOM uint32_t RT4 : 1;  /*!< [4..4] RT4 */
                __IOM uint32_t RT5 : 1;  /*!< [5..5] RT5 */
                __IOM uint32_t RT6 : 1;  /*!< [6..6] RT6 */
                __IOM uint32_t RT7 : 1;  /*!< [7..7] RT7 */
                __IOM uint32_t RT8 : 1;  /*!< [8..8] RT8 */
                __IOM uint32_t RT9 : 1;  /*!< [9..9] RT9 */
                __IOM uint32_t RT10 : 1; /*!< [10..10] RT10 */
                __IOM uint32_t RT11 : 1; /*!< [11..11] RT11 */
                __IOM uint32_t RT12 : 1; /*!< [12..12] RT12 */
                __IOM uint32_t RT13 : 1; /*!< [13..13] RT13 */
                __IOM uint32_t RT14 : 1; /*!< [14..14] RT14 */
                __IOM uint32_t RT15 : 1; /*!< [15..15] RT15 */
                __IOM uint32_t RT16 : 1; /*!< [16..16] RT16 */
                __IOM uint32_t RT17 : 1; /*!< [17..17] RT17 */
                __IOM uint32_t RT18 : 1; /*!< [18..18] RT18 */
                __IOM uint32_t RT19 : 1; /*!< [19..19] RT19 */
                __IOM uint32_t RT20 : 1; /*!< [20..20] RT20 */
                __IOM uint32_t RT21 : 1; /*!< [21..21] RT21 */
                __IOM uint32_t RT22 : 1; /*!< [22..22] RT22 */
                __IOM uint32_t RT23 : 1; /*!< [23..23] RT23 */
            } RTSR_b;
        };

        union
        {
            __IOM uint32_t FTSR; /*!< (@ 0x0000000C) FTSR */

            struct
            {
                __IOM uint32_t FT0 : 1;  /*!< [0..0] FT0 */
                __IOM uint32_t FT1 : 1;  /*!< [1..1] FT1 */
                __IOM uint32_t FT2 : 1;  /*!< [2..2] FT2 */
                __IOM uint32_t FT3 : 1;  /*!< [3..3] FT3 */
                __IOM uint32_t FT4 : 1;  /*!< [4..4] FT4 */
                __IOM uint32_t FT5 : 1;  /*!< [5..5] FT5 */
                __IOM uint32_t FT6 : 1;  /*!< [6..6] FT6 */
                __IOM uint32_t FT7 : 1;  /*!< [7..7] FT7 */
                __IOM uint32_t FT8 : 1;  /*!< [8..8] FT8 */
                __IOM uint32_t FT9 : 1;  /*!< [9..9] FT9 */
                __IOM uint32_t FT10 : 1; /*!< [10..10] FT10 */
                __IOM uint32_t FT11 : 1; /*!< [11..11] FT11 */
                __IOM uint32_t FT12 : 1; /*!< [12..12] FT12 */
                __IOM uint32_t FT13 : 1; /*!< [13..13] FT13 */
                __IOM uint32_t FT14 : 1; /*!< [14..14] FT14 */
                __IOM uint32_t FT15 : 1; /*!< [15..15] FT15 */
                __IOM uint32_t FT16 : 1; /*!< [16..16] FT16 */
                __IOM uint32_t FT17 : 1; /*!< [17..17] FT17 */
                __IOM uint32_t FT18 : 1; /*!< [18..18] FT18 */
                __IOM uint32_t FT19 : 1; /*!< [19..19] FT19 */
                __IOM uint32_t FT20 : 1; /*!< [20..20] FT20 */
                __IOM uint32_t FT21 : 1; /*!< [21..21] FT21 */
                __IOM uint32_t FT22 : 1; /*!< [22..22] FT22 */
                __IOM uint32_t FT23 : 1; /*!< [23..23] FT23 */
            } FTSR_b;
        };

        union
        {
            __IOM uint32_t SWIER; /*!< (@ 0x00000010) SWIER */

            struct
            {
                __IOM uint32_t SWIER0 : 1;  /*!< [0..0] SWIER0 */
                __IOM uint32_t SWIER1 : 1;  /*!< [1..1] SWIER1 */
                __IOM uint32_t SWIER2 : 1;  /*!< [2..2] SWIER2 */
                __IOM uint32_t SWIER3 : 1;  /*!< [3..3] SWIER3 */
                __IOM uint32_t SWIER4 : 1;  /*!< [4..4] SWIER4 */
                __IOM uint32_t SWIER5 : 1;  /*!< [5..5] SWIER5 */
                __IOM uint32_t SWIER6 : 1;  /*!< [6..6] SWIER6 */
                __IOM uint32_t SWIER7 : 1;  /*!< [7..7] SWIER7 */
                __IOM uint32_t SWIER8 : 1;  /*!< [8..8] SWIER8 */
                __IOM uint32_t SWIER9 : 1;  /*!< [9..9] SWIER9 */
                __IOM uint32_t SWIER10 : 1; /*!< [10..10] SWIER10 */
                __IOM uint32_t SWIER11 : 1; /*!< [11..11] SWIER11 */
                __IOM uint32_t SWIER12 : 1; /*!< [12..12] SWIER12 */
                __IOM uint32_t SWIER13 : 1; /*!< [13..13] SWIER13 */
                __IOM uint32_t SWIER14 : 1; /*!< [14..14] SWIER14 */
                __IOM uint32_t SWIER15 : 1; /*!< [15..15] SWIER15 */
                __IOM uint32_t SWIER16 : 1; /*!< [16..16] SWIER16 */
                __IOM uint32_t SWIER17 : 1; /*!< [17..17] SWIER17 */
                __IOM uint32_t SWIER18 : 1; /*!< [18..18] SWIER18 */
                __IOM uint32_t SWIER19 : 1; /*!< [19..19] SWIER19 */
                __IOM uint32_t SWIER20 : 1; /*!< [20..20] SWIER20 */
                __IOM uint32_t SWIER21 : 1; /*!< [21..21] SWIER21 */
                __IOM uint32_t SWIER22 : 1; /*!< [22..22] SWIER22 */
                __IOM uint32_t SWIER23 : 1; /*!< [23..23] SWIER23 */
            } SWIER_b;
        };

        union
        {
            __IOM uint32_t PR; /*!< (@ 0x00000014) PR */

            struct
            {
                __IOM uint32_t PR0 : 1;  /*!< [0..0] PR0 */
                __IOM uint32_t PR1 : 1;  /*!< [1..1] PR1 */
                __IOM uint32_t PR2 : 1;  /*!< [2..2] PR2 */
                __IOM uint32_t PR3 : 1;  /*!< [3..3] PR3 */
                __IOM uint32_t PR4 : 1;  /*!< [4..4] PR4 */
                __IOM uint32_t PR5 : 1;  /*!< [5..5] PR5 */
                __IOM uint32_t PR6 : 1;  /*!< [6..6] PR6 */
                __IOM uint32_t PR7 : 1;  /*!< [7..7] PR7 */
                __IOM uint32_t PR8 : 1;  /*!< [8..8] PR8 */
                __IOM uint32_t PR9 : 1;  /*!< [9..9] PR9 */
                __IOM uint32_t PR10 : 1; /*!< [10..10] PR10 */
                __IOM uint32_t PR11 : 1; /*!< [11..11] PR11 */
                __IOM uint32_t PR12 : 1; /*!< [12..12] PR12 */
                __IOM uint32_t PR13 : 1; /*!< [13..13] PR13 */
                __IOM uint32_t PR14 : 1; /*!< [14..14] PR14 */
                __IOM uint32_t PR15 : 1; /*!< [15..15] PR15 */
                __IOM uint32_t PR16 : 1; /*!< [16..16] PR16 */
                __IOM uint32_t PR17 : 1; /*!< [17..17] PR17 */
                __IOM uint32_t PR18 : 1; /*!< [18..18] PR18 */
                __IOM uint32_t PR19 : 1; /*!< [19..19] PR19 */
                __IOM uint32_t PR20 : 1; /*!< [20..20] PR20 */
                __IOM uint32_t PR21 : 1; /*!< [21..21] PR21 */
                __IOM uint32_t PR22 : 1; /*!< [22..22] PR22 */
                __IOM uint32_t PR23 : 1; /*!< [23..23] PR23 */
            } PR_b;
        };

        union
        {
            __IOM uint32_t FR; /*!< (@ 0x00000018) FR */

            struct
            {
                __IOM uint32_t FR0 : 2;  /*!< [1..0] FR0 */
                __IOM uint32_t FR1 : 2;  /*!< [3..2] FR1 */
                __IOM uint32_t FR2 : 2;  /*!< [5..4] FR2 */
                __IOM uint32_t FR3 : 2;  /*!< [7..6] FR3 */
                __IOM uint32_t FR4 : 2;  /*!< [9..8] FR4 */
                __IOM uint32_t FR5 : 2;  /*!< [11..10] FR5 */
                __IOM uint32_t FR6 : 2;  /*!< [13..12] FR6 */
                __IOM uint32_t FR7 : 2;  /*!< [15..14] FR7 */
                __IOM uint32_t FR8 : 2;  /*!< [17..16] FR8 */
                __IOM uint32_t FR9 : 2;  /*!< [19..18] FR9 */
                __IOM uint32_t FR10 : 2; /*!< [21..20] FR10 */
                __IOM uint32_t FR11 : 2; /*!< [23..22] FR11 */
                __IOM uint32_t FR12 : 2; /*!< [25..24] FR12 */
                __IOM uint32_t FR13 : 2; /*!< [27..26] FR13 */
                __IOM uint32_t FR14 : 2; /*!< [29..28] FR14 */
                __IOM uint32_t FR15 : 2; /*!< [31..30] FR15 */
            } FR_b;
        };

        union
        {
            __IOM uint32_t CR; /*!< (@ 0x0000001C) CR   */

            struct
            {
                __IOM uint32_t LR0 : 1;  /*!< [0..0] LR0 */
                __IOM uint32_t LR1 : 1;  /*!< [1..1] LR1 */
                __IOM uint32_t LR2 : 1;  /*!< [2..2] LR2 */
                __IOM uint32_t LR3 : 1;  /*!< [3..3] LR3 */
                __IOM uint32_t LR4 : 1;  /*!< [4..4] LR4 */
                __IOM uint32_t LR5 : 1;  /*!< [5..5] LR5 */
                __IOM uint32_t LR6 : 1;  /*!< [6..6] LR6 */
                __IOM uint32_t LR7 : 1;  /*!< [7..7] LR7 */
                __IOM uint32_t LR8 : 1;  /*!< [8..8] LR8 */
                __IOM uint32_t LR9 : 1;  /*!< [9..9] LR9 */
                __IOM uint32_t LR10 : 1; /*!< [10..10] LR10 */
                __IOM uint32_t LR11 : 1; /*!< [11..11] LR11 */
                __IOM uint32_t LR12 : 1; /*!< [12..12] LR12 */
                __IOM uint32_t LR13 : 1; /*!< [13..13] LR13 */
                __IOM uint32_t LR14 : 1; /*!< [14..14] LR14 */
                __IOM uint32_t LR15 : 1; /*!< [15..15] LR15 */
                __IOM uint32_t LR16 : 1; /*!< [16..16] LR16 */
                __IOM uint32_t LR17 : 1; /*!< [17..17] LR17 */
                __IOM uint32_t LR18 : 1; /*!< [18..18] LR18 */
                __IOM uint32_t LR19 : 1; /*!< [19..19] LR19 */
                __IOM uint32_t LR20 : 1; /*!< [20..20] LR20 */
                __IOM uint32_t LR21 : 1; /*!< [21..21] LR21 */
                __IOM uint32_t LR22 : 1; /*!< [22..22] LR19 */
                __IOM uint32_t LR23 : 1; /*!< [23..23] LR20 */
                __IM uint32_t : 4;
                __IOM uint32_t PSC : 3; /*!< [30..28] PSC */
            } CR_b;
        };
    } EXTI_TypeDef; /*!< Size = 32 (0x20)    */

    /* =========================================================================================================================== */
    /* ================   ANACTRL   ================ */
    /* =========================================================================================================================== */

    /**
     * @brief Analog system controler. (ANACTRL)
     */

    typedef struct
    { /*!< (@ 0x40017C00) ANACTRL Structure   */

        union
        {
            __IOM uint32_t OPA0_CSR; /*!< (@ 0x00000000) OPA0_CSR  */

            struct
            {
                __IOM uint32_t OP0EN : 1;     /*!< [0..0] OP0EN */
                __IOM uint32_t OP0NRS : 1;    /*!< [1..1] OP0NRS */
                __IOM uint32_t OP0PRS : 1;    /*!< [2..2] OP0PRS */
                __IM uint32_t : 1;
                __IOM uint32_t OP0NS : 1;     /*!< [4..4] OP0NS */
                __IOM uint32_t OP0PS : 1;     /*!< [5..5] OP0PS */
                __IOM uint32_t VM_SEL : 1;    /*!< [6..6] VM_SEL */
                __IM uint32_t : 1;
                __IOM uint32_t OP0GS : 3;     /*!< [10..8] OP0GS */
                __IOM uint32_t ADC_N_EN : 1;  /*!< [11..11] ADC_N_EN */
                __IOM uint32_t ADC_P_EN : 1;  /*!< [12..12] ADC_P_EN */
                __IOM uint32_t OP0RIN : 1;    /*!< [13..13] OP0RIN */
                __IOM uint32_t OP0RFB : 1;    /*!< [14..14] OP0RFB */
                __IM uint32_t : 1;
                __IOM uint32_t OP0OS : 5;     /*!< [20..16] OP0OS */
                __IM uint32_t : 3;
                __IOM uint32_t OP0NSEL : 1;   /*!< [24..24] OP0NSEL */
                __IM uint32_t : 1;
                __IOM uint32_t OP0PSEL : 1;   /*!< [26..26] OP0PSEL */
                __IM uint32_t : 1;
                __IOM uint32_t OP0N_PD : 1;   /*!< [28..28] OP0N_PD */
                __IOM uint32_t OP0P_PD : 1;   /*!< [29..29] OP0P_PD */
                __IOM uint32_t OP0TRIMEN : 1; /*!< [30..30] OP0TRIMEN */
                __IM uint32_t OP0TRIMO : 1;   /*!< [31..31] OP0TRIMO */
            } OPA0_CSR_b;
        };

        union
        {
            __IOM uint32_t OPA1_CSR; /*!< (@ 0x00000004) OPA1_CSR */

            struct
            {
                __IOM uint32_t OP1EN : 1;     /*!< [0..0] OP1EN */
                __IOM uint32_t OP1NRS : 1;    /*!< [1..1] OP1NRS */
                __IOM uint32_t OP1PRS : 1;    /*!< [2..2] OP1PRS */
                __IM uint32_t : 1;
                __IOM uint32_t OP1NS : 1;     /*!< [4..4] OP1NS */
                __IOM uint32_t OP1PS : 1;     /*!< [5..5] OP1PS */
                __IOM uint32_t VM_SEL : 1;    /*!< [6..6] VM_SEL */
                __IM uint32_t : 1;
                __IOM uint32_t OP1GS : 3;     /*!< [10..8] OP1GS */
                __IOM uint32_t ADC_N_EN : 1;  /*!< [11..11] ADC_N_EN */
                __IOM uint32_t ADC_P_EN : 1;  /*!< [12..12] ADC_P_EN */
                __IOM uint32_t OP1RIN : 1;    /*!< [13..13] OP1RIN */
                __IOM uint32_t OP1RFB : 1;    /*!< [14..14] OP1RFB */
                __IM uint32_t : 1;
                __IOM uint32_t OP1OS : 5;     /*!< [20..16] OP1OS */
                __IM uint32_t : 3;
                __IOM uint32_t OP1NSEL : 1;   /*!< [24..24] OP1NSEL */
                __IM uint32_t : 1;
                __IOM uint32_t OP1PSEL : 1;   /*!< [26..26] OP1PSEL */
                __IM uint32_t : 1;
                __IOM uint32_t OP1N_PD : 1;   /*!< [28..28] OP1N_PD */
                __IOM uint32_t OP1P_PD : 1;   /*!< [29..29] OP1P_PD */
                __IOM uint32_t OP1TRIMEN : 1; /*!< [30..30] OP1TRIMEN */
                __IM uint32_t OP1TRIMO : 1;   /*!< [31..31] OP1TRIMO */
            } OPA1_CSR_b;
        };

        union
        {
            __IOM uint32_t OPA2_CSR; /*!< (@ 0x00000008) OPA2_CSR  */

            struct
            {
                __IOM uint32_t OP2EN : 1;     /*!< [0..0] OP2EN */
                __IOM uint32_t OP2NRS : 1;    /*!< [1..1] OP2NRS */
                __IOM uint32_t OP2PRS : 1;    /*!< [2..2] OP2PRS */
                __IM uint32_t : 1;
                __IOM uint32_t OP2NS : 1;     /*!< [4..4] OP2NS */
                __IOM uint32_t OP2PS : 1;     /*!< [5..5] OP2PS */
                __IOM uint32_t VM_SEL : 1;    /*!< [6..6] VM_SEL */
                __IM uint32_t : 1;
                __IOM uint32_t OP2GS : 3;     /*!< [10..8] OP2GS */
                __IOM uint32_t ADC_N_EN : 1;  /*!< [11..11] ADC_N_EN */
                __IOM uint32_t ADC_P_EN : 1;  /*!< [12..12] ADC_P_EN */
                __IOM uint32_t OP2RIN : 1;    /*!< [13..13] OP2RIN */
                __IOM uint32_t OP2RFB : 1;    /*!< [14..14] OP2RFB */
                __IM uint32_t : 1;
                __IOM uint32_t OP2OS : 5;     /*!< [20..16] OP2OS */
                __IM uint32_t : 3;
                __IOM uint32_t OP2NSEL : 1;   /*!< [24..24] OP2NSEL */
                __IM uint32_t : 1;
                __IOM uint32_t OP2PSEL : 1;   /*!< [26..26] OP2PSEL */
                __IM uint32_t : 1;
                __IOM uint32_t OP2N_PD : 1;   /*!< [28..28] OP2N_PD */
                __IOM uint32_t OP2P_PD : 1;   /*!< [29..29] OP2P_PD */
                __IOM uint32_t OP2TRIMEN : 1; /*!< [30..30] OP2TRIMEN */
                __IM uint32_t OP2TRIMO : 1;   /*!< [31..31] OP2TRIMO */
            } OPA2_CSR_b;
        };

        __IM uint32_t RESERVED[5];

        union
        {
            __IOM uint32_t ACMP0_CSR; /*!< (@ 0x00000020) ACMP0_CSR */

            struct
            {
                __IOM uint32_t CP_EN : 1;      /*!< [0..0] CP_EN */
                __IOM uint32_t CP_FREN : 1;    /*!< [1..1] CP_FREN */
                __IOM uint32_t CP_HYSEN : 1;   /*!< [2..2] CP_HYSEN */
                __IOM uint32_t CP_IS : 1;      /*!< [3..3] CP_IS */
                __IM uint32_t : 5;
                __IOM uint32_t CP_DLY : 2;     /*!< [10..9] CP_DLY */
                __IOM uint32_t CP_FS : 1;      /*!< [11..11] CP_FS */
                __IM uint32_t : 3;
                __IOM uint32_t CP_LPS : 1;     /*!< [15..15] CP_LPS */
                __IOM uint32_t CP_PF : 5;      /*!< [20..16] CP_PF */
                __IOM uint32_t MISS_TRIG : 1;  /*!< [21..21] MISS_TRIG */
                __IM uint32_t : 1;
                __IOM uint32_t FILTER_SEL : 5; /*!< [27..23] FILTER_SEL */
                __IM uint32_t CP_OUT_SYNC : 1; /*!< [28..28] CP_OUT_SYNC */
            } ACMP0_CSR_b;
        };
        union
        {
            __IOM uint32_t ACMP1_CSR; /*!< (@ 0x00000024) ACMP1_CSR */

            struct
            {
                __IOM uint32_t CP_EN : 1;      /*!< [0..0] CP_EN */
                __IOM uint32_t CP_FREN : 1;    /*!< [1..1] CP_FREN */
                __IOM uint32_t CP_HYSEN : 1;   /*!< [2..2] CP_HYSEN */
                __IOM uint32_t CP_IS : 1;      /*!< [3..3] CP_IS */
                __IM uint32_t : 5;
                __IOM uint32_t CP_DLY : 2;     /*!< [10..9] CP_DLY */
                __IOM uint32_t CP_FS : 1;      /*!< [11..11] CP_FS */
                __IM uint32_t : 3;
                __IOM uint32_t CP_LPS : 1;     /*!< [15..15] CP_LPS */
                __IOM uint32_t CP_PF : 5;      /*!< [20..16] CP_PF */
                __IOM uint32_t MISS_TRIG : 1;  /*!< [21..21] MISS_TRIG */
                __IM uint32_t : 1;
                __IOM uint32_t FILTER_SEL : 5; /*!< [27..23] FILTER_SEL */
                __IM uint32_t CP_OUT_SYNC : 1; /*!< [28..28] CP_OUT_SYNC */
            } ACMP1_CSR_b;
        };

        __IM uint32_t RESERVED1[6];

        union
        {
            __IOM uint32_t DAC_CR; /*!< (@ 0x00000040) DAC0_CR */

            struct
            {
                __IOM uint32_t EN : 1; /*!< [0..0] EN    */
                __IOM uint32_t : 5;
                __IOM uint32_t WAVE : 2;     /*!< [7..6] WAVE */
                __IOM uint32_t MAMP : 4;     /*!< [11..8] MAMP */
                __IOM uint32_t DMAEN : 1;    /*!< [12..12] DMAEN */
                __IOM uint32_t DMAUDRIE : 1; /*!< [13..13] DMAUDRIE */
                __IOM uint32_t VREF_SEL : 1; /*!< [14..14] VREF_SEL */
                __IOM uint32_t ALIGN : 1;    /*!< [15..15] ALIGN */
            } DAC_CR_b;
        };

        union
        {
            __IOM uint32_t DAC_SR; /*!< (@ 0x00000044) DAC0_CSR */

            struct
            {
                __IOM uint32_t SWTRIG : 1; /*!< [0..0] SWTRIG */
                __IM uint32_t : 7;
                __IOM uint32_t DMAUDR : 1; /*!< [8..8] DMAUDR */
            } DAC_SR_b;
        };

        union
        {
            __IOM uint32_t DAC_DHR; /*!< (@ 0x00000048) DAC0_DHR */

            struct
            {
                __IOM uint32_t DHR : 16; /*!< [15..0] DHR */
            } DAC_DHR_b;
        };

        union
        {
            __IM uint32_t DAC_DOR; /*!< (@ 0x0000004C) DAC0_DOR */

            struct
            {
                __IM uint32_t DOR : 16; /*!< [15..0] DOR */
            } DAC_DOR_b;
        };

        __IM uint32_t RESERVED2[28];

        union
        {
            __IOM uint32_t ACMP0_MUXCSR; /*!< (@ 0x000000C0) ACMP0_MUXCR */

            struct
            {
                __IOM uint32_t CMP_SEQ_START : 1;  /*!< [0..0] CMP_SEQ_START */
                __IOM uint32_t CHNL_CNT_CFG : 7;   /*!< [7..1] CHNL_CNT_CFG */
                __IOM uint32_t CPOUT_SEQ : 8;      /*!< [15..8] CPOUT_SEQ */
                __IOM uint32_t ACMP_P_SEL0 : 3;    /*!< [18..16] ACMP_P_SEL0 */
                __IOM uint32_t ACMP_P_SEL1 : 2;    /*!< [20..19] ACMP_P_SEL1 */
                __IM uint32_t : 3;
                __IOM uint32_t ACMP_N_SEL : 3;     /*!< [26..24] ACMP_N_SEL */
                __IOM uint32_t CMP_MODE : 2;       /*!< [28..27] CMP_MODE */
                __IOM uint32_t CMP_INTEN : 1;      /*!< [29..29] CMP_INTEN */
                __IOM uint32_t CMP_INT_FLG : 1;    /*!< [30..30] CMP_INT_FLG */
                __IOM uint32_t TRIG_MODE : 1;      /*!< [31..31] TRIG_MODE */
            } ACMP0_MUXCSR_b;
        };

        union
        {
            __IOM uint32_t ACMP0_EXTCFG; /*!< (@ 0x000000C4) ACMP0_EXTCFG */

            struct
            {
                __IM uint32_t : 4;
                __IOM uint32_t EXTDTG : 8;   /*!< [11..4] EXTDTG */
                __IM uint32_t : 15;
                __IOM uint32_t EXTSE : 2;    /*!< [28..27] EXTSE */
            } ACMP0_EXTCFG_b;
        };

        union
        {
            __IOM uint32_t ACMP1_MUXCSR; /*!< (@ 0x000000C8) ACMP1_MUXCSR */

            struct
            {
                __IOM uint32_t CMP_SEQ_START : 1;  /*!< [0..0] CMP_SEQ_START */
                __IOM uint32_t CHNL_CNT_CFG : 7;   /*!< [7..1] CHNL_CNT_CFG */
                __IOM uint32_t CPOUT_SEQ : 8;      /*!< [15..8] CPOUT_SEQ */
                __IOM uint32_t ACMP_P_SEL0 : 3;    /*!< [18..16] ACMP_P_SEL0 */
                __IOM uint32_t ACMP_P_SEL1 : 2;    /*!< [20..19] ACMP_P_SEL1 */
                __IM uint32_t : 3;
                __IOM uint32_t ACMP_N_SEL : 3;     /*!< [26..24] ACMP_N_SEL */
                __IOM uint32_t CMP_MODE : 2;       /*!< [28..27] CMP_MODE */
                __IOM uint32_t CMP_INTEN : 1;      /*!< [29..29] CMP_INTEN */
                __IOM uint32_t CMP_INT_FLG : 1;    /*!< [30..30] CMP_INT_FLG */
                __IOM uint32_t TRIG_MODE : 1;      /*!< [31..31] TRIG_MODE */
            } ACMP1_MUXCSR_b;
        };

        union
        {
            __IOM uint32_t ACMP1_EXTCFG; /*!< (@ 0x000000CC) ACMP1_EXTCFG */

            struct
            {
                __IM uint32_t : 4;
                __IOM uint32_t EXTDTG : 8;   /*!< [11..4] EXTDTG */
                __IM uint32_t : 15;
                __IOM uint32_t EXTSE : 2;    /*!< [28..27] EXTSE */
            } ACMP1_EXTCFG_b;
        };

        __IM uint32_t RESERVED3[2];

        union
        {
            __IOM uint32_t ACMP0_CHNLSEL; /*!< (@ 0x000000D8) ACMP0_CHNLSEL */

            struct
            {
                __IOM uint32_t CHNLSEL0 : 3;   /*!< [2..0] CHNLSEL0 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL1 : 3;   /*!< [6..4] CHNLSEL1 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL2 : 3;   /*!< [10..8] CHNLSEL2 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL3 : 3;   /*!< [14..12] CHNLSEL3 */
                __IM uint32_t : 5;
                __IOM uint32_t CPOUT_CHNL : 3; /*!< [22..20] CPOUT_CHNL */
                __IOM uint32_t OUT_TYPE : 1;   /*!< [23..23] OUT_TYPE */
                __IOM uint32_t CHNL_NUM : 2;   /*!< [25..24] CPOUT_CHNL */
                __IM uint32_t : 2;
                __IOM uint32_t POLL_PS : 1;    /*!< [28..28] POLL_PS */
            } ACMP0_CHNLSEL_b;
        };

        union
        {
            __IOM uint32_t ACMP1_CHNLSEL; /*!< (@ 0x000000DC) ACMP1_CHNLSEL */

            struct
            {
                __IOM uint32_t CHNLSEL0 : 3;   /*!< [2..0] CHNLSEL0 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL1 : 3;   /*!< [6..4] CHNLSEL1 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL2 : 3;   /*!< [10..8] CHNLSEL2 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL3 : 3;   /*!< [14..12] CHNLSEL3 */
                __IM uint32_t : 5;
                __IOM uint32_t CPOUT_CHNL : 3; /*!< [22..20] CPOUT_CHNL */
                __IOM uint32_t OUT_TYPE : 1;   /*!< [23..23] OUT_TYPE */
                __IOM uint32_t CHNL_NUM : 2;   /*!< [25..24] CPOUT_CHNL */
                __IM uint32_t : 2;
                __IOM uint32_t POLL_PS : 1;    /*!< [28..28] POLL_PS */
            } ACMP1_CHNLSEL_b;
        };

        __IM uint32_t RESERVED4[5];

        union
        {
            __IOM uint32_t HALL_CR; /*!< (@ 0x000000F4) HALL_CR */

            struct
            {
                __IOM uint32_t HALL_MID_EN : 1;  /*!< [0..0] HALL_MID_EN */
                __IOM uint32_t HALL_IP1_SEL : 1; /*!< [1..1] HALL_IP1_SEL */
                __IOM uint32_t HALL_IP2_SEL : 1; /*!< [2..2] HALL_IP2_SEL */
                __IOM uint32_t HALL_IP3_SEL : 1; /*!< [3..3] HALL_IP3_SEL*/
                __IOM uint32_t HALL_SW1 : 1;     /*!< [4..4] HALL_SW1*/
                __IOM uint32_t HALL_SW2 : 1;     /*!< [5..5] HALL_SW2*/
                __IOM uint32_t HALL_SW3 : 1;     /*!< [6..6] HALL_SW3*/
            } HALL_CR_b;
        };

        union
        {
            __IOM uint32_t ANA_CTRL; /*!< (@ 0x000000F8) ANA_CSR */

            struct
            {
                __IM uint32_t : 4;
                __IOM uint32_t DAC_BUFEN : 1; /*!< [4..4] DAC_BUFEN */
                __IM uint32_t : 19;
                __IOM uint32_t CVREFEN : 1;   /*!< [24..24] CVREFEN */
                __IOM uint32_t RDS : 4;       /*!< [28..25] RDS */
                __IOM uint32_t VRHVS : 1;     /*!< [29..29] VRHVS */
                __IOM uint32_t VRHL : 1;      /*!< [30..30] RDS */
                __IOM uint32_t VRHH : 1;      /*!< [30..30] RDS */
            } ANA_CTRL_b;
        };
    } ANACTRL_TypeDef; /*!< Size = 256 (0x100)  */

#if defined (LCM32F067) || defined (LCM32F063) || defined (LCM32CF6990)
    /* =========================================================================================================================== */
    /* ================   OPA   ================ */
    /* =========================================================================================================================== */

    /**
     * @brief Operational amplifier  . (OPA)
     */

    typedef struct
    { /*!< (@ 0x40017C00) OPA0 Structure */

        union
        {
            __IOM uint32_t OPA_CSR; /*!< (@ 0x00000000) OPA_CSR  */

            struct
            {
                __IOM uint32_t OPEN : 1;     /*!< [0..0] OPEN */
                __IOM uint32_t OPNRS : 1;    /*!< [1..1] OPNRS */
                __IOM uint32_t OPPRS : 1;    /*!< [2..2] OPPRS */
                __IM uint32_t : 1;
                __IOM uint32_t OPNS : 1;     /*!< [4..4] OPNS */
                __IOM uint32_t OPPS : 1;     /*!< [5..5] OPPS */
                __IOM uint32_t VM_SEL : 1;    /*!< [6..6] VM_SEL */
                __IM uint32_t : 1;
                __IOM uint32_t OPGS : 3;     /*!< [10..8] OPGS */
                __IOM uint32_t ADC_N_EN : 1;  /*!< [11..11] ADC_N_EN */
                __IOM uint32_t ADC_P_EN : 1;  /*!< [12..12] ADC_P_EN */
                __IOM uint32_t OPRIN : 1;    /*!< [13..13] OPRIN */
                __IOM uint32_t OPRFB : 1;    /*!< [14..14] OPRFB */
                __IM uint32_t : 1;
                __IOM uint32_t OPOS : 5;     /*!< [20..16] OPOS */
                __IM uint32_t : 3;
                __IOM uint32_t OPNSEL : 1;   /*!< [24..24] OPNSEL */
                __IM uint32_t : 1;
                __IOM uint32_t OPPSEL : 1;   /*!< [26..26] OPPSEL */
                __IM uint32_t : 1;
                __IOM uint32_t OPN_PD : 1;   /*!< [28..28] OPN_PD */
                __IOM uint32_t OPP_PD : 1;   /*!< [29..29] OPP_PD */
                __IOM uint32_t OPTRIMEN : 1; /*!< [30..30] OPTRIMEN */
                __IM uint32_t OPTRIMO : 1;   /*!< [31..31] OPTRIMO */
            } OPA_CSR_b;
        };
    } OPA_TypeDef; /*!< Size = 16 (0x0C)  */
    
#elif defined (LCM32F062)
  /* None OPA */
#endif
    /* =========================================================================================================================== */
    /* ================   DAC   ================ */
    /* =========================================================================================================================== */

    /**
     * @brief Digital Analog Converter . (DAC)
     */

    typedef struct
    { /*!< (@ 0x40017C00) DAC Structure */

        __IM uint32_t RESERVED0[16];

        union
        {
            __IOM uint32_t DAC_CR; /*!< (@ 0x00000040) DAC0_CR */

            struct
            {
                __IOM uint32_t EN : 1;       /*!< [0..0] EN */
                __IOM uint32_t : 5;
                __IOM uint32_t WAVE : 2;     /*!< [7..6] WAVE */
                __IOM uint32_t MAMP : 4;     /*!< [11..8] MAMP */
                __IOM uint32_t DMAEN : 1;    /*!< [12..12] DMAEN */
                __IOM uint32_t DMAUDRIE : 1; /*!< [13..13] DMAUDRIE */
                __IOM uint32_t VREF_SEL : 1; /*!< [14..14] VREF_SEL */
                __IOM uint32_t ALIGN : 1;    /*!< [15..15] ALIGN */
            } DAC_CR_b;
        };

        union
        {
            __IOM uint32_t DAC_SR; /*!< (@ 0x00000044) DAC0_CSR */

            struct
            {
                __IOM uint32_t SWTRIG : 1; /*!< [0..0] SWTRIG */
                __IM uint32_t : 7;
                __IOM uint32_t DMAUDR : 1; /*!< [8..8] DMAUDR */
            } DAC_SR_b;
        };

        union
        {
            __IOM uint32_t DAC_DHR; /*!< (@ 0x00000048) DAC0_DHR */

            struct
            {
                __IOM uint32_t DHR : 16; /*!< [15..0] DHR */
            } DAC_DHR_b;
        };

        union
        {
            __IM uint32_t DAC_DOR; /*!< (@ 0x0000004C) DAC0_DOR */

            struct
            {
                __IM uint32_t DOR : 16; /*!< [15..0] DOR */
            } DAC_DOR_b;
        };

    } DAC_TypeDef; /*!< Size = 256 (0x100)  */

    /* =========================================================================================================================== */
    /* ================   ACMP   ================ */
    /* =========================================================================================================================== */

    /**
     * @brief Analog comparator . (ACMP)
     */

    typedef struct
    { /*!< (@ 0x40017C00) ACMP Structure */

        __IM uint32_t RESERVED0[8];

        union
        {
            __IOM uint32_t ACMP0_CSR; /*!< (@ 0x00000020) ACMP0_CSR */

            struct
            {
                __IOM uint32_t CP_EN : 1;      /*!< [0..0] CP_EN */
                __IOM uint32_t CP_FREN : 1;    /*!< [1..1] CP_FREN */
                __IOM uint32_t CP_HYSEN : 1;   /*!< [2..2] CP_HYSEN */
                __IOM uint32_t CP_IS : 1;      /*!< [3..3] CP_IS */
                __IM uint32_t : 5;
                __IOM uint32_t CP_DLY : 2;     /*!< [10..9] CP_DLY */
                __IOM uint32_t CP_FS : 1;      /*!< [11..11] CP_FS */
                __IM uint32_t : 3;
                __IOM uint32_t CP_LPS : 1;     /*!< [15..15] CP_LPS */
                __IOM uint32_t CP_PF : 5;      /*!< [20..16] CP_PF */
                __IOM uint32_t MISS_TRIG : 1;  /*!< [21..21] MISS_TRIG */
                __IM uint32_t : 1;
                __IOM uint32_t FILTER_SEL : 5; /*!< [27..23] FILTER_SEL */
                __IM uint32_t CP_OUT_SYNC : 1; /*!< [28..28] CP_OUT_SYNC */
            } ACMP0_CSR_b;
        };
        union
        {
            __IOM uint32_t ACMP1_CSR; /*!< (@ 0x00000024) ACMP1_CSR */

            struct
            {
                __IOM uint32_t CP_EN : 1;      /*!< [0..0] CP_EN */
                __IOM uint32_t CP_FREN : 1;    /*!< [1..1] CP_FREN */
                __IOM uint32_t CP_HYSEN : 1;   /*!< [2..2] CP_HYSEN */
                __IOM uint32_t CP_IS : 1;      /*!< [3..3] CP_IS */
                __IM uint32_t : 5;
                __IOM uint32_t CP_DLY : 2;     /*!< [10..9] CP_DLY */
                __IOM uint32_t CP_FS : 1;      /*!< [11..11] CP_FS */
                __IM uint32_t : 3;
                __IOM uint32_t CP_LPS : 1;     /*!< [15..15] CP_LPS */
                __IOM uint32_t CP_PF : 5;      /*!< [20..16] CP_PF */
                __IOM uint32_t MISS_TRIG : 1;  /*!< [21..21] MISS_TRIG */
                __IM uint32_t : 1;
                __IOM uint32_t FILTER_SEL : 5; /*!< [27..23] FILTER_SEL */
                __IM uint32_t CP_OUT_SYNC : 1; /*!< [28..28] CP_OUT_SYNC */
            } ACMP1_CSR_b;
        };

        __IM uint32_t RESERVED1[38];

        union
        {
            __IOM uint32_t ACMP0_MUXCSR; /*!< (@ 0x000000C0) ACMP0_MUXCR */

            struct
            {
                __IOM uint32_t CMP_SEQ_START : 1;  /*!< [0..0] CMP_SEQ_START */
                __IOM uint32_t CHNL_CNT_CFG : 7;   /*!< [7..1] CHNL_CNT_CFG */
                __IOM uint32_t CPOUT_SEQ : 8;      /*!< [15..8] CPOUT_SEQ */
                __IOM uint32_t ACMP_P_SEL0 : 3;    /*!< [18..16] ACMP_P_SEL0 */
                __IOM uint32_t ACMP_P_SEL1 : 2;    /*!< [20..19] ACMP_P_SEL1 */
                __IM uint32_t : 3;
                __IOM uint32_t ACMP_N_SEL : 3;     /*!< [26..24] ACMP_N_SEL */
                __IOM uint32_t CMP_MODE : 2;       /*!< [28..27] CMP_MODE */
                __IOM uint32_t CMP_INTEN : 1;      /*!< [29..29] CMP_INTEN */
                __IOM uint32_t CMP_INT_FLG : 1;     /*!< [30..30] CMP_INT_FLG */
                __IOM uint32_t TRIG_MODE : 1;       /*!< [31..31] TRIG_MODE */
            } ACMP0_MUXCSR_b;
        };

        union
        {
            __IOM uint32_t ACMP0_EXTCFG; /*!< (@ 0x000000C4) ACMP0_EXTCFG */

            struct
            {
                __IM uint32_t : 4;
                __IOM uint32_t EXTDTG : 8;   /*!< [11..4] EXTDTG */
                __IM uint32_t : 15;
                __IOM uint32_t EXTSE : 2;    /*!< [28..27] EXTSE */
            } ACMP0_EXTCFG_b;
        };

        union
        {
            __IOM uint32_t ACMP1_MUXCSR; /*!< (@ 0x000000C8) ACMP1_MUXCSR */

            struct
            {
                __IOM uint32_t CMP_SEQ_START : 1;  /*!< [0..0] CMP_SEQ_START */
                __IOM uint32_t CHNL_CNT_CFG : 7;   /*!< [7..1] CHNL_CNT_CFG */
                __IOM uint32_t CPOUT_SEQ : 8;      /*!< [15..8] CPOUT_SEQ */
                __IOM uint32_t ACMP_P_SEL0 : 3;    /*!< [18..16] ACMP_P_SEL0 */
                __IOM uint32_t ACMP_P_SEL1 : 2;    /*!< [20..19] ACMP_P_SEL1 */
                __IM uint32_t : 3;
                __IOM uint32_t ACMP_N_SEL : 3;     /*!< [26..24] ACMP_N_SEL */
                __IOM uint32_t CMP_MODE : 2;       /*!< [28..27] CMP_MODE */
                __IOM uint32_t CMP_INTEN : 1;      /*!< [29..29] CMP_INTEN */
                __IOM uint32_t CMP_INT_FLG : 1;     /*!< [30..30] CMP_INT_FLG */
                __IOM uint32_t TRIG_MODE : 1;       /*!< [31..31] TRIG_MODE */
            } ACMP1_MUXCSR_b;
        };

        union
        {
            __IOM uint32_t ACMP1_EXTCFG; /*!< (@ 0x000000CC) ACMP1_EXTCFG */

            struct
            {
                __IM uint32_t : 4;
                __IOM uint32_t EXTDTG : 8;   /*!< [11..4] EXTDTG */
                __IM uint32_t : 15;
                __IOM uint32_t EXTSE : 2;    /*!< [28..27] EXTSE */
            } ACMP1_EXTCFG_b;
        };

        __IM uint32_t RESERVED2[2];

        union
        {
            __IOM uint32_t ACMP0_CHNLSEL; /*!< (@ 0x000000D8) ACMP0_CHNLSEL */

            struct
            {
                __IOM uint32_t CHNLSEL0 : 3;   /*!< [2..0] CHNLSEL0 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL1 : 3;   /*!< [6..4] CHNLSEL1 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL2 : 3;   /*!< [10..8] CHNLSEL2 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL3 : 3;   /*!< [14..12] CHNLSEL3 */
                __IM uint32_t : 5;
                __IOM uint32_t CPOUT_CHNL : 3; /*!< [22..20] CPOUT_CHNL */
                __IOM uint32_t OUT_TYPE : 1;   /*!< [23..23] OUT_TYPE */
                __IOM uint32_t CHNL_NUM : 2;   /*!< [25..24] CPOUT_CHNL */
                __IM uint32_t : 2;
                __IOM uint32_t POLL_PS : 1;    /*!< [28..28] POLL_PS */
            } ACMP0_CHNLSEL_b;
        };

        union
        {
            __IOM uint32_t ACMP1_CHNLSEL; /*!< (@ 0x000000DC) ACMP1_CHNLSEL */

            struct
            {
                __IOM uint32_t CHNLSEL0 : 3;   /*!< [2..0] CHNLSEL0 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL1 : 3;   /*!< [6..4] CHNLSEL1 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL2 : 3;   /*!< [10..8] CHNLSEL2 */
                __IM uint32_t : 1;
                __IOM uint32_t CHNLSEL3 : 3;   /*!< [14..12] CHNLSEL3 */
                __IM uint32_t : 5;
                __IOM uint32_t CPOUT_CHNL : 3; /*!< [22..20] CPOUT_CHNL */
                __IOM uint32_t OUT_TYPE : 1;   /*!< [23..23] OUT_TYPE */
                __IOM uint32_t CHNL_NUM : 2;   /*!< [25..24] CPOUT_CHNL */
                __IM uint32_t : 2;
                __IOM uint32_t POLL_PS : 1;    /*!< [28..28] POLL_PS */
            } ACMP1_CHNLSEL_b;
        };

    } ACMP_TypeDef; /*!< Size = 224 (0xE0) */

    /* =========================================================================================================================== */
    /* ================  CHIPCTRL   ================ */
    /* =========================================================================================================================== */

    /**
     * @brief chip controler moudle. (CHIPCTRL)
     */

    typedef struct
    { /*!< (@ 0x40017000) CHIPCTRL Structure  */

        union
        {
            __IOM uint32_t CLK_CFG; /*!< (@ 0x00000000) CLK_CFG */

            struct
            {
                __IOM uint32_t SYS_CLK_SEL : 8; /*!< [7..0] SYS_CLK_SEL */
                __IM uint32_t : 4;
                __IOM uint32_t APB0_DIV : 4;    /*!< [15..12] APB0_DIV */
                __IOM uint32_t PLL_EN : 1;      /*!< [16..16] PLL_EN */
                __IM uint32_t : 2;
                __IOM uint32_t RCH_EN : 1;      /*!< [19..19] RCH_EN*/
                __IOM uint32_t SYS_SRC_SEL : 2; /*!< [21..20] SYS_SRC_SEL*/
            } CLK_CFG_b;
        };

        union
        {
            __IOM uint32_t PWR_CFG; /*!< (@ 0x00000004) PWR_CFG */

            struct
            {
                __IOM uint32_t LVREN : 1;    /*!< [0..0] LVREN */
                __IOM uint32_t LVRS : 3;     /*!< [3..1] LVRS */
                __IM uint32_t : 1;
                __IOM uint32_t AOUT_SEL : 3; /*!< [7..5] AOUT_SEL */
                __IOM uint32_t LVDEN : 1;    /*!< [8..8] LVDEN */
                __IOM uint32_t LVDES : 1;    /*!< [9..9] LVDES */
                __IOM uint32_t LVDS : 3;     /*!< [12..10] LVDS */
                __IOM uint32_t AOUT_EN : 1;  /*!< [13..13] AOUT_EN */
                __IOM uint32_t AOUT_POL : 1; /*!< [14..14] AOUT_POL */
                __IOM uint32_t : 13;
                __IOM uint32_t OP_ISEL : 3;  /*!< [30..28] OP_ISEL */
            } PWR_CFG_b;
        };

        union
        {
            __IOM uint32_t CTRL; /*!< (@ 0x00000008) CTRL */

            struct
            {
                __IOM uint32_t RCL_IE : 1;        /*!< [0..0] RCL_IE*/
                __IOM uint32_t RCH_IE : 1;        /*!< [1..1] RCH_IE*/
                __IOM uint32_t OSCL_IE : 1;       /*!< [2..2] OSCL_IE */
                __IM uint32_t : 1;
                __IOM uint32_t PLL_IE : 1;        /*!< [4..4] PLL_IE*/
                __IOM uint32_t CLKMUX_ERR_IE : 1; /*!< [5..5] CLKMUX_ERR_IE*/
                __IOM uint32_t CLKEN_ERR_IE : 1;  /*!< [6..6] CLKEN_ERR_IE */
                __IM uint32_t : 1;
                __IOM uint32_t FLASH_P_EN : 1;    /*!< [8..8] FLASH_P_EN */
                __IOM uint32_t SRAM_P_EN : 1;     /*!< [9..9] SRAM_P_EN */
                __IOM uint32_t HF_ROM_EN : 1;     /*!< [10..10] HF_ROM_EN */
                __IM uint32_t : 1;
                __IOM uint32_t IF_IE : 1;         /*!< [12..12] IF_IE */
                __IOM uint32_t DF_IE : 1;         /*!< [13..13] DF_IE */
                __IOM uint32_t SRAM_IE : 1;       /*!< [14..14] SRAM_IE */
                __IM uint32_t : 9;
                __IOM uint32_t OSCL_IP : 1; /*!< [24..24] OSCL_IP */
                __IM uint32_t : 1;
                __IOM uint32_t PLL_IP : 1;  /*!< [26..26] PLL_IP */
                __IM uint32_t : 2;
                __IOM uint32_t LVD_LOCK : 1; /*!< [29..29] LVD_LOCK */
                __IOM uint32_t LOCKUPEN : 1; /*!< [30..30] LOCKUPEN */
            } CTRL_b;
        };

        union
        {
            __IOM uint32_t PLL_CFG; /*!< (@ 0x0000000C) PLL_CFG   */

            struct
            {
                __IM uint32_t : 1;
                __IOM uint32_t PLL_LS : 1;   /*!< [1..1] PLL_LS*/
                __IOM uint32_t PLL_DN : 5;   /*!< [6..2] PLL_DN*/
                __IM uint32_t : 1;
                __IOM uint32_t PLL_DM : 2;   /*!< [9..8] PLL_DM */
                __IOM uint32_t PLL_MODE : 1; /*!< [10..10] PLL_MODE */
                __IOM uint32_t PLL_SEL : 1;  /*!< [11..11] PLL_SEL */
                __IOM uint32_t PLL_OD : 1;   /*!< [12..12] PLL_OD */
            } PLL_CFG_b;
        };

        union
        {
            __IOM uint32_t RCH_CFG; /*!< (@ 0x00000010) RCH_CFG   */

            struct
            {
                __IOM uint32_t RCH_TRIM : 12;    /*!< [11..0] RCH_TRIM */
                __IOM uint32_t RCH_PT : 4;       /*!< [15..12] RCH_PT */
                __IOM uint32_t RCH_FJ_EN : 1;    /*!< [16..16] RCH_FJ_EN */
                __IOM uint32_t RCH_FJ_INV : 3;   /*!< [19..17] RCH_FJ_INV */
                __IOM uint32_t RCH_FJ_RANGE : 2; /*!< [21..20] RCH_FJ_RANGE */
            } RCH_CFG_b;
        };

        __IM uint32_t RESERVED0;

        union
        {
            __IOM uint32_t STS; /*!< (@ 0x00000018) STS  */

            struct
            {
                __IOM uint32_t RCL_STS : 1;        /*!< [0..0] RCL_STS */
                __IOM uint32_t RCH_STS : 1;        /*!< [1..1] RCH_STS */
                __IOM uint32_t OSCL_STS : 1;       /*!< [2..2] OSCL_STS */
                __IM uint32_t : 1;
                __IOM uint32_t PLL_STS : 1;        /*!< [4..4] PLL_STS */
                __IOM uint32_t CLKMUX_ERR : 1;     /*!< [5..5] CLKMUX_ERR */
                __IOM uint32_t CLKEN_ERR : 1;      /*!< [6..6] CLKEN_ERR */
                __IM uint32_t : 9;
                __IOM uint32_t RCL_STB : 1;        /*!< [16..16] RCL_STB */
                __IOM uint32_t RCH_STB : 1;        /*!< [17..17] RCH_STB */
                __IOM uint32_t OSCL_STB : 1;       /*!< [18..18] OSCL_STB */
                __IM uint32_t : 1;
                __IOM uint32_t PLL_LOCK : 1;       /*!< [20..20] PLL_LOCK */
                __IM uint32_t : 1;
                __IOM uint32_t SYS_CLK_LOCK : 1;   /*!< [22..22] SYS_CLK_LOCK */
                __IOM uint32_t CLKMUX_LOCK : 1;    /*!< [23..23] CLKMUX_LOCK */
                __IOM uint32_t LVDFLG : 1;         /*!< [24..24] LVDFLG */
                __IOM uint32_t FLASH_CON_FLAG : 1; /*!< [25..25] FLASH_CON_FLAG */
                __IM uint32_t : 5;
                __IOM uint32_t SW_FLAG : 1;        /*!< [31..31] SW_FLAG */
            } STS_b;
        };

        union
        {
            __IOM uint32_t RST_CSR; /*!< (@ 0x0000001C) RST_CSR */

            struct
            {
                __IOM uint32_t POR_FLAG : 1;        /*!< [0..0] POR_FLAG */
                __IOM uint32_t LVR_FLAG : 1;        /*!< [1..1] LVR_FLAG */
                __IM uint32_t : 1;
                __IOM uint32_t RSTN_FLAG : 1;       /*!< [3..3] RSTN_FLAG */
                __IOM uint32_t IWDG_RST_FLAG : 1;   /*!< [4..4] IWDG_RST_FLAG */
                __IOM uint32_t : 1;                 /*!< [5..5] WWDG_RST_FLAG */
                __IOM uint32_t LOCKUP_RST_FLAG : 1; /*!< [6..6] LOCKUP_RST_FLAG */
                __IOM uint32_t SYSRESET_FLAG : 1;   /*!< [7..7] SYSRESET_FLAG */
                __IM uint32_t : 4;
                __IOM uint32_t LOCKUPRESET : 1;     /*!< [12..12] LOCKUPRESET */
            } RST_CSR_b;
        };

        union
        {
            union
            {
                __IOM uint32_t KEY_W; /*!< (@ 0x00000020) KEY */

                struct
                {
                    __IOM uint32_t KEY : 32; /*!< [31..0] KEY */
                } KEY_W_b;
            };

            union
            {
                __IOM uint32_t KEY_R; /*!< (@ 0x00000020) KEY */

                struct
                {
                    __IM uint32_t WR_ERR : 1;   /*!< [0..0] WR_ERR */
                    __IM uint32_t LOCK : 1;     /*!< [1..1] lock status */
                    __IM uint32_t : 6;
                    __IM uint32_t LOCK_CNT : 5; /*!< [8..12] LOCK_CNT */
                } KEY_R_b;
            };
        };

        union
        {
            __IOM uint32_t RCL_CFG; /*!< (@ 0x00000024) RCL_CFG */

            struct
            {
                __IOM uint32_t RCL_TRIM : 6; /*!< [5..0] RCL_TRIM */
                __IM uint32_t : 1;
                __IOM uint32_t RCL_EN : 1;   /*!< [7..7] RCL_EN */
            } RCL_CFG_b;
        };

        union
        {
            __IOM uint32_t BDCR; /*!< (@ 0x00000028) BDCR */

            struct
            {
                __IOM uint32_t OSCL_EN : 1;   /*!< [0..0] OSCL_EN */
                __IOM uint32_t OSCL_BYP : 1;  /*!< [1..1] OSCL_BYP */
                __IOM uint32_t OSCL_GAIN : 2; /*!< [3..2] OSCL_GAIN */
                __IOM uint32_t OSCL_TS : 2;   /*!< [5..4] OSCL_TS */
                __IOM uint32_t OSCL_REN : 1;  /*!< [6..6] OSCL_REN */
                __IM uint32_t : 2;
                __IOM uint32_t WT_SEL : 2;    /*!< [10..9] WT_SEL */
                __IOM uint32_t BDRST : 1;     /*!< [11..11] BDRST */
                __IM uint32_t : 2;
                __IOM uint32_t RST_CFG : 1;   /*!< [14..14] RST_CFG */
                __IM uint32_t : 1;
                __IOM uint32_t WT_EN : 1;     /*!< [16..16] WT_EN */
            } BDCR_b;
        };

        union
        {
            __IOM uint32_t BGR_CFG; /*!< (@ 0x0000002C) BGR_CFG */

            struct
            {
                __IOM uint32_t BGRTRIM : 11;  /*!< [10..0] BGRTRIM */
                __IM uint32_t : 5;
                __IOM uint32_t LPBGRTRIM : 3; /*!< [18..16] BGRTRIM */
            } BGR_CFG_b;
        };

        union
        {
            __IOM uint32_t PWR_CR; /*!< (@ 0x00000030) PWR_CR */

            struct
            {
                __IOM uint32_t LPDS : 1;    /*!< [0..0] LPDS*/
                __IM uint32_t : 1;
                __IOM uint32_t PMUEN : 1;   /*!< [2..2] PMUEN */
                __IOM uint32_t FPDS : 1;    /*!< [3..3] FPDS */
                __IOM uint32_t ULPDS : 1;   /*!< [4..4] ULPDS */
            } PWR_CR_b;
        };

        __IM uint32_t RESERVED1[2];

        union
        {
            __IOM uint32_t PWR_LDOCR; /*!< (@ 0x0000003C) PWR_LDOCR */

            struct
            {
                __IOM uint32_t EXTVDD : 1; /*!< [0..0] EXTVDD */
                __IOM uint32_t PD : 1;     /*!< [1..1] PD */
                __IOM uint32_t DRV : 2;    /*!< [3..2] DRV */
                __IM uint32_t : 2;
                __IOM uint32_t STOP : 1;   /*!< [6..6] STOP */
            } PWR_LDOCR_b;
        };

        union
        {
            __IOM uint32_t FLASH_PARITY_ADDR; /*!< (@ 0x00000040) FLASH_PARITY_ADDR */

            struct
            {
                __IOM uint32_t IF_P_FLAG : 1;         /*!< [0..0] IF_P_FLAG */
                __IOM uint32_t DF_P_FLAG : 1;         /*!< [1..1] DF_P_FLAG */
                __IM uint32_t : 6;
                __IM uint32_t FLASH_PARITY_BIT : 4;   /*!< [11..8] FLASH_PARITY_BIT */
                __IM uint32_t FLASH_PARITY_ADDR : 17; /*!< [28..16] FLASH_PARITY_ADDR */
            } FLASH_PARITY_ADDR_b;
        };

        union
        {
            __IM uint32_t FLASH_PARITY_DATA; /*!< (@ 0x00000044) FLASH_PARITY_DATA */

            struct
            {
                __IM uint32_t FLASH_PARITY_DATA : 32;  /*!< [31..0] FLASH_PARITY_DATA */
            } FLASH_PARITY_DATA_b;
        };

        union
        {
            __IOM uint32_t FLASH_PARITY_INJ; /*!< (@ 0x00000048) FLASH_PARITY_INJ */

            struct
            {
                __IOM uint32_t FLASH_P_INJ_BIT : 4; /*!< [3..0] FLASH_P_INJ_BIT */
                __IOM uint32_t FLASH_P_INJ_EN : 4;  /*!< [7..4] FLASH_P_INJ_EN */
            } FLASH_PARITY_INJ_b;
        };

        union
        {
            __IOM uint32_t SRAM_PARITY_ADDR; /*!< (@ 0x0000004C) SRAM_PARITY_ADDR */

            struct
            {
                __IOM uint32_t SRAM_P_FLAG : 1;       /*!< [0..0] SRAM_P_FLAG */
                __IM uint32_t : 1;
                __IM uint32_t SRAM_PARITY_ADDR : 14;  /*!< [15..2] SRAM_PARITY_ADDR */
                __IM uint32_t SRAM_PARITY_BIT : 4;    /*!< [19..16] SRAM_PARITY_BIT */
                __IM uint32_t SRAM_PARITY_CHECK : 4;  /*!< [23..20] SRAM_PARITY_CHECK */
            } SRAM_PARITY_ADDR_b;
        };

        union
        {
            __IM uint32_t SRAM_PARITY_DATA; /*!< (@ 0x00000050) SRAM_PARITY_DATA */

            struct
            {
                __IM uint32_t SRAM_PARITY_DATA : 32;  /*!< [31..0] SRAM_PARITY_DATA */
            } SRAM_PARITY_DATA_b;
        };

        union
        {
            __IOM uint32_t SRAM_PARITY_INJ; /*!< (@ 0x00000054) SRAM_PARITY_INJ */

            struct
            {
                __IOM uint32_t SRAM_P_INJ_BIT : 4; /*!< [3..0] SRAM_P_INJ_BIT */
                __IOM uint32_t SRAM_P_INJ_EN : 4;  /*!< [7..4] SRAM_P_INJ_EN */
            } SRAM_PARITY_INJ_b;
        };

        union
        {
            __IM uint32_t PARITY_BIT; /*!< (@ 0x00000058) PARITY_BIT */

            struct
            {
                __IM uint32_t FLASH_P_BIT : 4; /*!< [3..0] FLASH_P_BIT */
                __IM uint32_t : 12;
                __IM uint32_t SRAM_P_BIT : 4;  /*!< [19..16] SRAM_P_BIT */
            } PARITY_BIT_b;
        };

        union
        {
            __IOM uint32_t ROM; /*!< (@ 0x0000005C) ROM */

            struct
            {
                __IOM uint32_t ROM_ENCODING : 16; /*!< [15..0] ROM_ENCODING */
            } ROM_b;
        };

    } CHIPCTRL_TypeDef; /*!< Size = 84 (0x54)    */

    /* =========================================================================================================================== */
    /* ================   SYSCTRL   ================ */
    /* =========================================================================================================================== */

    /**
     * @brief SYSCTRL (SYSCTRL)
     */

    typedef struct
    { /*!< (@ 0x48007000) SYSCTRL Structure   */

        union
        {
            __IOM uint32_t ClkEnR0; /*!< (@ 0x00000000) ClkEnR0 */

            struct
            {
                __IOM uint32_t GPIOA_CLKEN : 1;  /*!< [0..0] GPIOA_CLKEN */
                __IOM uint32_t GPIOB_CLKEN : 1;  /*!< [1..1] GPIOB_CLKEN */
                __IM uint32_t : 4;
                __IOM uint32_t CRC_CLKEN : 1;    /*!< [6..6] CRC_CLKEN */
                __IOM uint32_t CORDIC_CLKEN: 1;  /*!< [7..7] CORDIC_CLKEN */
                __IOM uint32_t DMA_CLKEN : 1;    /*!< [8..8] DMA_CLKEN */
                __IOM uint32_t ADC_CLKEN : 1;    /*!< [9..9] ADC_CLKEN */
                __IOM uint32_t I2C0_CLKEN : 1 ;  /*!< [10..10] I2C0_CLKEN */
                __IM uint32_t : 1;
                __IOM uint32_t SPI0_CLKEN : 1;   /*!< [12..12] SPI0_CLKEN */
                __IOM uint32_t USART0_CLKEN : 1; /*!< [13..13] USART0_CLKEN */
                __IOM uint32_t USART1_CLKEN : 1; /*!< [14..14] USART1_CLKEN */
                __IM uint32_t : 1;
                __IOM uint32_t EFLS_CLKEN : 1;   /*!< [16..16] EFLS_CLKEN */
                __IOM uint32_t RAM0_CLKEN : 1;   /*!< [17..17] RAM0_CLKEN */
                __IOM uint32_t RAM1_CLKEN : 1;   /*!< [18..18] RAM1_CLKEN */
                __IOM uint32_t TIM1_CLKEN : 1;   /*!< [19..19] TIM1_CLKEN */
                __IM uint32_t : 8;
                __IOM uint32_t TIM15_CLKEN : 1;  /*!< [28..28] TIM15_CLKEN*/
                __IOM uint32_t TIM16_CLKEN : 1;  /*!< [29..29] TIM16_CLKEN*/
                __IOM uint32_t TIM17_CLKEN : 1;  /*!< [30..30] TIM17_CLKEN*/
                __IOM uint32_t TIM2_CLKEN : 1;   /*!< [31..31] TIM3_CLKEN */
            } ClkEnR0_b;
        };

        union
        {
            __IOM uint32_t ClkEnR1; /*!< (@ 0x00000004) ClkEnR1 */

            struct
            {
                __IOM uint32_t MCO_DIV : 3;        /*!< [2..0] MCO_DIV */
                __IOM uint32_t MCO_SEL : 3;        /*!< [5..3] MCO_SEL */
                __IM uint32_t : 1;
                __IOM uint32_t RCH_DIV : 1;        /*!< [7..7] RCH_DIV */
                __IM uint32_t : 2;
                __IOM uint32_t USART0_CLKDIV : 1;  /*!< [10..10] USART0_CLKDIV */
                __IOM uint32_t USART0_CLKSEL : 2;  /*!< [12..11] USART0_CLKSEL */
                __IOM uint32_t USART1_CLKDIV : 1;  /*!< [13..13] USART1_CLKDIV */
                __IOM uint32_t USART1_CLKSEL : 2;  /*!< [15..14] USART1_CLKSEL */
                __IOM uint32_t I2C0_CLKDIV : 1;    /*!< [16..16] I2C0_CLKDIV*/
                __IOM uint32_t I2C0_CLKSEL : 2;    /*!< [18..17] I2C0_CLKSEL */
                __IOM uint32_t SPI0_CLKDIV : 1;    /*!< [19..19] SPI0_CLKDIV */
                __IOM uint32_t SPI0_CLKSEL : 2;    /*!< [21..20] SPI0_CLKSEL */
                __IM uint32_t : 4;
                __IOM uint32_t TIM1_CLKSEL : 1;    /*!< [26..26] TIM1_CLKSEL */
                __IOM uint32_t TIM2_CLKSEL : 1;    /*!< [27..27] TIM2_CLKSEL */
                __IOM uint32_t TIM15_CLKSEL : 1;   /*!< [28..28] TIM15_CLKSEL */
                __IOM uint32_t TIM16_CLKSEL : 1;   /*!< [29..29] TIM16_CLKSEL */
                __IOM uint32_t TIM17_CLKSEL : 1;   /*!< [30..30] TIM17_CLKSEL*/
            } ClkEnR1_b;
        };

        union
        {
            __IOM uint32_t ClkEnR2; /*!< (@ 0x00000008) ClkEnR2 */

            struct
            {
                __IM uint32_t : 5;
                __IOM uint32_t ANA_CLKEN : 1;  /*!< [5..5] ANA_CLKEN */
                __IOM uint32_t EXTI_CLKEN : 1; /*!< [6..6] EXTI_CLKEN */
                __IOM uint32_t DIV_CLKEN : 1;  /*!< [7..7] DIV32_CLKEN */
            } ClkEnR2_b;
        };

        union
        {
            __IOM uint32_t RST0; /*!< (@ 0x0000000C) SW_RSTN0 */

            struct
            {
                __IOM uint32_t GPIOA_RST : 1;  /*!< [0..0] GPIOA_RST */
                __IOM uint32_t GPIOB_RST : 1;  /*!< [1..1] GPIOA_RST */
                __IM uint32_t : 4;
                __IOM uint32_t CRC_RST : 1;    /*!< [6..6] CRC_RST */
                __IM uint32_t : 1;
                __IOM uint32_t DMA_RST : 1;    /*!< [8..8] DMA_RST */
                __IOM uint32_t ADC_RST : 1;    /*!< [9..9] ADC_RST */
                __IOM uint32_t I2C0_RST : 1;   /*!< [10..10] I2C0_RST */
                __IM uint32_t : 1;
                __IOM uint32_t SPI0_RST : 1;   /*!< [12..12] SPI0_RST */
                __IOM uint32_t USART0_RST : 1; /*!< [13..13] USART0_RST */
                __IOM uint32_t USART1_RST : 1; /*!< [14..14] USART1_RST */
                __IM uint32_t : 1;
                __IOM uint32_t EFLS_RST : 1;   /*!< [16..16] EFLS_RST */
                __IOM uint32_t RAM0_RST : 1;   /*!< [17..17] RAM0_RST */
                __IOM uint32_t RAM1_RST : 1;   /*!< [18..18] RAM1_RST */
                __IOM uint32_t TIM1_RST : 1;   /*!< [19..19] TIM1_RST */
                __IM uint32_t : 8;
                __IOM uint32_t TIM15_RST : 1;  /*!< [28..28] TIM15_RST */
                __IOM uint32_t TIM16_RST : 1;  /*!< [29..29] TIM16_RST */
                __IOM uint32_t TIM17_RST : 1;  /*!< [30..30] TIM17_RST */
                __IOM uint32_t TIM2_RST : 1;   /*!< [31..31] TIM2_RST */
            } RST0_b;
        };

        union
        {
            __IOM uint32_t RST1; /*!< (@ 0x00000010) RST1 */

            struct
            {
                __IM uint32_t : 5;
                __IOM uint32_t ANA_RST : 1;  /*!< [5..5] ANA_RST */
                __IOM uint32_t EXTI_RST : 1; /*!< [6..6] EXTI_RST */
                __IOM uint32_t DIV_RST : 1;  /*!< [7..7] DIV_RST */
            } RST1_b;
        };

        union
        {
            __IOM uint32_t DBG_CFG; /*!< (@ 0x00000014) DBG_CFG */

            struct
            {
                __IOM uint32_t TIM1_STOP : 1;  /*!< [0..0] TIM1_STOP */
                __IM uint32_t : 3;
                __IOM uint32_t TIM15_STOP : 1; /*!< [4..4] TIM15_STOP */
                __IOM uint32_t TIM16_STOP : 1; /*!< [5..5] TIM16_STOP */
                __IOM uint32_t TIM17_STOP : 1; /*!< [6..6] TIM17_STOP */
                __IOM uint32_t WT_STOP : 1;    /*!< [7..7] WT_STOP */
                __IM uint32_t : 1;
                __IOM uint32_t IWDG_STOP : 1;  /*!< [9..9] IWDG_STOP */
                __IOM uint32_t TIM2_STOP : 1;  /*!< [10..10] TIM2_STOP */
            } DBG_CFG_b;
        };

        union
        {
            __IOM uint32_t EXTI_CFG0; /*!< (@ 0x00000018) EXTI_CFG0 */

            struct
            {
                __IOM uint32_t EXTI0 : 3; /*!< [2..0] EXTI0 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI1 : 3; /*!< [6..4] EXTI1 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI2 : 3; /*!< [10..8] EXTI2 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI3 : 3; /*!< [14..12] EXTI3 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI4 : 3; /*!< [18..16] EXTI4 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI5 : 3; /*!< [22..20] EXTI5 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI6 : 3; /*!< [26..24] EXTI6 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI7 : 3; /*!< [30..28] EXTI7 */
            } EXTI_CFG0_b;
        };

        union
        {
            __IOM uint32_t EXTI_CFG1; /*!< (@ 0x0000001C) EXTI_CFG1 */

            struct
            {
                __IOM uint32_t EXTI8 : 3; /*!< [2..0] EXTI8 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI9 : 3; /*!< [6..4] EXTI9 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI10 : 3; /*!< [10..8] EXTI10 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI11 : 3; /*!< [14..12] EXTI11 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI12 : 3; /*!< [18..16] EXTI12 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI13 : 3; /*!< [22..20] EXTI13 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI14 : 3; /*!< [26..24] EXTI14 */
                __IM uint32_t : 1;
                __IOM uint32_t EXTI15 : 3; /*!< [30..28] EXTI15 */
            } EXTI_CFG1_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG0; /*!< (@ 0x00000020) EDU_CFG0  */

            struct
            {
                __IOM uint32_t DMA_REQ0_MAP : 4; /*!< [3..0] DMA_REQ0_MAP */
                __IOM uint32_t DMA_REQ1_MAP : 4; /*!< [7..4] DMA_REQ1_MAP */
                __IOM uint32_t DMA_REQ2_MAP : 4; /*!< [11..8] DMA_REQ2_MAP */
                __IOM uint32_t DMA_REQ3_MAP : 4; /*!< [15..12] DMA_REQ3_MAP */
                __IOM uint32_t DMA_REQ4_MAP : 4; /*!< [19..16] DMA_REQ4_MAP */
                __IOM uint32_t DMA_REQ5_MAP : 4; /*!< [23..20] DMA_REQ5_MAP */
                __IOM uint32_t DMA_REQ6_MAP : 4; /*!< [27..24] DMA_REQ6_MAP */
                __IOM uint32_t DMA_REQ7_MAP : 4; /*!< [31..28] DMA_REQ7_MAP */
            } EDU_CFG0_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG1; /*!< (@ 0x00000024) EDU_CFG1 */

            struct
            {
                __IM uint32_t : 16;
                __IOM uint32_t TIM1_ETRS : 3; /*!< [18..16] TIM1_ETRS */
            } EDU_CFG1_b;
        };

        __IM uint32_t RESERVED0;

        union
        {
            __IOM uint32_t EDU_CFG3; /*!< (@ 0x0000002C) EDU_CFG3 */

            struct
            {
                __IOM uint32_t TIM15_TI1S : 3; /*!< [2..0] TIM15_TI1S */
                __IM uint32_t : 1;
                __IOM uint32_t TIM15_TI2S : 3; /*!< [6..4] TIM15_TI2S */
                __IM uint32_t : 1;
                __IOM uint32_t TIM15_ETRS : 3; /*!< [10..8] TIM15_ETRS */
                __IM uint32_t : 1;
                __IOM uint32_t TIM16_TI1S : 3; /*!< [14..12] TIM16_TI1S */
                __IM uint32_t : 1;
                __IOM uint32_t TIM16_TI2S : 3; /*!< [18..16] TIM16_TI2S */
                __IM uint32_t : 1;
                __IOM uint32_t TIM16_ETRS : 3; /*!< [22..20] TIM16_ETRS */
                __IM uint32_t : 1;
                __IOM uint32_t TIM17_TI1S : 3; /*!< [26..24] TIM17_TI1S */
                __IM uint32_t : 1;
                __IOM uint32_t TIM17_ETRS : 3; /*!< [30..28] TIM17_ETRS */
            } EDU_CFG3_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG4; /*!< (@ 0x00000030) EDU_CFG4 */

            struct
            {
                __IOM uint32_t TIM1_SP : 7;    /*!< [6..0] TIM1_SP */
                __IM uint32_t : 1;
                __IOM uint32_t TIM1_BKSE : 7;  /*!< [14..8] TIM1_BKSE */
                __IM uint32_t : 1;
                __IOM uint32_t TIM1_BK2SE : 6; /*!< [21..16] TIM1_BK2SE */
                __IM uint32_t : 2;
                __IOM uint32_t TIM1_OCCSE : 6; /*!< [29..24] TIM1_OCCSE */
            } EDU_CFG4_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG5; /*!< (@ 0x00000034) EDU_CFG5 */

            struct
            {
                __IM uint32_t : 16;
                __IOM uint32_t TIM17_SP : 7;   /*!< [22..16] TIM17_SP */
                __IM uint32_t : 1;
                __IOM uint32_t TIM17_BKSE : 7; /*!< [30..24] TIM17_BKSE */
            } EDU_CFG5_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG6; /*!< (@ 0x00000038) EDU_CFG6  */

            struct
            {
                __IOM uint32_t TIM15_SP : 7;    /*!< [6..0] TIM15_SP */
                __IM uint32_t : 1;
                __IOM uint32_t TIM15_BKSE : 7;  /*!< [14..8] TIM15_BKSE */
                __IM uint32_t : 1;
                __IOM uint32_t TIM15_BK2SE : 6; /*!< [21..16] TIM15_BK2SE */
            } EDU_CFG6_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG7; /*!< (@ 0x0000003C) EDU_CFG7 */

            struct
            {
                __IOM uint32_t TIM16_SP : 7;    /*!< [6..0] TIM16_SP */
                __IM uint32_t : 1;
                __IOM uint32_t TIM16_BKSE : 7;  /*!< [14..8] TIM16_BKSE */
                __IM uint32_t : 1;
                __IOM uint32_t TIM16_BK2SE : 6; /*!< [21..16] TIM16_BK2SE */
            } EDU_CFG7_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG8; /*!< (@ 0x00000040) EDU_CFG8 */

            struct
            {
                __IOM uint32_t TIM2_TI1S : 3;   /*!< [2..0] TIM2_TI1S */
                __IM uint32_t : 1;
                __IOM uint32_t TIM2_TI2S : 3;   /*!< [6..4] TIM2_TI2S */
                __IM uint32_t : 1;
                __IOM uint32_t TIM2_TI3S : 3;   /*!< [10..8] TIM2_TI3S */
                __IM uint32_t : 1;
                __IOM uint32_t TIM2_TI4S : 3;   /*!< [14..12] TIM2_TI4S */
                __IM uint32_t : 1;
                __IOM uint32_t TIM2_ETRS : 3;   /*!< [18..16] TIM2_ETRS */
            } EDU_CFG8_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG9; /*!< (@ 0x00000044) EDU_CFG9 */

            struct
            {
                __IOM uint32_t TIM2_SP : 7;    /*!< [6..0] TIM2_SP */
                __IM uint32_t : 1;
                __IOM uint32_t TIM2_BKSE : 7;  /*!< [14..8] TIM2_BKSE */
                __IM uint32_t : 8;
                __IOM uint32_t TIM2_OCCSE : 6; /*!< [21..16] TIM2_OCCSE */
            } EDU_CFG9_b;
        };

        __IM uint32_t RESERVED1;

        union
        {
            __IOM uint32_t EDU_CFG11; /*!< (@ 0x0000004C) EDU_CFG11 */

            struct
            {
                __IOM uint32_t ADC_EXTSEL0 : 8; /*!< [7..0] ADC input source0 selection */
                __IOM uint32_t ADC_EXTEN0 : 2;  /*!< [9..8] ADC input source0 enable */
                __IOM uint32_t : 6;
                __IOM uint32_t ADC_EXTSEL1 : 8; /*!< [23..16] ADC input source1 selection */
                __IOM uint32_t ADC_EXTEN1 : 2;  /*!< [25..24] ADC input source1 enable */
            } EDU_CFG11_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG12; /*!< (@ 0x00000050) EDU_CFG12 */

            struct
            {
                __IOM uint32_t ADC_EXTSEL2 : 8; /*!< [7..0] ADC input source2 selection */
                __IOM uint32_t ADC_EXTEN2 : 2;  /*!< [9..8] ADC input source2 enable */
                __IOM uint32_t : 6;
                __IOM uint32_t ADC_EXTSEL3 : 8; /*!< [23..16] ADC input source3 selection */
                __IOM uint32_t ADC_EXTEN3 : 2;  /*!< [25..24] ADC input source3 enable */
            } EDU_CFG12_b;
        };

        __IM uint32_t RESERVED2[2];

        union
        {
            __IOM uint32_t EDU_CFG15; /*!< (@ 0x0000005C) EDU_CFG15 */

            struct
            {
                __IOM uint32_t CP0_BLANKING : 8; /*!< [7..0] CP0_BLANKING */
                __IOM uint32_t CP1_BLANKING : 8; /*!< [16..8] CP1_BLANKING */
            } EDU_CFG15_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG16; /*!< (@ 0x00000060) EDU_CFG16 */

            struct
            {
                __IOM uint32_t CP0_EXTEN : 2;   /*!< [1..0] CP0_EXTEN */
                __IOM uint32_t CP1_EXTEN : 2;   /*!< [3..2] CP1_EXTEN */
                __IOM uint32_t CP0_EXTSEL0 : 2; /*!< [5..4] CP0_EXTSEL0 */
                __IOM uint32_t CP0_EXTSEL1 : 2; /*!< [7..6] CP0_EXTSEL1 */
                __IOM uint32_t CP1_EXTSEL0 : 2; /*!< [9..8] CP1_EXTSEL0 */
                __IOM uint32_t CP1_EXTSEL1 : 2; /*!< [11..10] CP1_EXTSEL1 */
                __IOM uint32_t CP0_EXTSP : 2;   /*!< [13..12] CP0_EXTSP */
                __IOM uint32_t CP1_EXTSP : 2;   /*!< [15..14] CP1_EXTSP */
            } EDU_CFG16_b;
        };

        union
        {
            __IOM uint32_t EDU_CFG17; /*!< (@ 0x00000064) EDU_CFG17 */

            struct
            {
                __IOM uint32_t DAC_TEN : 2;  /*!< [1..0] DAC_TEN */
                __IOM uint32_t : 2;
                __IOM uint32_t DAC_TSEL : 3; /*!< [6..4] DAC_TSEL */
            } EDU_CFG17_b;
        };

        __IM uint32_t RESERVED3[5];

        union
        {
            union
            {
                __IOM uint32_t KEY_W; /*!< (@ 0x0000007C) KEY */

                struct
                {
                    __IOM uint32_t KEY : 32; /*!< [31..0] KEY */
                } KEY_W_b;
            };
            union
            {
                __IM uint32_t KEY_R; /*!< (@ 0x0000007C)    */
                struct
                {
                    __IM uint32_t WR_ERR : 1;   /*!< [0..0] WR_ERR */
                    __IM uint32_t LOCK : 1;     /*!< [1..1] LOCK */
                    __IM uint32_t : 6;
                    __IM uint32_t LOCK_CNT : 5; /*!< [12..8] LOCK_CNT */
                    __IM uint32_t : 3;
                } KEY_R_b;
            };
        };
    } SYSCTRL_TypeDef; /*!< Size = 128 (0x80)   */

    /* =========================================================================================================================== */
    /* ================ADC================ */
    /* =========================================================================================================================== */

    /**
     * @brief ADC (ADC)
     */

    typedef struct
    { /*!< (@ 0x4001A000) ADC Structure  */

        union
        {
            __IM uint32_t SR; /*!< (@ 0x00000000) SR */

            struct
            {
                __IM uint32_t READY : 1;     /*!< [0..0] READY */
                __IM uint32_t BUSY : 1;      /*!< [1..1] EOSMP */
                __IM uint32_t : 14;
                __IM uint32_t PENDING : 16;  /*!< [31..16] PENDING */

            } SR_b;
        };

        union
        {
            __IOM uint32_t ISR; /*!< (@ 0x00000004) ISR */

            struct
            {
                __IOM uint32_t AWD : 2;  /*!< [1..0] AWD */
                __IM uint32_t : 13;
                __IOM uint32_t DOF : 1;  /*!< [15..15] DOF */
                __IM uint32_t SDOF : 16; /*!< [31..16] SDOF */

            } ISR_b;
        };

        union
        {
            __IOM uint32_t IER; /*!< (@ 0x00000008) IER */

            struct
            {
                __IOM uint32_t AWDIE : 2;   /*!< [1..0] AWDIE */
                __IM uint32_t : 13;
                __IOM uint32_t DOFIE : 1;   /* [15..15] DOFIE */
            } IER_b;
        };

        union
        {
            __IOM uint32_t SOCISR; /*!< (@ 0x0000000C) SOCISR */

            struct
            {
                __IOM uint32_t EOC : 16; /*!< [15..0] EOC */
                __IOM uint32_t POF : 16; /*!< [31..16] POF */
            } SOCISR_b;
        };

        union
        {
            __IOM uint32_t SOCIER; /*!< (@ 0x00000010) SOCIER */

            struct
            {
                __IOM uint32_t EOCIE : 16; /*!< [15..0] EOCIE */
                __IOM uint32_t POFIE : 16; /*!< [31..16] POFIE */
            } SOCIER_b;
        };

        union
        {
            __IOM uint32_t CR; /*!< (@ 0x00000014) CR */

            struct
            {
                __IOM uint32_t EN : 1;    /*!< [0..0] STOP */
                __IOM uint32_t DIS : 1;   /*!< [1..1] DIS */
                __IOM uint32_t START : 1; /*!< [2..2] START */
                __IOM uint32_t STOP : 1;  /*!< [3..3] STOP */
                __IOM uint32_t : 12;
                __IOM uint32_t SW : 16;   /*!< [31..16] SW */
            } CR_b;
        };

        union
        {
            __IOM uint32_t CFGR; /*!< (@ 0x00000018) CFGR */

            struct
            {
                __IOM uint32_t ALIGN : 1;  /*!< [0..0] ALIGN */
                __IOM uint32_t OVF : 1;    /*!< [1..1] OVF */
                __IOM uint32_t : 10;
                __IOM uint32_t ST : 1;     /*!< [12..12] ST */
                __IOM uint32_t STS : 1;    /*!< [13..13] STS */
                __IOM uint32_t SV : 1;     /*!< [14..14] SV */
                __IOM uint32_t SVS : 1;    /*!< [15..15] SVS */
                __IOM uint32_t LP : 1;     /*!< [16..16] LP */
                __IOM uint32_t VFS : 1;    /*!< [17..17] VFS */
                __IOM uint32_t VREF : 1;   /*!< [18..18] VREF */
                __IOM uint32_t MD2 : 1;    /*!< [19..19] MD2 */
                __IOM uint32_t : 7;
                __IOM uint32_t CKMODE : 5; /*!< [31..27] CKMODE */
            } CFGR_b;
        };

        union
        {
            __IOM uint32_t SMPR; /*!< (@ 0x0000001C) SMPR */

            struct
            {
                __IOM uint32_t APW : 3;   /*!< [2..0] APW */
                __IM uint32_t : 1;
                __IOM uint32_t SPW : 4;   /*!< [7..4] SPW */
                __IOM uint32_t CPW : 2;   /*!< [9..8] CPW */
                __IM uint32_t : 2;
                __IOM uint32_t CC : 4;    /*!< [13..12] CC */
                __IM uint32_t : 4;
                __IOM uint32_t STSPW : 2; /*!< [21..20] STSPW */
            } SMPR_b;
        };

        union
        {
            __IOM uint32_t TRIM; /*!< (@ 0x00000020) TRIM */

            struct
            {
                __IOM uint32_t GAIN_TRIM : 8; /*!< [7..0] GAIN_TRIM */
                __IM uint32_t : 8;
                __IOM uint32_t VOS_TRIM : 8;  /*!< [23..160] STSPW */
            } TRIM_b;
        };

        union
        {
            __IOM uint32_t ANA; /*!< (@ 0x00000024) ANA */

            struct
            {
                __IM uint32_t : 12;
                __IOM uint32_t PD_SHA : 1;   /*!< [12..12] PD_SHA */
                __IOM uint32_t PD_SHB : 1;   /*!< [13..13] PD_SHB */
                __IOM uint32_t PD_REF : 1;   /*!< [14..14] PD_REF */
                __IOM uint32_t PD_ADC : 1;   /*!< [15..15] PD_ADC */
            } ANA_b;
        };

        union
        {
            __IOM uint32_t DMACFG; /*!< (@ 0x00000028) DMACFG */

            struct
            {
                __IOM uint32_t DREQ : 16; /*!< [15..0] DREQ */
                __IOM uint32_t DEN : 16;  /*!< [31..16] DEN */
            } DMACFG_b;
        };

        union
        {
            __IM uint32_t DADDR; /*!< (@ 0x0000002C) DADDR */

            struct
            {
                __IM uint32_t DMA_DATA : 16; /*!< [15..0] DMA_DATA */
            } DADDR_b;
        };

        __IM uint32_t RESERVED0[4];

        union
        {
            __IOM uint32_t AWD0_CFGR; /*!< (@ 0x00000040) AWD0_CFGR */

            struct
            {
                __IOM uint32_t AWDSEL : 16; /*!< [15..0] AWDSEL */
            } AWD0_CFGR_b;
        };

        union
        {
            __IOM uint32_t AWD1_CFGR; /*!< (@ 0x00000044) AWD1_CFGR */

            struct
            {
                __IOM uint32_t AWDSEL : 16; /*!< [15..0] AWDSEL */
            } AWD1_CFGR_b;
        };

        __IM uint32_t RESERVED1[2];

        union
        {
            __IOM uint32_t AWD0_TR; /*!< (@ 0x00000050) AWD0_TR */

            struct
            {
                __IOM uint32_t LT : 12; /*!< [11..0] LT */
                __IM uint32_t : 4;
                __IOM uint32_t HT : 12; /*!< [27..16] HT */
            } AWD0_TR_b;
        };

        union
        {
            __IOM uint32_t AWD1_TR; /*!< (@ 0x00000054) AWD1_TR */

            struct
            {
                __IOM uint32_t LT : 12; /*!< [11..0] LT */
                __IM uint32_t : 4;
                __IOM uint32_t HT : 12; /*!< [27..16] HT */
            } AWD1_TR_b;
        };

        __IM uint32_t RESERVED2[2];

        union
        {
            __IOM uint32_t EXTCFGR0; /*!< (@ 0x00000060) EXTCFGR0 */
            struct
            {
                __IOM uint32_t DLY0 : 8; /*!< [7..0] DLY0 */
                __IOM uint32_t DLY1 : 8; /*!< [7..0] DLY1 */
                __IOM uint32_t DLY2 : 8; /*!< [7..0] DLY2 */
                __IOM uint32_t DLY3 : 8; /*!< [7..0] DLY3 */
            } EXTCFGR0_b;
        };

        __IM uint32_t RESERVED3[7];

        union
        {
            __IOM uint32_t ADCSOC0; /*!< (@ 0x00000080) ADCSOC0 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC0_b;
        };

        union
        {
            __IOM uint32_t ADCSOC1; /*!< (@ 0x00000084) ADCSOC1 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC1_b;
        };

        union
        {
            __IOM uint32_t ADCSOC2; /*!< (@ 0x00000088) ADCSOC2 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC2_b;
        };

        union
        {
            __IOM uint32_t ADCSOC3; /*!< (@ 0x0000008C) ADCSOC3 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC3_b;
        };

        union
        {
            __IOM uint32_t ADCSOC4; /*!< (@ 0x00000090) ADCSOC4 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC4_b;
        };

        union
        {
            __IOM uint32_t ADCSOC5; /*!< (@ 0x00000094) ADCSOC5 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC5_b;
        };

        union
        {
            __IOM uint32_t ADCSOC6; /*!< (@ 0x00000098) ADCSOC6 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC6_b;
        };

        union
        {
            __IOM uint32_t ADCSOC7; /*!< (@ 0x0000009C) ADCSOC7 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC7_b;
        };

        union
        {
            __IOM uint32_t ADCSOC8; /*!< (@ 0x000000A0) ADCSOC8 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC8_b;
        };

        union
        {
            __IOM uint32_t ADCSOC9; /*!< (@ 0x000000A4) ADCSOC9 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC9_b;
        };

        union
        {
            __IOM uint32_t ADCSOC10; /*!< (@ 0x000000A8) ADCSOC10 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC10_b;
        };

        union
        {
            __IOM uint32_t ADCSOC11; /*!< (@ 0x000000AC) ADCSOC11 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC11_b;
        };

        union
        {
            __IOM uint32_t ADCSOC12; /*!< (@ 0x000000B0) ADCSOC12 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC12_b;
        };

        union
        {
            __IOM uint32_t ADCSOC13; /*!< (@ 0x000000B4) ADCSOC13 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC13_b;
        };

        union
        {
            __IOM uint32_t ADCSOC14; /*!< (@ 0x000000B8) ADCSOC14 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC14_b;
        };

        union
        {
            __IOM uint32_t ADCSOC15; /*!< (@ 0x000000BC) ADCSOC15 */
            struct
            {
                __IOM uint32_t CHSEL : 4;   /*!< [3..0] Trigger source  selection */
                __IOM uint32_t TRIGSEL : 3; /*!< [6..4] SOC Channel selection */
                __IOM uint32_t FP : 1;      /*!< [7..7] FP */
                __IOM uint32_t CON : 1;     /*!< [8..8] CON */
            } ADCSOC15_b;
        };

        union
        {
            __IOM uint32_t DR0; /*!< (@ 0x000000C0) DR0 */
            struct
            {
                __IOM uint32_t DATA0 : 16; /*!< [15..0] DATA */
            } DR0_b;
        };

        union
        {
            __IOM uint32_t DR1; /*!< (@ 0x000000C4) DR1 */
            struct
            {
                __IOM uint32_t DATA1 : 16; /*!< [15..0] DATA */
            } DR1_b;
        };

        union
        {
            __IOM uint32_t DR2; /*!< (@ 0x000000C8) DR2 */
            struct
            {
                __IOM uint32_t DATA2 : 16; /*!< [15..0] DATA */
            } DR2_b;
        };

        union
        {
            __IOM uint32_t DR3; /*!< (@ 0x000000CC) DR3 */
            struct
            {
                __IOM uint32_t DATA3 : 16; /*!< [15..0] DATA */
            } DR3_b;
        };

        union
        {
            __IOM uint32_t DR4; /*!< (@ 0x000000D0) DR4 */
            struct
            {
                __IOM uint32_t DATA4 : 16; /*!< [15..0] DATA */
            } DR4_b;
        };

        union
        {
            __IOM uint32_t DR5; /*!< (@ 0x000000D4) DR5 */
            struct
            {
                __IOM uint32_t DATA5 : 16; /*!< [15..0] DATA */
            } DR5_b;
        };

        union
        {
            __IOM uint32_t DR6; /*!< (@ 0x000000D8) DR6 */
            struct
            {
                __IOM uint32_t DATA6 : 16; /*!< [15..0] DATA */
            } DR6_b;
        };

        union
        {
            __IOM uint32_t DR7; /*!< (@ 0x000000DC) DR7 */
            struct
            {
                __IOM uint32_t DATA7 : 16; /*!< [15..0] DATA */
            } DR7_b;
        };

        union
        {
            __IOM uint32_t DR8; /*!< (@ 0x000000E0) DR8 */
            struct
            {
                __IOM uint32_t DATA8 : 16; /*!< [15..0] DATA  */
            } DR8_b;
        };

        union
        {
            __IOM uint32_t DR9; /*!< (@ 0x000000E4) DR9 */
            struct
            {
                __IOM uint32_t DATA9 : 16; /*!< [15..0] DATA */
            } DR9_b;
        };

        union
        {
            __IOM uint32_t DR10; /*!< (@ 0x000000E8) DR10 */
            struct
            {
                __IOM uint32_t DATA10 : 16; /*!< [15..0] DATA */
            } DR10_b;
        };

        union
        {
            __IOM uint32_t DR11; /*!< (@ 0x000000EC) DR11 */
            struct
            {
                __IOM uint32_t DATA11 : 16; /*!< [15..0] DATA */
            } DR11_b;
        };

        union
        {
            __IOM uint32_t DR12; /*!< (@ 0x000000F0) DR12 */
            struct
            {
                __IOM uint32_t DATA12 : 16; /*!< [15..0] DATA */
            } DR12_b;
        };

        union
        {
            __IOM uint32_t DR13; /*!< (@ 0x000000F4) DR13 */
            struct
            {
                __IOM uint32_t DATA13 : 16; /*!< [15..0] DATA */
            } DR13_b;
        };

        union
        {
            __IOM uint32_t DR14; /*!< (@ 0x000000F8) DR14 */
            struct
            {
                __IOM uint32_t DATA14 : 16; /*!< [15..0] DATA */
            } DR14_b;
        };

        union
        {
            __IOM uint32_t DR15; /*!< (@ 0x000000FC) DR15 */
            struct
            {
                __IOM uint32_t DATA15 : 16; /*!< [15..0] DATA */
            } DR15_b;
        };

    } ADC_TypeDef; /*!< Size = 256 (0x100)    */

    /* =========================================================================================================================== */
    /* ================    IWDG================ */
    /* =========================================================================================================================== */

    /**
     * @brief IWDG (IWDG)
     */

    typedef struct
    { /*!< (@ 0x40017400) IWDG Structure */

        union
        {
            __IOM uint32_t KR; /*!< (@ 0x00000000) KR */

            struct
            {
                __IOM uint32_t KEY : 16; /*!< [15..0] KEY */
            } KR_b;
        };

        union
        {
            __IOM uint32_t PR; /*!< (@ 0x00000004) PR */

            struct
            {
                __IOM uint32_t PR : 3; /*!< [2..0] PR */
            } PR_b;
        };

        union
        {
            __IOM uint32_t RLR; /*!< (@ 0x00000008) RLR */

            struct
            {
                __IOM uint32_t RLR : 12; /*!< [11..0] RL */
            } RLR_b;
        };

        union
        {
            __IOM uint32_t SR; /*!< (@ 0x0000000C) SR */

            struct
            {
                __IOM uint32_t PVU : 1; /*!< [0..0] PVU */
                __IOM uint32_t RVU : 1; /*!< [1..1] RVU */
                __IOM uint32_t WVU : 1; /*!< [2..2] WVU */
            } SR_b;
        };

        union
        {
            __IOM uint32_t WINR; /*!< (@ 0x00000010) WINR */

            struct
            {
                __IOM uint32_t WIN : 12; /*!< [11..0] WIN */
            } WINR_b;
        };
    } IWDG_TypeDef; /*!< Size = 20 (0x14)    */

    /* =========================================================================================================================== */
    /* ================ DIV================ */
    /* =========================================================================================================================== */

    /**
     * @brief DIV0 (DIV0)
     */
    typedef struct
    { /*!< (@ 0x48015000) DIV0 Structure */
        union
        {
            __IOM uint32_t DIV_CTRL; /*!< (@ 0x00000000) DIV_CTRL */
            struct
            {
                __IOM uint32_t DIV_RST : 1;         /*!< [0..0] DIV_RST */
                __IOM uint32_t DIV_IN_PROCCEED : 1; /*!< [1..1] DIV_IN_PROCCEED */
                __IOM uint32_t DIV_ALO_WRITED : 1;  /*!< [2..2] DIV_ALO_WRITED */
                __IM uint32_t : 1;
                __IOM uint32_t DIV_B_WRITED : 1;    /*!< [4..4] DIV_B_WRITED */
                __IM uint32_t : 3;
                __IOM uint32_t DIV16 : 1;           /*!< [8..8] DIV16 */
                __IM uint32_t : 15;
                __IM uint32_t DIV0F : 1;             /*!< [24..24] DIV0F */
                __IOM uint32_t DIV0_INTREN : 1;     /*!< [25..25] DIV0_INTREN */
            } DIV_CTRL_b;
        };
        union
        {
            __IOM uint32_t DIV_ALO; /*!< (@ 0x00000004) DIV_ALO */
            struct
            {
                __IOM uint32_t DIV_ALO : 32;    /*!< [31..0] DIV_ALO */
            } DIV_ALOO_b;
        };

        __IM uint32_t RESERVED0;

        union
        {
            __IOM uint32_t DIV_B; /*!< (@ 0x0000000C) DIV_B */
            struct
            {
                __IOM uint32_t DIV_B : 32;     /*!< [31..0] DIV_B */
            } DIV_B_b;
        };
        union
        {
            __IOM uint32_t DIV_QUOT; /*!< (@ 0x00000010) DIV_QUOT */
            struct
            {
                __IM uint32_t DIV_QUOT : 32;    /*!< [31..0] DIV_QUOT */
            } DIV_QUOT_b;
        };
    
        __IM uint32_t RESERVED1;

        union
        {
            __IOM uint32_t DIV_REM; /*!< (@ 0x00000018) DIV_REM */
            struct
            {
                __IM uint32_t DIV_REM : 32;     /*!< [31..0] DIV_REM */
            } DIV_REM_b;
        };
    } DIV_TypeDef;

#if defined (LCM32F067) || defined (LCM32F063) || defined (LCM32CF6990)
    /* =========================================================================================================================== */
    /* ================ CORDIC ================ */
    /* =========================================================================================================================== */
    /**
     * @brief CORDIC (CORDIC)
     */
    typedef struct
    { /*!< (@ 0x48010000) CORDIC Structure */
        union
        {
            __IOM uint32_t CTRL; /*!< (@ 0x00000000) CTRL */
            struct
            {
                __IOM uint32_t DONE : 1;        /*!< [0..0] DONE */
                __IOM uint32_t OVF : 1;         /*!< [1..1] OVF */
                __IM uint32_t : 2;
                __IOM uint32_t DONE_INTEN : 1;  /*!< [4..4] DONE_INTEN */
                __IOM uint32_t OVF_INTEN : 1;   /*!< [5..5] OVF_INTEN */
                __IM uint32_t : 2;
                __IOM uint32_t START : 1;       /*!< [8..8] START */
            } CTRL_b;
        };

        union
        {
            __IOM uint32_t CFG; /*!< (@ 0x00000004) CFG */
            struct
            {
                __IOM uint32_t KEEPX : 1;           /*!< [0..0] KEEPX */
                __IOM uint32_t KEEPY : 1;           /*!< [1..1] KEEPY */
                __IOM uint32_t KEEPZ : 1;           /*!< [2..2] KEEPZ */
                __IM uint32_t : 1;
                __IOM uint32_t BYPASS_PRE : 1;      /*!< [4..4] BYPASS_PRE */
                __IOM uint32_t BYPASS_POST : 1;     /*!< [5..5] BYPASS_POST */
                __IM uint32_t : 2;
                __IOM uint32_t MODE : 1;            /*!< [8..8] MODE */
                __IM uint32_t : 3;
                __IOM uint32_t FUNC : 2;            /*!< [13..12] FUNC */
                __IM uint32_t : 2;
                __IOM uint32_t CYCLES : 5;          /*!< [20..16] CYCLES */
            } CFG_b;
        };

        __IOM uint32_t RESERVED0;

        union
        {
            __IOM uint32_t XI; /*!< (@ 0x0000000C) XI */
            struct
            {
                __IOM uint32_t XI : 32;  /*!< [31..0] XI */
            } XI_b;
        };

        union
        {
            __IOM uint32_t YI; /*!< (@ 0x00000010) YI */
            struct
            {
                __IOM uint32_t YI : 32;  /*!< [31..0] YI */
            } YI_b;
        };

        union
        {
            __IOM uint32_t ZI; /*!< (@ 0x00000014) ZI */
            struct
            {
                __IOM uint32_t ZI : 32;  /*!< [31..0] ZI */
            } ZI_b;
        };

        union
        {
            __IOM uint32_t XO; /*!< (@ 0x00000018) XO */
            struct
            {
                __IOM uint32_t XO : 32;  /*!< [31..0] XO */
            } XO_b;
        };

        union
        {
            __IOM uint32_t YO; /*!< (@ 0x0000001C) YO */
            struct
            {
                __IOM uint32_t YO : 32;  /*!< [31..0] YO */
            } YO_b;
        };

        union
        {
            __IOM uint32_t ZO; /*!< (@ 0x00000020) ZO */
            struct
            {
                __IOM uint32_t ZO : 32;  /*!< [31..0] ZO */
            } ZO_b;
        };

    } CORDIC_TypeDef;
    
#elif defined (LCM32F062)
  /* None Cordic */
#endif

    /* =========================================================================================================================== */
    /* ================ CRC================ */
    /* =========================================================================================================================== */

    /**
     * @brief CRC (CRC)
     */
    typedef struct
    { /*!< (@ 0x48011000) CRC Structure */
        union
        {
            __IOM uint32_t CRC_CTRL; /*!< (@ 0x00000000) CRC_CTRL */
            struct
            {
                __IOM uint32_t CRC_SRSTALL : 1; /*!< [0..0] CRC_SRSTALL */
                __IOM uint32_t CRC_SRST : 1;    /*!< [1..1] CRC_SRST */
                __IOM uint32_t CRC_VALID : 1;   /*!< [2..2] CRC_VALID */
                __IM uint32_t : 5;
                __IOM uint32_t CRC_BYTE : 2;    /*!< [9..8] CRC_BYTE */
                __IM uint32_t : 5;
                __IOM uint32_t CRC_INTV_EN : 1; /*!< [15..15] CRC_INTV_EN */
                __IOM uint32_t CRC_LMS : 1;     /*!< [16..16] CRC_LMS */
                __IOM uint32_t CRC_SWAP : 2;    /*!< [18..17] CRC_SWAP */
                __IM uint32_t : 5;
                __IOM uint32_t CRC_GPS : 2;     /*!< [25..24] CRC_GPS */
            } CRC_CTRL_b;
        };
        union
        {
            __IOM uint32_t CRC_DATA; /*!< (@ 0x00000004) CRC_DATA */
            struct
            {
                __IM uint32_t DATA : 32;    /*!< [31..0] DATA */
            } CRC_DATA_b;
        };
        union
        {
            __IOM uint32_t CRC_RESULT; /*!< (@ 0x00000008) CRC_RESULT */
            struct
            {
                __IM uint32_t RESULT : 32;  /*!< [31..0] RESULT */
            } CRC_RESULT_b;
        };
    } CRC_TypeDef;

    /* =========================================================================================================================== */
    /* =================== WT ================== */
    /* =========================================================================================================================== */

    typedef struct
    { /*!< (@ 0x40017A00) Watch Timer */

        union
        {
            __IOM uint32_t WTCON; /*!< (@ 0x00000000) WTCON */

            struct
            {
                __IOM uint32_t WTINTS : 1; /*!< [0..0] WTINTS */
                __IOM uint32_t T8CKS : 2;  /*!< [2..1] T8CKS */
                __IOM uint32_t TR8 : 1;    /*!< [3..3] TR8 */
                __IOM uint32_t BUZS : 2;   /*!< [5..4] BUZS */
                __IOM uint32_t WTF : 1;    /*!< [6..6] WTF */
                __IOM uint32_t WTEN : 1;   /*!< [7..7] WTEN */
                __IOM uint32_t BZLS : 1;   /*!< [8..8] BZLS */
            } WTCON_b;
        };

        union
        {
            __IOM uint32_t T8; /*!< (@ 0x00000004) T8 */

            struct
            {
                __IOM uint32_t T8 : 8; /*!< [7..0] T8 */
            } T8_b;
        };
    } WT_TypeDef; /*!< Size = 32 (0x20)  */
    
    /* =========================================================================================================================== */
    /* ================    OB    ================ */
    /* =========================================================================================================================== */
    typedef struct
    {
      __IO uint16_t USER; //0x1FFFF600
      /*
      __IO uint16_t DATA0;//0x1FFFF602
      __IO uint32_t DATA1;//0x1FFFF604
      __IO uint32_t DATA2;//0x1FFFF606
      */
      __IO uint16_t DATA[3];
      /*
      __IO uint16_t WRP0;//0x1FFFF608 //<FLASH option byte write protection 0,
      __IO uint16_t WRP1;//0x1FFFF60A //<FLASH option byte write protection 1,
      __IO uint16_t WRP2;//0x1FFFF60C //<FLASH option byte write protection 2,
      __IO uint16_t WRP3;//0x1FFFF60E //<FLASH option byte write protection 3,
      */
      __IO uint16_t WRP[4];
      /*
      __IO uint16_t RDP0;//0x1FFFF610
      __IO uint16_t RDP1;//0x1FFFF612
      __IO uint16_t RDP2;//0x1FFFF614
      __IO uint16_t RDP3;//0x1FFFF616
      __IO uint16_t RDP4;//0x1FFFF618
      __IO uint16_t RDP5;//0x1FFFF61A
      __IO uint16_t RDP6;//0x1FFFF61C
      __IO uint16_t RDP7;//0x1FFFF61E
      */
      __IO uint16_t RDP[8];
      /*
      __IO uint16_t RDP8; //0x1FFFF620
      __IO uint16_t RDP9; //0x1FFFF622
      __IO uint16_t RDP10;//0x1FFFF624
      __IO uint16_t RDP11;//0x1FFFF626
      */
      __IO uint16_t RDP2[4];
    } OB_TypeDef;

    /** @} */ /* End of group Device_Peripheral_peripherals */

    /* =========================================================================================================================== */
    /* ================    Device Specific Peripheral Address Map================ */
    /* =========================================================================================================================== */

    /** @addtogroup Device_Peripheral_peripheralAddr
     * @{
     */
/* APB0 */
#define TIM1_BASE       (0x40010000UL)
#define EXTI_BASE       (0x40011000UL)
#define I2C0_BASE       (0x40013000UL)
#define USART0_BASE     (0x40014000UL)
#define USART1_BASE     (0x40015000UL)
#define CHIPCTRL_BASE   (0x40017000UL)
#define IWDG_BASE       (0x40017400UL)
#define WT_BASE         (0x40017A00UL)
#define ANACTRL_BASE    (0x40017C00UL)
#define OPA0_BASE       (ANACTRL_BASE + 0x00000000)
#define OPA1_BASE       (ANACTRL_BASE + 0x00000004)
#define OPA2_BASE       (ANACTRL_BASE + 0x00000008)
#define SPI0_BASE       (0x40018000UL)
#define ADC_BASE        (0x4001A000UL)
#define TIM15_BASE      (0x4001B000UL)
#define TIM16_BASE      (0x4001C000UL)
#define FLASH_BASE      (0x4001D000UL)
#define TIM17_BASE      (0x4001E000UL)
#define TIM2_BASE       (0x4001F000UL)

/* AHB0 */
#define GPIOA_BASE      (0x48000000UL)
#define GPIOB_BASE      (0x48000200UL)
#define DMAC_BASE       (0x48004000UL)
#define DMAC_CH0        (0x48004000UL)
#define DMAC_CH1        (0x48004058UL)
#define SYSCTRL_BASE    (0x48007000UL)

/* AHB1 */
#define CORDIC_BASE     (0x48010000UL)
#define CRC0_BASE       (0x48011000UL)
#define DIV0_BASE       (0x48015000UL)

#define OB_BASE         (0x1FFFF600UL)

    /** @} */ /* End of group Device_Peripheral_peripheralAddr */

    /* =========================================================================================================================== */
    /* ================Peripheral declaration ================ */
    /* =========================================================================================================================== */

    /** @addtogroup Device_Peripheral_declaration
     * @{
     */

#define USART0          ((USART_TypeDef *)USART0_BASE)
#define USART1          ((USART_TypeDef *)USART1_BASE)

#define I2C0            ((I2C_TypeDef *)I2C0_BASE)

#define TIM1            ((TIM_TypeDef *)TIM1_BASE)
#define TIM2            ((TIM_TypeDef *)TIM2_BASE)
#define TIM15           ((TIM_TypeDef *)TIM15_BASE)
#define TIM16           ((TIM_TypeDef *)TIM16_BASE)
#define TIM17           ((TIM_TypeDef *)TIM17_BASE)

#define SPI0            ((SPI_TypeDef *)SPI0_BASE)

#define DMA1            ((DMAC_TypeDef *)DMAC_BASE)
#define DMA1_Channel0   ((DMA_Channel_TypeDef *)DMAC_CH0)
#define DMA1_Channel1   ((DMA_Channel_TypeDef *)DMAC_CH1)

#define FLASH           ((FLASH_TypeDef *)FLASH_BASE)

#define GPIOA           ((GPIO_TypeDef *)GPIOA_BASE)
#define GPIOB           ((GPIO_TypeDef *)GPIOB_BASE)

#define EXTI            ((EXTI_TypeDef *)EXTI_BASE)

#define ACMP            ((ACMP_TypeDef *)(ANACTRL_BASE))
#define DAC             ((DAC_TypeDef *)(ANACTRL_BASE))

#if defined (LCM32F067) || defined (LCM32F063)  || defined (LCM32CF6990)
#define OPA0            ((OPA_TypeDef *)(OPA0_BASE))
#define OPA1            ((OPA_TypeDef *)(OPA1_BASE))
#define OPA2            ((OPA_TypeDef *)(OPA2_BASE))
#elif defined (LCM32F062)
  /* None OPA */
#endif

#define ANACTRL         ((ANACTRL_TypeDef *)ANACTRL_BASE)
#define CHIPCTRL        ((CHIPCTRL_TypeDef *)CHIPCTRL_BASE)
#define SYSCTRL         ((SYSCTRL_TypeDef *)SYSCTRL_BASE)

#define ADC             ((ADC_TypeDef *)ADC_BASE)
#define IWDG            ((IWDG_TypeDef *)IWDG_BASE)
#define DIV0            ((DIV_TypeDef *)DIV0_BASE)
#define CRC0            ((CRC_TypeDef *)CRC0_BASE)
#define WT              ((WT_TypeDef *)WT_BASE)

#if defined (LCM32F067) || defined (LCM32F063) || defined (LCM32CF6990)
#define CORDIC          ((CORDIC_TypeDef *)CORDIC_BASE)
#elif defined (LCM32F062)
  /* None Cordic */
#endif

#define OB              ((OB_TypeDef *)OB_BASE)


/** @} */ /* End of group Device_Peripheral_declaration */

/* =========================================  End of section using anonymous unions  ============================================= */
#if defined(__CC_ARM)
#pragma pop
#elif defined(__ICCARM__)
/* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic pop
#elif defined(__GNUC__)
/* anonymous unions are enabled by default */
#elif defined(__TMS470__)
/* anonymous unions are enabled by default */
#elif defined(__TASKING__)
#pragma warning restore
#elif defined(__CSMC__)
/* anonymous unions are enabled by default */
#endif

/* ========================================================================== */
/* ====================             CHIPCTRL             ==================== */
/* ========================================================================== */

/* ==================================  CLK_CFG  ============================= */
#define CHIPCTRL_CLK_CFG_SYS_SRC_SEL_Pos          (20UL)                       /*!< SYS_SRC_SEL (Bit 20)                   */
#define CHIPCTRL_CLK_CFG_SYS_SRC_SEL_Msk          (0x00300000UL)               /*!< SYS_SRC_SEL (Bitfield-Mask: 0x03)      */
#define CHIPCTRL_CLK_CFG_RCH_EN_Pos               (19UL)                       /*!< RCH_EN (Bit 19)                        */
#define CHIPCTRL_CLK_CFG_RCH_EN_Msk               (0x00080000UL)               /*!< RCH_EN (Bitfield-Mask: 0x01)           */
#define CHIPCTRL_CLK_CFG_PLL_EN_Pos               (16UL)                       /*!< PLL_EN (Bit 16)                        */
#define CHIPCTRL_CLK_CFG_PLL_EN_Msk               (0x00010000UL)               /*!< PLL_EN (Bitfield-Mask: 0x01)           */
#define CHIPCTRL_CLK_CFG_APB0_DIV_Pos             (12UL)                       /*!< APB0_DIV (Bit 12)                      */
#define CHIPCTRL_CLK_CFG_APB0_DIV_Msk             (0x0000F000UL)               /*!< APB0_DIV (Bitfield-Mask: 0x0F)         */
#define CHIPCTRL_CLK_CFG_SYS_CLK_SEL_Pos          (0UL)                        /*!< SYS_CLK_SEL (Bit 0)                    */
#define CHIPCTRL_CLK_CFG_SYS_CLK_SEL_Msk          (0x000000FFUL)               /*!< SYS_CLK_SEL (Bitfield-Mask: 0xFF)      */
/* ================================  PWR_CFG  =============================== */
#define CHIPCTRL_PWR_CFG_OP_ISEL_Pos              (28UL)                       /*!< OP_ISEL (Bit 28)                       */
#define CHIPCTRL_PWR_CFG_OP_ISEL_Msk              (0x70000000UL)               /*!< OP_ISEL (Bitfield-Mask: 0x07)          */
#define CHIPCTRL_PWR_CFG_AOUT_EN_Pos              (13UL)                       /*!< AOUT_EN (Bit 13)                       */
#define CHIPCTRL_PWR_CFG_AOUT_EN_Msk              (0x00002000UL)               /*!< AOUT_EN (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_PWR_CFG_LVDS_Pos                 (10UL)                       /*!< LVDS (Bit 10)                          */
#define CHIPCTRL_PWR_CFG_LVDS_Msk                 (0x00001C00UL)               /*!< LVDS (Bitfield-Mask: 0x07)             */
#define CHIPCTRL_PWR_CFG_LVDES_Pos                (9UL)                        /*!< LVDES (Bit 9)                          */
#define CHIPCTRL_PWR_CFG_LVDES_Msk                (0x00000200UL)               /*!< LVDES (Bitfield-Mask: 0x01)            */
#define CHIPCTRL_PWR_CFG_LVDEN_Pos                (8UL)                        /*!< LVDEN (Bit 8)                          */
#define CHIPCTRL_PWR_CFG_LVDEN_Msk                (0x00000100UL)               /*!< LVDEN (Bitfield-Mask: 0x01)            */
#define CHIPCTRL_PWR_CFG_AOUT_SEL_Pos             (5UL)                        /*!< AOUT_SEL (Bit 5)                       */
#define CHIPCTRL_PWR_CFG_AOUT_SEL_Msk             (0x000000E0UL)               /*!< AOUT_SEL (Bitfield-Mask: 0x07)         */
#define CHIPCTRL_PWR_CFG_LVRS_Pos                 (1UL)                        /*!< LVRS (Bit 1)                           */
#define CHIPCTRL_PWR_CFG_LVRS_Msk                 (0x0000000EUL)               /*!< LVRS (Bitfield-Mask: 0x07)             */
#define CHIPCTRL_PWR_CFG_LVREN_Pos                (0UL)                        /*!< LVREN (Bit 0)                          */
#define CHIPCTRL_PWR_CFG_LVREN_Msk                (0x00000001UL)               /*!< LVREN (Bitfield-Mask: 0x01)            */
/* =================================  CTRL  ================================= */
#define CHIPCTRL_CTRL_LOCKUPEN_Pos                (30UL)                       /*!< LOCKUPEN (Bit 30)                      */
#define CHIPCTRL_CTRL_LOCKUPEN_Msk                (0x40000000UL)               /*!< LOCKUPEN (Bitfield-Mask: 0x01)         */
#define CHIPCTRL_CTRL_LVD_LOCK_Pos                (29UL)                       /*!< LVD_LOCK (Bit 29)                      */
#define CHIPCTRL_CTRL_LVD_LOCK_Msk                (0x20000000UL)               /*!< LVD_LOCK (Bitfield-Mask: 0x01)         */
#define CHIPCTRL_CTRL_PLL_IP_Pos                  (26UL)                       /*!< PLL_IP (Bit 26)                        */
#define CHIPCTRL_CTRL_PLL_IP_Msk                  (0x04000000UL)               /*!< PLL_IP (Bitfield-Mask: 0x01)           */
#define CHIPCTRL_CTRL_OSCL_IP_Pos                 (24UL)                       /*!< OSCL_IP (Bit 24)                       */
#define CHIPCTRL_CTRL_OSCL_IP_Msk                 (0x01000000UL)               /*!< OSCL_IP (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_CTRL_SRAM_IE_Pos                 (14UL)                       /*!< SRAM_IE (Bit 14)                       */
#define CHIPCTRL_CTRL_SRAM_IE_Msk                 (0x00004000UL)               /*!< SRAM_IE (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_CTRL_DF_IE_Pos                   (13UL)                       /*!< DF_IE (Bit 13)                         */
#define CHIPCTRL_CTRL_DF_IE_Msk                   (0x00002000UL)               /*!< DF_IE (Bitfield-Mask: 0x01)            */
#define CHIPCTRL_CTRL_IF_IE_Pos                   (12UL)                       /*!< IF_IE (Bit 12)                         */
#define CHIPCTRL_CTRL_IF_IE_Msk                   (0x00001000UL)               /*!< IF_IE (Bitfield-Mask: 0x01)            */
#define CHIPCTRL_CTRL_HF_ROM_EN_Pos               (10UL)                       /*!< HF_ROM_EN (Bit 10)                     */
#define CHIPCTRL_CTRL_HF_ROM_EN_Msk               (0x00000400UL)               /*!< HF_ROM_EN (Bitfield-Mask: 0x01)        */
#define CHIPCTRL_CTRL_SRAM_P_EN_Pos               (9UL)                        /*!< SRAM_P_EN (Bit 9)                      */
#define CHIPCTRL_CTRL_SRAM_P_EN_Msk               (0x00000200UL)               /*!< SRAM_P_EN (Bitfield-Mask: 0x01)        */
#define CHIPCTRL_CTRL_FLASH_P_EN_Pos              (8UL)                        /*!< FLASH_P_EN (Bit 8)                     */
#define CHIPCTRL_CTRL_FLASH_P_EN_Msk              (0x00000100UL)               /*!< FLASH_P_EN (Bitfield-Mask: 0x01)       */
#define CHIPCTRL_CTRL_CLKEN_ERR_IE_Pos            (6UL)                        /*!< CLKEN_ERR_IE (Bit 6)                   */
#define CHIPCTRL_CTRL_CLKEN_ERR_IE_Msk            (0x00000040UL)               /*!< CLKEN_ERR_IE (Bitfield-Mask: 0x01)     */
#define CHIPCTRL_CTRL_CLKMUX_ERR_IE_Pos           (5UL)                        /*!< CLKMUX_ERR_IE (Bit 5)                  */
#define CHIPCTRL_CTRL_CLKMUX_ERR_IE_Msk           (0x00000020UL)               /*!< CLKMUX_ERR_IE (Bitfield-Mask: 0x01)    */
#define CHIPCTRL_CTRL_PLL_IE_Pos                  (4UL)                        /*!< PLL_IE (Bit 4)                         */
#define CHIPCTRL_CTRL_PLL_IE_Msk                  (0x00000010UL)               /*!< PLL_IE (Bitfield-Mask: 0x01)           */
#define CHIPCTRL_CTRL_OSCL_IE_Pos                 (2UL)                        /*!< OSCL_IE (Bit 2)                        */
#define CHIPCTRL_CTRL_OSCL_IE_Msk                 (0x00000004UL)               /*!< OSCL_IE (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_CTRL_RCH_IE_Pos                  (1UL)                        /*!< RCH_IE (Bit 1)                         */
#define CHIPCTRL_CTRL_RCH_IE_Msk                  (0x00000002UL)               /*!< RCH_IE (Bitfield-Mask: 0x01)           */
#define CHIPCTRL_CTRL_RCL_IE_Pos                  (0UL)                        /*!< RCL_IE (Bit 0)                         */
#define CHIPCTRL_CTRL_RCL_IE_Msk                  (0x00000001UL)               /*!< RCL_IE (Bitfield-Mask: 0x01)           */
/* ================================  PLL_CFG  =============================== */
#define CHIPCTRL_PLL_CFG_PLL_OD_Pos               (12UL)                       /*!< PLL_OD (Bit 12)                        */
#define CHIPCTRL_PLL_CFG_PLL_OD_Msk               (0x00001000UL)               /*!< PLL_OD (Bitfield-Mask: 0x01)           */
#define CHIPCTRL_PLL_CFG_PLL_SEL_Pos              (11UL)                       /*!< PLL_SEL (Bit 11)                       */
#define CHIPCTRL_PLL_CFG_PLL_SEL_Msk              (0x00000800UL)               /*!< PLL_SEL (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_PLL_CFG_PLL_MODE_Pos             (10UL)                       /*!< PLL_MODE (Bit 10)                      */
#define CHIPCTRL_PLL_CFG_PLL_MODE_Msk             (0x00000400UL)               /*!< PLL_MODE (Bitfield-Mask: 0x01)         */
#define CHIPCTRL_PLL_CFG_PLL_DM_Pos               (8UL)                        /*!< PLL_DM (Bit 8)                         */
#define CHIPCTRL_PLL_CFG_PLL_DM_Msk               (0x00000300UL)               /*!< PLL_DM (Bitfield-Mask: 0x03)           */
#define CHIPCTRL_PLL_CFG_PLL_DN_Pos               (2UL)                        /*!< PLL_DN (Bit 2)                         */
#define CHIPCTRL_PLL_CFG_PLL_DN_Msk               (0x0000007CUL)               /*!< PLL_DN (Bitfield-Mask: 0x1F)           */
#define CHIPCTRL_PLL_CFG_PLL_LS_Pos               (1UL)                        /*!< PLL_LS (Bit 1)                         */
#define CHIPCTRL_PLL_CFG_PLL_LS_Msk               (0x00000002UL)               /*!< PLL_LS (Bitfield-Mask: 0x01)           */
/* ===============================  RCH_CFG  ================================ */
#define CHIPCTRL_RCH_CFG_RCH_FJ_RANGE_Pos         (20UL)                       /*!< RCH_FJ_RANGE (Bit 20)                  */
#define CHIPCTRL_RCH_CFG_RCH_FJ_RANGE_Msk         (0x00300000UL)               /*!< RCH_FJ_RANGE (Bitfield-Mask: 0x03)     */
#define CHIPCTRL_RCH_CFG_RCH_FJ_INV_Pos           (17UL)                       /*!< RCH_FJ_INV (Bit 17)                    */
#define CHIPCTRL_RCH_CFG_RCH_FJ_INV_Msk           (0x000E0000UL)               /*!< RCH_FJ_INV (Bitfield-Mask: 0x07)       */
#define CHIPCTRL_RCH_CFG_RCH_FJ_EN_Pos            (16UL)                       /*!< RCH_FJ_EN (Bit 16)                     */
#define CHIPCTRL_RCH_CFG_RCH_FJ_EN_Msk            (0x00010000UL)               /*!< RCH_FJ_EN (Bitfield-Mask: 0x01)        */
#define CHIPCTRL_RCH_CFG_RCH_PT_Pos               (12UL)                       /*!< RCH_PT (Bit 12)                        */
#define CHIPCTRL_RCH_CFG_RCH_PT_Msk               (0x0000F000UL)               /*!< RCH_PT (Bitfield-Mask: 0x0f)           */
#define CHIPCTRL_RCH_CFG_RCH_TRIM_Pos             (0UL)                        /*!< RCH_TRIM (Bit 0)                       */
#define CHIPCTRL_RCH_CFG_RCH_TRIM_Msk             (0x00000FFFUL)               /*!< RCH_TRIM (Bitfield-Mask: 0xfff)        */
/* =================================  STS  ================================== */
#define CHIPCTRL_STS_SW_FLAG_Pos                  (31UL)                       /*!< SW_FLAG (Bit 31)                       */
#define CHIPCTRL_STS_SW_FLAG_Msk                  (0x80000000UL)               /*!< SW_FLAG (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_STS_FLASH_CON_FLAG_Pos           (25UL)                       /*!< FLASH_CON_FLAG (Bit 25)                */
#define CHIPCTRL_STS_FLASH_CON_FLAG_Msk           (0x02000000UL)               /*!< FLASH_CON_FLAG (Bitfield-Mask: 0x01)   */
#define CHIPCTRL_STS_LVDFLG_Pos                   (24UL)                       /*!< LVDFLG (Bit 24)                        */
#define CHIPCTRL_STS_LVDFLG_Msk                   (0x01000000UL)               /*!< LVDFLG (Bitfield-Mask: 0x01)           */
#define CHIPCTRL_STS_CLKMUX_LOCK_Pos              (23UL)                       /*!< CLKMUX_LOCK (Bit 23)                   */
#define CHIPCTRL_STS_CLKMUX_LOCK_Msk              (0x00800000UL)               /*!< CLKMUX_LOCK (Bitfield-Mask: 0x01)      */
#define CHIPCTRL_STS_SYS_CLK_LOCK_Pos             (22UL)                       /*!< SYS_CLK_LOCK (Bit 22)                  */
#define CHIPCTRL_STS_SYS_CLK_LOCK_Msk             (0x00400000UL)               /*!< SYS_CLK_LOCK (Bitfield-Mask: 0x01)     */
#define CHIPCTRL_STS_PLL_LOCK_Pos                 (20UL)                       /*!< PLL_LOCK (Bit 20)                      */
#define CHIPCTRL_STS_PLL_LOCK_Msk                 (0x00100000UL)               /*!< PLL_LOCK (Bitfield-Mask: 0x01)         */
#define CHIPCTRL_STS_OSCL_STB_Pos                 (18UL)                       /*!< OSCL_STB (Bit 18)                      */
#define CHIPCTRL_STS_OSCL_STB_Msk                 (0x00040000UL)               /*!< OSCL_STB (Bitfield-Mask: 0x01)         */
#define CHIPCTRL_STS_RCH_STB_Pos                  (17UL)                       /*!< RCH_STB (Bit 17)                       */
#define CHIPCTRL_STS_RCH_STB_Msk                  (0x00020000UL)               /*!< RCH_STB (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_STS_RCL_STB_Pos                  (16UL)                       /*!< RCL_STB (Bit 16)                       */
#define CHIPCTRL_STS_RCL_STB_Msk                  (0x00010000UL)               /*!< RCL_STB (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_STS_CLKEN_ERR_Pos                (6UL)                        /*!< CLKEN_ERR (Bit 6)                      */
#define CHIPCTRL_STS_CLKEN_ERR_Msk                (0x00000040UL)               /*!< CLKEN_ERR (Bitfield-Mask: 0x01)        */
#define CHIPCTRL_STS_CLKMUX_ERR_Pos               (5UL)                        /*!< CLKMUX_ERR (Bit 5)                     */
#define CHIPCTRL_STS_CLKMUX_ERR_Msk               (0x00000020UL)               /*!< CLKMUX_ERR (Bitfield-Mask: 0x01)       */
#define CHIPCTRL_STS_PLL_STS_Pos                  (4UL)                        /*!< PLL_STS (Bit 4)                        */
#define CHIPCTRL_STS_PLL_STS_Msk                  (0x00000010UL)               /*!< PLL_STS (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_STS_OSCL_STS_Pos                 (2UL)                        /*!< OSCL_STS (Bit 2)                       */
#define CHIPCTRL_STS_OSCL_STS_Msk                 (0x00000004UL)               /*!< OSCL_STS (Bitfield-Mask: 0x01)         */
#define CHIPCTRL_STS_RCH_STS_Pos                  (1UL)                        /*!< RCH_STS (Bit 1)                        */
#define CHIPCTRL_STS_RCH_STS_Msk                  (0x00000002UL)               /*!< RCH_STS (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_STS_RCL_STS_Pos                  (0UL)                        /*!< RCL_STS (Bit 0)                        */
#define CHIPCTRL_STS_RCL_STS_Msk                  (0x00000001UL)               /*!< RCL_STS (Bitfield-Mask: 0x01)          */
/* ================================  RST_CSR  =============================== */
#define CHIPCTRL_RST_CSR_LOCKUPRESET_Pos          (12UL)                       /*!< LOCKUPRESET (Bit 12)                   */
#define CHIPCTRL_RST_CSR_LOCKUPRESET_Msk          (0x00001000UL)               /*!< LOCKUPRESET (Bitfield-Mask: 0x01)      */
#define CHIPCTRL_RST_CSR_SYSRESET_FLAG_Pos        (7UL)                        /*!< SYSRESET_FLAG (Bit 7)                  */
#define CHIPCTRL_RST_CSR_SYSRESET_FLAG_Msk        (0x00000080UL)               /*!< SYSRESET_FLAG (Bitfield-Mask: 0x01)    */
#define CHIPCTRL_RST_CSR_LOCKUP_RST_FLAG_Pos      (6UL)                        /*!< LOCKUP_RST_FLAG (Bit 6)                */
#define CHIPCTRL_RST_CSR_LOCKUP_RST_FLAG_Msk      (0x00000040UL)               /*!< LOCKUP_RST_FLAG (Bitfield-Mask: 0x01)  */
#define CHIPCTRL_RST_CSR_IWDG_RST_FLAG_Pos        (4UL)                        /*!< IWDG_RST_FLAG (Bit 4)                  */
#define CHIPCTRL_RST_CSR_IWDG_RST_FLAG_Msk        (0x00000010UL)               /*!< IWDG_RST_FLAG (Bitfield-Mask: 0x01)    */
#define CHIPCTRL_RST_CSR_RSTN_FLAG_Pos            (3UL)                        /*!< RSTN_FLAG (Bit 3)                      */
#define CHIPCTRL_RST_CSR_RSTN_FLAG_Msk            (0x00000008UL)               /*!< RSTN_FLAG (Bitfield-Mask: 0x01)        */
#define CHIPCTRL_RST_CSR_LVR_FLAG_Pos             (1UL)                        /*!< LVR_FLAG (Bit 1)                       */
#define CHIPCTRL_RST_CSR_LVR_FLAG_Msk             (0x00000002UL)               /*!< LVR_FLAG (Bitfield-Mask: 0x01)         */
#define CHIPCTRL_RST_CSR_POR_FLAG_Pos             (0UL)                        /*!< POR_FLAG (Bit 0)                       */
#define CHIPCTRL_RST_CSR_POR_FLAG_Msk             (0x00000001UL)               /*!< POR_FLAG (Bitfield-Mask: 0x01)         */
/* =================================  KEY  ================================== */
#define CHIPCTRL_KEY_KEY_Pos                      (0UL)                        /*!< KEY (Bit 0)                            */
#define CHIPCTRL_KEY_KEY_Msk                      (0xFFFFFFFFUL)               /*!< KEY (Bitfield-Mask: 0xFFFFFFFF)        */
/* ==============================  KEY_STATUS  ============================== */
#define CHIPCTRL_KEY_STATUS_LOCK_CNT_Pos          (8UL)                        /*!< LOCKCNT (Bit 8)                        */
#define CHIPCTRL_KEY_STATUS_LOCK_CNT_Msk          (0x00001F00UL)               /*!< LOCKCNT (Bitfield-Mask: 0x1f)          */
#define CHIPCTRL_KEY_STATUS_LOCK_Pos              (1UL)                        /*!< LOCK (Bit 1)                           */
#define CHIPCTRL_KEY_STATUS_LOCK_Msk              (0x00000002UL)               /*!< LOCK (Bitfield-Mask: 0x1)              */
#define CHIPCTRL_KEY_STATUS_WR_ERR_Pos            (0UL)                        /*!< WRERR (Bit 0)                          */
#define CHIPCTRL_KEY_STATUS_WR_ERR_Msk            (0x00000001UL)               /*!< WRERR (Bitfield-Mask: 0x1)             */
/* ================================  RCL_CFG  =============================== */
#define CHIPCTRL_RCL_CFG_RCL_EN_Pos               (7UL)                        /*!< RCL_EN (Bit 7)                         */
#define CHIPCTRL_RCL_CFG_RCL_EN_Msk               (0x00000080UL)               /*!< RCL_EN (Bitfield-Mask: 0x01)           */
#define CHIPCTRL_RCL_CFG_RCL_TRIM_Pos             (0UL)                        /*!< RCL_TRIM (Bit 0)                       */
#define CHIPCTRL_RCL_CFG_RCL_TRIM_Msk             (0x0000003FUL)               /*!< RCL_TRIM (Bitfield-Mask: 0x3F)         */
/* =================================  BDCR  ================================= */
#define CHIPCTRL_BDCR_WT_EN_Pos                   (16UL)                       /*!< WT_EN (Bit 16)                         */
#define CHIPCTRL_BDCR_WT_EN_Msk                   (0x00010000UL)               /*!< WT_EN (Bitfield-Mask: 0x01)            */
#define CHIPCTRL_BDCR_RST_CFG_Pos                 (14UL)                       /*!< RST_CFG0 (Bit 14)                      */
#define CHIPCTRL_BDCR_RST_CFG_Msk                 (0x00004000UL)               /*!< RST_CFG0 (Bitfield-Mask: 0x01)         */
#define CHIPCTRL_BDCR_BDRST_Pos                   (11UL)                       /*!< BDRST (Bit 11)                         */
#define CHIPCTRL_BDCR_BDRST_Msk                   (0x00000800UL)               /*!< BDRST (Bitfield-Mask: 0x01)            */
#define CHIPCTRL_BDCR_WT_SEL_Pos                  (9UL)                        /*!< WT_SEL (Bit 7)                         */
#define CHIPCTRL_BDCR_WT_SEL_Msk                  (0x00000600UL)               /*!< WT_SEL (Bitfield-Mask: 0x03)           */
#define CHIPCTRL_BDCR_OSCL_REN_Pos                (6UL)                        /*!< OSCL_REN (Bit 6)                       */
#define CHIPCTRL_BDCR_OSCL_REN_Msk                (0x00000040UL)               /*!< OSCL_REN (Bitfield-Mask: 0x01)         */
#define CHIPCTRL_BDCR_OSCL_TS_Pos                 (4UL)                        /*!< OSCL_TS (Bit 4)                        */
#define CHIPCTRL_BDCR_OSCL_TS_Msk                 (0x00000030UL)               /*!< OSCL_TS (Bitfield-Mask: 0x03)          */
#define CHIPCTRL_BDCR_OSCL_GAIN_Pos               (2UL)                        /*!< OSCL_GAIN (Bit 2)                      */
#define CHIPCTRL_BDCR_OSCL_GAIN_Msk               (0x0000000CUL)               /*!< OSCL_GAIN (Bitfield-Mask: 0x03)        */
#define CHIPCTRL_BDCR_OSCL_BYP_Pos                (1UL)                        /*!< OSCL_BYP (Bit 1)                       */
#define CHIPCTRL_BDCR_OSCL_BYP_Msk                (0x00000002UL)               /*!< OSCL_BYP (Bitfield-Mask: 0x01)         */
#define CHIPCTRL_BDCR_OSCL_EN_Pos                 (0UL)                        /*!< OSCL_EN (Bit 0)                        */
#define CHIPCTRL_BDCR_OSCL_EN_Msk                 (0x00000001UL)               /*!< OSCL_EN (Bitfield-Mask: 0x01)          */
/* ================================  BGR_CFG  =============================== */
#define CHIPCTRL_BGR_CFG_LPBGR_TRIM_Pos           (16UL)                       /*!< LPBGR_TRIM (Bit 16)                    */
#define CHIPCTRL_BGR_CFG_LPBGR_TRIM_Msk           (0x00070000UL)               /*!< LPBGR_TRIM (Bitfield-Mask: 0x7)        */
#define CHIPCTRL_BGR_CFG_BGR_TRIM_Pos             (0UL)                        /*!< BGRTRIM (Bit 0)                        */
#define CHIPCTRL_BGR_CFG_BGR_TRIM_Msk             (0x000007FFUL)               /*!< BGRTRIM (Bitfield-Mask: 0x7FF)         */
/* ===============================  PWR_KEY_W  ============================== */
#define CHIPCTRL_PWR_KEY_W_KEY_Pos                (0UL)                        /*!< KEY (Bit 0)                            */
#define CHIPCTRL_PWR_KEY_W_KEY_Msk                (0xFFFFFFFFUL)               /*!< KEY (Bitfield-Mask: 0xFFFFFFFF)        */
/* ===============================  PWR_KEY_R  ============================== */
#define CHIPCTRL_PWR_KEY_R_LOCK_CNT_Pos           (8UL)                        /*!< LOCKCNT (Bit 8)                        */
#define CHIPCTRL_PWR_KEY_R_LOCK_CNT_Msk           (0x00001F00UL)               /*!< LOCKCNT (Bitfield-Mask: 0x1F)          */
#define CHIPCTRL_PWR_KEY_R_LOCK_Pos               (1UL)                        /*!< LOCK (Bit 1)                           */
#define CHIPCTRL_PWR_KEY_R_LOCK_Msk               (0x00000002UL)               /*!< LOCKCNT (Bitfield-Mask: 0x01)          */
#define CHIPCTRL_PWR_KEY_R_WR_ERR_Pos             (0UL)                        /*!< WRERR (Bit 0)                          */
#define CHIPCTRL_PWR_KEY_R_WR_ERR_Msk             (0x00000001UL)               /*!< WRERR (Bitfield-Mask: 0x01)            */
/* ================================  PWR_CR  ================================ */
#define CHIPCTRL_PWR_CR_ULPDS_Pos                 (4UL)                        /*!< ULPDS (Bit 4)                          */
#define CHIPCTRL_PWR_CR_ULPDS_Msk                 (0x00000010UL)               /*!< ULPDS (Bitfield-Mask: 0x01)            */
#define CHIPCTRL_PWR_CR_FPDS_Pos                  (3UL)                        /*!< FPDS (Bit 3)                           */
#define CHIPCTRL_PWR_CR_FPDS_Msk                  (0x00000008UL)               /*!< FPDS (Bitfield-Mask: 0x01)             */
#define CHIPCTRL_PWR_CR_PMUEN_Pos                 (2UL)                        /*!< PMUEN (Bit 2)                          */
#define CHIPCTRL_PWR_CR_PMUEN_Msk                 (0x00000004UL)               /*!< PMUEN (Bitfield-Mask: 0x01)            */
#define CHIPCTRL_PWR_CR_LPDS_Pos                  (0UL)                        /*!< LPDS (Bit 0)                           */
#define CHIPCTRL_PWR_CR_LPDS_Msk                  (0x00000001UL)               /*!< LPDS (Bitfield-Mask: 0x01)             */
/* ===============================  PWR_LDOCR  ============================== */
#define CHIPCTRL_PWR_LDOCR_STOP_Pos               (6UL)                        /*!< STOP (Bit 6)                           */
#define CHIPCTRL_PWR_LDOCR_STOP_Msk               (0x00000040UL)               /*!< STOP (Bitfield-Mask: 0x01)             */
#define CHIPCTRL_PWR_LDOCR_DRV_Pos                (2UL)                        /*!< DRV (Bit 2)                            */
#define CHIPCTRL_PWR_LDOCR_DRV_Msk                (0x0000000CUL)               /*!< DRV (Bitfield-Mask: 0x03)              */
#define CHIPCTRL_PWR_LDOCR_PD_Pos                 (1UL)                        /*!< PD (Bit 1)                             */
#define CHIPCTRL_PWR_LDOCR_PD_Msk                 (0x00000002UL)               /*!< PD (Bitfield-Mask: 0x01)               */
#define CHIPCTRL_PWR_LDOCR_EXTVDD_Pos             (0UL)                        /*!< EXTVDD (Bit 0)                         */
#define CHIPCTRL_PWR_LDOCR_EXTVDD_Msk             (0x00000001UL)               /*!< EXTVDD (Bitfield-Mask: 0x01)           */

/* ========================================================================== */
/* ================                  SYSCTRL                 ================ */
/* ========================================================================== */

/* ===============================  ClkEnR0  ================================ */
#define SYSCTRL_ClkEnR0_TIM2_CLKEN_Pos            (31UL)                       /*!< TIM2_CLKEN (Bit 31)                    */
#define SYSCTRL_ClkEnR0_TIM2_CLKEN_Msk            (0x80000000UL)               /*!< TIM2_CLKEN (Bitfield-Mask: 0x01)       */
#define SYSCTRL_ClkEnR0_TIM17_CLKEN_Pos           (30UL)                       /*!< TIM17_CLKEN (Bit 30)                   */
#define SYSCTRL_ClkEnR0_TIM17_CLKEN_Msk           (0x40000000UL)               /*!< TIM17_CLKEN (Bitfield-Mask: 0x01)      */
#define SYSCTRL_ClkEnR0_TIM16_CLKEN_Pos           (29UL)                       /*!< TIM16_CLKEN (Bit 29)                   */
#define SYSCTRL_ClkEnR0_TIM16_CLKEN_Msk           (0x20000000UL)               /*!< TIM16_CLKEN (Bitfield-Mask: 0x01)      */
#define SYSCTRL_ClkEnR0_TIM15_CLKEN_Pos           (28UL)                       /*!< TIM15_CLKEN (Bit 28)                   */
#define SYSCTRL_ClkEnR0_TIM15_CLKEN_Msk           (0x10000000UL)               /*!< TIM15_CLKEN (Bitfield-Mask: 0x01)      */
#define SYSCTRL_ClkEnR0_TIM1_CLKEN_Pos            (19UL)                       /*!< TIM1_CLKEN (Bit 19)                    */
#define SYSCTRL_ClkEnR0_TIM1_CLKEN_Msk            (0x00080000UL)               /*!< TIM1_CLKEN (Bitfield-Mask: 0x01)       */
#define SYSCTRL_ClkEnR0_RAM1_CLKEN_Pos            (18UL)                       /*!< RAM1_CLKEN (Bit 18)                    */
#define SYSCTRL_ClkEnR0_RAM1_CLKEN_Msk            (0x00040000UL)               /*!< RAM1_CLKEN (Bitfield-Mask: 0x01)       */
#define SYSCTRL_ClkEnR0_RAM0_CLKEN_Pos            (17UL)                       /*!< RAM0_CLKEN (Bit 17)                    */
#define SYSCTRL_ClkEnR0_RAM0_CLKEN_Msk            (0x00020000UL)               /*!< RAM0_CLKEN (Bitfield-Mask: 0x01)       */
#define SYSCTRL_ClkEnR0_EFLS_CLKEN_Pos            (16UL)                       /*!< EFLS_CLKEN (Bit 16)                    */
#define SYSCTRL_ClkEnR0_EFLS_CLKEN_Msk            (0x00010000UL)               /*!< EFLS_CLKEN (Bitfield-Mask: 0x01)       */
#define SYSCTRL_ClkEnR0_USART1_CLKEN_Pos          (14UL)                       /*!< USART1_CLKEN (Bit 14)                  */
#define SYSCTRL_ClkEnR0_USART1_CLKEN_Msk          (0x00004000UL)               /*!< USART1_CLKEN (Bitfield-Mask: 0x01)     */
#define SYSCTRL_ClkEnR0_USART0_CLKEN_Pos          (13UL)                       /*!< USART0_CLKEN (Bit 13)                  */
#define SYSCTRL_ClkEnR0_USART0_CLKEN_Msk          (0x00002000UL)               /*!< USART0_CLKEN (Bitfield-Mask: 0x01)     */
#define SYSCTRL_ClkEnR0_SPI0_CLKEN_Pos            (12UL)                       /*!< SPI0_CLKEN (Bit 12)                    */
#define SYSCTRL_ClkEnR0_SPS0_CLKEN_Msk            (0x00001000UL)               /*!< SPI0_CLKEN (Bitfield-Mask: 0x01)       */
#define SYSCTRL_ClkEnR0_I2C0_CLKEN_Pos            (10UL)                       /*!< I2C0_CLKEN (Bit 10)                    */
#define SYSCTRL_ClkEnR0_I2C0_CLKEN_Msk            (0x00000400UL)               /*!< I2C0_CLKEN (Bitfield-Mask: 0x01)       */
#define SYSCTRL_ClkEnR0_ADC_CLKEN_Pos             (9UL)                        /*!< ADC_CLKEN (Bit 9)                      */
#define SYSCTRL_ClkEnR0_ADC_CLKEN_Msk             (0x00000200UL)               /*!< ADC_CLKEN (Bitfield-Mask: 0x01)        */
#define SYSCTRL_ClkEnR0_DMA_CLKEN_Pos             (8UL)                        /*!< DMA_CLKEN (Bit 8)                      */
#define SYSCTRL_ClkEnR0_DMA_CLKEN_Msk             (0x00000100UL)               /*!< DMA_CLKEN (Bitfield-Mask: 0x01)        */
#define SYSCTRL_ClkEnR0_CORDIC_CLKEN_Pos          (7UL)                        /*!< CORDIC_CLKEN (Bit 7)                   */
#define SYSCTRL_ClkEnR0_CORDIC_CLKEN_Msk          (0x00000080UL)               /*!< CORDIC_CLKEN (Bitfield-Mask: 0x01)     */
#define SYSCTRL_ClkEnR0_CRC_CLKEN_Pos             (6UL)                        /*!< CRC_CLKEN (Bit 6)                      */
#define SYSCTRL_ClkEnR0_CRC_CLKEN_Msk             (0x00000040UL)               /*!< CRC_CLKEN (Bitfield-Mask: 0x01)        */
#define SYSCTRL_ClkEnR0_GPIOB_CLKEN_Pos           (1UL)                        /*!< GPIOB_CLKEN (Bit 1)                    */
#define SYSCTRL_ClkEnR0_GPIOB_CLKEN_Msk           (0x00000002UL)               /*!< GPIOB_CLKEN (Bitfield-Mask: 0x01)      */
#define SYSCTRL_ClkEnR0_GPIOA_CLKEN_Pos           (0UL)                        /*!< GPIOA_CLKEN (Bit 0)                    */
#define SYSCTRL_ClkEnR0_GPIOA_CLKEN_Msk           (0x00000001UL)               /*!< GPIOA_CLKEN (Bitfield-Mask: 0x01)      */
/* ================================  ClkEnR1  =============================== */
#define SYSCTRL_ClkEnR1_TIM17_CLKSEL_Pos          (30UL)                       /*!< TIM17_CLKSEL (Bit 30)                  */
#define SYSCTRL_ClkEnR1_TIM17_CLKSEL_Msk          (0x40000000UL)               /*!< TIM17_CLKSEL (Bitfield-Mask: 0x01)     */
#define SYSCTRL_ClkEnR1_TIM16_CLKSEL_Pos          (29UL)                       /*!< TIM16_CLKSEL (Bit 29)                  */
#define SYSCTRL_ClkEnR1_TIM16_CLKSEL_Msk          (0x20000000UL)               /*!< TIM16_CLKSEL (Bitfield-Mask: 0x01)     */
#define SYSCTRL_ClkEnR1_TIM15_CLKSEL_Pos          (28UL)                       /*!< TIM15_CLKSEL (Bit 28)                  */
#define SYSCTRL_ClkEnR1_TIM15_CLKSEL_Msk          (0x10000000UL)               /*!< TIM15_CLKSEL (Bitfield-Mask: 0x01)     */
#define SYSCTRL_ClkEnR1_TIM2_CLKSEL_Pos           (27UL)                       /*!< TIM2_CLKSEL (Bit 27)                   */
#define SYSCTRL_ClkEnR1_TIM2_CLKSEL_Msk           (0x08000000UL)               /*!< TIM2_CLKSEL (Bitfield-Mask: 0x01)      */
#define SYSCTRL_ClkEnR1_TIM1_CLKSEL_Pos           (26UL)                       /*!< TIM1_CLKSEL (Bit 26)                   */
#define SYSCTRL_ClkEnR1_TIM1_CLKSEL_Msk           (0x04000000UL)               /*!< TIM1_CLKSEL (Bitfield-Mask: 0x01)      */
#define SYSCTRL_ClkEnR1_SPI0_CLKSEL_Pos           (20UL)                       /*!< SPI0_CLKSEL (Bit 20)                   */
#define SYSCTRL_ClkEnR1_SPI0_CLKSEL_Msk           (0x00300000UL)               /*!< SPI0_CLKSEL (Bitfield-Mask: 0x03)      */
#define SYSCTRL_ClkEnR1_SPI0_CLKDIV_Pos           (19UL)                       /*!< SPI0_CLKDIV (Bit 19)                   */
#define SYSCTRL_ClkEnR1_SPI0_CLKDIV_Msk           (0x00080000UL)               /*!< SPI0_CLKDIV (Bitfield-Mask: 0x01)      */
#define SYSCTRL_ClkEnR1_I2C0_CLKSEL_Pos           (17UL)                       /*!< I2C0_CLKSEL (Bit 17)                   */
#define SYSCTRL_ClkEnR1_I2C0_CLKSEL_Msk           (0x00060000UL)               /*!< I2C0_CLKSEL (Bitfield-Mask: 0x03)      */
#define SYSCTRL_ClkEnR1_I2C0_CLKDIV_Pos           (16UL)                       /*!< I2C0_CLKDIV (Bit 16)                   */
#define SYSCTRL_ClkEnR1_I2C0_CLKDIV_Msk           (0x00010000UL)               /*!< I2C0_CLKDIV (Bitfield-Mask: 0x01)      */
#define SYSCTRL_ClkEnR1_USART1_CLKSEL_Pos         (14UL)                       /*!< USART1_CLKSEL (Bit 14)                 */
#define SYSCTRL_ClkEnR1_USART1_CLKSEL_Msk         (0x0000C000UL)               /*!< USART1_CLKSEL (Bitfield-Mask: 0x03)    */
#define SYSCTRL_ClkEnR1_USART1_CLKDIV_Pos         (13UL)                       /*!< USART1_CLKDIV (Bit 13)                 */
#define SYSCTRL_ClkEnR1_USART1_CLKDIV_Msk         (0x00002000UL)               /*!< USART1_CLKDIV (Bitfield-Mask: 0x01)    */
#define SYSCTRL_ClkEnR1_USART0_CLKSEL_Pos         (11UL)                       /*!< USART0_CLKSEL (Bit 11)                 */
#define SYSCTRL_ClkEnR1_USART0_CLKSEL_Msk         (0x00001800UL)               /*!< USART0_CLKSEL (Bitfield-Mask: 0x03)    */
#define SYSCTRL_ClkEnR1_USART0_CLKDIV_Pos         (10UL)                       /*!< USART0_CLKDIV (Bit 10)                 */
#define SYSCTRL_ClkEnR1_USART0_CLKDIV_Msk         (0x00000400UL)               /*!< USART0_CLKDIV (Bitfield-Mask: 0x01)    */
#define SYSCTRL_ClkEnR1_RCH_DIV_Pos               (7UL)                        /*!< RCH_DIV (Bit 7)                        */
#define SYSCTRL_ClkEnR1_RCH_DIV_Msk               (0x00000080UL)               /*!< RCH_DIV (Bitfield-Mask: 0x01)          */
#define SYSCTRL_ClkEnR1_MCO_SEL_Pos               (3UL)                        /*!< MCO_SEL (Bit 3)                        */
#define SYSCTRL_ClkEnR1_MCO_SEL_Msk               (0x00000038UL)               /*!< MCO_SEL (Bitfield-Mask: 0x07)          */
#define SYSCTRL_ClkEnR1_MCO_DIV_Pos               (0UL)                        /*!< MCO_DIV (Bit 0)                        */
#define SYSCTRL_ClkEnR1_MCO_DIV_Msk               (0x00000007UL)               /*!< MCO_DIV (Bitfield-Mask: 0x07)          */
/* ================================  ClkEnR2  ================================ */
#define SYSCTRL_ClkEnR2_DIV_CLKEN_Pos             (7UL)                        /*!< DIV_CLKEN (Bit 7)                      */
#define SYSCTRL_ClkEnR2_DIV_CLKEN_Msk             (0x00000080UL)               /*!< DIV_CLKEN (Bitfield-Mask: 0x01)        */
#define SYSCTRL_ClkEnR2_EXTI_CLKEN_Pos            (6UL)                        /*!< EXTI_CLKEN (Bit 6)                     */
#define SYSCTRL_ClkEnR2_EXTI_CLKEN_Msk            (0x00000040UL)               /*!< EXTI_CLKEN (Bitfield-Mask: 0x01)       */
#define SYSCTRL_ClkEnR2_ANA_CLKEN_Pos             (5UL)                        /*!< ANA_CLKEN (Bit 5)                      */
#define SYSCTRL_ClkEnR2_ANA_CLKEN_Msk             (0x00000020UL)               /*!< ANA_CLKEN (Bitfield-Mask: 0x01)        */
/* ==================================  RST0  ================================ */
#define SYSCTRL_RST0_TIM2_RST_Pos                 (31UL)                       /*!< TIM2_RST (Bit 31)                      */
#define SYSCTRL_RST0_TIM2_RST_Msk                 (0x80000000UL)               /*!< TIM2_RST (Bitfield-Mask: 0x01)         */
#define SYSCTRL_RST0_TIM17_RST_Pos                (31UL)                       /*!< TIM17_RST (Bit 30)                     */
#define SYSCTRL_RST0_TIM17_RST_Msk                (0x40000000UL)               /*!< TIM17_RST (Bitfield-Mask: 0x01)        */
#define SYSCTRL_RST0_TIM16_RST_Pos                (29UL)                       /*!< TIM16_RST (Bit 29)                     */
#define SYSCTRL_RST0_TIM16_RST_Msk                (0x20000000UL)               /*!< TIM16_RST (Bitfield-Mask: 0x01)        */
#define SYSCTRL_RST0_TIM15_RST_Pos                (28UL)                       /*!< TIM15_RST (Bit 28)                     */
#define SYSCTRL_RST0_TIM15_RST_Msk                (0x10000000UL)               /*!< TIM15_RST (Bitfield-Mask: 0x01)        */
#define SYSCTRL_RST0_TIM1_RST_Pos                 (19UL)                       /*!< TIM1_RST (Bit 19)                      */
#define SYSCTRL_RST0_TIM1_RST_Msk                 (0x00080000UL)               /*!< TIM1_RST (Bitfield-Mask: 0x01)         */
#define SYSCTRL_RST0_RAM1_RST_Pos                 (18UL)                       /*!< RAM1_RST (Bit 18)                      */
#define SYSCTRL_RST0_RAM1_RST_Msk                 (0x00040000UL)               /*!< RAM1_RST (Bitfield-Mask: 0x01)         */
#define SYSCTRL_RST0_RAM0_RST_Pos                 (17UL)                       /*!< RAM0_RST (Bit 17)                      */
#define SYSCTRL_RST0_RAM0_RST_Msk                 (0x00020000UL)               /*!< RAM0_RST (Bitfield-Mask: 0x01)         */
#define SYSCTRL_RST0_EFLS_RST_Pos                 (16UL)                       /*!< EFLS_RST (Bit 16)                      */
#define SYSCTRL_RST0_EFLS_RST_Msk                 (0x00010000UL)               /*!< EFLS_RST (Bitfield-Mask: 0x01)         */
#define SYSCTRL_RST0_USART1_RST_Pos               (14UL)                       /*!< USART1_RST (Bit 14)                    */
#define SYSCTRL_RST0_USART1_RST_Msk               (0x00004000UL)               /*!< USART1_RST (Bitfield-Mask: 0x01)       */
#define SYSCTRL_RST0_USART0_RST_Pos               (13UL)                       /*!< USART0_RST (Bit 13)                    */
#define SYSCTRL_RST0_USART0_RST_Msk               (0x00002000UL)               /*!< USART0_RST (Bitfield-Mask: 0x01)       */
#define SYSCTRL_RST0_SPI0_RST_Pos                 (12UL)                       /*!< SPI0_RST (Bit 12)                      */
#define SYSCTRL_RST0_SPI0_RST_Msk                 (0x00001000UL)               /*!< SPI0_RST (Bitfield-Mask: 0x01)         */
#define SYSCTRL_RST0_I2C0_RST_Pos                 (10UL)                       /*!< I2C0_RST (Bit 10)                      */
#define SYSCTRL_RST0_I2C0_RST_Msk                 (0x00000400UL)               /*!< I2C0_RST (Bitfield-Mask: 0x01)         */
#define SYSCTRL_RST0_ADC_RST_Pos                  (9UL)                        /*!< ADC_RST (Bit 9)                        */
#define SYSCTRL_RST0_ADC_RST_Msk                  (0x00000200UL)               /*!< ADC_RST (Bitfield-Mask: 0x01)          */
#define SYSCTRL_RST0_DMA_RST_Pos                  (8UL)                        /*!< DMA_RST (Bit 8)                        */
#define SYSCTRL_RST0_DMA_RST_Msk                  (0x00000100UL)               /*!< DMA_RST (Bitfield-Mask: 0x01)          */
#define SYSCTRL_RST0_CORDIC_RST_Pos               (7UL)                        /*!< CORDIC_RST (Bit 7)                     */
#define SYSCTRL_RST0_CORDIC_RST_Msk               (0x00000080UL)               /*!< CORDIC_RST (Bitfield-Mask: 0x01)       */
#define SYSCTRL_RST0_CRC_RST_Pos                  (6UL)                        /*!< CRC_RST (Bit 6)                        */
#define SYSCTRL_RST0_CRC_RST_Msk                  (0x00000040UL)               /*!< CRC_RST (Bitfield-Mask: 0x01)          */
#define SYSCTRL_RST0_GPIOB_RST_Pos                (1UL)                        /*!< GPIOB_RST (Bit 1)                      */
#define SYSCTRL_RST0_GPIOB_RST_Msk                (0x00000002UL)               /*!< GPIOB_RST (Bitfield-Mask: 0x01)        */
#define SYSCTRL_RST0_GPIOA_RST_Pos                (0UL)                        /*!< GPIOA_RST (Bit 0)                      */
#define SYSCTRL_RST0_GPIOA_RST_Msk                (0x00000001UL)               /*!< GPIOA_RST (Bitfield-Mask: 0x01)        */
/* =================================  RST1  ================================= */
#define SYSCTRL_RST1_DIV_RST_Pos                  (7UL)                        /*!< DIV_RST (Bit 7)                        */
#define SYSCTRL_RST1_DIV_RST_Msk                  (0x00000080UL)               /*!< DIV_RST (Bitfield-Mask: 0x01)          */
#define SYSCTRL_RST1_EXTI_RST_Pos                 (6UL)                        /*!< EXTI_RST (Bit 6)                       */
#define SYSCTRL_RST1_EXTI_RST_Msk                 (0x00000040UL)               /*!< EXTI_RST (Bitfield-Mask: 0x01)         */
#define SYSCTRL_RST1_ANA_RST_Pos                  (5UL)                        /*!< ANA_RST (Bit 5)                        */
#define SYSCTRL_RST1_ANA_RST_Msk                  (0x00000020UL)               /*!< ANA_RST (Bitfield-Mask: 0x01)          */
/* ================================  DBG_CFG  =============================== */
#define SYSCTRL_DBG_CFG_TIM2_STOP_Pos             (10UL)                       /*!< TIM2_STOP (Bit 10)                     */
#define SYSCTRL_DBG_CFG_TIM2_STOP_Msk             (0x00000400UL)               /*!< TIM2_STOP (Bitfield-Mask: 0x01)        */
#define SYSCTRL_DBG_CFG_IWDG_STOP_Pos             (9UL)                        /*!< IWDG_STOP (Bit 9)                      */
#define SYSCTRL_DBG_CFG_IWDG_STOP_Msk             (0x00000200UL)               /*!< IWDG_STOP (Bitfield-Mask: 0x01)        */
#define SYSCTRL_DBG_CFG_WT_STOP_Pos               (7UL)                        /*!< WT_STOP (Bit 7)                        */
#define SYSCTRL_DBG_CFG_WT_STOP_Msk               (0x00000080UL)               /*!< WT_STOP (Bitfield-Mask: 0x01)          */
#define SYSCTRL_DBG_CFG_TIM17_STOP_Pos            (6UL)                        /*!< TIM17_STOP (Bit 6)                     */
#define SYSCTRL_DBG_CFG_TIM17_STOP_Msk            (0x00000040UL)               /*!< TIM17_STOP (Bitfield-Mask: 0x01)       */
#define SYSCTRL_DBG_CFG_TIM16_STOP_Pos            (5UL)                        /*!< TIM16_STOP (Bit 5)                     */
#define SYSCTRL_DBG_CFG_TIM16_STOP_Msk            (0x00000020UL)               /*!< TIM16_STOP (Bitfield-Mask: 0x01)       */
#define SYSCTRL_DBG_CFG_TIM15_STOP_Pos            (4UL)                        /*!< TIM15_STOP (Bit 4)                     */
#define SYSCTRL_DBG_CFG_TIM15_STOP_Msk            (0x00000010UL)               /*!< TIM15_STOP (Bitfield-Mask: 0x01)       */
#define SYSCTRL_DBG_CFG_TIM1_STOP_Pos             (0UL)                        /*!< TIM1_STOP (Bit 0)                      */
#define SYSCTRL_DBG_CFG_TIM1_STOP_Msk             (0x0000001UL)                /*!< TIM1_STOP (Bitfield-Mask: 0x01)        */
/* ===============================  EXTI_CFG0  ============================== */
#define SYSCTRL_EXTI_CFG0_EXTI7_Pos               (28UL)                       /*!< EXTI7 (Bit 28)                         */
#define SYSCTRL_EXTI_CFG0_EXTI7_Msk               (0x70000000UL)               /*!< EXTI7 (Bitfield-Mask: 0x07)            */
#define SYSCTRL_EXTI_CFG0_EXTI6_Pos               (24UL)                       /*!< EXTI6 (Bit 24)                         */
#define SYSCTRL_EXTI_CFG0_EXTI6_Msk               (0x07000000UL)               /*!< EXTI6 (Bitfield-Mask: 0x07)            */
#define SYSCTRL_EXTI_CFG0_EXTI5_Pos               (20UL)                       /*!< EXTI5 (Bit 20)                         */
#define SYSCTRL_EXTI_CFG0_EXTI5_Msk               (0x00700000UL)               /*!< EXTI5 (Bitfield-Mask: 0x07)            */
#define SYSCTRL_EXTI_CFG0_EXTI4_Pos               (16UL)                       /*!< EXTI4 (Bit 16)                         */
#define SYSCTRL_EXTI_CFG0_EXTI4_Msk               (0x00070000UL)               /*!< EXTI4 (Bitfield-Mask: 0x07)            */
#define SYSCTRL_EXTI_CFG0_EXTI3_Pos               (12UL)                       /*!< EXTI3 (Bit 12)                         */
#define SYSCTRL_EXTI_CFG0_EXTI3_Msk               (0x00007000UL)               /*!< EXTI3 (Bitfield-Mask: 0x07)            */
#define SYSCTRL_EXTI_CFG0_EXTI2_Pos               (8UL)                        /*!< EXTI2 (Bit 8)                          */
#define SYSCTRL_EXTI_CFG0_EXTI2_Msk               (0x00000700UL)               /*!< EXTI2 (Bitfield-Mask: 0x07)            */
#define SYSCTRL_EXTI_CFG0_EXTI1_Pos               (4UL)                        /*!< EXTI1 (Bit 4)                          */
#define SYSCTRL_EXTI_CFG0_EXTI1_Msk               (0x00000070UL)               /*!< EXTI1 (Bitfield-Mask: 0x07)            */
#define SYSCTRL_EXTI_CFG0_EXTI0_Pos               (0UL)                        /*!< EXTI0 (Bit 0)                          */
#define SYSCTRL_EXTI_CFG0_EXTI0_Msk               (0x00000007UL)               /*!< EXTI0 (Bitfield-Mask: 0x07)            */
/* ===============================  EXTI_CFG1  ============================== */
#define SYSCTRL_EXTI_CFG1_EXTI15_Pos              (28UL)                       /*!< EXTI15 (Bit 28)                        */
#define SYSCTRL_EXTI_CFG1_EXTI15_Msk              (0x70000000UL)               /*!< EXTI15 (Bitfield-Mask: 0x07)           */
#define SYSCTRL_EXTI_CFG1_EXTI14_Pos              (24UL)                       /*!< EXTI14 (Bit 24)                        */
#define SYSCTRL_EXTI_CFG1_EXTI14_Msk              (0x07000000UL)               /*!< EXTI14 (Bitfield-Mask: 0x07)           */
#define SYSCTRL_EXTI_CFG1_EXTI13_Pos              (20UL)                       /*!< EXTI13 (Bit 20)                        */
#define SYSCTRL_EXTI_CFG1_EXTI13_Msk              (0x00700000UL)               /*!< EXTI13 (Bitfield-Mask: 0x07)           */
#define SYSCTRL_EXTI_CFG1_EXTI12_Pos              (16UL)                       /*!< EXTI12 (Bit 16)                        */
#define SYSCTRL_EXTI_CFG1_EXTI12_Msk              (0x00070000UL)               /*!< EXTI12 (Bitfield-Mask: 0x07)           */
#define SYSCTRL_EXTI_CFG1_EXTI11_Pos              (12UL)                       /*!< EXTI11 (Bit 12)                        */
#define SYSCTRL_EXTI_CFG1_EXTI11_Msk              (0x00007000UL)               /*!< EXTI11 (Bitfield-Mask: 0x07)           */
#define SYSCTRL_EXTI_CFG1_EXTI10_Pos              (8UL)                        /*!< EXTI10 (Bit 8)                         */
#define SYSCTRL_EXTI_CFG1_EXTI10_Msk              (0x00000700UL)               /*!< EXTI10 (Bitfield-Mask: 0x07)           */
#define SYSCTRL_EXTI_CFG1_EXTI9_Pos               (4UL)                        /*!< EXTI9 (Bit 4)                          */
#define SYSCTRL_EXTI_CFG1_EXTI9_Msk               (0x00000070UL)               /*!< EXTI9 (Bitfield-Mask: 0x07)            */
#define SYSCTRL_EXTI_CFG1_EXTI8_Pos               (0UL)                        /*!< EXTI8 (Bit 0)                          */
#define SYSCTRL_EXTI_CFG1_EXTI8_Msk               (0x00000007UL)               /*!< EXTI8 (Bitfield-Mask: 0x07)            */
/* ===============================  EDU_CFG0  =============================== */
#define SYSCTRL_EDU_CFG0_DMA_REQ7_MAP_Pos         (28UL)                       /*!< DMA_REQ7_MAP (Bit 28)                  */
#define SYSCTRL_EDU_CFG0_DMA_REQ7_MAP_Msk         (0xF0000000UL)               /*!< DMA_REQ7_MAP (Bitfield-Mask: 0x0F)     */
#define SYSCTRL_EDU_CFG0_DMA_REQ6_MAP_Pos         (24UL)                       /*!< DMA_REQ6_MAP (Bit 24)                  */
#define SYSCTRL_EDU_CFG0_DMA_REQ6_MAP_Msk         (0x0F000000UL)               /*!< DMA_REQ6_MAP (Bitfield-Mask: 0x0F)     */
#define SYSCTRL_EDU_CFG0_DMA_REQ5_MAP_Pos         (20UL)                       /*!< DMA_REQ5_MAP (Bit 20)                  */
#define SYSCTRL_EDU_CFG0_DMA_REQ5_MAP_Msk         (0x00F00000UL)               /*!< DMA_REQ5_MAP (Bitfield-Mask: 0x0F)     */
#define SYSCTRL_EDU_CFG0_DMA_REQ4_MAP_Pos         (16UL)                       /*!< DMA_REQ4_MAP (Bit 16)                  */
#define SYSCTRL_EDU_CFG0_DMA_REQ4_MAP_Msk         (0x000F0000UL)               /*!< DMA_REQ4_MAP (Bitfield-Mask: 0x0F)     */
#define SYSCTRL_EDU_CFG0_DMA_REQ3_MAP_Pos         (12UL)                       /*!< DMA_REQ3_MAP (Bit 12)                  */
#define SYSCTRL_EDU_CFG0_DMA_REQ3_MAP_Msk         (0x0000F000UL)               /*!< DMA_REQ3_MAP (Bitfield-Mask: 0x0F)     */
#define SYSCTRL_EDU_CFG0_DMA_REQ2_MAP_Pos         (8UL)                        /*!< DMA_REQ2_MAP (Bit 8)                   */
#define SYSCTRL_EDU_CFG0_DMA_REQ2_MAP_Msk         (0x00000F00UL)               /*!< DMA_REQ2_MAP (Bitfield-Mask: 0x0F)     */
#define SYSCTRL_EDU_CFG0_DMA_REQ1_MAP_Pos         (4UL)                        /*!< DMA_REQ1_MAP (Bit 4)                   */
#define SYSCTRL_EDU_CFG0_DMA_REQ1_MAP_Msk         (0x000000F0UL)               /*!< DMA_REQ1_MAP (Bitfield-Mask: 0x0F)     */
#define SYSCTRL_EDU_CFG0_DMA_REQ0_MAP_Pos         (0UL)                        /*!< DMA_REQ0_MAP (Bit 0)                   */
#define SYSCTRL_EDU_CFG0_DMA_REQ0_MAP_Msk         (0x0000000FUL)               /*!< DMA_REQ0_MAP (Bitfield-Mask: 0x0F)     */
/* ================================  EDU_CFG1  ============================== */
#define SYSCTRL_EDU_CFG1_TIM1_ETRS_Pos            (16UL)                       /*!< TIM1_ETRS (Bit 16)                     */
#define SYSCTRL_EDU_CFG1_TIM1_ETRS_Msk            (0x00070000UL)               /*!< TIM1_ETRS (Bitfield-Mask: 0x07)        */
/* ================================  EDU_CFG3  ============================== */
#define SYSCTRL_EDU_CFG3_TIM17_ETRS_Pos           (28UL)                       /*!< TIM17_ETRS (Bit 28)                    */
#define SYSCTRL_EDU_CFG3_TIM17_ETRS_Msk           (0x70000000UL)               /*!< TIM17_ETRS (Bitfield-Mask: 0x07)       */
#define SYSCTRL_EDU_CFG3_TIM17_TI1S_Pos           (24UL)                       /*!< TIM17_TI1S (Bit 24)                    */
#define SYSCTRL_EDU_CFG3_TIM17_TI1S_Msk           (0x07000000UL)               /*!< TIM17_TI1S (Bitfield-Mask: 0x07)       */
#define SYSCTRL_EDU_CFG3_TIM16_ETRS_Pos           (20UL)                       /*!< TIM16_ETRS (Bit 20)                    */
#define SYSCTRL_EDU_CFG3_TIM16_ETRS_Msk           (0x00700000UL)               /*!< TIM16_ETRS (Bitfield-Mask: 0x07)       */
#define SYSCTRL_EDU_CFG3_TIM16_TI2S_Pos           (16UL)                       /*!< TIM16_TI2S (Bit 16)                    */
#define SYSCTRL_EDU_CFG3_TIM16_TI2S_Msk           (0x00070000UL)               /*!< TIM16_TI2S (Bitfield-Mask: 0x07)       */
#define SYSCTRL_EDU_CFG3_TIM16_TI1S_Pos           (12UL)                       /*!< TIM16_TI1S (Bit 12)                    */
#define SYSCTRL_EDU_CFG3_TIM16_TI1S_Msk           (0x00007000UL)               /*!< TIM16_TI1S (Bitfield-Mask: 0x07)       */
#define SYSCTRL_EDU_CFG3_TIM15_ETRS_Pos           (8UL)                        /*!< TIM15_ETRS (Bit 8)                     */
#define SYSCTRL_EDU_CFG3_TIM15_ETRS_Msk           (0x00000700UL)               /*!< TIM15_ETRS (Bitfield-Mask: 0x07)       */
#define SYSCTRL_EDU_CFG3_TIM15_TI2S_Pos           (4UL)                        /*!< TIM15_TI2S (Bit 4)                     */
#define SYSCTRL_EDU_CFG3_TIM15_TI2S_Msk           (0x00000070UL)               /*!< TIM15_TI2S (Bitfield-Mask: 0x07)       */
#define SYSCTRL_EDU_CFG3_TIM15_TI1S_Pos           (0UL)                        /*!< TIM15_TI1S (Bit 0)                     */
#define SYSCTRL_EDU_CFG3_TIM15_TI1S_Msk           (0x00000007UL)               /*!< TIM15_TI1S (Bitfield-Mask: 0x07)       */
/* ================================  EDU_CFG4  ============================== */
#define SYSCTRL_EDU_CFG4_TIM1_OCCSE_Pos           (24UL)                       /*!< TIM1_OCCSE (Bit 24)                    */
#define SYSCTRL_EDU_CFG4_TIM1_OCCSE_Msk           (0x3F000000UL)               /*!< TIM1_OCCSE (Bitfield-Mask: 0x3F)       */
#define SYSCTRL_EDU_CFG4_TIM1_BK2SE_Pos           (16UL)                       /*!< TIM1_BK2SE (Bit 16)                    */
#define SYSCTRL_EDU_CFG4_TIM1_BK2SE_Msk           (0x003F0000UL)               /*!< TIM1_BK2SE (Bitfield-Mask: 0x3F)       */
#define SYSCTRL_EDU_CFG4_TIM1_BKSE_Pos            (8UL)                        /*!< TIM1_BKSE (Bit 8)                      */
#define SYSCTRL_EDU_CFG4_TIM1_BKSE_Msk            (0x00007F00UL)               /*!< TIM1_BKSE (Bitfield-Mask: 0x7F)        */
#define SYSCTRL_EDU_CFG4_TIM1_SP_Pos              (0UL)                        /*!< TIM1_SP (Bit 0)                        */
#define SYSCTRL_EDU_CFG4_TIM1_SP_Msk              (0x0000007FUL)               /*!< TIM1_SP (Bitfield-Mask: 0x7F)          */
/* ================================  EDU_CFG5  ============================== */
#define SYSCTRL_EDU_CFG5_TIM17_BKSE_Pos           (24UL)                       /*!< TIM17_BKSE (Bit 24)                    */
#define SYSCTRL_EDU_CFG5_TIM17_BKSE_Msk           (0x7F000000UL)               /*!< TIM17_BKSE (Bitfield-Mask: 0x7F)       */
#define SYSCTRL_EDU_CFG5_TIM17_SP_Pos             (16UL)                       /*!< TIM17_SP (Bit 16)                      */
#define SYSCTRL_EDU_CFG5_TIM17_SP_Msk             (0x007F0000UL)               /*!< TIM17_SP (Bitfield-Mask: 0x7F)         */
/* ================================  EDU_CFG6  ============================== */
#define SYSCTRL_EDU_CFG6_TIM15_BK2SE_Pos          (16UL)                       /*!< TIM15_BK2SE (Bit 16)                   */
#define SYSCTRL_EDU_CFG6_TIM15_BK2SE_Msk          (0x003F0000UL)               /*!< TIM15_BK2SE (Bitfield-Mask: 0x3F)      */
#define SYSCTRL_EDU_CFG6_TIM15_BKSE_Pos           (8UL)                        /*!< TIM15_BKSE (Bit 8)                     */
#define SYSCTRL_EDU_CFG6_TIM15_BKSE_Msk           (0x0007F00UL)                /*!< TIM15_BKSE (Bitfield-Mask: 0x7F)       */
#define SYSCTRL_EDU_CFG6_TIM15_SP_Pos             (0UL)                        /*!< TIM15_SP (Bit 0)                       */
#define SYSCTRL_EDU_CFG6_TIM15_SP_Msk             (0x000007FUL)                /*!< TIM15_SP (Bitfield-Mask: 0x7F)         */
/* ================================  EDU_CFG7  ============================== */
#define SYSCTRL_EDU_CFG7_TIM16_BK2SE_Pos          (16UL)                       /*!< TIM16_BK2SE (Bit 16)                   */
#define SYSCTRL_EDU_CFG7_TIM16_BK2SE_Msk          (0x003F0000UL)               /*!< TIM16_BK2SE (Bitfield-Mask: 0x3F)      */
#define SYSCTRL_EDU_CFG7_TIM16_BKSE_Pos           (8UL)                        /*!< TIM16_BKSE (Bit 8)                     */
#define SYSCTRL_EDU_CFG7_TIM16_BKSE_Msk           (0x0007F00UL)                /*!< TIM16_BKSE (Bitfield-Mask: 0x7F)       */
#define SYSCTRL_EDU_CFG7_TIM16_SP_Pos             (0UL)                        /*!< TIM16_SP (Bit 0)                       */
#define SYSCTRL_EDU_CFG7_TIM16_SP_Msk             (0x000007FUL)                /*!< TIM16_SP (Bitfield-Mask: 0x7F)         */
/* ================================  EDU_CFG8  ============================== */
#define SYSCTRL_EDU_CFG8_TIM2_ETRS_Pos            (16UL)                       /*!< TIM2_ETRS (Bit 16)                     */
#define SYSCTRL_EDU_CFG8_TIM2_ETRS_Msk            (0x00070000UL)               /*!< TIM2_ETRS (Bitfield-Mask: 0x07)        */
#define SYSCTRL_EDU_CFG8_TIM2_TI4S_Pos            (12UL)                       /*!< TIM2_TI4S (Bit 12)                     */
#define SYSCTRL_EDU_CFG8_TIM2_TI4S_Msk            (0x00007000UL)               /*!< TIM2_TI4S (Bitfield-Mask: 0x07)        */
#define SYSCTRL_EDU_CFG8_TIM2_TI3S_Pos            (8UL)                        /*!< TIM2_TI3S (Bit 8)                      */
#define SYSCTRL_EDU_CFG8_TIM2_TI3S_Msk            (0x00000700UL)               /*!< TIM2_TI3S (Bitfield-Mask: 0x07)        */
#define SYSCTRL_EDU_CFG8_TIM2_TI2S_Pos            (4UL)                        /*!< TIM2_TI2S (Bit 4)                      */
#define SYSCTRL_EDU_CFG8_TIM2_TI2S_Msk            (0x00000070UL)               /*!< TIM2_TI2S (Bitfield-Mask: 0x07)        */
#define SYSCTRL_EDU_CFG8_TIM2_TI1S_Pos            (0UL)                        /*!< TIM2_TI1S (Bit 0)                      */
#define SYSCTRL_EDU_CFG8_TIM2_TI1S_Msk            (0x00000007UL)               /*!< TIM2_TI1S (Bitfield-Mask: 0x07)        */
/* ================================  EDU_CFG9  ============================== */
#define SYSCTRL_EDU_CFG9_TIM2_OCCSE_Pos           (24UL)                       /*!< TIM2_OCCSE (Bit 24)                    */
#define SYSCTRL_EDU_CFG9_TIM2_OCCSE_Msk           (0x3F000000UL)               /*!< TIM2_OCCSE (Bitfield-Mask: 0x3F)       */
#define SYSCTRL_EDU_CFG9_TIM2_BKSE_Pos            (8UL)                        /*!< TIM2_BKSE (Bit 8)                      */
#define SYSCTRL_EDU_CFG9_TIM2_BKSE_Msk            (0x00007F00UL)               /*!< TIM2_BKSE (Bitfield-Mask: 0x7F)        */
#define SYSCTRL_EDU_CFG9_TIM2_SP_Pos              (0UL)                        /*!< TIM2_SP (Bit 0)                        */
#define SYSCTRL_EDU_CFG9_TIM2_SP_Msk              (0x0000007FUL)               /*!< TIM2_SP (Bitfield-Mask: 0x7F)          */
/* ================================  EDU_CFG11  ============================= */
#define SYSCTRL_EDU_CFG11_ADC_EXTEN1_Pos          (24UL)                       /*!< ADC_EXTEN1 (Bit 24)                    */
#define SYSCTRL_EDU_CFG11_ADC_EXTEN1_Msk          (0x03000000UL)               /*!< ADC_EXTEN1 (Bitfield-Mask: 0x3)        */
#define SYSCTRL_EDU_CFG11_ADC_EXTSEL1_Pos         (16UL)                       /*!< ADC_EXTSEL1 (Bit 16)                   */
#define SYSCTRL_EDU_CFG11_ADC_EXTSEL1_Msk         (0x00FF0000UL)               /*!< ADC_EXTSEL1 (Bitfield-Mask: 0xFF)      */
#define SYSCTRL_EDU_CFG11_ADC_EXTEN0_Pos          (8UL)                        /*!< ADC_EXTEN0 (Bit 8)                     */
#define SYSCTRL_EDU_CFG11_ADC_EXTEN0_Msk          (0x00000300UL)               /*!< ADC_EXTEN0 (Bitfield-Mask: 0x3)        */
#define SYSCTRL_EDU_CFG11_ADC_EXTSEL0_Pos         (0UL)                        /*!< ADC_EXTSEL0 (Bit 0)                    */
#define SYSCTRL_EDU_CFG11_ADC_EXTSEL0_Msk         (0x000000FFUL)               /*!< ADC_EXTSEL0 (Bitfield-Mask: 0xFF)      */
/* ================================  EDU_CFG12  ============================= */
#define SYSCTRL_EDU_CFG12_ADC_EXTEN3_Pos          (24UL)                       /*!< ADC_EXTEN3 (Bit 24)                    */
#define SYSCTRL_EDU_CFG12_ADC_EXTEN3_Msk          (0x03000000UL)               /*!< ADC_EXTEN3 (Bitfield-Mask: 0x3)        */
#define SYSCTRL_EDU_CFG12_ADC_EXTSEL3_Pos         (16UL)                       /*!< ADC_EXTSEL3 (Bit 16)                   */
#define SYSCTRL_EDU_CFG12_ADC_EXTSEL3_Msk         (0x00FF0000UL)               /*!< ADC_EXTSEL3 (Bitfield-Mask: 0xFF)      */
#define SYSCTRL_EDU_CFG12_ADC_EXTEN2_Pos          (8UL)                        /*!< ADC_EXTEN2 (Bit 8)                     */
#define SYSCTRL_EDU_CFG12_ADC_EXTEN2_Msk          (0x00000300UL)               /*!< ADC_EXTEN2 (Bitfield-Mask: 0x3)        */
#define SYSCTRL_EDU_CFG12_ADC_EXTSEL2_Pos         (0UL)                        /*!< ADC_EXTSEL2 (Bit 0)                    */
#define SYSCTRL_EDU_CFG12_ADC_EXTSEL2_Msk         (0x000000FFUL)               /*!< ADC_EXTSEL2 (Bitfield-Mask: 0xFF)      */
/* ================================  EDU_CFG15  ============================= */
#define SYSCTRL_EDU_CFG15_CP1_BLANKING_Pos        (8UL)                        /*!< CP1_BLANKING (Bit 8)                   */
#define SYSCTRL_EDU_CFG15_CP1_BLANKING_Msk        (0x0000FF00UL)               /*!< CP1_BLANKING (Bitfield-Mask: 0xFF)     */
#define SYSCTRL_EDU_CFG15_CP0_BLANKING2_Pos       (0UL)                        /*!< CP0_BLANKING (Bit 0)                   */
#define SYSCTRL_EDU_CFG15_CP0_BLANKING_Msk        (0x000000FFUL)               /*!< CP0_BLANKING (Bitfield-Mask: 0xFF)     */
/* ===============================  EDU_CFG16  ============================== */
#define SYSCTRL_EDU_CFG16_CP1_EXTSP_Pos           (14UL)                       /*!< CP1_EXTSP (Bit 14)                     */
#define SYSCTRL_EDU_CFG16_CP1_EXTSP_Msk           (0x0000C000UL)               /*!< CP1_EXTSP (Bitfield-Mask: 0x3)         */
#define SYSCTRL_EDU_CFG16_CP0_EXTSP_Pos           (12UL)                       /*!< CP0_EXTSP (Bit 12)                     */
#define SYSCTRL_EDU_CFG16_CP0_EXTSP_Msk           (0x00003000UL)               /*!< CP0_EXTSP (Bitfield-Mask: 0x3)         */
#define SYSCTRL_EDU_CFG16_CP1_EXTSEL1_Pos         (10UL)                       /*!< CP1_EXTSEL1 (Bit 10)                   */
#define SYSCTRL_EDU_CFG16_CP1_EXTSEL1_Msk         (0x00000C00UL)               /*!< CP1_EXTSEL1 (Bitfield-Mask: 0x3)       */
#define SYSCTRL_EDU_CFG16_CP1_EXTSEL0_Pos         (8UL)                        /*!< CP1_EXTSEL0 (Bit 8)                    */
#define SYSCTRL_EDU_CFG16_CP1_EXTSEL0_Msk         (0x00000300UL)               /*!< CP1_EXTSEL0 (Bitfield-Mask: 0x3)       */
#define SYSCTRL_EDU_CFG16_CP0_EXTSEL1_Pos         (6UL)                        /*!< CP0_EXTSEL1 (Bit 6)                    */
#define SYSCTRL_EDU_CFG16_CP0_EXTSEL1_Msk         (0x000000C0UL)               /*!< CP0_EXTSEL1 (Bitfield-Mask: 0x3)       */
#define SYSCTRL_EDU_CFG16_CP0_EXTSEL0_Pos         (4UL)                        /*!< CP0_EXTSEL0 (Bit 4)                    */
#define SYSCTRL_EDU_CFG16_CP0_EXTSEL0_Msk         (0x00000030UL)               /*!< CP0_EXTSEL0 (Bitfield-Mask: 0x3)       */
#define SYSCTRL_EDU_CFG16_CP1_EXTEN_Pos           (2UL)                        /*!< CP1_EXTEN (Bit 2)                      */
#define SYSCTRL_EDU_CFG16_CP1_EXTEN_Msk           (0x0000000CUL)               /*!< CP1_EXTEN (Bitfield-Mask: 0x3)         */
#define SYSCTRL_EDU_CFG16_CP0_EXTEN_Pos           (0UL)                        /*!< CP0_EXTEN (Bit 0)                      */
#define SYSCTRL_EDU_CFG16_CP0_EXTEN_Msk           (0x00000003UL)               /*!< CP0_EXTEN (Bitfield-Mask: 0x3)         */
/* ===============================  EDU_CFG17  ============================== */
#define SYSCTRL_EDU_CFG17_DAC_TSEL_Pos            (4UL)                        /*!< DAC_TSEL (Bit 4)                       */
#define SYSCTRL_EDU_CFG17_DAC_TSEL_Msk            (0x00000070UL)               /*!< DAC_TSEL  (Bitfield-Mask: 0x7)         */
#define SYSCTRL_EDU_CFG17_DAC_TEN_Pos             (0UL)                        /*!< DAC_TEN (Bit 0)                        */
#define SYSCTRL_EDU_CFG17_DAC_TEN_Msk             (0x00000003UL)               /*!< DAC_TEN (Bitfield-Mask: 0x7)           */
/* ===============================  KEY_READ  =============================== */
#define SYSCTRL_KEY_LOCK_CNT_Pos                  (8UL)                        /*!< LOCK_CNT (Bit 8)                       */
#define SYSCTRL_KEY_LOCK_CNT_Msk                  (0x00001F00UL)               /*!< LOCK_CNT (Bitfield-Mask: 0x1F)         */
#define SYSCTRL_KEY_LOCK_Pos                      (1UL)                        /*!< LOCK (Bit 1)                           */
#define SYSCTRL_KEY_LOCK_Msk                      (0x00000002UL)               /*!< LOCK (Bitfield-Mask: 0x01)             */
#define SYSCTRL_KEY_WR_ERR_Pos                    (0UL)                        /*!< WR_ERR (Bit 0)                         */
#define SYSCTRL_KEY_WR_ERR_Msk                    (0x00000001UL)               /*!< WR_ERR (Bitfield-Mask: 0x01)           */
/* ===============================  KEY_WRITE  ============================== */
#define SYSCTRL_KEY_KEY_Pos                       (0UL)                        /*!< KEY (Bit 0)                            */
#define SYSCTRL_KEY_KEY_Msk                       (0xFFFFFFFFUL)               /*!< KEY (Bitfield-Mask: 0xFFFFFFFF)        */
/* ========================================================================== */
/* ================                    END                   ================ */
/* ========================================================================== */

/* ========================================================================== */
/* ================                   NVIC                    =============== */
/* ========================================================================== */
/* =================================  ISER  ================================= */
#define NVIC_ISER_SETENA_Pos                      (0UL)                        /*!< SETENA (Bit 0)                         */
#define NVIC_ISER_SETENA_Msk                      (0xFFFFFFFFUL)               /*!< SETENA (Bitfield-Mask: 0xffffffff)     */
/* =================================  ICER  ================================= */
#define NVIC_ICER_CLRENA_Pos                      (0UL)                        /*!< CLRENA (Bit 0)                         */
#define NVIC_ICER_CLRENA_Msk                      (0xFFFFFFFFUL)               /*!< CLRENA (Bitfield-Mask: 0xffffffff)     */
/* =================================  ISPR  ================================= */
#define NVIC_ISPR_SETPEND_Pos                     (0UL)                        /*!< SETPEND (Bit 0)                        */
#define NVIC_ISPR_SETPEND_Msk                     (0xFFFFFFFFUL)               /*!< SETPEND (Bitfield-Mask: 0xffffffff)    */
/* =================================  ICPR  ================================= */
#define NVIC_ICPR_CLRPEND_Pos                     (0UL)                        /*!< CLRPEND (Bit 0)                        */
#define NVIC_ICPR_CLRPEND_Msk                     (0xFFFFFFFFUL)               /*!< CLRPEND (Bitfield-Mask: 0xffffffff)    */
/* =================================  IPR0  ================================= */
#define NVIC_IPR0_PRI_00_Pos                      (6UL)                        /*!< PRI_00 (Bit 6)                         */
#define NVIC_IPR0_PRI_00_Msk                      (0x000000C0UL)               /*!< PRI_00 (Bitfield-Mask: 0x03)           */
#define NVIC_IPR0_PRI_01_Pos                      (14UL)                       /*!< PRI_01 (Bit 14)                        */
#define NVIC_IPR0_PRI_01_Msk                      (0x0000C000UL)               /*!< PRI_01 (Bitfield-Mask: 0x03)           */
#define NVIC_IPR0_PRI_02_Pos                      (22UL)                       /*!< PRI_02 (Bit 22)                        */
#define NVIC_IPR0_PRI_02_Msk                      (0x00C00000UL)               /*!< PRI_02 (Bitfield-Mask: 0x03)           */
#define NVIC_IPR0_PRI_03_Pos                      (30UL)                       /*!< PRI_03 (Bit 30)                        */
#define NVIC_IPR0_PRI_03_Msk                      (0xC0000000UL)               /*!< PRI_03 (Bitfield-Mask: 0x03)           */
/* =================================  IPR1  ================================= */
#define NVIC_IPR1_PRI_40_Pos                      (6UL)                        /*!< PRI_40 (Bit 6)                         */
#define NVIC_IPR1_PRI_40_Msk                      (0x000000C0UL)               /*!< PRI_40 (Bitfield-Mask: 0x03)           */
#define NVIC_IPR1_PRI_41_Pos                      (14UL)                       /*!< PRI_41 (Bit 14)                        */
#define NVIC_IPR1_PRI_41_Msk                      (0x0000C000UL)               /*!< PRI_41 (Bitfield-Mask: 0x03)           */
#define NVIC_IPR1_PRI_42_Pos                      (22UL)                       /*!< PRI_42 (Bit 22)                        */
#define NVIC_IPR1_PRI_42_Msk                      (0x00C00000UL)               /*!< PRI_42 (Bitfield-Mask: 0x03)           */
#define NVIC_IPR1_PRI_43_Pos                      (30UL)                       /*!< PRI_43 (Bit 30)                        */
#define NVIC_IPR1_PRI_43_Msk                      (0xC0000000UL)               /*!< PRI_43 (Bitfield-Mask: 0x03)           */
/* =================================  IPR2  ================================= */
#define NVIC_IPR2_PRI_80_Pos                      (6UL)                        /*!< PRI_80 (Bit 6)                         */
#define NVIC_IPR2_PRI_80_Msk                      (0x000000C0UL)               /*!< PRI_80 (Bitfield-Mask: 0x03)           */
#define NVIC_IPR2_PRI_81_Pos                      (14UL)                       /*!< PRI_81 (Bit 14)                        */
#define NVIC_IPR2_PRI_81_Msk                      (0x0000C000UL)               /*!< PRI_81 (Bitfield-Mask: 0x03)           */
#define NVIC_IPR2_PRI_82_Pos                      (22UL)                       /*!< PRI_82 (Bit 22)                        */
#define NVIC_IPR2_PRI_82_Msk                      (0x00C00000UL)               /*!< PRI_82 (Bitfield-Mask: 0x03)           */
#define NVIC_IPR2_PRI_83_Pos                      (30UL)                       /*!< PRI_83 (Bit 30)                        */
#define NVIC_IPR2_PRI_83_Msk                      (0xC0000000UL)               /*!< PRI_83 (Bitfield-Mask: 0x03)           */
/* =================================  IPR3  ================================= */
#define NVIC_IPR3_PRI_120_Pos                     (6UL)                        /*!< PRI_120 (Bit 6)                        */
#define NVIC_IPR3_PRI_120_Msk                     (0x000000C0UL)               /*!< PRI_120 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR3_PRI_121_Pos                     (14UL)                       /*!< PRI_121 (Bit 14)                       */
#define NVIC_IPR3_PRI_121_Msk                     (0x0000C000UL)               /*!< PRI_121 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR3_PRI_122_Pos                     (22UL)                       /*!< PRI_122 (Bit 22)                       */
#define NVIC_IPR3_PRI_122_Msk                     (0x00C00000UL)               /*!< PRI_122 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR3_PRI_123_Pos                     (30UL)                       /*!< PRI_123 (Bit 30)                       */
#define NVIC_IPR3_PRI_123_Msk                     (0xC0000000UL)               /*!< PRI_123 (Bitfield-Mask: 0x03)          */
/* =================================  IPR4  ================================= */
#define NVIC_IPR4_PRI_160_Pos                     (6UL)                        /*!< PRI_160 (Bit 6)                        */
#define NVIC_IPR4_PRI_160_Msk                     (0x000000C0UL)               /*!< PRI_160 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR4_PRI_161_Pos                     (14UL)                       /*!< PRI_161 (Bit 14)                       */
#define NVIC_IPR4_PRI_161_Msk                     (0x0000C000UL)               /*!< PRI_161 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR4_PRI_162_Pos                     (22UL)                       /*!< PRI_162 (Bit 22)                       */
#define NVIC_IPR4_PRI_162_Msk                     (0x00C00000UL)               /*!< PRI_162 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR4_PRI_163_Pos                     (30UL)                       /*!< PRI_163 (Bit 30)                       */
#define NVIC_IPR4_PRI_163_Msk                     (0xC0000000UL)               /*!< PRI_163 (Bitfield-Mask: 0x03)          */
/* =================================  IPR5  ================================= */
#define NVIC_IPR5_PRI_200_Pos                     (6UL)                        /*!< PRI_200 (Bit 6)                        */
#define NVIC_IPR5_PRI_200_Msk                     (0x000000C0UL)               /*!< PRI_200 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR5_PRI_201_Pos                     (14UL)                       /*!< PRI_201 (Bit 14)                       */
#define NVIC_IPR5_PRI_201_Msk                     (0x0000C000UL)               /*!< PRI_201 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR5_PRI_202_Pos                     (22UL)                       /*!< PRI_202 (Bit 22)                       */
#define NVIC_IPR5_PRI_202_Msk                     (0x00C00000UL)               /*!< PRI_202 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR5_PRI_203_Pos                     (30UL)                       /*!< PRI_203 (Bit 30)                       */
#define NVIC_IPR5_PRI_203_Msk                     (0xC0000000UL)               /*!< PRI_203 (Bitfield-Mask: 0x03)          */
/* =================================  IPR6  ================================= */
#define NVIC_IPR6_PRI_240_Pos                     (6UL)                        /*!< PRI_240 (Bit 6)                        */
#define NVIC_IPR6_PRI_240_Msk                     (0x000000C0UL)               /*!< PRI_240 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR6_PRI_241_Pos                     (14UL)                       /*!< PRI_241 (Bit 14)                       */
#define NVIC_IPR6_PRI_241_Msk                     (0x0000C000UL)               /*!< PRI_241 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR6_PRI_242_Pos                     (22UL)                       /*!< PRI_242 (Bit 22)                       */
#define NVIC_IPR6_PRI_242_Msk                     (0x00C00000UL)               /*!< PRI_242 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR6_PRI_243_Pos                     (30UL)                       /*!< PRI_243 (Bit 30)                       */
#define NVIC_IPR6_PRI_243_Msk                     (0xC0000000UL)               /*!< PRI_243 (Bitfield-Mask: 0x03)          */
/* =================================  IPR7  ================================= */
#define NVIC_IPR7_PRI_280_Pos                     (6UL)                        /*!< PRI_280 (Bit 6)                        */
#define NVIC_IPR7_PRI_280_Msk                     (0x000000C0UL)               /*!< PRI_280 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR7_PRI_281_Pos                     (14UL)                       /*!< PRI_281 (Bit 14)                       */
#define NVIC_IPR7_PRI_281_Msk                     (0x0000C000UL)               /*!< PRI_281 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR7_PRI_282_Pos                     (22UL)                       /*!< PRI_282 (Bit 22)                       */
#define NVIC_IPR7_PRI_282_Msk                     (0x00C00000UL)               /*!< PRI_282 (Bitfield-Mask: 0x03)          */
#define NVIC_IPR7_PRI_283_Pos                     (30UL)                       /*!< PRI_283 (Bit 30)                       */
#define NVIC_IPR7_PRI_283_Msk                     (0xC0000000UL)               /*!< PRI_283 (Bitfield-Mask: 0x03)          */
/* ========================================================================== */
/* ================                  END                    ================= */
/* ========================================================================== */

    /** @} */ /* End of group PosMask_peripherals */
/* ========================================================================== */
/* ================   Enumerated Values Peripheral Section   ================ */
/* ========================================================================== */

static unsigned char lcm32f06x_gbl_imask_status = 0;

#define chipctrl_access(expr)                         \
    {                                                 \
        __ISB();                                      \
        lcm32f06x_gbl_imask_status = __get_PRIMASK(); \
        __disable_irq();                              \
        *(volatile unsigned int *)0x40017020 = 0x87214365;     \
    }

#define sysctrl_access(expr)                          \
    {                                                 \
        __ISB();                                      \
        lcm32f06x_gbl_imask_status = __get_PRIMASK(); \
        __disable_irq();                              \
        *(volatile unsigned int *)0x4800707c = 0x05FA659A;     \
    }

#define __dekey()       \
    {                   \
        __enable_irq(); \
    }

/* HSE frequency == 16MHz */
#ifndef _LCM32_GBL_HSE_nHZ
#define _LCM32_GBL_HSE_nHZ (8000000UL)
// Comment it will dis-warning report but is it really useful 
// #warning "#define _LCM32_GBL_HSE_nHZ  (8000000UL) ; if your high osc is not equal to 8Mhz,please edit it actually;"
#endif

/* LSE frequency == 32768Hz*/
#ifndef _LCM32_GBL_LSE_nHZ
#define _LCM32_GBL_LSE_nHZ (32768UL)
// Comment it will dis-warrning report but is it really useful
// #warning "#define _LCM32_GBL_LSE_nHZ  (32768UL) ; if your low osc is not equal to 32.76KHz,please edit it actually."
#endif

/* HSI frequency == 16Mhz*/
#ifndef _LCM32_GBL_HSI_nHZ
#define _LCM32_GBL_HSI_nHZ (16000000UL)
#endif

/* LSI frequency == 32768Hz*/
#ifndef _LCM32_GBL_LSI_nHZ
#define _LCM32_GBL_LSI_nHZ (32768UL)
#endif

#define OS_ENTER_CRITICAL()        \
    {                              \
        cpu_sr = OS_CPU_SR_Save(); \
    }
#define OS_EXIT_CRITICAL()         \
    {                              \
        OS_CPU_SR_Restore(cpu_sr); \
    }

#include "lcm32f06x_conf.h"

#ifdef __cplusplus
}
#endif

#endif // __LCM32F06X_H__

/** @} */ /* End of group lcm32f06x */

/** @} */ /* End of group  */
