;**************************************************************************
;* @file     startup_lcm32f06x.s
;* @brief    LCM32F06x startup file for IAR Systems
;**************************************************************************
;

; Amount of memory (in bytes) allocated for Stack
; Tailor this value to your application needs
; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>
;

        MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)

        SECTION .intvec:CODE:NOROOT(2)

        EXTERN  __iar_program_start
        EXTERN  SystemInit
        PUBLIC  __vector_table

        DATA
__vector_table
        DCD     sfe(CSTACK)
        DCD     Reset_Handler                       ; Reset Handler
        DCD     NMI_Handler                         ; NMI Handler
        DCD     HardFault_Handler                   ; Hard Fault Handler
        DCD     0                                   ; Reserved
        DCD     0                                   ; Reserved
        DCD     0                                   ; Reserved
        DCD     0                                   ; Reserved
        DCD     0                                   ; Reserved
        DCD     0                                   ; Reserved
        DCD     0                                   ; Reserved
        DCD     SVC_Handler                         ; SVCall Handler
        DCD     0                                   ; Reserved
        DCD     0                                   ; Reserved
        DCD     PendSV_Handler                      ; PendSV Handler
        DCD     SysTick_Handler                     ; SysTick Handler

        ; External Interrupts               ;ж
        DCD     WWDG_Handler                ; WWDG                 Handler
        DCD     EXTI16_LVD_Handler          ; EXTI16_LVD           Handler
        DCD     EXTI17_WT_Handler           ; EXTI17_WT            Handler
        DCD     EFLS_Handler                ; EFLS                 Handler
        DCD     CHIPCTRL_Handler            ; CHIPCTRL             Handler
        DCD     EXTI0_1_Handler             ; EXTI0_1              Handler
        DCD     EXTI2_3_Handler             ; EXTI2_3              Handler
        DCD     EXTI4_15_Handler            ; EXTI4_15             Handler
        DCD     ACMP_EXTI18_19_Handler      ; ACMP_EXTI18_19       Handler
        DCD     DMAC_CH0_Handler            ; DMAC_CH0             Handler
        DCD     DMAC_CH1_Handler            ; DMAC_CH1             Handler
        DCD     SRAM_Handler                ; SRAM                 Handler
        DCD     ADC_Handler                 ; ADC                  Handler
        DCD     TIM1_NON_CC_Handler         ; TIM1_NON_CC          Handler
        DCD     TIM1_CC_Handler             ; TIM1_CC              Handler
        DCD     TIM2_Handler                ; TIM2                 Handler
        DCD     EXTI22_24_LP_USART_Handler  ; EXTI22_24_LP_USART   Handler
        DCD     DAC0_Handler                ; DAC0                 Handler
        DCD     ACMP_EXTI20_21_Handler      ; ACMP_EXTI20_21       Handler
        DCD     0                           ; Reserved
        DCD     TIM15_Handler               ; TIM15                Handler
        DCD     TIM16_Handler               ; TIM16                Handler
        DCD     TIM17_Handler               ; TIM17                Handler
        DCD     I2C0_Handler                ; I2C0                 Handler
        DCD     0                           ; Reserved
        DCD     SSP0_Handler                ; SSP0                 Handler
        DCD     0                           ; Reserved
        DCD     USART0_Handler              ; USART0                Handler
        DCD     USART1_Handler              ; USART1                Handler
        DCD     0                           ; Reserved
        DCD     0                           ; Reserved
        DCD     DIV_CORDIC_Handler          ; DIV_CORDIC           Handler

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
        THUMB

        PUBWEAK Reset_Handler
        SECTION .text:CODE:REORDER:NOROOT(2)
Reset_Handler
        LDR     R0, =SystemInit
        BLX     R0
        LDR     R0, =__iar_program_start
        BX      R0

        PUBWEAK NMI_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
NMI_Handler
        B NMI_Handler

        PUBWEAK HardFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
HardFault_Handler
        B HardFault_Handler

        PUBWEAK SVC_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SVC_Handler
        B SVC_Handler

        PUBWEAK PendSV_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
PendSV_Handler
        B PendSV_Handler

        PUBWEAK SysTick_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SysTick_Handler
        B SysTick_Handler

        PUBWEAK WWDG_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
WWDG_Handler
        B WWDG_Handler

        PUBWEAK EXTI16_LVD_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI16_LVD_Handler
        B EXTI16_LVD_Handler

        PUBWEAK EXTI17_WT_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI17_WT_Handler
        B EXTI17_WT_Handler

        PUBWEAK EFLS_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
EFLS_Handler
        B EFLS_Handler

        PUBWEAK CHIPCTRL_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
CHIPCTRL_Handler
        B CHIPCTRL_Handler

        PUBWEAK EXTI0_1_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI0_1_Handler
        B EXTI0_1_Handler

        PUBWEAK EXTI2_3_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI2_3_Handler
        B EXTI2_3_Handler

        PUBWEAK EXTI4_15_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI4_15_Handler
        B EXTI4_15_Handler

        PUBWEAK ACMP_EXTI18_19_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
ACMP_EXTI18_19_Handler
        B ACMP_EXTI18_19_Handler

        PUBWEAK DMAC_CH0_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMAC_CH0_Handler
        B DMAC_CH0_Handler

        PUBWEAK DMAC_CH1_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMAC_CH1_Handler
        B DMAC_CH1_Handler

        PUBWEAK SRAM_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SRAM_Handler
        B SRAM_Handler

        PUBWEAK ADC_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
ADC_Handler
        B ADC_Handler

        PUBWEAK TIM1_NON_CC_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM1_NON_CC_Handler
        B TIM1_NON_CC_Handler

        PUBWEAK TIM1_CC_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM1_CC_Handler
        B TIM1_CC_Handler

        PUBWEAK TIM2_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM2_Handler
        B TIM2_Handler

        PUBWEAK EXTI22_24_LP_USART_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI22_24_LP_USART_Handler
        B EXTI22_24_LP_USART_Handler

        PUBWEAK DAC0_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
DAC0_Handler
        B DAC0_Handler

        PUBWEAK ACMP_EXTI20_21_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
ACMP_EXTI20_21_Handler
        B ACMP_EXTI20_21_Handler

        PUBWEAK TIM15_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM15_Handler
        B TIM15_Handler

        PUBWEAK TIM16_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM16_Handler
        B TIM16_Handler

        PUBWEAK TIM17_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM17_Handler
        B TIM17_Handler

        PUBWEAK I2C0_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
I2C0_Handler
        B I2C0_Handler

        PUBWEAK SSP0_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SSP0_Handler
        B SSP0_Handler

        PUBWEAK USART0_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
USART0_Handler
        B USART0_Handler

        PUBWEAK USART1_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
USART1_Handler
        B USART1_Handler

        PUBWEAK DIV_CORDIC_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
DIV_CORDIC_Handler
        B DIV_CORDIC_Handler

        END
